/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;

public class SubstanceDisabledResizableIcon
implements ResizableIcon {
    protected LazyResettableHashMap<BufferedImage> cachedImages;
    protected ResizableIcon delegate;

    public SubstanceDisabledResizableIcon(ResizableIcon delegate) {
        this.delegate = delegate;
        this.cachedImages = new LazyResettableHashMap("FlamingoSubstanceDisabledIcons");
    }

    @Override
    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.delegate.setDimension(newDimension);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        AsynchronousLoading asyncDelegate;
        if (this.delegate instanceof AsynchronousLoading && (asyncDelegate = (AsynchronousLoading)((Object)this.delegate)).isLoading()) {
            return;
        }
        SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(c, ComponentState.DISABLED_UNSELECTED);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(this.getIconWidth(), this.getIconHeight(), scheme.getDisplayName());
        BufferedImage filtered = this.cachedImages.get(key);
        if (filtered == null) {
            BufferedImage offscreen = FlamingoUtilities.getBlankImage(this.getIconWidth(), this.getIconHeight());
            Graphics2D g2d = offscreen.createGraphics();
            this.delegate.paintIcon(c, g2d, 0, 0);
            g2d.dispose();
            filtered = SubstanceImageCreator.getColorSchemeImage(offscreen, scheme, 0.5f);
            this.cachedImages.put(key, filtered);
        }
        g.drawImage(filtered, x, y, null);
    }
}

