/*
 * Decompiled with CFR 0.152.
 */
package icy.canvas;

import icy.canvas.Layer;
import icy.common.CollapsibleEvent;
import icy.util.StringUtil;

public class CanvasLayerEvent
implements CollapsibleEvent {
    private Layer source;
    private final LayersEventType type;
    private String property;

    public CanvasLayerEvent(Layer source, LayersEventType type, String property) {
        this.source = source;
        this.type = type;
        this.property = property;
    }

    public CanvasLayerEvent(Layer source, LayersEventType type) {
        this(source, type, null);
    }

    public Layer getSource() {
        return this.source;
    }

    public LayersEventType getType() {
        return this.type;
    }

    public String getProperty() {
        return this.property;
    }

    @Override
    public boolean collapse(CollapsibleEvent event) {
        return this.equals(event);
    }

    @Override
    public int hashCode() {
        return this.source.hashCode() ^ this.type.hashCode() ^ (this.property != null ? this.property.hashCode() : 0);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CanvasLayerEvent) {
            CanvasLayerEvent e = (CanvasLayerEvent)obj;
            return e.getSource() == this.source && e.getType() == this.type && StringUtil.equals(e.getProperty(), this.property);
        }
        return super.equals(obj);
    }

    public static enum LayersEventType {
        ADDED,
        REMOVED,
        CHANGED;

    }
}

