/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.button;

import icy.action.IcyAbstractAction;
import icy.resource.icon.IcyIcon;
import icy.util.StringUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class IcyCommandMenuButton
extends JCommandMenuButton {
    private static final long serialVersionUID = -8129025104172266942L;
    private boolean internalEnabled = this.isEnabled();
    private IcyAbstractAction action = null;
    private final PropertyChangeListener actionPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StringUtil.equals("enabled", evt.getPropertyName())) {
                IcyCommandMenuButton.this.refreshEnabled();
            }
        }
    };

    public IcyCommandMenuButton(String title, IcyIcon icon) {
        super(title, (ResizableIcon)icon);
    }

    @Deprecated
    public IcyCommandMenuButton(String title, String iconName) {
        this(title, new IcyIcon(iconName));
    }

    public IcyCommandMenuButton(IcyIcon icon) {
        this(null, icon);
    }

    public IcyCommandMenuButton(String title) {
        this(title, (IcyIcon)null);
    }

    public IcyCommandMenuButton(IcyAbstractAction action) {
        this(null, (IcyIcon)null);
        this.setAction(action);
    }

    @Deprecated
    public IcyCommandMenuButton(icy.common.IcyAbstractAction action) {
        this(null, (IcyIcon)null);
        this.setAction(action);
    }

    public IcyCommandMenuButton() {
        this(null, (IcyIcon)null);
    }

    public IcyIcon getIcyIcon() {
        ResizableIcon icon = this.getIcon();
        if (icon instanceof IcyIcon) {
            return (IcyIcon)icon;
        }
        return null;
    }

    public String getIconName() {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            return icon.getName();
        }
        return null;
    }

    public void setIconName(String iconName) {
        IcyIcon icon = this.getIcyIcon();
        if (icon != null) {
            icon.setName(iconName);
        }
    }

    public void setEnabled(boolean b) {
        this.internalEnabled = b;
        this.refreshEnabled();
    }

    protected void refreshEnabled() {
        super.setEnabled(this.internalEnabled && (this.action == null || this.action.isEnabled()));
    }

    public void setAction(IcyAbstractAction value) {
        if (this.action != value) {
            if (this.action != null) {
                this.removeActionListener(this.action);
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.action = value;
            this.setText(this.action.getName());
            IcyIcon icon = this.action.getIcon();
            if (icon != null) {
                this.setIcon(new IcyIcon(icon));
            } else {
                this.setIcon(null);
            }
            this.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_ONLY);
            if (value != null) {
                this.setActionRichTooltip(this.action.getRichToolTip());
                this.addActionListener(value);
                value.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.refreshEnabled();
        }
    }

    public IcyAbstractAction getAction() {
        return this.action;
    }
}

