/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu;

import icy.action.FileActions;
import icy.action.GeneralActions;
import icy.action.PreferencesActions;
import icy.file.FileUtil;
import icy.file.Importer;
import icy.file.Loader;
import icy.gui.component.button.IcyCommandButton;
import icy.gui.component.menu.IcyRibbonApplicationMenuEntryPrimary;
import icy.gui.component.menu.IcyRibbonApplicationMenuEntrySecondary;
import icy.gui.plugin.PluginCommandButton;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.preferences.GeneralPreferences;
import icy.preferences.IcyPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.sequence.Sequence;
import icy.sequence.SequenceImporter;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.type.collection.CollectionUtil;
import icy.type.collection.list.RecentFileList;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenu;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntryPrimary;
import org.pushingpixels.flamingo.api.ribbon.RibbonApplicationMenuEntrySecondary;

public class ApplicationMenu
extends RibbonApplicationMenu
implements PluginLoader.PluginLoaderListener {
    static final int RECENTFILE_MAXLEN = 100;
    final RecentFileList recentFileList = new RecentFileList(IcyPreferences.applicationRoot().node("loader"));
    private final RibbonApplicationMenuEntryPrimary amepCreate = new IcyRibbonApplicationMenuEntryPrimary(FileActions.newSequenceAction);
    private final RibbonApplicationMenuEntrySecondary amesCreateGraySequence = new IcyRibbonApplicationMenuEntrySecondary(FileActions.newGraySequenceAction);
    private final RibbonApplicationMenuEntrySecondary amesCreateRGBSequence = new IcyRibbonApplicationMenuEntrySecondary(FileActions.newRGBSequenceAction);
    private final RibbonApplicationMenuEntrySecondary amesCreateRGBASequence = new IcyRibbonApplicationMenuEntrySecondary(FileActions.newARGBSequenceAction);
    private final RibbonApplicationMenuEntryPrimary amepOpen;
    private final RibbonApplicationMenuEntryPrimary amepImport;
    private final RibbonApplicationMenuEntryPrimary amepSaveDefault;
    private final RibbonApplicationMenuEntrySecondary amepSave;
    private final RibbonApplicationMenuEntrySecondary amepSaveAs;
    private final RibbonApplicationMenuEntrySecondary amepSaveMetaData;
    private final RibbonApplicationMenuEntryPrimary amepClose;
    private final RibbonApplicationMenuEntrySecondary amesCloseCurrent;
    private final RibbonApplicationMenuEntrySecondary amesCloseOthers;
    private final RibbonApplicationMenuEntrySecondary amesCloseAll;
    private final RibbonApplicationMenuEntryPrimary amepPreferences;
    private final RibbonApplicationMenuEntryPrimary amepExit;

    public ApplicationMenu() {
        this.amepCreate.addSecondaryMenuGroup("New image", new RibbonApplicationMenuEntrySecondary[]{this.amesCreateGraySequence, this.amesCreateRGBSequence, this.amesCreateRGBASequence});
        this.amepOpen = new IcyRibbonApplicationMenuEntryPrimary(FileActions.openSequenceAction);
        this.amepOpen.setRolloverCallback((RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback)new OpenRecentFileRollOverCallBack());
        this.amepImport = new IcyRibbonApplicationMenuEntryPrimary(new IcyIcon(ResourceUtil.ICON_DOC_IMPORT), "Import", null, JCommandButton.CommandButtonKind.POPUP_ONLY);
        this.amepImport.setRolloverCallback((RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback)new ImportResourceRollOverCallBack());
        this.amepSaveDefault = new IcyRibbonApplicationMenuEntryPrimary(FileActions.saveDefaultSequenceAction);
        this.amepSave = new IcyRibbonApplicationMenuEntrySecondary(FileActions.saveSequenceAction);
        this.amepSaveAs = new IcyRibbonApplicationMenuEntrySecondary(FileActions.saveAsSequenceAction);
        this.amepSaveMetaData = new IcyRibbonApplicationMenuEntrySecondary(FileActions.saveMetaDataAction);
        this.amepSaveDefault.addSecondaryMenuGroup("Save", new RibbonApplicationMenuEntrySecondary[]{this.amepSave, this.amepSaveAs, this.amepSaveMetaData});
        this.amepClose = new IcyRibbonApplicationMenuEntryPrimary(FileActions.closeSequenceAction);
        this.amesCloseCurrent = new IcyRibbonApplicationMenuEntrySecondary(FileActions.closeCurrentSequenceAction);
        this.amesCloseOthers = new IcyRibbonApplicationMenuEntrySecondary(FileActions.closeOthersSequencesAction);
        this.amesCloseAll = new IcyRibbonApplicationMenuEntrySecondary(FileActions.closeAllSequencesAction);
        this.amepClose.addSecondaryMenuGroup("Close Sequence", new RibbonApplicationMenuEntrySecondary[]{this.amesCloseCurrent, this.amesCloseOthers, this.amesCloseAll});
        this.amepPreferences = new IcyRibbonApplicationMenuEntryPrimary(PreferencesActions.preferencesAction);
        this.amepExit = new IcyRibbonApplicationMenuEntryPrimary(GeneralActions.exitApplicationAction);
        this.amepExit.setRolloverCallback((RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback)new EmptyRollOverCallBack());
        this.addMenuEntry(this.amepCreate);
        this.addMenuEntry(this.amepOpen);
        this.addMenuEntry(this.amepSaveDefault);
        this.addMenuSeparator();
        this.addMenuEntry(this.amepImport);
        this.addMenuSeparator();
        this.addMenuEntry(this.amepClose);
        this.addMenuSeparator();
        this.addMenuEntry(this.amepPreferences);
        this.addMenuSeparator();
        this.addMenuEntry(this.amepExit);
        this.setDefaultCallback(new OpenRecentFileRollOverCallBack());
        this.refreshState();
        PluginLoader.addListener(this);
    }

    private void refreshState() {
        Sequence focusedSequence = Icy.getMainInterface().getActiveSequence();
        boolean hasImporter = !PluginLoader.getPlugins(SequenceImporter.class).isEmpty() || !PluginLoader.getPlugins(Importer.class).isEmpty();
        this.amepImport.setEnabled(hasImporter);
        this.amepSaveDefault.setEnabled(focusedSequence != null);
        this.amepSave.setEnabled(focusedSequence != null && !StringUtil.isEmpty(focusedSequence.getFilename()));
        this.amepSaveAs.setEnabled(focusedSequence != null);
        this.amepSaveMetaData.setEnabled(focusedSequence != null && !StringUtil.isEmpty(focusedSequence.getFilename()) && GeneralPreferences.getSequencePersistence());
        this.amepClose.setEnabled(Icy.getMainInterface().getSequences().size() > 0);
    }

    public RecentFileList getRecentFileList() {
        return this.recentFileList;
    }

    public void addRecentLoadedFile(List<File> files) {
        this.addRecentLoadedFile(files.toArray(new File[files.size()]));
    }

    public void addRecentLoadedFile(File[] files) {
        this.recentFileList.addEntry(files);
    }

    public void addRecentLoadedFile(File file) {
        this.addRecentLoadedFile(new File[]{file});
    }

    public void addRecentFile(List<String> paths) {
        this.addRecentFile(paths.toArray(new String[paths.size()]));
    }

    public void addRecentFile(String[] paths) {
        this.recentFileList.addEntry(paths);
    }

    public void addRecentFile(String path) {
        this.addRecentFile(new String[]{path});
    }

    public void onSequenceActivationChange() {
        this.refreshState();
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        this.refreshState();
    }

    private class EmptyRollOverCallBack
    implements RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback {
        public void menuEntryActivated(JPanel targetPanel) {
            ComponentUtil.setPreferredWidth(targetPanel, 480);
            targetPanel.removeAll();
            targetPanel.add(new JPanel());
            targetPanel.validate();
        }
    }

    private class ImportResourceRollOverCallBack
    implements RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback {
        public void menuEntryActivated(JPanel targetPanel) {
            ArrayList<PluginDescriptor> importerPlugins;
            ComponentUtil.setPreferredWidth(targetPanel, 480);
            JCommandButtonPanel importPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
            importPanel.setMaxButtonColumns(1);
            importPanel.setLayoutKind(JCommandButtonPanel.LayoutKind.ROW_FILL);
            ArrayList<PluginDescriptor> sequenceImporterPlugins = PluginLoader.getPlugins(SequenceImporter.class);
            if (!sequenceImporterPlugins.isEmpty()) {
                importPanel.addButtonGroup("Sequence importer");
                for (PluginDescriptor plugin : sequenceImporterPlugins) {
                    AbstractCommandButton button = PluginCommandButton.createButton(plugin, false, false, false);
                    button.setHorizontalAlignment(2);
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            AbstractCommandButton button = (AbstractCommandButton)event.getSource();
                            PluginDescriptor pluginDescriptor = PluginLoader.getPlugin(button.getName());
                            if (pluginDescriptor != null) {
                                try {
                                    final SequenceImporter importer = (SequenceImporter)((Object)PluginLauncher.startSafe(pluginDescriptor));
                                    ThreadUtil.bgRun(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                Sequence result = importer.load();
                                                if (result != null) {
                                                    Icy.getMainInterface().addSequence(result);
                                                }
                                            }
                                            catch (Exception exc) {
                                                IcyExceptionHandler.handleException(exc, false);
                                            }
                                        }
                                    });
                                }
                                catch (Exception exc) {
                                    IcyExceptionHandler.handleException(exc, false);
                                }
                            }
                        }
                    });
                    importPanel.addButtonToLastGroup(button);
                }
            }
            if (!(importerPlugins = PluginLoader.getPlugins(Importer.class)).isEmpty()) {
                importPanel.addButtonGroup("General importer");
                for (PluginDescriptor plugin : importerPlugins) {
                    AbstractCommandButton button = PluginCommandButton.createButton(plugin, false, false, false);
                    button.setHorizontalAlignment(2);
                    button.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            AbstractCommandButton button = (AbstractCommandButton)event.getSource();
                            PluginDescriptor pluginDescriptor = PluginLoader.getPlugin(button.getName());
                            if (pluginDescriptor != null) {
                                try {
                                    final Importer importer = (Importer)((Object)PluginLauncher.startSafe(pluginDescriptor));
                                    ThreadUtil.bgRun(new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                importer.load();
                                            }
                                            catch (Exception exc) {
                                                IcyExceptionHandler.handleException(exc, false);
                                            }
                                        }
                                    });
                                }
                                catch (Exception exc) {
                                    IcyExceptionHandler.handleException(exc, false);
                                }
                            }
                        }
                    });
                    importPanel.addButtonToLastGroup(button);
                }
            }
            targetPanel.removeAll();
            targetPanel.setLayout(new BorderLayout());
            targetPanel.add((Component)new JScrollPane((Component)importPanel), "Center");
            targetPanel.validate();
        }
    }

    private class OpenRecentFileRollOverCallBack
    implements RibbonApplicationMenuEntryPrimary.PrimaryRolloverCallback {
        public void menuEntryActivated(JPanel targetPanel) {
            ComponentUtil.setPreferredWidth(targetPanel, 480);
            JCommandButtonPanel recentFilesPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
            recentFilesPanel.setMaxButtonColumns(1);
            recentFilesPanel.setLayoutKind(JCommandButtonPanel.LayoutKind.ROW_FILL);
            recentFilesPanel.addButtonGroup("Recent Files");
            ApplicationMenu.this.recentFileList.clean();
            int nbRecentFile = ApplicationMenu.this.recentFileList.getSize();
            IcyIcon icon = new IcyIcon("document");
            for (int i = 0; i < nbRecentFile; ++i) {
                String entry = ApplicationMenu.this.recentFileList.getEntryAsName(i, 100, true);
                if (StringUtil.isEmpty(entry)) continue;
                JCommandButton button = new JCommandButton(entry, (ResizableIcon)icon);
                button.setHorizontalAlignment(2);
                final String[] paths = ApplicationMenu.this.recentFileList.getEntry(i);
                int numFile = paths.length;
                RichTooltip toolTip = numFile == 1 ? new RichTooltip("Single file sequence", FileUtil.getFileName(paths[0])) : new RichTooltip("Multiple files sequence", FileUtil.getFileName(paths[0]));
                for (int j = 1; j < Math.min(10, numFile); ++j) {
                    toolTip.addDescriptionSection(FileUtil.getFileName(paths[j]));
                }
                if (numFile > 10) {
                    toolTip.addDescriptionSection("...");
                    toolTip.addDescriptionSection(FileUtil.getFileName(paths[numFile - 1]));
                }
                button.setActionRichTooltip(toolTip);
                button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        Loader.load(CollectionUtil.asList(paths), false, true, true);
                    }
                });
                recentFilesPanel.addButtonToLastGroup((AbstractCommandButton)button);
            }
            recentFilesPanel.addButtonGroup("Action");
            IcyCommandButton clearButton = new IcyCommandButton(FileActions.clearRecentFilesAction);
            recentFilesPanel.addButtonToLastGroup((AbstractCommandButton)clearButton);
            targetPanel.removeAll();
            targetPanel.setLayout(new BorderLayout());
            targetPanel.add((Component)new JScrollPane((Component)recentFilesPanel), "Center");
            targetPanel.validate();
        }
    }
}

