/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.IcyTable;
import icy.gui.preferences.EditRepositoryDialog;
import icy.gui.preferences.PluginLocalPreferencePanel;
import icy.gui.preferences.PluginOnlinePreferencePanel;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.gui.preferences.WorkspaceLocalPreferencePanel;
import icy.gui.preferences.WorkspaceOnlinePreferencePanel;
import icy.plugin.PluginRepositoryLoader;
import icy.preferences.RepositoryPreferences;
import icy.workspace.WorkspaceRepositoryLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RepositoryPreferencePanel
extends PreferencePanel
implements ListSelectionListener {
    private static final long serialVersionUID = 5676905012950916850L;
    public static final String NODE_NAME = "Repository";
    static final String[] columnNames = new String[]{"Name", "Location", "Enabled"};
    final ArrayList<RepositoryPreferences.RepositoryInfo> repositories = new ArrayList();
    final AbstractTableModel tableModel;
    final JTable table;
    final JButton addButton;
    final JButton editButton;
    final JButton removeButton;

    RepositoryPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Preferences");
        this.load();
        this.addButton = new JButton("add...");
        this.addButton.setToolTipText("Add a new repository");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryPreferencePanel.this.addRepository();
            }
        });
        this.editButton = new JButton("edit...");
        this.editButton.setToolTipText("Edit selected repository");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryPreferencePanel.this.editRepository(RepositoryPreferencePanel.this.getSelectedRepository());
            }
        });
        this.removeButton = new JButton("remove");
        this.removeButton.setToolTipText("Delete selected repository");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepositoryPreferencePanel.this.removeRepository(RepositoryPreferencePanel.this.getSelectedRepository());
            }
        });
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 3));
        buttonsPanel.add(this.addButton);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(this.editButton);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(this.removeButton);
        buttonsPanel.add(Box.createVerticalStrut(8));
        buttonsPanel.add(Box.createVerticalGlue());
        this.tableModel = new AbstractTableModel(){
            private static final long serialVersionUID = -8573364273165723214L;

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public String getColumnName(int column) {
                return columnNames[column];
            }

            @Override
            public int getRowCount() {
                return RepositoryPreferencePanel.this.repositories.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                RepositoryPreferences.RepositoryInfo reposInf = RepositoryPreferencePanel.this.repositories.get(row);
                switch (column) {
                    case 0: {
                        return reposInf.getName();
                    }
                    case 1: {
                        return reposInf.getLocation();
                    }
                    case 2: {
                        return reposInf.isEnabled();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 2;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                RepositoryPreferences.RepositoryInfo reposInf = RepositoryPreferencePanel.this.repositories.get(rowIndex);
                switch (columnIndex) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (!(aValue instanceof Boolean)) break;
                        reposInf.setEnabled((Boolean)aValue);
                    }
                }
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 2) {
                    return Boolean.class;
                }
                return String.class;
            }
        };
        this.table = new IcyTable(this.tableModel);
        TableColumnModel colModel = this.table.getColumnModel();
        TableColumn col = colModel.getColumn(0);
        col.setMinWidth(80);
        col.setPreferredWidth(80);
        col.setMaxWidth(120);
        col = colModel.getColumn(1);
        col.setMinWidth(160);
        col.setPreferredWidth(240);
        col.setMaxWidth(500);
        col = colModel.getColumn(2);
        col.setMinWidth(60);
        col.setPreferredWidth(60);
        col.setMaxWidth(60);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoResizeMode(4);
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 3));
        tablePanel.add(this.table.getTableHeader());
        tablePanel.add(new JScrollPane(this.table));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)tablePanel, "Center");
        this.mainPanel.add((Component)buttonsPanel, "East");
        this.mainPanel.validate();
        this.table.getSelectionModel().setSelectionInterval(0, 0);
    }

    @Override
    protected void load() {
        this.repositories.clear();
        this.repositories.addAll(RepositoryPreferences.getRepositeries());
    }

    @Override
    protected void save() {
        RepositoryPreferences.setRepositeries(this.repositories);
        PluginRepositoryLoader.reload();
        WorkspaceRepositoryLoader.reload();
        ((PluginLocalPreferencePanel)this.getPreferencePanel(PluginLocalPreferencePanel.class)).updateRepositories();
        ((PluginOnlinePreferencePanel)this.getPreferencePanel(PluginOnlinePreferencePanel.class)).updateRepositories();
        ((WorkspaceOnlinePreferencePanel)this.getPreferencePanel(WorkspaceOnlinePreferencePanel.class)).updateRepositories();
        ((WorkspaceLocalPreferencePanel)this.getPreferencePanel(WorkspaceLocalPreferencePanel.class)).updateRepositories();
    }

    private int getRepositeryIndex(RepositoryPreferences.RepositoryInfo reposInf) {
        return this.repositories.indexOf(reposInf);
    }

    private int getRepositeryModelIndex(RepositoryPreferences.RepositoryInfo reposInf) {
        return this.getRepositeryIndex(reposInf);
    }

    RepositoryPreferences.RepositoryInfo getSelectedRepository() {
        int index = this.table.getSelectedRow();
        if (index == -1) {
            return null;
        }
        if ((index = this.table.convertRowIndexToModel(index)) == -1) {
            return null;
        }
        return this.repositories.get(index);
    }

    boolean addRepository() {
        RepositoryPreferences.RepositoryInfo reposInf = new RepositoryPreferences.RepositoryInfo("name", "http://");
        if (!new EditRepositoryDialog("Add a new repository", reposInf).isCanceled()) {
            this.repositories.add(reposInf);
            int ind = this.getRepositeryModelIndex(reposInf);
            this.tableModel.fireTableRowsInserted(ind, ind);
            return true;
        }
        return false;
    }

    boolean editRepository(RepositoryPreferences.RepositoryInfo reposInf) {
        int ind = this.getRepositeryModelIndex(reposInf);
        if (!new EditRepositoryDialog("Edit repository", reposInf).isCanceled()) {
            try {
                this.tableModel.fireTableRowsUpdated(ind, ind);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    boolean removeRepository(RepositoryPreferences.RepositoryInfo reposInf) {
        int ind = this.getRepositeryModelIndex(reposInf);
        if (this.repositories.remove(reposInf)) {
            this.tableModel.fireTableRowsDeleted(ind, ind);
            return true;
        }
        return false;
    }

    private void udpateButtonsState() {
        RepositoryPreferences.RepositoryInfo selectedRepos = this.getSelectedRepository();
        boolean enabled = selectedRepos != null && !selectedRepos.isDefault();
        this.editButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.udpateButtonsState();
    }
}

