/*
 * Decompiled with CFR 0.152.
 */
package icy.imagej;

import icy.gui.util.LookAndFeelUtil;
import icy.imagej.ImageJWrapper;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.util.ColorUtil;
import icy.util.ReflectionUtil;
import ij.IJ;
import ij.gui.Toolbar;
import ij.plugin.MacroInstaller;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JToolBar;
import org.pushingpixels.substance.api.skin.SkinChangeListener;

public class ToolbarWrapper
extends Toolbar {
    private static final long serialVersionUID = 6546185720732862969L;
    final CustomToolBar swingComponent = new CustomToolBar(0);
    private final SkinChangeListener skinChangeListener;
    Field grayField;
    Field brighterField;
    Field darkerField;
    Field evenDarkerField;
    Field toolColorField;

    public ToolbarWrapper(ImageJWrapper ijw) {
        this.swingComponent.setMinimumSize(this.getMinimumSize());
        this.swingComponent.setPreferredSize(this.getPreferredSize());
        this.swingComponent.addKeyListener(ijw);
        this.swingComponent.addMouseListener(this);
        this.swingComponent.addMouseMotionListener(this);
        try {
            Vector popups = (Vector)((Vector)ReflectionUtil.getFieldObject(this, "popups", true)).clone();
            for (Object obj : popups) {
                PopupMenu popup = (PopupMenu)obj;
                super.remove(popup);
                this.swingComponent.add(popup);
            }
            this.grayField = ReflectionUtil.getField(this.getClass(), "gray", true);
            this.brighterField = ReflectionUtil.getField(this.getClass(), "brighter", true);
            this.darkerField = ReflectionUtil.getField(this.getClass(), "darker", true);
            this.evenDarkerField = ReflectionUtil.getField(this.getClass(), "evenDarker", true);
            this.toolColorField = ReflectionUtil.getField(this.getClass(), "toolColor", true);
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false);
            System.err.println("Cannot restore toolbar buttons from ImageJ.");
        }
        this.skinChangeListener = new SkinChangeListener(){

            public void skinChanged() {
                Color bgCol = LookAndFeelUtil.getBackground(ToolbarWrapper.this.swingComponent);
                if (ColorUtil.getLuminance(bgCol) < 64) {
                    bgCol = ColorUtil.mix(bgCol, Color.gray);
                }
                Color brighterCol = ColorUtil.mix(bgCol, Color.white);
                Color darkerCol = ColorUtil.mix(bgCol, Color.black);
                Color evenDarkerCol = ColorUtil.mix(darkerCol, Color.black);
                if (ColorUtil.getLuminance(bgCol) < 128) {
                    brighterCol = ColorUtil.mix(bgCol, brighterCol);
                } else {
                    darkerCol = ColorUtil.mix(bgCol, darkerCol);
                    evenDarkerCol = ColorUtil.mix(darkerCol, evenDarkerCol);
                }
                try {
                    if (ToolbarWrapper.this.grayField != null) {
                        ToolbarWrapper.this.grayField.set(ToolbarWrapper.this, bgCol);
                    }
                    if (ToolbarWrapper.this.brighterField != null) {
                        ToolbarWrapper.this.brighterField.set(ToolbarWrapper.this, brighterCol);
                    }
                    if (ToolbarWrapper.this.darkerField != null) {
                        ToolbarWrapper.this.darkerField.set(ToolbarWrapper.this, darkerCol);
                    }
                    if (ToolbarWrapper.this.evenDarkerField != null) {
                        ToolbarWrapper.this.evenDarkerField.set(ToolbarWrapper.this, evenDarkerCol);
                    }
                    if (ToolbarWrapper.this.toolColorField != null) {
                        ToolbarWrapper.this.toolColorField.set(ToolbarWrapper.this, LookAndFeelUtil.getForeground(ToolbarWrapper.this.swingComponent));
                    }
                    ToolbarWrapper.this.swingComponent.repaint();
                }
                catch (Exception e) {
                    IcyExceptionHandler.showErrorMessage(e, false);
                    System.err.println("Cannot hack background color of ImageJ toolbar.");
                }
            }
        };
        new MacroInstaller().run(IJ.getDirectory("macros") + "StartupMacros.txt");
        LookAndFeelUtil.addSkinChangeListener(new LookAndFeelUtil.WeakSkinChangeListener(this.skinChangeListener));
    }

    @Override
    public Container getParent() {
        return this.swingComponent.getParent();
    }

    public JToolBar getSwingComponent() {
        return this.swingComponent;
    }

    @Override
    public synchronized void add(PopupMenu popup) {
        if (this.swingComponent == null) {
            super.add(popup);
        } else {
            this.swingComponent.add(popup);
            this.swingComponent.repaint();
        }
    }

    @Override
    public synchronized void remove(MenuComponent popup) {
        if (this.swingComponent == null) {
            super.remove(popup);
        } else {
            this.swingComponent.remove(popup);
            this.swingComponent.repaint();
        }
    }

    @Override
    public Graphics getGraphics() {
        return this.swingComponent.getGraphics();
    }

    private class CustomToolBar
    extends JToolBar {
        private static final long serialVersionUID = -3278693015639517146L;

        public CustomToolBar(int orientation) {
            super(orientation);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFloatable(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            ToolbarWrapper.this.paint(g);
        }

        @Override
        public void removeNotify() {
            try {
                if (SystemUtil.isUnix()) {
                    Vector pp = (Vector)ReflectionUtil.getFieldObject(this, "popups", true);
                    pp.clear();
                }
            }
            catch (Exception e) {
                IcyExceptionHandler.showErrorMessage(e, false);
                System.err.println("Cannot remove toolbar buttons from ImageJ.");
            }
            super.removeNotify();
        }
    }
}

