/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.CollapsibleEvent;
import icy.painter.Overlay;
import icy.painter.VtkPainter;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import icy.util.XMLUtil;
import icy.vtk.IcyVtkPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import org.w3c.dom.Node;
import plugins.kernel.canvas.VtkCanvas;
import vtk.vtkActor;
import vtk.vtkInformation;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkSphereSource;

public class Anchor3D
extends Overlay
implements VtkPainter,
Runnable {
    protected static final String ID_COLOR = "color";
    protected static final String ID_SELECTEDCOLOR = "selected_color";
    protected static final String ID_SELECTED = "selected";
    protected static final String ID_POS_X = "pos_x";
    protected static final String ID_POS_Y = "pos_y";
    protected static final String ID_POS_Z = "pos_z";
    protected static final String ID_RAY = "ray";
    protected static final String ID_VISIBLE = "visible";
    public static final int DEFAULT_RAY = 6;
    public static final Color DEFAULT_NORMAL_COLOR = Color.GREEN;
    public static final Color DEFAULT_SELECTED_COLOR = Color.WHITE;
    protected final Point3D.Double position;
    protected int ray;
    protected Color color;
    protected Color selectedColor;
    protected boolean selected;
    protected boolean visible;
    protected Point3D startDragMousePosition;
    protected Point3D startDragPainterPosition;
    protected final Ellipse2D ellipse;
    vtkSphereSource vtkSource;
    protected vtkPolyDataMapper polyMapper;
    protected vtkActor actor;
    protected vtkInformation vtkInfo;
    protected boolean needRebuild;
    protected boolean needPropertiesUpdate;
    protected double[] scaling;
    protected WeakReference<VtkCanvas> canvas3d;
    protected final List<Anchor3DPositionListener> anchor3DPositionlisteners;

    public Anchor3D(double x, double y, double z, int ray, Color color, Color selectedColor) {
        super("Anchor", Overlay.OverlayPriority.SHAPE_NORMAL);
        this.position = new Point3D.Double(x, y, z);
        this.ray = ray;
        this.color = color;
        this.selectedColor = selectedColor;
        this.selected = false;
        this.visible = true;
        this.startDragMousePosition = null;
        this.startDragPainterPosition = null;
        this.ellipse = new Ellipse2D.Double();
        this.vtkSource = null;
        this.polyMapper = null;
        this.actor = null;
        this.vtkInfo = null;
        this.scaling = new double[3];
        Arrays.fill(this.scaling, 1.0);
        this.needRebuild = true;
        this.needPropertiesUpdate = false;
        this.canvas3d = new WeakReference<Object>(null);
        this.anchor3DPositionlisteners = new ArrayList<Anchor3DPositionListener>();
    }

    public Anchor3D(double x, double y, double z, Color color, Color selectedColor) {
        this(x, y, z, 6, color, selectedColor);
    }

    public Anchor3D(double x, double y, double z, int ray) {
        this(x, y, z, ray, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    public Anchor3D(double x, double y, double z) {
        this(x, y, z, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    public Anchor3D() {
        this(0.0, 0.0, 0.0, 6, DEFAULT_NORMAL_COLOR, DEFAULT_SELECTED_COLOR);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.vtkSource != null) {
            this.vtkSource.Delete();
        }
        if (this.actor != null) {
            this.actor.SetPropertyKeys(null);
            this.actor.Delete();
        }
        if (this.vtkInfo != null) {
            this.vtkInfo.Remove(VtkCanvas.visibilityKey);
            this.vtkInfo.Delete();
        }
        if (this.polyMapper != null) {
            this.polyMapper.Delete();
        }
    }

    public double getX() {
        return this.position.x;
    }

    public void setX(double value) {
        this.setPosition(value, this.position.y, this.position.z);
    }

    public double getY() {
        return this.position.y;
    }

    public void setY(double value) {
        this.setPosition(this.position.x, value, this.position.z);
    }

    public double getZ() {
        return this.position.z;
    }

    public void setZ(double value) {
        this.setPosition(this.position.x, this.position.y, value);
    }

    public Point3D getPositionInternal() {
        return this.position;
    }

    public Point3D getPosition() {
        return new Point3D.Double(this.position.x, this.position.y, this.position.z);
    }

    public void setPosition(Point3D p) {
        this.setPosition(p.getX(), p.getY(), p.getZ());
    }

    public void setPosition(double x, double y, double z) {
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            this.position.x = x;
            this.position.y = y;
            this.position.z = z;
            this.needRebuild = true;
            this.positionChanged();
            this.painterChanged();
        }
    }

    public void translate(double dx, double dy, double dz) {
        this.setPosition(this.position.x + dx, this.position.y + dy, this.position.z + dz);
    }

    public int getRay() {
        return this.ray;
    }

    public void setRay(int value) {
        if (this.ray != value) {
            this.ray = value;
            this.needRebuild = true;
            this.painterChanged();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        if (this.color != value) {
            this.color = value;
            this.needPropertiesUpdate = true;
            this.painterChanged();
        }
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setSelectedColor(Color value) {
        if (this.selectedColor != value) {
            this.selectedColor = value;
            this.needPropertiesUpdate = true;
            this.painterChanged();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) {
        if (this.selected != value) {
            this.selected = value;
            if (!value) {
                this.startDragMousePosition = null;
            }
            this.needPropertiesUpdate = true;
            this.painterChanged();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        if (this.visible != value) {
            this.visible = value;
            this.needPropertiesUpdate = true;
            this.painterChanged();
        }
    }

    public boolean isOver(IcyCanvas canvas, Point3D imagePoint) {
        this.updateEllipseForCanvas(canvas);
        if (canvas instanceof VtkCanvas) {
            return this.actor != null && this.actor == ((VtkCanvas)canvas).getPickedObject();
        }
        if (imagePoint == null) {
            return false;
        }
        double x = imagePoint.getX();
        double y = imagePoint.getY();
        double z = imagePoint.getZ();
        int cnvZ = canvas.getPositionZ();
        if ((cnvZ == -1 || z == -1.0 || cnvZ == (int)z) && this.ellipse.getBounds2D().contains(x, y)) {
            return this.ellipse.contains(x, y);
        }
        return false;
    }

    protected double getAdjRay(IcyCanvas canvas) {
        return canvas.canvasToImageLogDeltaX(this.ray);
    }

    protected void updateEllipseForCanvas(IcyCanvas canvas) {
        if (canvas instanceof VtkCanvas) {
            double[] s;
            VtkCanvas cnv = (VtkCanvas)canvas;
            if (this.canvas3d.get() != cnv) {
                this.canvas3d = new WeakReference<VtkCanvas>(cnv);
            }
            if (!Arrays.equals(this.scaling, s = cnv.getVolumeScale())) {
                this.scaling = s;
                this.needRebuild = true;
            }
            if (this.needRebuild) {
                if (this.actor == null) {
                    this.initVtkObjects();
                }
                ThreadUtil.runSingle(this);
                this.needRebuild = false;
            }
            if (this.needPropertiesUpdate) {
                this.updateVtkDisplayProperties();
                this.needPropertiesUpdate = false;
            }
            this.updateVtkRadius();
        } else {
            double adjRay = this.getAdjRay(canvas);
            this.ellipse.setFrame(this.position.x - adjRay, this.position.y - adjRay, adjRay * 2.0, adjRay * 2.0);
        }
    }

    protected boolean updateDrag(InputEvent e, double x, double y, double z) {
        if (this.startDragMousePosition == null) {
            return false;
        }
        double dx = x - this.startDragMousePosition.getX();
        double dy = y - this.startDragMousePosition.getY();
        double dz = z - this.startDragMousePosition.getZ();
        if (EventUtil.isShiftDown(e)) {
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0.0;
                if (Math.abs(dz) > Math.abs(dx)) {
                    dx = 0.0;
                } else {
                    dz = 0.0;
                }
            } else {
                dx = 0.0;
                if (Math.abs(dz) > Math.abs(dy)) {
                    dy = 0.0;
                } else {
                    dz = 0.0;
                }
            }
        }
        this.setPosition(new Point3D.Double(this.startDragPainterPosition.getX() + dx, this.startDragPainterPosition.getY() + dy, this.startDragPainterPosition.getZ() + dz));
        return true;
    }

    protected boolean updateDrag(InputEvent e, Point3D pt) {
        return this.updateDrag(e, pt.getX(), pt.getY(), pt.getZ());
    }

    protected void positionChanged() {
        this.updater.changed(new Anchor3DEvent(this));
    }

    @Override
    public void onChanged(CollapsibleEvent object) {
        if (object instanceof Anchor3DEvent) {
            this.firePositionChangedEvent(((Anchor3DEvent)object).getSource());
            return;
        }
        super.onChanged(object);
    }

    protected void firePositionChangedEvent(Anchor3D source) {
        for (Anchor3DPositionListener listener : new ArrayList<Anchor3DPositionListener>(this.anchor3DPositionlisteners)) {
            listener.positionChanged(source);
        }
    }

    public void addPositionListener(Anchor3DPositionListener listener) {
        this.anchor3DPositionlisteners.add(listener);
    }

    public void removePositionListener(Anchor3DPositionListener listener) {
        this.anchor3DPositionlisteners.remove(listener);
    }

    protected void initVtkObjects() {
        this.vtkSource = new vtkSphereSource();
        this.vtkSource.SetRadius((double)this.getRay());
        this.vtkSource.SetThetaResolution(12);
        this.vtkSource.SetPhiResolution(12);
        this.polyMapper = new vtkPolyDataMapper();
        this.polyMapper.SetInputConnection(this.vtkSource.GetOutputPort());
        this.actor = new vtkActor();
        this.actor.SetMapper((vtkMapper)this.polyMapper);
        this.vtkInfo = new vtkInformation();
        this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
        this.actor.SetPropertyKeys(this.vtkInfo);
        Color col = this.getColor();
        this.actor.GetProperty().SetColor((double)col.getRed() / 255.0, (double)col.getGreen() / 255.0, (double)col.getBlue() / 255.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean rebuildVtkObjects() {
        VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
        if (canvas == null) {
            return false;
        }
        IcyVtkPanel vtkPanel = canvas.getVtkPanel();
        if (vtkPanel == null) {
            return false;
        }
        Point3D pos = this.getPosition();
        vtkPanel.lock();
        try {
            this.vtkSource.SetCenter(pos.getX() * this.scaling[0], pos.getY() * this.scaling[1], pos.getZ() * this.scaling[2]);
            this.vtkSource.Update();
            this.polyMapper.Update();
        }
        finally {
            vtkPanel.unlock();
        }
        this.painterChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateVtkDisplayProperties() {
        IcyVtkPanel vtkPanel;
        if (this.actor == null) {
            return;
        }
        VtkCanvas cnv = (VtkCanvas)this.canvas3d.get();
        Color col = this.isSelected() ? this.getSelectedColor() : this.getColor();
        double r = (double)col.getRed() / 255.0;
        double g = (double)col.getGreen() / 255.0;
        double b = (double)col.getBlue() / 255.0;
        IcyVtkPanel icyVtkPanel = vtkPanel = cnv != null ? cnv.getVtkPanel() : null;
        if (vtkPanel != null) {
            vtkPanel.lock();
        }
        try {
            this.actor.GetProperty().SetColor(r, g, b);
            if (this.isVisible()) {
                this.actor.SetVisibility(1);
                this.vtkInfo.Set(VtkCanvas.visibilityKey, 1);
            } else {
                this.actor.SetVisibility(0);
                this.vtkInfo.Set(VtkCanvas.visibilityKey, 0);
            }
        }
        finally {
            if (vtkPanel != null) {
                vtkPanel.unlock();
            }
        }
        this.painterChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateVtkRadius() {
        VtkCanvas canvas = (VtkCanvas)this.canvas3d.get();
        if (canvas == null) {
            return;
        }
        IcyVtkPanel vtkPanel = canvas.getVtkPanel();
        if (vtkPanel == null) {
            return;
        }
        if (this.vtkSource == null) {
            return;
        }
        double radius = this.getAdjRay(canvas) * this.scaling[0];
        if (this.vtkSource.GetRadius() != radius) {
            vtkPanel.lock();
            try {
                this.vtkSource.SetRadius(radius);
                this.vtkSource.Update();
            }
            finally {
                vtkPanel.unlock();
            }
            this.painterChanged();
        }
    }

    @Override
    public vtkProp[] getProps() {
        if (this.actor == null) {
            this.initVtkObjects();
        }
        return new vtkActor[]{this.actor};
    }

    @Override
    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        this.paint(g, sequence, canvas, false);
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas, boolean simplified) {
        this.updateEllipseForCanvas(canvas);
        if (canvas instanceof IcyCanvas2D) {
            int zRange;
            if (!this.isVisible()) {
                return;
            }
            int cnvZ = canvas.getPositionZ();
            int dz = Math.abs((int)this.getZ() - cnvZ);
            if (dz > (zRange = Math.min(10, Math.max(3, sequence.getSizeZ() / 10)))) {
                return;
            }
            boolean shapeVisible = ShapeUtil.isVisible(g, this.ellipse);
            if (shapeVisible) {
                Graphics2D g2 = (Graphics2D)g.create();
                float ratio = 1.0f - (float)dz / (float)zRange;
                if (ratio != 1.0f) {
                    GraphicsUtil.mixAlpha(g2, ratio);
                }
                if (this.isSelected()) {
                    g2.setColor(this.getSelectedColor());
                } else {
                    g2.setColor(this.getColor());
                }
                if (simplified) {
                    int ray = (int)canvas.canvasToImageDeltaX(2);
                    g2.fillRect((int)this.getX() - ray, (int)this.getY() - ray, ray * 2, ray * 2);
                } else {
                    g2.fill(this.ellipse);
                    g2.setStroke(new BasicStroke((float)(this.getAdjRay(canvas) / 8.0)));
                    g2.setColor(Color.black);
                    g2.draw(this.ellipse);
                }
                g2.dispose();
            }
        } else if (canvas instanceof VtkCanvas) {
            // empty if block
        }
    }

    @Override
    public void keyPressed(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible() && !this.getReceiveKeyEventOnHidden()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        this.updateDrag(e, imagePoint.x, imagePoint.y, imagePoint.z);
    }

    @Override
    public void keyReleased(KeyEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible() && !this.getReceiveKeyEventOnHidden()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        this.updateDrag(e, imagePoint.x, imagePoint.y, imagePoint.z);
    }

    @Override
    public void mousePressed(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible() && !this.getReceiveMouseEventOnHidden()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        if (EventUtil.isLeftMouseButton(e) && this.isSelected()) {
            this.startDragMousePosition = imagePoint.toPoint3D();
            this.startDragPainterPosition = this.getPosition();
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        this.startDragMousePosition = null;
    }

    @Override
    public void mouseDrag(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible() && !this.getReceiveMouseEventOnHidden()) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (imagePoint == null) {
            return;
        }
        if (EventUtil.isLeftMouseButton(e) && this.isSelected()) {
            if (this.startDragMousePosition == null) {
                this.startDragMousePosition = imagePoint.toPoint3D();
                this.startDragPainterPosition = this.getPosition();
            }
            this.updateDrag(e, imagePoint.x, imagePoint.y, imagePoint.z);
            e.consume();
        }
    }

    @Override
    public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (!this.isVisible() && !this.getReceiveMouseEventOnHidden()) {
            return;
        }
        if (e.isConsumed()) {
            this.setSelected(false);
        } else {
            boolean overlapped = this.isOver(canvas, imagePoint != null ? imagePoint.toPoint3D() : null);
            this.setSelected(overlapped);
            if (overlapped) {
                e.consume();
            }
        }
    }

    @Override
    public void run() {
        this.rebuildVtkObjects();
    }

    public boolean loadPositionFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.setX(XMLUtil.getElementDoubleValue(node, ID_POS_X, 0.0));
            this.setY(XMLUtil.getElementDoubleValue(node, ID_POS_Y, 0.0));
            this.setZ(XMLUtil.getElementDoubleValue(node, ID_POS_Z, 0.0));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    public boolean savePositionToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementDoubleValue(node, ID_POS_X, this.getX());
        XMLUtil.setElementDoubleValue(node, ID_POS_Y, this.getY());
        XMLUtil.setElementDoubleValue(node, ID_POS_Z, this.getZ());
        return true;
    }

    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.beginUpdate();
        try {
            this.setColor(new Color(XMLUtil.getElementIntValue(node, ID_COLOR, DEFAULT_NORMAL_COLOR.getRGB())));
            this.setSelectedColor(new Color(XMLUtil.getElementIntValue(node, ID_SELECTEDCOLOR, DEFAULT_SELECTED_COLOR.getRGB())));
            this.setX(XMLUtil.getElementDoubleValue(node, ID_POS_X, 0.0));
            this.setY(XMLUtil.getElementDoubleValue(node, ID_POS_Y, 0.0));
            this.setZ(XMLUtil.getElementDoubleValue(node, ID_POS_Z, 0.0));
            this.setRay(XMLUtil.getElementIntValue(node, ID_RAY, 6));
            this.setVisible(XMLUtil.getElementBooleanValue(node, ID_VISIBLE, true));
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementIntValue(node, ID_COLOR, this.getColor().getRGB());
        XMLUtil.setElementIntValue(node, ID_SELECTEDCOLOR, this.getSelectedColor().getRGB());
        XMLUtil.setElementDoubleValue(node, ID_POS_X, this.getX());
        XMLUtil.setElementDoubleValue(node, ID_POS_Y, this.getY());
        XMLUtil.setElementDoubleValue(node, ID_POS_Z, this.getY());
        XMLUtil.setElementIntValue(node, ID_RAY, this.getRay());
        XMLUtil.setElementBooleanValue(node, ID_VISIBLE, this.isVisible());
        return true;
    }

    public static class Anchor3DEvent
    implements CollapsibleEvent {
        private final Anchor3D source;

        public Anchor3DEvent(Anchor3D source) {
            this.source = source;
        }

        public Anchor3D getSource() {
            return this.source;
        }

        @Override
        public boolean collapse(CollapsibleEvent event) {
            return this.equals(event);
        }

        @Override
        public int hashCode() {
            return this.source.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Anchor3DEvent) {
                Anchor3DEvent event = (Anchor3DEvent)obj;
                return event.getSource() == this.source;
            }
            return super.equals(obj);
        }
    }

    public static interface Anchor3DPositionListener
    extends EventListener {
        public void positionChanged(Anchor3D var1);
    }
}

