/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.file.FileUtil;
import icy.plugin.PluginLoader;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.util.JarUtil;
import icy.util.ReflectionUtil;
import icy.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static ClassLoader getContextClassLoader() {
        return SystemUtil.getContextClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return SystemUtil.getSystemClassLoader();
    }

    public static List<Class<?>> getLoadedClasses(ClassLoader cl) {
        try {
            Vector classes = (Vector)ReflectionUtil.getFieldObject(cl, "classes", true);
            return new ArrayList(classes);
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return null;
        }
    }

    public static Class<?> getPrimitiveType(String primitiveName) {
        if (primitiveName.equals("byte")) {
            return Byte.TYPE;
        }
        if (primitiveName.equals("short")) {
            return Short.TYPE;
        }
        if (primitiveName.equals("int")) {
            return Integer.TYPE;
        }
        if (primitiveName.equals("long")) {
            return Long.TYPE;
        }
        if (primitiveName.equals("char")) {
            return Character.TYPE;
        }
        if (primitiveName.equals("float")) {
            return Float.TYPE;
        }
        if (primitiveName.equals("double")) {
            return Double.TYPE;
        }
        if (primitiveName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (primitiveName.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    public static Class<?> findClass(String className) throws ClassNotFoundException {
        try {
            return PluginLoader.loadClass(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                return ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e2) {
                try {
                    return Class.forName(className, true, PluginLoader.getLoader());
                }
                catch (ClassNotFoundException e3) {
                    try {
                        return Class.forName(className, false, PluginLoader.getLoader());
                    }
                    catch (ClassNotFoundException e4) {
                        Class<?> result = ClassUtil.getPrimitiveType(className);
                        if (result != null) {
                            return result;
                        }
                        return Class.forName(className);
                    }
                }
            }
        }
    }

    public static String getQualifiedNameFromPath(String path) {
        return FileUtil.getGenericPath(path).replace('/', '.');
    }

    public static String getPathFromQualifiedName(String qualifiedName) {
        return qualifiedName.replace('.', '/');
    }

    public static String getPackageName(String className) {
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(0, index);
        }
        return "";
    }

    public static String getFirstPackageName(String className) {
        String packageName = ClassUtil.getPackageName(className);
        int index = packageName.lastIndexOf(46);
        if (index != -1) {
            return packageName.substring(0, index);
        }
        return packageName;
    }

    public static String getBaseClassName(String className) {
        int lastDollar = className.indexOf(36);
        if (lastDollar > 0) {
            return className.substring(0, lastDollar);
        }
        return className;
    }

    public static String getSimpleClassName(String className) {
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(index + 1);
        }
        return className;
    }

    public static String getJarPath(Class<?> c) {
        URL url = c.getResource('/' + c.getName().replace('.', '/') + ".class");
        if (url != null && url.getProtocol().equalsIgnoreCase("jar")) {
            String result = url.getPath();
            int ind = result.indexOf(58);
            if (ind != -1) {
                result = result.substring(ind + 1);
            }
            if ((ind = result.indexOf(33)) != -1) {
                result = result.substring(0, ind);
            }
            return new File(result).getAbsolutePath();
        }
        return "";
    }

    public static Class<?>[] getInterfaces(Class<?> c) {
        if (c == null) {
            return new Class[0];
        }
        return c.getInterfaces();
    }

    public static boolean isAbstract(Class<?> c) {
        if (c == null) {
            return false;
        }
        return Modifier.isAbstract(c.getModifiers());
    }

    public static boolean isPublic(Class<?> c) {
        if (c == null) {
            return false;
        }
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isPrivate(Class<?> c) {
        if (c == null) {
            return false;
        }
        return Modifier.isPrivate(c.getModifiers());
    }

    public static boolean isSubClass(Class<?> clazz, Class<?> baseClass) {
        if (clazz == null || baseClass == null) {
            return false;
        }
        return baseClass.isAssignableFrom(clazz);
    }

    public static List<String> getResourcesInPackage(String packageName, String extension, boolean recursive, boolean includeFolder, boolean includeJar, boolean includeHidden) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        ClassUtil.getResourcesInPackage(packageName, extension, recursive, includeFolder, includeJar, includeHidden, result);
        return result;
    }

    private static void getResourcesInPackage(String packageName, String extension, boolean recursive, boolean includeFolder, boolean includeJar, boolean includeHidden, List<String> result) throws IOException {
        String ext;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = ClassUtil.getPathFromQualifiedName(packageName);
        Enumeration<URL> urls = classLoader.getResources(path);
        String string = ext = StringUtil.isEmpty(extension) ? "" : extension.toLowerCase();
        while (urls.hasMoreElements()) {
            URL packageUrl = urls.nextElement();
            String urlPath = URLDecoder.decode(packageUrl.getFile(), "UTF-8");
            String protocol = packageUrl.getProtocol().toLowerCase();
            if ("file".equals(protocol)) {
                ClassUtil.getResourcesInPath(urlPath, packageName, recursive, includeFolder, includeJar, includeHidden, result);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarURLConnection connection = (JarURLConnection)packageUrl.openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
            String pathWithPrefix = path + '/';
            int prefixLength = path.length() + 1;
            while (jarEntryEnumeration.hasMoreElements()) {
                int index;
                JarEntry jarEntry = jarEntryEnumeration.nextElement();
                String absoluteFileName = jarEntry.getName();
                if (!StringUtil.isEmpty(extension) && !absoluteFileName.endsWith(ext)) continue;
                if (absoluteFileName.startsWith("/")) {
                    absoluteFileName = absoluteFileName.substring(1);
                }
                boolean accept = true;
                if (!absoluteFileName.startsWith(pathWithPrefix)) continue;
                if (!recursive && (index = absoluteFileName.indexOf(47, prefixLength)) != -1) {
                    accept = false;
                }
                if (!includeFolder && jarEntry.isDirectory()) {
                    accept = false;
                }
                if (!accept) continue;
                result.add(absoluteFileName);
            }
            jarFile.close();
        }
    }

    public static List<String> getResourcesInPath(String path, boolean recursive, boolean includeFolder, boolean includeJar, boolean includeHidden) {
        ArrayList<String> result = new ArrayList<String>();
        ClassUtil.getResourcesInPath(path, ClassUtil.getQualifiedNameFromPath(path), recursive, includeFolder, includeJar, includeHidden, result);
        return result;
    }

    public static List<String> getResourcesInPath(String path, String basePath, boolean recursive, boolean includeFolder, boolean includeJar, boolean includeHidden) {
        ArrayList<String> result = new ArrayList<String>();
        ClassUtil.getResourcesInPath(path, basePath, recursive, includeFolder, includeJar, includeHidden, result);
        return result;
    }

    public static void getResourcesInPath(String path, String basePath, boolean recursive, boolean includeFolder, boolean includeJar, boolean includeHidden, List<String> result) {
        File file = new File(path);
        String qualifiedPath = StringUtil.isEmpty(basePath) ? "" : basePath + "/";
        if (file.isDirectory()) {
            if (recursive) {
                ClassUtil.findResourcesRecursive(file, includeFolder, includeJar, includeHidden, result, qualifiedPath);
            } else {
                for (File subFile : file.listFiles()) {
                    ClassUtil.findResourceInFile(subFile, includeJar, includeHidden, result, qualifiedPath);
                }
            }
        } else {
            ClassUtil.findResourceInFile(file, includeJar, includeHidden, result, qualifiedPath);
        }
    }

    private static void findResourcesRecursive(File directory, boolean includeFolder, boolean includeJar, boolean includeHidden, List<String> result, String basePath) {
        for (File childFile : directory.listFiles()) {
            String childFilename = childFile.getName();
            if (childFile.isDirectory()) {
                if (!includeHidden && childFilename.startsWith(".")) continue;
                if (includeFolder) {
                    result.add(basePath + childFilename);
                }
                ClassUtil.findResourcesRecursive(childFile, includeJar, includeFolder, includeHidden, result, basePath + childFilename + '/');
                continue;
            }
            ClassUtil.findResourceInFile(childFile, includeJar, includeHidden, result, basePath);
        }
    }

    public static void findResourceInFile(File file, boolean includeJar, boolean includeHidden, List<String> result, String basePath) {
        String shortName = file.getName();
        if (!includeHidden && shortName.startsWith(".")) {
            return;
        }
        String fileName = file.getPath();
        if (FileUtil.getFileExtension(fileName, false).toLowerCase().equals("jar")) {
            if (includeJar) {
                JarUtil.getAllFiles(fileName, false, includeHidden, result);
            }
        } else {
            result.add(basePath + shortName);
        }
    }

    public static Set<String> findClassNamesInPackage(String packageName, boolean includeSubPackages) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        ClassUtil.findClassNamesInPackage(packageName, includeSubPackages, classes);
        return classes;
    }

    public static void findClassNamesInPackage(String packageName, boolean includeSubPackages, Set<String> classes) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = ClassUtil.getPathFromQualifiedName(packageName);
        Enumeration<URL> urls = classLoader.getResources(path);
        while (urls.hasMoreElements()) {
            URL packageUrl = urls.nextElement();
            String urlPath = URLDecoder.decode(packageUrl.getFile(), "UTF-8");
            String protocol = packageUrl.getProtocol().toLowerCase();
            if ("file".equals(protocol)) {
                ClassUtil.findClassNamesInPath(urlPath, packageName, includeSubPackages, classes);
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            JarURLConnection connection = (JarURLConnection)packageUrl.openConnection();
            JarFile jarFile = connection.getJarFile();
            Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
            String pathWithPrefix = path + '/';
            int prefixLength = path.length() + 1;
            while (jarEntryEnumeration.hasMoreElements()) {
                String className;
                int index;
                JarEntry jarEntry = jarEntryEnumeration.nextElement();
                String absoluteFileName = jarEntry.getName();
                if (!absoluteFileName.endsWith(".class")) continue;
                if (absoluteFileName.startsWith("/")) {
                    absoluteFileName = absoluteFileName.substring(1);
                }
                boolean accept = true;
                if (!absoluteFileName.startsWith(pathWithPrefix)) continue;
                String qualifiedName = absoluteFileName.replace('/', '.');
                if (!includeSubPackages && (index = absoluteFileName.indexOf(47, prefixLength)) != -1) {
                    accept = false;
                }
                if (!accept || (className = ClassUtil.filenameToClassname(qualifiedName)) == null) continue;
                classes.add(className);
            }
            jarFile.close();
        }
    }

    public static HashSet<String> findClassNamesInPath(String path, boolean includeSubDir) {
        return ClassUtil.findClassNamesInPath(path, ClassUtil.getQualifiedNameFromPath(path), includeSubDir, true);
    }

    public static HashSet<String> findClassNamesInPath(String path, boolean includeSubDir, boolean includeJar) {
        return ClassUtil.findClassNamesInPath(path, ClassUtil.getQualifiedNameFromPath(path), includeSubDir, includeJar);
    }

    public static HashSet<String> findClassNamesInPath(String path, String packageName, boolean includeSubDir) {
        HashSet<String> classes = new HashSet<String>();
        ClassUtil.findClassNamesInPath(path, packageName, includeSubDir, true, classes);
        return classes;
    }

    public static HashSet<String> findClassNamesInPath(String path, String packageName, boolean includeSubDir, boolean includeJar) {
        HashSet<String> classes = new HashSet<String>();
        ClassUtil.findClassNamesInPath(path, packageName, includeSubDir, includeJar, classes);
        return classes;
    }

    public static void findClassNamesInPath(String path, String packageName, boolean includeSubDir, Set<String> classes) {
        ClassUtil.findClassNamesInPath(path, packageName, includeSubDir, true, classes);
    }

    public static void findClassNamesInPath(String path, String packageName, boolean includeSubDir, boolean includeJar, Set<String> classes) {
        File dir = new File(path);
        String qualifiedName = StringUtil.isEmpty(packageName) ? "" : packageName + '.';
        if (dir.isDirectory()) {
            if (includeSubDir) {
                ClassUtil.findClassNamesRecursive(dir, includeJar, classes, qualifiedName);
            } else {
                for (File file : dir.listFiles()) {
                    ClassUtil.findClassNameInFile(file, includeJar, classes, qualifiedName);
                }
            }
        } else {
            ClassUtil.findClassNameInFile(dir, classes, qualifiedName);
        }
    }

    private static void findClassNamesRecursive(File directory, boolean includeJar, Set<String> classSet, String qualifiedName) {
        for (File childFile : directory.listFiles()) {
            String childFilename = childFile.getName();
            if (childFilename.startsWith(".")) continue;
            if (childFile.isDirectory()) {
                ClassUtil.findClassNamesRecursive(childFile, includeJar, classSet, qualifiedName + childFilename + '.');
                continue;
            }
            ClassUtil.findClassNameInFile(childFile, includeJar, classSet, qualifiedName);
        }
    }

    public static void findClassNameInFile(File file, boolean includeJar, Set<String> classSet, String qualifiedNamePrefix) {
        String fileName = file.getPath();
        if (FileUtil.getFileExtension(fileName, false).toLowerCase().equals("jar")) {
            if (includeJar) {
                ClassUtil.findClassNamesInJAR(fileName, classSet);
            }
        } else {
            ClassUtil.addClassFileName(file.getName(), classSet, qualifiedNamePrefix);
        }
    }

    public static void findClassNameInFile(File file, Set<String> classSet, String qualifiedNamePrefix) {
        ClassUtil.findClassNameInFile(file, true, classSet, qualifiedNamePrefix);
    }

    public static void findClassNamesInJAR(String fileName, Set<String> classSet) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(fileName);
        }
        catch (IOException e) {
            System.err.println("Cannot open " + fileName + ":");
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory()) continue;
            ClassUtil.addClassFileName(jarEntry.getName(), classSet, "");
        }
        try {
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Set<String> findClassNamesInJAR(String fileName) {
        HashSet<String> result = new HashSet<String>();
        ClassUtil.findClassNamesInJAR(fileName, result);
        return result;
    }

    private static void addClassFileName(String fileName, Set<String> classSet, String prefix) {
        String simpleClassName = ClassUtil.filenameToClassname(fileName);
        if (simpleClassName != null) {
            classSet.add(prefix + simpleClassName);
        }
    }

    public static String filenameToClassname(String fileName) {
        if (fileName.toLowerCase().endsWith(".class")) {
            return ClassUtil.fixClassName(fileName.substring(0, fileName.length() - 6));
        }
        return null;
    }

    public static String fixClassName(String fileName) {
        char innerChar;
        String result = fileName.replace('/', '.');
        int lastDollar = result.lastIndexOf(36);
        if (lastDollar > 0 && (innerChar = result.charAt(lastDollar + 1)) >= '0' && innerChar <= '9') {
            return null;
        }
        return result;
    }

    public static File getFile(String fullClassName) {
        String className = ClassUtil.getBaseClassName(fullClassName);
        try {
            URLConnection connection;
            Class<?> clazz = ClassUtil.findClass(className);
            URL classUrl = clazz.getResource(clazz.getSimpleName() + ".class");
            if (classUrl == null) {
                classUrl = clazz.getResource(clazz.getName() + ".class");
            }
            if ((connection = classUrl.openConnection()) instanceof JarURLConnection) {
                return new File(((JarURLConnection)connection).getJarFileURL().toURI());
            }
            return new File(classUrl.toURI());
        }
        catch (Exception e) {
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return null;
        }
    }

    @Deprecated
    public static Method getMethod(Object object, String methodName, boolean forceAccess, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        return ReflectionUtil.getMethod(object, methodName, forceAccess, parameterTypes);
    }

    @Deprecated
    public static Object invokeMethod(Object object, String methodName, boolean forceAccess, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ReflectionUtil.invokeMethod(object, methodName, forceAccess, args);
    }

    @Deprecated
    public static Field getField(Object object, String fieldName, boolean forceAccess) throws SecurityException, NoSuchFieldException {
        return ReflectionUtil.getField(object, fieldName, forceAccess);
    }

    @Deprecated
    public static Object getFieldObject(Object object, String fieldName, boolean forceAccess) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        return ReflectionUtil.getFieldObject(object, fieldName, forceAccess);
    }
}

