/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.math.MathUtil;
import icy.util.Random;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.color.ColorSpace;

public class ColorUtil {
    public static final ColorSpace sRGB = ColorSpace.getInstance(1000);
    private static final Color[] colors = ColorUtil.generateRainbow(32, true, true, true);

    public static Color getRandomColor() {
        return colors[Random.nextInt(20)];
    }

    public static Color[] generateRainbow(float saturation, float brightness, int size, boolean black, boolean white, boolean gray) {
        Color[] result = new Color[size];
        int start = 0;
        if (black) {
            result[start++] = Color.black;
        }
        if (white) {
            result[start++] = Color.white;
        }
        if (gray) {
            result[start++] = Color.gray;
        }
        for (int i = start; i < result.length; ++i) {
            result[i] = Color.getHSBColor((float)(i - start) / (float)(size - start), saturation, brightness);
        }
        return result;
    }

    public static Color[] generateRainbow(int size, boolean black, boolean white, boolean gray) {
        return ColorUtil.generateRainbow(1.0f, 1.0f, size, black, white, gray);
    }

    public static Color[] generateRainbow(int size) {
        return ColorUtil.generateRainbow(size, false, false, false);
    }

    public static String toString(Color color) {
        return ColorUtil.toString(color, true, ":");
    }

    public static String toString(int rgb) {
        return ColorUtil.toString(rgb, true, ":");
    }

    public static String toString(Color color, boolean hexa) {
        return ColorUtil.toString(color, hexa, ":");
    }

    public static String toString(int rgb, boolean hexa) {
        return ColorUtil.toString(rgb, hexa, ":");
    }

    public static String toString(Color color, boolean hexa, String sep) {
        if (color == null) {
            return "-";
        }
        return ColorUtil.toString(color.getRGB(), hexa, sep);
    }

    public static String toString(int rgb, boolean hexa, String sep) {
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        if (hexa) {
            return (StringUtil.toHexaString(a, 2) + sep + StringUtil.toHexaString(r, 2) + sep + StringUtil.toHexaString(g, 2) + sep + StringUtil.toHexaString(b, 2)).toUpperCase();
        }
        return StringUtil.toString(a) + sep + StringUtil.toString(r) + sep + StringUtil.toString(g) + sep + StringUtil.toString(b);
    }

    public static boolean isBlack(Color color) {
        return (color.getRGB() & 0xFFFFFF) == 0;
    }

    public static Color mixOver(Color backColor, Color frontColor) {
        float frontAlpha = (float)frontColor.getAlpha() / 255.0f;
        float invAlpha = 1.0f - frontAlpha;
        int r = (int)((float)backColor.getRed() * invAlpha + (float)frontColor.getRed() * frontAlpha);
        int g = (int)((float)backColor.getGreen() * invAlpha + (float)frontColor.getGreen() * frontAlpha);
        int b = (int)((float)backColor.getBlue() * invAlpha + (float)frontColor.getBlue() * frontAlpha);
        int a = Math.max(backColor.getAlpha(), frontColor.getAlpha());
        return new Color(r, g, b, a);
    }

    public static Color mix(Color c1, Color c2, float ratio) {
        float r2 = Math.min(1.0f, Math.max(0.0f, ratio));
        float r1 = 1.0f - r2;
        int r = (int)((float)c1.getRed() * r1 + (float)c2.getRed() * r2);
        int g = (int)((float)c1.getGreen() * r1 + (float)c2.getGreen() * r2);
        int b = (int)((float)c1.getBlue() * r1 + (float)c2.getBlue() * r2);
        return new Color(r, g, b);
    }

    public static Color mix(Color c1, Color c2, boolean useAlpha) {
        int a;
        int b;
        int g;
        int r;
        if (useAlpha) {
            float a1 = (float)c1.getAlpha() / 255.0f;
            float a2 = (float)c2.getAlpha() / 255.0f;
            float af = a1 + a2;
            r = (int)(((float)c1.getRed() * a1 + (float)c2.getRed() * a2) / af);
            g = (int)(((float)c1.getGreen() * a1 + (float)c2.getGreen() * a2) / af);
            b = (int)(((float)c1.getBlue() * a1 + (float)c2.getBlue() * a2) / af);
            a = Math.max(c1.getAlpha(), c2.getAlpha());
        } else {
            r = (c1.getRed() + c2.getRed()) / 2;
            g = (c1.getGreen() + c2.getGreen()) / 2;
            b = (c1.getBlue() + c2.getBlue()) / 2;
            a = 255;
        }
        return new Color(r, g, b, a);
    }

    public static Color mix(Color c1, Color c2) {
        return ColorUtil.mix(c1, c2, false);
    }

    public static Color add(Color c1, Color c2, boolean useAlpha) {
        int r = Math.min(c1.getRed() + c2.getRed(), 255);
        int g = Math.min(c1.getGreen() + c2.getGreen(), 255);
        int b = Math.min(c1.getBlue() + c2.getBlue(), 255);
        int a = useAlpha ? Math.max(c1.getAlpha(), c2.getAlpha()) : 255;
        return new Color(r, g, b, a);
    }

    public static Color add(Color c1, Color c2) {
        return ColorUtil.add(c1, c2, false);
    }

    public static Color sub(Color c1, Color c2, boolean useAlpha) {
        int r = Math.max(c1.getRed() - c2.getRed(), 0);
        int g = Math.max(c1.getGreen() - c2.getGreen(), 0);
        int b = Math.max(c1.getBlue() - c2.getBlue(), 0);
        int a = useAlpha ? Math.max(c1.getAlpha(), c2.getAlpha()) : 255;
        return new Color(r, g, b, a);
    }

    public static Color sub(Color c1, Color c2) {
        return ColorUtil.sub(c1, c2, false);
    }

    public static Color xor(Color c) {
        return new Color(c.getRed() ^ 0xFF, c.getGreen() ^ 0xFF, c.getBlue() ^ 0xFF, c.getAlpha());
    }

    public static int getGrayMix(Color c) {
        return ColorUtil.getGrayMix(c.getRGB());
    }

    public static int getGrayMix(int rgb) {
        return ((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb >> 0 & 0xFF)) / 3;
    }

    public static Color getGrayColorMix(Color c) {
        int gray = ColorUtil.getGrayMix(c);
        return new Color(gray, gray, gray);
    }

    public static Color getGrayColorLum(Color c) {
        int gray = ColorUtil.getLuminance(c);
        return new Color(gray, gray, gray);
    }

    public static int getLuminance(Color c) {
        return (int)((double)c.getRed() * 0.299 + (double)c.getGreen() * 0.587 + (double)c.getBlue() * 0.114);
    }

    public static float[] toHSV(Color c) {
        return ColorUtil.toHSV(c.getRGBColorComponents(null));
    }

    public static float[] toHSV(float[] rgb) {
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        if (max == 0.0f) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float v = max;
        float delta = max - min;
        float s = delta / max;
        if (delta == 0.0f) {
            return new float[]{0.0f, s, v};
        }
        float h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        if (h < 0.0f) {
            h += 6.0f;
        }
        return new float[]{h / 6.0f, s, v};
    }

    public static float[] fromHSV(float[] hsv) {
        float b;
        float g;
        float r;
        float h = hsv[0];
        float s = hsv[0];
        float v = hsv[0];
        if (s == 0.0f) {
            return new float[]{v, v, v};
        }
        int i = (int)Math.floor(h *= 6.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                r = v;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = v;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = v;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = v;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = v;
                break;
            }
            default: {
                r = v;
                g = p;
                b = q;
            }
        }
        return new float[]{r, g, b};
    }

    public static float[] fromXYZ(float[] xyz) {
        return sRGB.fromCIEXYZ(xyz);
    }

    public static float[] toXYZ(Color c) {
        return ColorUtil.toXYZ(c.getRGBColorComponents(null));
    }

    public static float[] toXYZ(float[] rgb) {
        return sRGB.toCIEXYZ(rgb);
    }

    public static float[] toLAB(Color c) {
        return ColorUtil.toLAB(c.getRGBColorComponents(null));
    }

    public static float[] toLAB(float[] rgb) {
        return ColorUtil.XYZtoLAB(ColorUtil.toXYZ(rgb));
    }

    private static float pivotXYZ(float value) {
        return value > 0.008856f ? (float)MathUtil.cubicRoot(value) : 7.787f * value + 0.1379f;
    }

    public static float[] XYZtoLAB(float[] xyz) {
        float x = ColorUtil.pivotXYZ(xyz[0] / 95.047f);
        float y = ColorUtil.pivotXYZ(xyz[1] / 100.0f);
        float z = ColorUtil.pivotXYZ(xyz[2] / 108.883f);
        float l = Math.max(0.0f, 116.0f * y - 16.0f);
        float a = 500.0f * (x - y);
        float b = 200.0f * (y - z);
        return new float[]{l, a, b};
    }

    public static double getDistance(Color c1, Color c2, boolean hsv) {
        if (hsv) {
            float[] hsv1 = ColorUtil.toHSV(c1);
            float[] hsv2 = ColorUtil.toHSV(c2);
            return ColorUtil.getDistance(hsv1, hsv2, true);
        }
        float[] lab1 = ColorUtil.toLAB(c1);
        float[] lab2 = ColorUtil.toLAB(c2);
        return ColorUtil.getDistance(lab1, lab2, true);
    }

    static double getDistance(float[] c1, float[] c2, boolean compareThirdComponent) {
        float result = (float)(Math.pow(c1[0] - c2[0], 2.0) + Math.pow(c1[1] - c2[1], 2.0));
        if (compareThirdComponent) {
            result = (float)((double)result + Math.pow(c1[2] - c2[2], 2.0));
        }
        return result;
    }

    public static Color getDominantColor(Color[] colors) {
        return ColorUtil.getDominantColor(colors, 33);
    }

    public static Color getDominantColor(Color[] colors, int binNumber) {
        int i;
        Color[] baseColors = ColorUtil.generateRainbow(1.0f, 1.0f, binNumber, false, false, true);
        float[][] colorsHSV = new float[colors.length][];
        float[][] baseColorsHSV = new float[binNumber][];
        for (i = 0; i < colors.length; ++i) {
            colorsHSV[i] = ColorUtil.toHSV(colors[i]);
        }
        for (i = 0; i < baseColors.length; ++i) {
            baseColorsHSV[i] = ColorUtil.toHSV(baseColors[i]);
        }
        int[] bins = new int[binNumber];
        for (float[] colorHsv : colorsHSV) {
            double minDist = ColorUtil.getDistance(colorHsv, baseColorsHSV[0], true);
            int minInd = 0;
            for (int ind = 1; ind < baseColorsHSV.length; ++ind) {
                double dist = ColorUtil.getDistance(colorHsv, baseColorsHSV[ind], true);
                if (!(dist < minDist)) continue;
                minDist = dist;
                minInd = ind;
            }
            int n = minInd;
            bins[n] = bins[n] + 1;
        }
        int max = bins[0];
        int maxInd = 0;
        for (int i2 = 1; i2 < bins.length; ++i2) {
            int v = bins[i2];
            if (v <= max) continue;
            max = v;
            maxInd = i2;
        }
        return baseColors[maxInd];
    }

    public static Color getColorFromWavelength(double wavelength) {
        double b;
        double g;
        double r;
        if (wavelength >= 380.0 && wavelength < 440.0) {
            r = -(wavelength - 440.0) / 60.0;
            g = 0.0;
            b = 1.0;
        } else if (wavelength >= 440.0 && wavelength < 490.0) {
            r = 0.0;
            g = (wavelength - 440.0) / 50.0;
            b = 1.0;
        } else if (wavelength >= 490.0 && wavelength < 510.0) {
            r = 0.0;
            g = 1.0;
            b = -(wavelength - 510.0) / 20.0;
        } else if (wavelength >= 510.0 && wavelength < 580.0) {
            r = (wavelength - 510.0) / 70.0;
            g = 1.0;
            b = 0.0;
        } else if (wavelength >= 580.0 && wavelength < 645.0) {
            r = 1.0;
            g = -(wavelength - 645.0) / 65.0;
            b = 0.0;
        } else if (wavelength >= 645.0 && wavelength < 781.0) {
            r = 1.0;
            g = 0.0;
            b = 0.0;
        } else {
            r = 0.0;
            g = 0.0;
            b = 0.0;
        }
        double factor = wavelength >= 380.0 && wavelength < 420.0 ? 0.3 + 0.7 * (wavelength - 380.0) / 40.0 : (wavelength >= 420.0 && wavelength < 701.0 ? 1.0 : (wavelength >= 701.0 && wavelength < 781.0 ? 0.3 + 0.7 * (780.0 - wavelength) / 80.0 : 0.0));
        int[] rgb = new int[]{r == 0.0 ? 0 : (int)Math.round(255.0 * r * factor), g == 0.0 ? 0 : (int)Math.round(255.0 * g * factor), b == 0.0 ? 0 : (int)Math.round(255.0 * b * factor)};
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

