/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VectraReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectraReader.class);
    private static final String SOFTWARE_CHECK = "PerkinElmer-QPI";
    private int pyramidDepth = 1;
    private String profileXML;

    public VectraReader() {
        super("PerkinElmer Vectra/QPTIFF", new String[]{"tiff", "tif", "qptiff"});
        this.domains = new String[]{"Histology", "Light Microscopy"};
        this.noSubresolutions = true;
        this.suffixSufficient = false;
        this.canSeparateSeries = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return VectraReader.checkSuffix(name, "qptiff");
        }
        try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
            TiffParser tiffParser = new TiffParser(stream);
            tiffParser.setDoCaching(false);
            if (!tiffParser.isValidHeader()) {
                boolean bl = false;
                return bl;
            }
            IFD ifd = tiffParser.getFirstIFD();
            if (ifd == null) {
                boolean bl = false;
                return bl;
            }
            tiffParser.fillInIFD(ifd);
            String software = ifd.getIFDTextValue(305);
            boolean bl = software != null && software.startsWith(SOFTWARE_CHECK);
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", e);
            return false;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        int ifd = this.getIFDIndex(this.getCoreIndex(), no);
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h2);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        if (this.getCoreIndex() < this.pyramidDepth - 1) {
            int currentIndex = this.getCoreIndex();
            this.setCoreIndex(this.pyramidDepth - 1);
            byte[] thumb = this.openThumbBytes(no);
            this.setCoreIndex(currentIndex);
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pyramidDepth = 1;
            this.profileXML = null;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.getIFDIndex(this.getCoreIndex(), 0);
            return (int)((IFD)this.ifds.get(ifd)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = this.getIFDIndex(this.getCoreIndex(), 0);
            return (int)((IFD)this.ifds.get(ifd)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int s2;
        IFD ifd;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        this.thumbnailIFDs = null;
        for (IFD ifd2 : this.ifds) {
            this.tiffParser.fillInIFD(ifd2);
        }
        CoreMetadata m3 = (CoreMetadata)this.core.get(0, 0);
        m3.sizeC = 1;
        if (((IFD)this.ifds.get(0)).getSamplesPerPixel() == 1) {
            long width = ((IFD)this.ifds.get(0)).getImageWidth();
            long height = ((IFD)this.ifds.get(0)).getImageLength();
            int ifd3 = 1;
            while (((IFD)this.ifds.get(ifd3)).getImageWidth() == width && ((IFD)this.ifds.get(ifd3)).getImageLength() == height) {
                ++m3.sizeC;
                ++ifd3;
            }
        }
        for (int start = m3.sizeC + 1; start < this.ifds.size() && (ifd = (IFD)this.ifds.get(start)).getIFDIntValue(254) == 1; start += m3.sizeC) {
            ++this.pyramidDepth;
        }
        int coreSize = this.ifds.size() - this.pyramidDepth * (m3.sizeC - 1);
        this.core.clear();
        for (s2 = 0; s2 < coreSize; ++s2) {
            CoreMetadata ms = new CoreMetadata(m3);
            if (s2 == 0) {
                ms.resolutionCount = this.pyramidDepth;
            }
            if (s2 > 0 && s2 < this.pyramidDepth) {
                this.core.add(0, ms);
                continue;
            }
            this.core.add(ms);
        }
        for (s2 = 0; s2 < this.core.size(); ++s2) {
            for (int r = 0; r < this.core.size(s2); ++r) {
                CoreMetadata ms = (CoreMetadata)this.core.get(s2, r);
                int index = this.getIFDIndex(this.core.flattenedIndex(s2, r), 0);
                IFD ifd4 = (IFD)this.ifds.get(index);
                PhotoInterp p = ifd4.getPhotometricInterpretation();
                int samples = ifd4.getSamplesPerPixel();
                ms.rgb = samples > 1 || p == PhotoInterp.RGB;
                ms.sizeX = (int)ifd4.getImageWidth();
                ms.sizeY = (int)ifd4.getImageLength();
                ms.sizeZ = 1;
                ms.sizeT = 1;
                if (ms.rgb) {
                    ms.sizeC = samples;
                }
                ms.littleEndian = ifd4.isLittleEndian();
                ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
                ms.imageCount = ms.sizeC / samples;
                ms.pixelType = ifd4.getPixelType();
                ms.metadataComplete = true;
                ms.interleaved = false;
                ms.falseColor = false;
                ms.dimensionOrder = "XYCZT";
                ms.thumbnail = s2 != 0 || r > 0;
            }
        }
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            int coreIndex = this.seriesToCoreIndex(i);
            store.setImageName(this.getImageName(coreIndex), i);
            store.setImageDescription("", i);
            int ifdIndex = this.getIFDIndex(coreIndex, 0);
            IFD ifd = (IFD)this.ifds.get(ifdIndex);
            double x = ifd.getXResolution();
            double y = ifd.getYResolution();
            store.setPixelsPhysicalSizeX(FormatTools.getPhysicalSizeX(x), i);
            store.setPixelsPhysicalSizeY(FormatTools.getPhysicalSizeY(y), i);
        }
        for (int c = 0; c < this.getSizeC(); ++c) {
            String xml = this.getIFDComment(c);
            try {
                Element root = XMLTools.parseDOM(xml).getDocumentElement();
                NodeList children = root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    int series;
                    if (!(children.item(i) instanceof Element)) continue;
                    Element e = (Element)children.item(i);
                    String name = e.getNodeName();
                    String value = e.getTextContent();
                    if (name.equals("ScanProfile")) {
                        try {
                            Document profileRoot = XMLTools.createDocument();
                            Node tmp = profileRoot.importNode(e, true);
                            profileRoot.appendChild(tmp);
                            this.profileXML = XMLTools.getXML(profileRoot);
                            this.addGlobalMeta(name, this.profileXML);
                        }
                        catch (Exception ex) {
                            LOGGER.debug("Could not preserve scan profile metadata", ex);
                        }
                    } else {
                        this.addGlobalMetaList(name, value);
                    }
                    if (name.equals("Name")) {
                        if (this.hasFlattenedResolutions()) {
                            for (int series2 = 0; series2 < this.pyramidDepth; ++series2) {
                                store.setChannelName(value, series2, c);
                            }
                            continue;
                        }
                        store.setChannelName(value, 0, c);
                        continue;
                    }
                    if (name.equals("Color")) {
                        String[] components = value.split(",");
                        Color color = new Color(Integer.parseInt(components[0]), Integer.parseInt(components[1]), Integer.parseInt(components[2]), 255);
                        if (this.hasFlattenedResolutions()) {
                            for (series = 0; series < this.pyramidDepth; ++series) {
                                store.setChannelColor(color, series, c);
                            }
                            continue;
                        }
                        store.setChannelColor(color, 0, c);
                        continue;
                    }
                    if (name.equals("Objective") && c == 0) {
                        String instrument = MetadataTools.createLSID("Instrument", 0);
                        String objective = MetadataTools.createLSID("Objective", 0, 0);
                        store.setInstrumentID(instrument, 0);
                        store.setObjectiveID(objective, 0, 0);
                        store.setObjectiveModel(value, 0, 0);
                        try {
                            String mag = value.toLowerCase().replace("x", "");
                            Double magFactor = DataTools.parseDouble(mag);
                            store.setObjectiveNominalMagnification(magFactor, 0, 0);
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.info("Could not determine magnification: {}", (Object)value);
                        }
                        for (series = 0; series < this.getSeriesCount(); ++series) {
                            store.setImageInstrumentRef(instrument, series);
                            store.setObjectiveSettingsID(objective, series);
                        }
                        continue;
                    }
                    if (!name.equals("ExposureTime")) continue;
                    Time exposure = new Time(DataTools.parseDouble(value), UNITS.MICROSECOND);
                    store.setPlaneExposureTime(exposure, 0, c);
                    store.setPlaneTheZ(new NonNegativeInteger(0), 0, c);
                    store.setPlaneTheT(new NonNegativeInteger(0), 0, c);
                    store.setPlaneTheC(new NonNegativeInteger(c), 0, c);
                }
                continue;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                LOGGER.warn("Could not parse XML for channel {}", (Object)c);
                LOGGER.debug("", e);
            }
        }
    }

    public String getScanProfileXML() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.profileXML;
    }

    private String getImageName(int coreIndex) {
        if (coreIndex < this.pyramidDepth) {
            return "resolution #" + (coreIndex + 1);
        }
        if (coreIndex == this.pyramidDepth) {
            return "thumbnail";
        }
        String name = this.getImageType(this.getIFDIndex(coreIndex, 0));
        if (name != null) {
            return name;
        }
        return this.core.flattenedSize() == this.ifds.size() - 1 ? "label" : "macro";
    }

    private String getIFDComment(int ifdIndex) {
        String xml = ((IFD)this.ifds.get(ifdIndex)).getComment().trim();
        xml = xml.replace("utf-16", "utf-8");
        return xml;
    }

    private String getImageType(int ifdIndex) {
        String xml = this.getIFDComment(ifdIndex);
        try {
            Element root = XMLTools.parseDOM(xml).getDocumentElement();
            NodeList types = root.getElementsByTagName("ImageType");
            if (types.getLength() > 0) {
                return types.item(0).getTextContent();
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.debug("Could not determine image type for IFD #" + ifdIndex, e);
        }
        return null;
    }

    private int getIFDIndex(int coreIndex, int no) {
        if (coreIndex == 0) {
            return no;
        }
        if (coreIndex < this.pyramidDepth) {
            return this.getImageCount() * coreIndex + 1 + no;
        }
        if (coreIndex == this.pyramidDepth) {
            return ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount;
        }
        return this.ifds.size() - (this.core.flattenedSize() - coreIndex);
    }
}

