/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.Int1D;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.StriddenFloat1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float1D
extends Array1D
implements FloatArray {
    protected Float1D(int dim1) {
        super(dim1);
    }

    protected Float1D(int[] dims) {
        super(dims);
    }

    protected Float1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1);

    public abstract void set(int var1, float var2);

    @Override
    public void fill(float value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            this.set(i1, value);
        }
    }

    @Override
    public void increment(float value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            this.set(i1, this.get(i1) + value);
        }
    }

    @Override
    public void decrement(float value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            this.set(i1, this.get(i1) - value);
        }
    }

    @Override
    public void scale(float value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            this.set(i1, this.get(i1) * value);
        }
    }

    @Override
    public void map(FloatFunction function) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            this.set(i1, function.apply(this.get(i1)));
        }
    }

    @Override
    public void fill(FloatGenerator generator) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            this.set(i1, generator.nextFloat());
        }
    }

    @Override
    public void scan(FloatScanner scanner) {
        scanner.initialize(this.get(0));
        for (int i1 = 1; i1 < this.dim1; ++i1) {
            scanner.update(this.get(i1));
        }
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float minValue = this.get(0);
        for (int i1 = 1; i1 < this.dim1; ++i1) {
            float value = this.get(i1);
            if (!(value < minValue)) continue;
            minValue = value;
        }
        return minValue;
    }

    @Override
    public float max() {
        float maxValue = this.get(0);
        for (int i1 = 1; i1 < this.dim1; ++i1) {
            float value = this.get(i1);
            if (!(value > maxValue)) continue;
            maxValue = value;
        }
        return maxValue;
    }

    @Override
    public float[] getMinAndMax() {
        float[] result = new float[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(float[] mm) {
        float minValue;
        float maxValue = minValue = this.get(0);
        for (int i1 = 1; i1 < this.dim1; ++i1) {
            float value = this.get(i1);
            if (value < minValue) {
                minValue = value;
            }
            if (!(value > maxValue)) continue;
            maxValue = value;
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public float sum() {
        float totalValue = this.get(0);
        for (int i1 = 1; i1 < this.dim1; ++i1) {
            totalValue += this.get(i1);
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] out = new byte[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (byte)inp[i];
            }
        } else {
            int i = -1;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                out[++i] = (byte)this.get(i1);
            }
        }
        return Byte1D.wrap(out, this.getShape());
    }

    @Override
    public Short1D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)inp[i];
            }
        } else {
            int i = -1;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                out[++i] = (short)this.get(i1);
            }
        }
        return Short1D.wrap(out, this.getShape());
    }

    @Override
    public Int1D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (int)inp[i];
            }
        } else {
            int i = -1;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                out[++i] = (int)this.get(i1);
            }
        }
        return Int1D.wrap(out, this.getShape());
    }

    @Override
    public Long1D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (long)inp[i];
            }
        } else {
            int i = -1;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                out[++i] = (long)this.get(i1);
            }
        }
        return Long1D.wrap(out, this.getShape());
    }

    @Override
    public Float1D toFloat() {
        return this;
    }

    @Override
    public Double1D toDouble() {
        double[] out = new double[this.number];
        if (this.isFlat()) {
            float[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i];
            }
        } else {
            int i = -1;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                out[++i] = this.get(i1);
            }
        }
        return Double1D.wrap(out, this.getShape());
    }

    @Override
    public Float1D copy() {
        return new FlatFloat1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Float1D src = arr.getType() == 4 ? (Float1D)arr : (Float1D)arr.toFloat();
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            this.set(i1, src.get(i1));
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                this.set(i1, (float)src.get(i1));
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                this.set(i1, (float)src.get(i1));
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float1D create() {
        return new FlatFloat1D(this.getShape());
    }

    public static Float1D create(int dim1) {
        return new FlatFloat1D(dim1);
    }

    public static Float1D create(int[] dims) {
        return new FlatFloat1D(dims);
    }

    public static Float1D create(Shape shape) {
        return new FlatFloat1D(shape);
    }

    public static Float1D wrap(float[] data, int dim1) {
        return new FlatFloat1D(data, dim1);
    }

    public static Float1D wrap(float[] data, int[] dims) {
        return new FlatFloat1D(data, dims);
    }

    public static Float1D wrap(float[] data, Shape shape) {
        return new FlatFloat1D(data, shape);
    }

    public static Float1D wrap(float[] data, int offset, int stride1, int dim1) {
        return new StriddenFloat1D(data, offset, stride1, dim1);
    }

    @Override
    public abstract FloatScalar slice(int var1);

    @Override
    public abstract FloatScalar slice(int var1, int var2);

    @Override
    public abstract Float1D view(Range var1);

    @Override
    public abstract Float1D view(int[] var1);

    @Override
    public abstract Float1D as1D();
}

