/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.Long1D;
import mitiv.array.LongArray;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.array.impl.FlatLong1D;
import mitiv.array.impl.StriddenLong1D;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public class LongScalar
extends Scalar
implements LongArray {
    final long[] data;
    final int offset;
    final boolean flat;

    public LongScalar() {
        this.data = new long[1];
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public LongScalar create() {
        return new LongScalar();
    }

    public LongScalar(long[] arr, int idx) {
        this.data = arr;
        this.offset = idx;
        this.flat = idx == 0 && arr.length == 1;
        this.checkSanity();
    }

    public static LongScalar wrap(long[] arr, int idx) {
        return new LongScalar(arr, idx);
    }

    public LongScalar(long value) {
        this.data = new long[]{value};
        this.offset = 0;
        this.flat = true;
    }

    @Override
    public final void checkSanity() {
        if (this.offset < 0 || this.offset >= this.data.length) {
            throw new IndexOutOfBoundsException("Scalar offset is out of bounds");
        }
    }

    @Override
    public final int getType() {
        return 3;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    final int index() {
        return this.offset;
    }

    public final long get() {
        return this.data[this.offset];
    }

    public final void set(long value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(long value) {
        this.data[this.offset] = value;
    }

    @Override
    public final void fill(LongGenerator generator) {
        this.data[this.offset] = generator.nextLong();
    }

    @Override
    public final void increment(long value) {
        int n = this.offset;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public final void decrement(long value) {
        int n = this.offset;
        this.data[n] = this.data[n] - value;
    }

    @Override
    public final void scale(long value) {
        int n = this.offset;
        this.data[n] = this.data[n] * value;
    }

    @Override
    public final void map(LongFunction function) {
        this.data[this.offset] = function.apply(this.data[this.offset]);
    }

    @Override
    public final void scan(LongScanner scanner) {
        scanner.initialize(this.data[this.offset]);
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public final long[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        return new long[]{this.data[this.offset]};
    }

    @Override
    public final long[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public long min() {
        return this.data[this.offset];
    }

    @Override
    public long max() {
        return this.data[this.offset];
    }

    @Override
    public long[] getMinAndMax() {
        long[] result = new long[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(long[] mm) {
        long value;
        mm[0] = value = this.data[this.offset];
        mm[1] = value;
    }

    @Override
    public long sum() {
        return this.data[this.offset];
    }

    @Override
    public double average() {
        return this.data[this.offset];
    }

    @Override
    public final ByteArray toByte() {
        return new ByteScalar((byte)this.data[this.offset]);
    }

    @Override
    public final ShortArray toShort() {
        return new ShortScalar((short)this.data[this.offset]);
    }

    @Override
    public final IntArray toInt() {
        return new IntScalar((int)this.data[this.offset]);
    }

    @Override
    public final LongArray toLong() {
        return this;
    }

    @Override
    public final FloatArray toFloat() {
        return new FloatScalar(this.data[this.offset]);
    }

    @Override
    public final DoubleArray toDouble() {
        return new DoubleScalar(this.data[this.offset]);
    }

    @Override
    public final Long1D as1D() {
        if (this.offset == 0) {
            return new FlatLong1D(this.data, 1);
        }
        return new StriddenLong1D(this.data, this.offset, 0, 1);
    }

    @Override
    public final void assign(ShapedArray src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        switch (src.getType()) {
            case 0: {
                this.data[this.offset] = ((ByteScalar)src).get();
                break;
            }
            case 1: {
                this.data[this.offset] = ((ShortScalar)src).get();
                break;
            }
            case 2: {
                this.data[this.offset] = ((IntScalar)src).get();
                break;
            }
            case 3: {
                this.data[this.offset] = ((LongScalar)src).get();
                break;
            }
            case 4: {
                this.data[this.offset] = (long)((FloatScalar)src).get();
                break;
            }
            case 5: {
                this.data[this.offset] = (long)((DoubleScalar)src).get();
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
    }

    @Override
    public final void assign(ShapedVector src) {
        if (!shape.equals(src.getShape())) {
            throw new NonConformableArrayException();
        }
        this.data[this.offset] = (long)src.get(0);
    }

    @Override
    public final LongScalar copy() {
        return new LongScalar(this.data[this.offset]);
    }
}

