/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.process.process1D;

/**
 * Class that encloses a one-dimensional convolver.
 * 
 * @version November 16, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class Convolver1D {

	/** Convolves a sequence with a kernel, and puts the result in a new array. */
	public static double[] convolve(double vin[], double vout[],
			double kernel[]) {
		int n = vin.length;
		int nk = kernel.length;
		int kc = nk / 2;
		int period = (n <= 1 ? 1 : 2 * n - 2);
		int im;
		for (int i = 0; i < n; i++) {
			double sum = 0.0;
			for (int k = 0; k < nk; k++) {
				im = i + k - kc;
				while (im < 0) {
					im += period;
				}
				while (im >= n) {
					im = period - im;
					im = im < 0 ? -im : im;
				}
				sum += kernel[k] * vin[im];
			}
			vout[i] = sum;
		}
		return vout;
	}
	
	//------------------------------------------------------------------------------------------------
	/** Convolves a sequence with a kernel, and puts the result in a new array for the subdivision. 
	 * Border conditions : mirror*/
	public static double[] subdivConvolve(double vin[], double vout[],
			double kernel[], int period) {
		int n = vin.length;
		int nk = kernel.length;
		int nvout=vout.length;
		int index=0;
		
		for (int i = 0; i < nvout; i++) {
			double sum = 0.0;
		
			for (int k = 0; k < nk; k++) {
				index=i-nk+1+k;
				while (index<0 || index>n-1){
					if (index<0) index+=period;
					else if (index>n-1) index-=period;
				}
				
				sum += kernel[nk-1-k] * vin[index];
			}
			vout[i] = sum;
		}
		return vout;
	}
	
	//------------------------------------------------------------------------------------------------
	/** Convolves a sequence with a kernel, and puts the result in a new array for the refinement. 
	 * Border conditions : zeros*/
	public static double[] refinementConvolve(double vin[], double vout[],
			double kernel[]) {
		int n = vin.length;
		int nk = kernel.length;
		int nvout=vout.length;
		int index=0;
		
		for (int i = 0; i < nvout; i++) {
			double sum = 0.0;
		
			for (int k = 0; k < nk; k++) {
				index=i-nk+1+k;
				if(index>=0 && index<=n-1) sum += kernel[nk-1-k] * vin[index];
			}
			vout[i] = sum;
		}
		return vout;
	}
}
