package plugins.ylemontag.sequencecomparator.comparators;

import icy.sequence.Sequence;
import plugins.ylemontag.sequencecomparator.ErrorMeasure;

/**
 * 
 * @author Yoann Le Montagner
 *
 */
public class GlobalL2 extends GlobalSquaredErrorBased
{	
	/**
	 * Constructor
	 */
	public GlobalL2(String distanceName)
	{
		super(distanceName);
	}
	
	@Override
	protected void normalizeErrorMeasure(ErrorMeasure retVal, Sequence seq)
	{
		retVal.errorAll = Math.sqrt(retVal.errorAll);
		arrayNormalization(retVal.errorZ);
		arrayNormalization(retVal.errorT);
		arrayNormalization(retVal.errorC);
	}
	
	/**
	 * Compute the square root of all the elements in the array
	 */
	private static void arrayNormalization(double[] array)
	{
		for(int k=0; k<array.length; ++k) {
			array[k] = Math.sqrt(array[k]);
		}
	}
}
