/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.micromanager.block.capture;

import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import mmcorej.TaggedImage;
import org.json.JSONObject;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.MDUtils;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarArray;
import plugins.adufour.vars.lang.VarObject;
import plugins.adufour.vars.util.VarException;
import plugins.stef.micromanager.block.AbstractMicroscopeBlock;
import plugins.stef.micromanager.block.lang.VarChannels;
import plugins.stef.micromanager.block.lang.VarMMGroup;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.tools.StageMover;

public class MicroscopeSnapChannels
extends AbstractMicroscopeBlock {
    VarObject trigger = new VarObject("Trigger", null);
    VarMMGroup group = new VarMMGroup();
    VarChannels channels = new VarChannels(this.group);
    VarArray<TaggedImage> out = new VarArray("Tagged image(s)", TaggedImage[].class, (Object[])new TaggedImage[0]);

    public void run() {
        this.out.setValue((Object)new TaggedImage[0]);
        ChannelSpec[] specs = this.channels.getValue();
        if (specs.length <= 0) {
            return;
        }
        try {
            MicroManager.setChannelGroup((String)((String)this.group.getValue()));
        }
        catch (Exception e) {
            throw new VarException((Var)this.group, "Group value is not valid.");
        }
        ArrayList result = new ArrayList();
        for (int ch = 0; ch < specs.length; ++ch) {
            ChannelSpec cs = specs[ch];
            if (!cs.useChannel) continue;
            try {
                String configName = cs.config;
                if (!StringUtil.isEmpty((String)configName)) {
                    MicroManager.setConfigForGroup((String)MicroManager.getChannelGroup(), (String)configName, (boolean)true);
                }
                MicroManager.setExposure((double)cs.exposure);
                if (cs.doZStack.booleanValue() && cs.zOffset != 0.0) {
                    StageMover.moveZRelative((double)cs.zOffset, (boolean)true);
                }
                List images = MicroManager.snapTaggedImage();
                if (cs.doZStack.booleanValue() && cs.zOffset != 0.0) {
                    StageMover.moveZRelative((double)(-cs.zOffset), (boolean)true);
                }
                if (images.isEmpty()) {
                    throw new Exception("Cannot snap image from Micro-Manager !");
                }
                for (TaggedImage image : images) {
                    JSONObject tags = image.tags;
                    MDUtils.setNumChannels((JSONObject)tags, (int)specs.length);
                    MDUtils.setChannelIndex((JSONObject)tags, (int)ch);
                    MDUtils.setChannelColor((JSONObject)tags, (int)cs.color.getRGB());
                }
                result.addAll(images);
                continue;
            }
            catch (Throwable t) {
                throw new VarException(this.out, t.getMessage());
            }
        }
        this.out.setValue((Object)result.toArray(new TaggedImage[result.size()]));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("trigger", (Var)this.trigger);
        inputMap.add("group", (Var)this.group);
        inputMap.add("channels", (Var)this.channels);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("out", this.out);
    }

    public String getName() {
        return "Snap Channel(s)";
    }
}

