/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.micromanager.block.lang;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.micromanager.dialogs.ChannelTableModel;
import org.micromanager.utils.ChannelSpec;
import org.micromanager.utils.TooltipTextMaker;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.tprovoost.Microscopy.MicroManager.gui.ChannelTable;

public class VarChannelsEditor
extends VarEditor<ChannelSpec[]> {
    protected JPanel mainPanel;
    protected ChannelTable table;

    public VarChannelsEditor(Var<ChannelSpec[]> variable) {
        super(variable);
        if (this.mainPanel == null) {
            this.initialize();
        }
        this.setEditorEnabled(true);
    }

    protected JPanel createEditorComponent() {
        if (this.mainPanel == null) {
            this.initialize();
        }
        return this.mainPanel;
    }

    private void initialize() {
        this.table = new ChannelTable();
        JScrollPane scroll = new JScrollPane((Component)this.table);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setMinimumSize(new Dimension(240, 60));
        scroll.setPreferredSize(new Dimension(240, 100));
        JButton btnAddChannel = new JButton("Add Channel");
        btnAddChannel.setToolTipText("Create new channel for currently selected channel group");
        btnAddChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChannelTableModel model = (ChannelTableModel)VarChannelsEditor.this.table.getModel();
                model.addNewChannel();
                model.fireTableDataChanged();
            }
        });
        JButton btnRemoveChannel = new JButton("Remove Channel");
        btnRemoveChannel.setToolTipText("Remove currently selected channel");
        btnRemoveChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = VarChannelsEditor.this.table.getSelectedRow();
                if (sel > -1) {
                    ChannelTableModel model = (ChannelTableModel)VarChannelsEditor.this.table.getModel();
                    model.removeChannel(sel);
                    model.fireTableDataChanged();
                    if (VarChannelsEditor.this.table.getRowCount() > sel) {
                        VarChannelsEditor.this.table.setRowSelectionInterval(sel, sel);
                    }
                }
            }
        });
        JButton upButton = new JButton("Up");
        upButton.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip((String)"Move currently selected channel up (Channels higher on list are acquired first)"));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = VarChannelsEditor.this.table.getSelectedRow();
                if (sel > -1) {
                    ChannelTableModel model = (ChannelTableModel)VarChannelsEditor.this.table.getModel();
                    int newSel = model.rowUp(sel);
                    model.fireTableDataChanged();
                    VarChannelsEditor.this.table.setRowSelectionInterval(newSel, newSel);
                }
            }
        });
        JButton downButton = new JButton("Down");
        downButton.setToolTipText(TooltipTextMaker.addHTMLBreaksForTooltip((String)"Move currently selected channel down (Channels lower on list are acquired later)"));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int sel = VarChannelsEditor.this.table.getSelectedRow();
                if (sel > -1) {
                    ChannelTableModel model = (ChannelTableModel)VarChannelsEditor.this.table.getModel();
                    int newSel = model.rowDown(sel);
                    model.fireTableDataChanged();
                    VarChannelsEditor.this.table.setRowSelectionInterval(newSel, newSel);
                }
            }
        });
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new BoxLayout(panelButtons, 0));
        panelButtons.add(btnAddChannel);
        panelButtons.add(btnRemoveChannel);
        panelButtons.add(upButton);
        panelButtons.add(downButton);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)scroll, "Center");
        this.mainPanel.add((Component)panelButtons, "North");
        this.mainPanel.validate();
    }

    protected void activateListeners() {
    }

    protected void deactivateListeners() {
    }

    protected void updateInterfaceValue() {
    }

    public void setGroup(String group) {
        this.table.setGroup(group);
    }

    public Dimension getPreferredSize() {
        if (this.mainPanel != null) {
            return this.mainPanel.getPreferredSize();
        }
        return new Dimension(400, 140);
    }

    public void setComponentToolTipText(String s) {
        if (this.mainPanel != null) {
            this.mainPanel.setToolTipText(s);
        }
    }

    protected void setEditorEnabled(boolean enabled) {
        if (this.mainPanel != null) {
            this.mainPanel.setEnabled(enabled);
        }
    }
}

