/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.micromanager.block.setting;

import org.micromanager.MMStudio;
import org.micromanager.api.MultiStagePosition;
import org.micromanager.api.PositionList;
import plugins.adufour.blocks.tools.input.InputBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarArray;
import plugins.adufour.vars.util.VarException;
import plugins.stef.micromanager.block.AbstractMicroscopeBlock;
import plugins.stef.micromanager.block.lang.VarMultiStagePosition;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;

public class MicroscopePositions
extends AbstractMicroscopeBlock
implements InputBlock {
    VarArray<MultiStagePosition> varPositions = new VarMultiStagePosition("Positions", null);

    public void declareInput(VarList inputMap) {
        inputMap.add("positions", this.varPositions);
    }

    public void declareOutput(VarList outputMap) {
    }

    public void run() {
        MMStudio mstudio = MicroManager.getMMStudio();
        if (mstudio == null) {
            throw new VarException(null, "Cannot retrieve Micro-Manager core...\nBe sure you started Micro-Manager plugin before using Micro-Manager blocks !");
        }
        try {
            PositionList list = mstudio.getPositionList();
            if (list.getPositions() == null) {
                throw new VarException(this.varPositions, "PositionList is empty. There should be at least one value.");
            }
            this.varPositions.setValue((Object)list.getPositions());
        }
        catch (Exception e) {
            throw new VarException(this.varPositions, e.getMessage());
        }
    }
}

