/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.micromanager.block.setting;

import java.util.List;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.protocols.gui.MainFrame;
import plugins.adufour.protocols.gui.ProtocolPanel;
import plugins.adufour.protocols.gui.block.BlockPanel;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.ComboBox;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarObject;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.vars.util.VarListener;
import plugins.stef.micromanager.block.AbstractMicroscopeBlock;
import plugins.stef.micromanager.block.lang.VarMMGroup;
import plugins.stef.micromanager.block.lang.VarMMPreset;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;

public class MicroscopeSetConfig
extends AbstractMicroscopeBlock {
    VarObject trigger = new VarObject("Trigger", null);
    VarMMGroup group = new VarMMGroup();
    VarMMPreset preset = new VarMMPreset(this.group);
    VarBoolean wait = new VarBoolean("Wait", true);
    VarBoolean done = new VarBoolean("Done", false);

    public MicroscopeSetConfig() {
        this.group.addListener((VarListener)new VarListener<String>(){

            public void valueChanged(Var<String> source, String oldValue, String newValue) {
                MicroscopeSetConfig.this.refreshPresetsGUI(newValue);
            }

            public void referenceChanged(Var<String> source, Var<? extends String> oldReference, Var<? extends String> newReference) {
            }
        });
    }

    public void run() {
        this.done.setValue((Object)Boolean.FALSE);
        try {
            MicroManager.setConfigForGroup((String)((String)this.group.getValue()), (String)((String)this.preset.getValue()), (boolean)((Boolean)this.wait.getValue()));
            this.done.setValue((Object)Boolean.TRUE);
        }
        catch (Throwable t) {
            throw new VarException((Var)this.group, t.getMessage());
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("trigger", (Var)this.trigger);
        inputMap.add("group", (Var)this.group);
        inputMap.add("preset", (Var)this.preset);
        inputMap.add("wait", (Var)this.wait);
    }

    public void declareOutput(VarList outputMap) {
        if (this.done != null) {
            outputMap.add("done", (Var)this.done);
        }
    }

    public void refreshPresetsGUI(String group) {
        ProtocolPanel protocolPanel;
        MainFrame protocols = Protocols.getInstance();
        if (protocols != null && (protocolPanel = protocols.getActiveProtocol()) != null) {
            VarEditor editor;
            BlockPanel bp;
            WorkFlowContainer wfc = protocolPanel.getWorkFlowContainer();
            WorkFlow wf = protocolPanel.getWorkFlow();
            BlockDescriptor bd = wf.getInputOwner((Var)this.preset);
            if (bd != null && (bp = wfc.getBlockPanel(bd)) != null && (editor = bp.getVarEditor((Var)this.preset)) instanceof ComboBox) {
                ComboBox combo = (ComboBox)editor;
                List presets = MicroManager.getConfigs((String)group);
                if (presets.size() > 0) {
                    combo.setDefaultValues((Object[])presets.toArray(new String[presets.size()]), 0, false);
                }
            }
        }
    }
}

