/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker;

import icy.gui.component.sequence.SequenceChooser;
import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import plugins.tinevez.kymographtracker.ActionPanel;
import plugins.tinevez.kymographtracker.KymographTracker2;

class SequenceSelectionPanel
extends ActionPanel {
    private KymographTracker2 kymographTracker;
    private static final long serialVersionUID = 802043406982206717L;
    SequenceChooser sequenceChooser;
    JButton startWorkFlowButton;

    public SequenceSelectionPanel(KymographTracker2 kymographTracker) {
        this.kymographTracker = kymographTracker;
        this.description = "Image sequence selection";
        this.node = new DefaultMutableTreeNode(this.description);
        this.setBorder(new TitledBorder(this.description));
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new GridBagLayout());
        this.add((Component)northPanel, "North");
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 2, 2);
        JTextArea nDescription = new JTextArea("Select the image sequence to process. Only the first channel will be processed.");
        nDescription.setEditable(false);
        nDescription.setLineWrap(true);
        nDescription.setWrapStyleWord(true);
        northPanel.add((Component)nDescription, c);
        ++c.gridy;
        this.sequenceChooser = new SequenceChooser();
        northPanel.add((Component)this.sequenceChooser, c);
        this.sequenceChooser.addListener(new SequenceChooser.SequenceChooserListener(){

            public void sequenceChanged(Sequence sequence) {
                SequenceSelectionPanel.this.kymographTracker.changeSelectedSequence(sequence);
            }
        });
        this.kymographTracker.changeSelectedSequence(this.sequenceChooser.getSelectedSequence());
        JPanel southPanel = new JPanel(new BorderLayout());
        this.startWorkFlowButton = new JButton("Start kymograph tracking workflow");
        southPanel.add((Component)this.startWorkFlowButton, "Center");
        this.add((Component)southPanel, "South");
    }

    @Override
    protected void changeSelectedSequence(Sequence sequence) {
    }
}

