/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.pathtracing;

import icy.canvas.IcyCanvas;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.painter.OverlayEvent;
import icy.sequence.Sequence;
import icy.type.collection.array.ArrayUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import plugins.tinevez.pathtracing.InteractiveMultipleTracing;
import plugins.tinevez.pathtracing.PathEvent;
import plugins.tinevez.pathtracing.PathListener;

public class InteractiveMultipleDjikstraTracingESC
extends Overlay
implements InteractiveMultipleTracing {
    Sequence seq = null;
    int width;
    int height;
    double[] dataSave = null;
    double[][] optimalPath = null;
    int[] pathMap = null;
    final boolean verticalPath;
    boolean mapReady = false;
    double maxIntensity;
    ArrayList<Thread> mapThreadList = new ArrayList();
    ArrayList<Thread> pathThreadList = new ArrayList();
    Vector<Thread> runningThreads = new Vector();
    double alpha;
    private boolean isEnabled = true;
    private boolean paused = false;
    private ArrayList<PathListener> pathListenerList;
    int xInit;
    int yInit;
    int xFinal;
    int yFinal;
    public Lock mapThreadListLock = new ReentrantLock();
    public Lock pathThreadListLock = new ReentrantLock();
    public Lock pathLock = new ReentrantLock();
    public Lock initLock = new ReentrantLock();
    public Lock dataSaveLock = new ReentrantLock();
    public Lock distanceMapLock = new ReentrantLock();
    public Lock visitedLock = new ReentrantLock();
    public Condition visitedCondition = this.visitedLock.newCondition();
    AnnounceFrame announceFrame;
    private DrawingState state;
    Thread storePathThread;
    ArrayList<double[][]> optimalPathList = new ArrayList();

    public InteractiveMultipleDjikstraTracingESC(Sequence seq) throws IllegalArgumentException {
        this(seq, 1.0E-4, false);
    }

    public InteractiveMultipleDjikstraTracingESC(Sequence seq, double alpha, boolean verticalPath) throws IllegalArgumentException {
        super("Path tracer");
        this.verticalPath = verticalPath;
        if (seq != null) {
            this.state = DrawingState.RESET;
            this.seq = seq;
            if (seq.getSizeT() > 1 || seq.getSizeZ() > 1) {
                new AnnounceFrame("The tracing algorithm will account for the first image of the spatio-temporal volume only", 7);
            }
            if (alpha < 0.0) {
                throw new IllegalArgumentException("Regularization parameter should be positive in InteractiveDjisktraTracing");
            }
            this.alpha = alpha;
            this.width = seq.getWidth();
            this.height = seq.getHeight();
            boolean component = false;
            IcyBufferedImage image = seq.getFirstImage();
            this.dataSaveLock.lock();
            this.dataSave = (double[])ArrayUtil.arrayToDoubleArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
            this.maxIntensity = 0.0;
            for (int i = 0; i < this.dataSave.length; ++i) {
                if (!(this.dataSave[i] > this.maxIntensity)) continue;
                this.maxIntensity = this.dataSave[i];
            }
            this.dataSaveLock.unlock();
            this.pathListenerList = new ArrayList();
            Runnable stopTracerThr = new Runnable(){

                @Override
                public void run() {
                    InteractiveMultipleDjikstraTracingESC.this.stopTracing();
                }
            };
            this.announceFrame = verticalPath ? new AnnounceFrame("Tracing paths " + seq.getName() + " from top to bottom: click in image to add intermediary points, press ESC to finalize path ", "Stop", stopTracerThr, 0) : new AnnounceFrame("Tracing paths " + seq.getName() + ": click in image to add intermediary points, press ESC to finalize path ", "Stop", stopTracerThr, 0);
            if (!seq.getViewers().isEmpty()) {
                ((Viewer)seq.getViewers().get(0)).toFront();
            }
        } else {
            throw new IllegalArgumentException("Sequence is null in MultipleInteractiveDjisktraTracingESC");
        }
    }

    public void stopTracing() {
        if (this.announceFrame != null) {
            this.announceFrame.close();
        }
        this.state = DrawingState.RESET;
        this.pathThreadListLock.lock();
        for (Thread thr : this.pathThreadList) {
            ((StoppableThread)thr).stopThread();
        }
        this.pathThreadListLock.unlock();
        this.disable();
    }

    public void addPathLister(PathListener listener) {
        this.pathListenerList.add(listener);
    }

    public void removePathLister(PathListener listener) {
        this.pathListenerList.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g2d, Sequence sequence, IcyCanvas canvas) {
        Color tempLineColor = Color.YELLOW;
        Color lineColor = Color.RED;
        Color extremityColor = Color.BLUE;
        float shiftDrawX = 0.5f;
        float shiftDrawY = 0.5f;
        if (this.isEnabled && !this.paused) {
            Point p;
            Line2D.Float l;
            if (this.optimalPath != null) {
                g2d.setStroke(new BasicStroke(0.5f));
                try {
                    this.pathLock.lock();
                    for (int cnt = 0; cnt < this.optimalPath.length; ++cnt) {
                        if (cnt <= 0) continue;
                        g2d.setColor(tempLineColor);
                        l = new Line2D.Float((float)((int)this.optimalPath[cnt][0]) + 0.5f, (float)((int)this.optimalPath[cnt][1]) + 0.5f, (float)((int)this.optimalPath[cnt - 1][0]) + 0.5f, (float)((int)this.optimalPath[cnt - 1][1]) + 0.5f);
                        g2d.draw(l);
                    }
                }
                finally {
                    this.pathLock.unlock();
                }
                if (!this.optimalPathList.isEmpty()) {
                    for (int i = 0; i < this.optimalPathList.size(); ++i) {
                        double[][] path = this.optimalPathList.get(i);
                        for (int cnt = 0; cnt < path.length; ++cnt) {
                            if (cnt <= 0) continue;
                            g2d.setColor(lineColor);
                            Line2D.Float l2 = new Line2D.Float((float)((int)path[cnt][0]) + 0.5f, (float)((int)path[cnt][1]) + 0.5f, (float)((int)path[cnt - 1][0]) + 0.5f, (float)((int)path[cnt - 1][1]) + 0.5f);
                            g2d.draw(l2);
                        }
                    }
                }
            }
            if ((p = new Point((int)canvas.getMouseImagePosX(), (int)canvas.getMouseImagePosY())) != null) {
                g2d.setStroke(new BasicStroke(0.5f));
                g2d.setColor(extremityColor);
                l = new Line2D.Float((float)(p.x - 1) + 0.5f, (float)(p.y - 1) + 0.5f, (float)(p.x + 1) + 0.5f, (float)(p.y + 1) + 0.5f);
                g2d.draw(l);
                l = new Line2D.Float((float)(p.x - 1) + 0.5f, (float)(p.y + 1) + 0.5f, (float)(p.x + 1) + 0.5f, (float)(p.y - 1) + 0.5f);
                g2d.draw(l);
            }
        }
    }

    public void mousePressed(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void mouseReleased(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    private void finalizePath(int xF, int yF, boolean addNewPathThread) {
        if (this.mapReady) {
            this.pathThreadListLock.lock();
            for (Thread thr : this.pathThreadList) {
                ((StoppableThread)thr).stopThread();
            }
            this.pathThreadListLock.unlock();
            this.initLock.lock();
            this.xFinal = xF;
            this.yFinal = yF;
            this.storePathThread = new ComputeFinalPathThread(this.xInit, this.yInit, this.xFinal, this.yFinal, addNewPathThread);
            this.initLock.unlock();
            this.storePathThread.start();
        } else {
            this.pathThreadListLock.lock();
            for (Thread thr : this.pathThreadList) {
                ((StoppableThread)thr).stopThread();
            }
            this.pathThreadListLock.unlock();
            this.initLock.lock();
            this.xFinal = xF;
            this.yFinal = yF;
            this.storePathThread = new ComputeFinalPathThreadWaiting(this.xInit, this.yInit, this.xFinal, this.yFinal, addNewPathThread);
            this.initLock.unlock();
            this.storePathThread.start();
        }
    }

    private void initNewMapThread(int xi, int yi) {
        this.mapThreadListLock.lock();
        for (Thread t : this.mapThreadList) {
            ((StoppableThread)t).stopThread();
        }
        this.mapThreadListLock.unlock();
        this.pathThreadListLock.lock();
        for (Thread t : this.pathThreadList) {
            ((StoppableThread)t).stopThread();
        }
        this.pathThreadListLock.unlock();
        this.initLock.lock();
        this.xInit = xi;
        this.yInit = yi;
        ComputeMapThread thr = null;
        thr = this.verticalPath ? new ComputeMapThreadToTop(this.xInit, this.yInit) : new ComputeMapThreadBidirectional(this.xInit, this.yInit);
        this.initLock.unlock();
        this.mapReady = false;
        this.mapThreadListLock.lock();
        this.mapThreadList.add(thr);
        this.mapThreadListLock.unlock();
        thr.start();
    }

    public void mouseClick(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (this.isEnabled && !this.paused) {
            switch (this.state) {
                case RESET: 
                case ESC: {
                    this.clearOptimalPath();
                    int xi = (int)Math.round(imagePoint.getX());
                    int yi = (int)Math.round(imagePoint.getY());
                    if (xi < 0 || xi >= this.width || yi < 0 || yi >= this.height) break;
                    this.initNewMapThread(xi, yi);
                    this.state = DrawingState.FIRST_CLICKED;
                    break;
                }
                case FIRST_CLICKED: 
                case SECOND_CLICKED: {
                    int xF = (int)Math.round(imagePoint.getX());
                    int yF = (int)Math.round(imagePoint.getY());
                    if (xF < 0 || xF >= this.width || yF < 0 || yF >= this.height) break;
                    this.paused = true;
                    this.finalizePath(xF, yF, true);
                    this.state = DrawingState.SECOND_CLICKED;
                }
            }
        }
    }

    public void mouseMove(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (this.isEnabled && !this.paused) {
            if (this.state == DrawingState.FIRST_CLICKED || this.state == DrawingState.SECOND_CLICKED) {
                if (this.mapReady) {
                    this.pathThreadListLock.lock();
                    for (Thread t : this.pathThreadList) {
                        ((StoppableThread)t).stopThread();
                    }
                    int xF = (int)Math.round(imagePoint.getX());
                    int yF = (int)Math.round(imagePoint.getY());
                    if (!(xF < 0 || xF >= this.width || yF < 0 || yF >= this.height || this.verticalPath && yF <= this.yInit)) {
                        this.xFinal = xF;
                        this.yFinal = yF;
                        this.initLock.lock();
                        ComputePathThread thr = new ComputePathThread(this.xInit, this.yInit, this.xFinal, this.yFinal);
                        this.initLock.unlock();
                        this.pathThreadList.add(thr);
                        thr.start();
                    }
                    this.pathThreadListLock.unlock();
                } else {
                    this.pathThreadListLock.lock();
                    for (Thread t : this.pathThreadList) {
                        ((StoppableThread)t).stopThread();
                    }
                    int xF = (int)Math.round(imagePoint.getX());
                    int yF = (int)Math.round(imagePoint.getY());
                    if (xF >= 0 && xF < this.width && yF >= 0 && yF < this.height) {
                        this.xFinal = xF;
                        this.yFinal = yF;
                        this.initLock.lock();
                        ComputePathThreadWaiting thr = new ComputePathThreadWaiting(this.xInit, this.yInit, this.xFinal, this.yFinal);
                        this.initLock.unlock();
                        this.pathThreadList.add(thr);
                        thr.start();
                    }
                    this.pathThreadListLock.unlock();
                }
            } else {
                this.seq.overlayChanged((Overlay)this);
            }
        }
    }

    public void mouseDrag(MouseEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyPressed(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
    }

    public void keyReleased(KeyEvent e, Point2D imagePoint, IcyCanvas canvas) {
        if (e.getKeyCode() == 27) {
            if (this.state == DrawingState.SECOND_CLICKED) {
                this.state = DrawingState.ESC;
                this.finalizePath(this.xInit, this.yInit, false);
                this.paused = true;
            } else if (this.state == DrawingState.FIRST_CLICKED) {
                this.state = DrawingState.ESC;
            }
        }
    }

    public Number getIntensityAt(double x, double y) {
        if (this.dataSave != null && x >= 0.0 && x < (double)this.width && y >= 0.0 && y < (double)this.height) {
            return this.dataSave[(int)Math.round(x) + (int)Math.round(y) * this.width];
        }
        return -1;
    }

    @Override
    public ArrayList<double[][]> getOptimalPathCopy() {
        ArrayList<double[][]> copy = new ArrayList<double[][]>();
        this.pathLock.lock();
        for (double[][] path : this.optimalPathList) {
            copy.add((double[][])path.clone());
        }
        this.pathLock.unlock();
        return copy;
    }

    public void enable() {
        this.isEnabled = true;
        this.seq.overlayChanged((Overlay)this);
    }

    public void disable() {
        this.isEnabled = false;
        this.seq.overlayChanged((Overlay)this);
    }

    private void storeOptimalPath() {
        this.pathLock.lock();
        if (this.optimalPath != null) {
            this.optimalPathList.add(this.optimalPath);
        }
        this.pathLock.unlock();
    }

    private void clearOptimalPath() {
        this.pathLock.lock();
        if (this.optimalPath != null) {
            this.optimalPathList.clear();
        }
        this.pathLock.unlock();
    }

    abstract class StoppableThread
    extends Thread {
        StoppableThread() {
        }

        public abstract void stopThread();
    }

    class FireListenersThread
    extends Thread {
        double[][] path;
        PathEvent pathEvent;

        public FireListenersThread(double[][] path, PathEvent event) {
            InteractiveMultipleDjikstraTracingESC.this.runningThreads.add(this);
            this.path = path;
            this.pathEvent = event;
        }

        @Override
        public void run() {
            for (PathListener listener : InteractiveMultipleDjikstraTracingESC.this.pathListenerList) {
                listener.refreshPath(this.pathEvent, InteractiveMultipleDjikstraTracingESC.this, this.path);
            }
            InteractiveMultipleDjikstraTracingESC.this.runningThreads.remove(this);
        }
    }

    class ComputePathThreadWaiting
    extends StoppableThread
    implements ActionListener {
        int xInit;
        int yInit;
        int xFinal;
        int yFinal;
        boolean run = true;

        public ComputePathThreadWaiting(int xInit, int yInit, int xFinal, int yFinal) {
            this.xInit = xInit;
            this.yInit = yInit;
            this.xFinal = xFinal;
            this.yFinal = yFinal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runFunction() {
            boolean found = false;
            boolean wait = false;
            int idxInit = this.xInit + this.yInit * InteractiveMultipleDjikstraTracingESC.this.width;
            int idxFinal = this.xFinal + this.yFinal * InteractiveMultipleDjikstraTracingESC.this.width;
            ArrayList<Thread> threadList = new ArrayList<Thread>();
            int[] prev = new int[InteractiveMultipleDjikstraTracingESC.this.width * InteractiveMultipleDjikstraTracingESC.this.height];
            block5: while (this.run && !found) {
                InteractiveMultipleDjikstraTracingESC.this.mapThreadListLock.lock();
                threadList = new ArrayList();
                threadList.addAll(InteractiveMultipleDjikstraTracingESC.this.mapThreadList);
                InteractiveMultipleDjikstraTracingESC.this.mapThreadListLock.unlock();
                for (Thread thr : threadList) {
                    ComputeMapThread mapThread = (ComputeMapThread)thr;
                    if (mapThread.run && mapThread.xInit == this.xInit && mapThread.yInit == mapThread.yInit) {
                        if (mapThread.visited[idxFinal]) {
                            InteractiveMultipleDjikstraTracingESC.this.visitedLock.lock();
                            System.arraycopy(mapThread.prev, 0, prev, 0, mapThread.prev.length);
                            found = true;
                            InteractiveMultipleDjikstraTracingESC.this.visitedLock.unlock();
                            continue block5;
                        }
                        wait = true;
                        continue block5;
                    }
                    if (!wait) continue;
                    InteractiveMultipleDjikstraTracingESC.this.visitedLock.lock();
                    try {
                        InteractiveMultipleDjikstraTracingESC.this.visitedCondition.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    finally {
                        InteractiveMultipleDjikstraTracingESC.this.visitedLock.unlock();
                    }
                }
            }
            ArrayList<Integer> path = new ArrayList<Integer>();
            int idx = idxFinal;
            path.add(new Integer(idxFinal));
            while (idx != idxInit && !this.isInterrupted() && this.run) {
                idx = prev[idx];
                path.add(new Integer(idx));
            }
            int pathLength = path.size();
            double[][] pathTab = new double[pathLength][2];
            for (int cnt = 0; cnt < pathLength; ++cnt) {
                int tmp = (Integer)path.get(pathLength - cnt - 1);
                pathTab[cnt] = new double[]{tmp % InteractiveMultipleDjikstraTracingESC.this.width, tmp / InteractiveMultipleDjikstraTracingESC.this.width};
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracingESC.this.pathLock.lock();
                InteractiveMultipleDjikstraTracingESC.this.optimalPath = pathTab;
                if (!InteractiveMultipleDjikstraTracingESC.this.pathListenerList.isEmpty()) {
                    double[][] pathClone = new double[InteractiveMultipleDjikstraTracingESC.this.optimalPath.length][];
                    for (int i = 0; i < InteractiveMultipleDjikstraTracingESC.this.optimalPath.length; ++i) {
                        pathClone[i] = (double[])InteractiveMultipleDjikstraTracingESC.this.optimalPath[i].clone();
                    }
                    if (InteractiveMultipleDjikstraTracingESC.this.state == DrawingState.ESC) {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.FINAL_PATH);
                        thr.start();
                    } else {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.TEMPORARY_PATH);
                        thr.start();
                    }
                }
                InteractiveMultipleDjikstraTracingESC.this.pathLock.unlock();
                InteractiveMultipleDjikstraTracingESC.this.seq.overlayChanged((Overlay)InteractiveMultipleDjikstraTracingESC.this);
            }
        }

        @Override
        public void run() {
            this.runFunction();
            InteractiveMultipleDjikstraTracingESC.this.pathThreadListLock.lock();
            InteractiveMultipleDjikstraTracingESC.this.pathThreadList.remove(this);
            InteractiveMultipleDjikstraTracingESC.this.pathThreadListLock.unlock();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.interrupt();
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    class ComputeFinalPathThreadWaiting
    extends ComputePathThreadWaiting {
        boolean addNewMapThread;

        public ComputeFinalPathThreadWaiting(int xInit, int yInit, int xFinal, int yFinal, boolean addNewMapThread) {
            super(xInit, yInit, xFinal, yFinal);
            this.addNewMapThread = false;
            this.addNewMapThread = addNewMapThread;
        }

        @Override
        public void run() {
            try {
                ((ComputePathThreadWaiting)this).runFunction();
                InteractiveMultipleDjikstraTracingESC.this.storeOptimalPath();
                if (this.addNewMapThread) {
                    InteractiveMultipleDjikstraTracingESC.this.initNewMapThread(this.xFinal, this.yFinal);
                }
            }
            finally {
                InteractiveMultipleDjikstraTracingESC.this.paused = false;
            }
        }
    }

    class ComputePathThread
    extends StoppableThread
    implements ActionListener {
        int xInit;
        int yInit;
        int xFinal;
        int yFinal;
        boolean run = true;

        public ComputePathThread(int xInit, int yInit, int xFinal, int yFinal) {
            this.xInit = xInit;
            this.yInit = yInit;
            this.xFinal = xFinal;
            this.yFinal = yFinal;
        }

        private void runFunction() {
            InteractiveMultipleDjikstraTracingESC.this.distanceMapLock.lock();
            int[] prev = new int[InteractiveMultipleDjikstraTracingESC.this.pathMap.length];
            System.arraycopy(InteractiveMultipleDjikstraTracingESC.this.pathMap, 0, prev, 0, prev.length);
            InteractiveMultipleDjikstraTracingESC.this.distanceMapLock.unlock();
            int width = InteractiveMultipleDjikstraTracingESC.this.seq.getWidth();
            int idxInit = this.xInit + this.yInit * width;
            int idxFinal = this.xFinal + this.yFinal * width;
            ArrayList<Integer> path = new ArrayList<Integer>();
            int idx = idxFinal;
            path.add(new Integer(idxFinal));
            while (idx != idxInit && !this.isInterrupted() && this.run) {
                idx = prev[idx];
                path.add(new Integer(idx));
            }
            int pathLength = path.size();
            double[][] pathTab = new double[pathLength][2];
            for (int cnt = 0; cnt < pathLength; ++cnt) {
                int tmp = (Integer)path.get(pathLength - cnt - 1);
                pathTab[cnt] = new double[]{tmp % width, tmp / width};
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracingESC.this.pathLock.lock();
                InteractiveMultipleDjikstraTracingESC.this.optimalPath = pathTab;
                if (!InteractiveMultipleDjikstraTracingESC.this.pathListenerList.isEmpty()) {
                    double[][] pathClone = new double[InteractiveMultipleDjikstraTracingESC.this.optimalPath.length][];
                    for (int i = 0; i < InteractiveMultipleDjikstraTracingESC.this.optimalPath.length; ++i) {
                        pathClone[i] = (double[])InteractiveMultipleDjikstraTracingESC.this.optimalPath[i].clone();
                    }
                    if (InteractiveMultipleDjikstraTracingESC.this.state == DrawingState.ESC) {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.FINAL_PATH);
                        thr.start();
                    } else {
                        FireListenersThread thr = new FireListenersThread(pathClone, PathEvent.TEMPORARY_PATH);
                        thr.start();
                    }
                }
                InteractiveMultipleDjikstraTracingESC.this.pathLock.unlock();
                InteractiveMultipleDjikstraTracingESC.this.seq.overlayChanged(new OverlayEvent(null, OverlayEvent.OverlayEventType.PAINTER_CHANGED));
            }
        }

        @Override
        public void run() {
            this.runFunction();
            InteractiveMultipleDjikstraTracingESC.this.pathThreadListLock.lock();
            InteractiveMultipleDjikstraTracingESC.this.pathThreadList.remove(this);
            InteractiveMultipleDjikstraTracingESC.this.pathThreadListLock.unlock();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.interrupt();
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    class ComputeFinalPathThread
    extends ComputePathThread {
        boolean addNewMapThread;

        public ComputeFinalPathThread(int xInit, int yInit, int xFinal, int yFinal, boolean addNewPathThread) {
            super(xInit, yInit, xFinal, yFinal);
            this.addNewMapThread = false;
            this.addNewMapThread = addNewPathThread;
        }

        @Override
        public void run() {
            try {
                ((ComputePathThread)this).runFunction();
                InteractiveMultipleDjikstraTracingESC.this.storeOptimalPath();
                if (this.addNewMapThread) {
                    InteractiveMultipleDjikstraTracingESC.this.initNewMapThread(this.xFinal, this.yFinal);
                }
            }
            finally {
                InteractiveMultipleDjikstraTracingESC.this.paused = false;
            }
        }
    }

    class ComputeMapThreadToTop
    extends ComputeMapThread {
        public ComputeMapThreadToTop(int xInit, int yInit) {
            super(xInit, yInit);
        }

        @Override
        public void run() {
            for (int u = 0; u < this.dist.length; ++u) {
                this.dist[u] = Double.MAX_VALUE;
            }
            int idxInit = this.yInit * InteractiveMultipleDjikstraTracingESC.this.width + this.xInit;
            this.dist[idxInit] = 0.0;
            int currentIdx = idxInit;
            int currentX = this.xInit;
            int currentY = this.yInit;
            boolean stop = false;
            while (!stop && this.run) {
                double ival = this.data[currentIdx];
                double currentDist = this.dist[currentIdx];
                if (currentX > 0) {
                    this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                    if (currentX < InteractiveMultipleDjikstraTracingESC.this.width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                        if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width + 1);
                        }
                    }
                } else if (currentX < InteractiveMultipleDjikstraTracingESC.this.width - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                } else if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width);
                }
                this.visited[currentIdx] = true;
                InteractiveMultipleDjikstraTracingESC.this.visitedLock.lock();
                InteractiveMultipleDjikstraTracingESC.this.visitedCondition.signalAll();
                InteractiveMultipleDjikstraTracingESC.this.visitedLock.unlock();
                double minDist = Double.MAX_VALUE;
                int minIdx = -1;
                for (int cnt = 0; cnt < this.dist.length; ++cnt) {
                    if (this.visited[cnt] || !(this.dist[cnt] < minDist) && minIdx != -1) continue;
                    minDist = this.dist[cnt];
                    minIdx = cnt;
                }
                if (minIdx == -1) {
                    stop = true;
                    continue;
                }
                currentIdx = minIdx;
                currentY = currentIdx / InteractiveMultipleDjikstraTracingESC.this.width;
                currentX = currentIdx - InteractiveMultipleDjikstraTracingESC.this.width * currentY;
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracingESC.this.distanceMapLock.lock();
                InteractiveMultipleDjikstraTracingESC.this.pathMap = this.prev;
                InteractiveMultipleDjikstraTracingESC.this.distanceMapLock.unlock();
                InteractiveMultipleDjikstraTracingESC.this.mapReady = true;
            }
            InteractiveMultipleDjikstraTracingESC.this.mapThreadListLock.lock();
            InteractiveMultipleDjikstraTracingESC.this.mapThreadList.remove(this);
            InteractiveMultipleDjikstraTracingESC.this.mapThreadListLock.unlock();
            InteractiveMultipleDjikstraTracingESC.this.seq.overlayChanged((Overlay)InteractiveMultipleDjikstraTracingESC.this);
        }
    }

    class ComputeMapThreadBidirectional
    extends ComputeMapThread {
        public ComputeMapThreadBidirectional(int xInit, int yInit) {
            super(xInit, yInit);
        }

        @Override
        public void run() {
            for (int u = 0; u < this.dist.length; ++u) {
                this.dist[u] = Double.MAX_VALUE;
            }
            int idxInit = this.yInit * InteractiveMultipleDjikstraTracingESC.this.width + this.xInit;
            this.dist[idxInit] = 0.0;
            int currentIdx = idxInit;
            int currentX = this.xInit;
            int currentY = this.yInit;
            boolean stop = false;
            while (!stop && this.run) {
                double ival = this.data[currentIdx];
                double currentDist = this.dist[currentIdx];
                if (currentX > 0) {
                    this.test(currentDist, ival, currentIdx, currentIdx - 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracingESC.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                    if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width - 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                    if (currentX < InteractiveMultipleDjikstraTracingESC.this.width - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + 1);
                        if (currentY > 0) {
                            this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracingESC.this.width + 1);
                        }
                        if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                            this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width + 1);
                        }
                    }
                } else if (currentX < InteractiveMultipleDjikstraTracingESC.this.width - 1) {
                    this.test(currentDist, ival, currentIdx, currentIdx + 1);
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracingESC.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                    if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width + 1);
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                } else {
                    if (currentY > 0) {
                        this.test(currentDist, ival, currentIdx, currentIdx - InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                    if (currentY < InteractiveMultipleDjikstraTracingESC.this.height - 1) {
                        this.test(currentDist, ival, currentIdx, currentIdx + InteractiveMultipleDjikstraTracingESC.this.width);
                    }
                }
                this.visited[currentIdx] = true;
                InteractiveMultipleDjikstraTracingESC.this.visitedLock.lock();
                InteractiveMultipleDjikstraTracingESC.this.visitedCondition.signalAll();
                InteractiveMultipleDjikstraTracingESC.this.visitedLock.unlock();
                double minDist = Double.MAX_VALUE;
                int minIdx = -1;
                for (int cnt = 0; cnt < this.dist.length; ++cnt) {
                    if (this.visited[cnt] || !(this.dist[cnt] < minDist) && minIdx != -1) continue;
                    minDist = this.dist[cnt];
                    minIdx = cnt;
                }
                if (minIdx == -1) {
                    stop = true;
                    continue;
                }
                currentIdx = minIdx;
                currentY = currentIdx / InteractiveMultipleDjikstraTracingESC.this.width;
                currentX = currentIdx - InteractiveMultipleDjikstraTracingESC.this.width * currentY;
            }
            if (this.run) {
                InteractiveMultipleDjikstraTracingESC.this.distanceMapLock.lock();
                InteractiveMultipleDjikstraTracingESC.this.pathMap = this.prev;
                InteractiveMultipleDjikstraTracingESC.this.distanceMapLock.unlock();
                InteractiveMultipleDjikstraTracingESC.this.mapReady = true;
            }
            InteractiveMultipleDjikstraTracingESC.this.mapThreadListLock.lock();
            InteractiveMultipleDjikstraTracingESC.this.mapThreadList.remove(this);
            InteractiveMultipleDjikstraTracingESC.this.mapThreadListLock.unlock();
            InteractiveMultipleDjikstraTracingESC.this.seq.overlayChanged((Overlay)InteractiveMultipleDjikstraTracingESC.this);
        }
    }

    abstract class ComputeMapThread
    extends StoppableThread {
        int xInit;
        int yInit;
        double[] dist;
        int[] prev;
        boolean[] visited;
        double[] data;
        boolean run;

        public ComputeMapThread(int xInit, int yInit) {
            this.dist = new double[InteractiveMultipleDjikstraTracingESC.this.width * InteractiveMultipleDjikstraTracingESC.this.height];
            this.prev = new int[InteractiveMultipleDjikstraTracingESC.this.width * InteractiveMultipleDjikstraTracingESC.this.height];
            this.visited = new boolean[InteractiveMultipleDjikstraTracingESC.this.width * InteractiveMultipleDjikstraTracingESC.this.height];
            this.data = null;
            this.run = true;
            this.xInit = xInit;
            this.yInit = yInit;
            InteractiveMultipleDjikstraTracingESC.this.dataSaveLock.lock();
            this.data = new double[InteractiveMultipleDjikstraTracingESC.this.dataSave.length];
            System.arraycopy(InteractiveMultipleDjikstraTracingESC.this.dataSave, 0, this.data, 0, this.data.length);
            InteractiveMultipleDjikstraTracingESC.this.dataSaveLock.unlock();
        }

        @Override
        public abstract void run();

        public double dist(double i1, double i2) {
            return InteractiveMultipleDjikstraTracingESC.this.maxIntensity / (i2 + InteractiveMultipleDjikstraTracingESC.this.alpha);
        }

        protected void test(double currentDist, double refI, int currentIdx, int idx) {
            double d;
            if (!this.visited[idx] && (d = currentDist + this.dist(refI, this.data[idx])) < this.dist[idx]) {
                this.dist[idx] = d;
                this.prev[idx] = currentIdx;
            }
        }

        @Override
        public void stopThread() {
            this.run = false;
        }
    }

    public static enum DrawingState {
        RESET,
        FIRST_CLICKED,
        SECOND_CLICKED,
        ESC;

    }
}

