/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszGeneralization;

public class RieszConfig {
    int order;
    double[][] filters;
    int numChannels;
    HarmonicTypes harmonicType;
    int[] harmonics;
    int width;
    int height;

    RieszConfig(int order, HarmonicTypes harmonicTypes, int width, int height) {
        this.order = Math.abs(order);
        this.harmonicType = harmonicTypes;
        this.width = width;
        this.height = height;
        this.fillHarmonics();
        this.prepareFiltersFFT();
    }

    RieszConfig(int order, HarmonicTypes harmonicTypes) {
        this.order = order;
        this.harmonicType = harmonicTypes;
        this.fillHarmonics();
    }

    RieszConfig(int[] harmonics, int width, int height) {
        throw new IllegalArgumentException("Custom harmonics not yet supported");
    }

    private void fillHarmonics() {
        switch (this.harmonicType) {
            case even: {
                if (this.order % 2 > 0) {
                    throw new IllegalArgumentException("Order of Riesz filter must be even for even-type harmonics.");
                }
                this.numChannels = this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                for (int o = -this.order; o <= this.order; o += 2) {
                    this.harmonics[k] = o;
                    ++k;
                }
                break;
            }
            case odd: {
                if (this.order % 2 == 0) {
                    throw new IllegalArgumentException("Order of Riesz filter must be odd for odd-type harmonics.");
                }
                this.numChannels = this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                for (int o = -this.order; o <= this.order; o += 2) {
                    this.harmonics[k] = o;
                    ++k;
                }
                break;
            }
            case complete: {
                this.numChannels = 2 * this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                int o = -this.order;
                while (o <= this.order) {
                    this.harmonics[k] = o++;
                    ++k;
                }
                break;
            }
            case positive: {
                this.numChannels = this.order + 1;
                this.harmonics = new int[this.numChannels];
                int k = 0;
                int o = 0;
                while (o <= this.order) {
                    this.harmonics[k] = o++;
                    ++k;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to use this constructor for RieszConfig with custom harmonics");
            }
        }
    }

    protected void prepareFiltersFFT() {
        int x;
        int y;
        int x2;
        this.filters = new double[this.numChannels][this.width * this.height * 2];
        double[] angles = new double[this.width * this.height];
        int cX = (int)Math.ceil((this.width + 1) / 2);
        int cY = (int)Math.ceil((this.height + 1) / 2);
        for (x2 = 0; x2 < cX; ++x2) {
            angles[x2] = 0.0;
        }
        for (x2 = cX; x2 < this.width; ++x2) {
            angles[x2] = Math.PI;
        }
        for (y = 1; y < cY; ++y) {
            angles[y * this.width] = 1.5707963267948966;
            for (x = 1; x < cX; ++x) {
                angles[x + y * this.width] = Math.atan2((double)y / (double)this.height, (double)x / (double)this.width);
            }
            for (x = cX; x < this.width; ++x) {
                angles[x + y * this.width] = Math.atan2((double)y / (double)this.height, (double)(x - this.width) / (double)this.width);
            }
        }
        for (y = cY; y < this.height; ++y) {
            angles[y * this.width] = -1.5707963267948966;
            for (x = 1; x < cX; ++x) {
                angles[x + y * this.width] = Math.atan2((double)(y - this.height) / (double)this.height, (double)x / (double)this.width);
            }
            for (x = cX; x < this.width; ++x) {
                angles[x + y * this.width] = Math.atan2((double)(y - this.height) / (double)this.height, (double)(x - this.width) / (double)this.width);
            }
        }
        for (int c = 0; c < this.numChannels; ++c) {
            double h = this.harmonics[c];
            double[] values = this.filters[c];
            for (int i = 0; i < angles.length; ++i) {
                values[2 * i] = Math.cos(h * angles[i]);
                values[2 * i + 1] = Math.sin(h * angles[i]);
            }
        }
    }

    public double[][] analysis(double[] image, RieszGeneralization generalization) {
        return this.analysis(image, generalization, false, false);
    }

    public double[][] analysis(double[] image, RieszGeneralization generalization, boolean inputInFourier, boolean outputInFourier) {
        double[] dataFFT;
        if (inputInFourier) {
            dataFFT = image;
        } else {
            dataFFT = new double[this.width * this.height * 2];
            for (int i = 0; i < this.width * this.height; ++i) {
                dataFFT[2 * i] = image[i];
            }
            DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
            fft.complexForward(dataFFT);
        }
        double[][] bandFFT = new double[this.numChannels][this.width * this.height * 2];
        for (int i = 0; i < this.numChannels; ++i) {
            for (int t = 0; t < this.width * this.height; ++t) {
                bandFFT[i][2 * t] = dataFFT[2 * t] * this.filters[i][2 * t] - dataFFT[2 * t + 1] * this.filters[i][2 * t + 1];
                bandFFT[i][2 * t + 1] = dataFFT[2 * t] * this.filters[i][2 * t + 1] + dataFFT[2 * t + 1] * this.filters[i][2 * t];
            }
        }
        bandFFT = generalization.combineBandsForwardComplex(bandFFT);
        if (outputInFourier) {
            return bandFFT;
        }
        if (generalization.realCoefficients) {
            DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
            double[][] bands = new double[bandFFT.length][this.width * this.height];
            for (int i = 0; i < bandFFT.length; ++i) {
                fft.complexInverse(bandFFT[i], true);
                for (int j = 0; j < this.width * this.height; ++j) {
                    bands[i][j] = bandFFT[i][2 * j];
                }
            }
            return bands;
        }
        DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
        for (int i = 0; i < bandFFT.length; ++i) {
            fft.complexInverse(bandFFT[i], true);
        }
        return bandFFT;
    }

    public double[] synthesis(double[][] rieszBands, RieszGeneralization generalization, boolean inputInFourier, boolean outputInFourier) {
        double[] reconstruction;
        double[][] rieszBandsFFT;
        if (inputInFourier) {
            rieszBandsFFT = rieszBands;
        } else {
            rieszBandsFFT = new double[rieszBands.length][2 * this.width * this.height];
            for (int i = 0; i < rieszBands.length; ++i) {
                DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
                for (int j = 0; j < this.width * this.height; ++j) {
                    rieszBandsFFT[i][2 * j] = rieszBands[i][j];
                }
                fft.complexForward(rieszBandsFFT[i]);
            }
        }
        rieszBandsFFT = generalization.combineBandsBackwardComplex(rieszBandsFFT);
        double[] reconstructionFFT = new double[this.width * this.height * 2];
        for (int i = 0; i < this.numChannels; ++i) {
            for (int t = 0; t < this.width * this.height; ++t) {
                int n = 2 * t;
                reconstructionFFT[n] = reconstructionFFT[n] + (rieszBandsFFT[i][2 * t] * this.filters[i][2 * t] + rieszBandsFFT[i][2 * t + 1] * this.filters[i][2 * t + 1]);
                int n2 = 2 * t + 1;
                reconstructionFFT[n2] = reconstructionFFT[n2] + (-rieszBandsFFT[i][2 * t] * this.filters[i][2 * t + 1] + rieszBandsFFT[i][2 * t + 1] * this.filters[i][2 * t]);
            }
        }
        if (outputInFourier) {
            reconstruction = reconstructionFFT;
        } else {
            DoubleFFT_2D fft = new DoubleFFT_2D(this.height, this.width);
            fft.complexInverse(reconstructionFFT, true);
            reconstruction = new double[this.width * this.height];
            for (int t = 0; t < this.width * this.height; ++t) {
                reconstruction[t] = reconstructionFFT[2 * t];
            }
        }
        return reconstruction;
    }

    public void steerCoefficients(double[][] rieszBands, RieszGeneralization generalization, double[] angles, boolean forward) {
        if (generalization.realCoefficients) {
            int b;
            Object complexBands = new double[rieszBands.length][];
            for (int i = 0; i < ((double[][])complexBands).length; ++i) {
                complexBands[i] = new double[rieszBands[i].length * 2];
                for (int j = 0; j < rieszBands[i].length; ++j) {
                    complexBands[i][2 * j] = rieszBands[i][j];
                }
            }
            complexBands = generalization.combineBandsBackwardComplex((double[][])complexBands);
            for (b = 0; b < ((double[][])complexBands).length; ++b) {
                double s;
                double i;
                double r;
                int k;
                int harmonic = this.harmonics[b];
                if (forward) {
                    for (k = 0; k < angles.length; ++k) {
                        r = complexBands[b][2 * k];
                        i = complexBands[b][2 * k + 1];
                        double c = Math.cos((double)harmonic * angles[k]);
                        s = Math.sin((double)harmonic * angles[k]);
                        complexBands[b][2 * k] = r * c - i * s;
                        complexBands[b][2 * k + 1] = r * s + i * c;
                    }
                    continue;
                }
                for (k = 0; k < angles.length; ++k) {
                    r = complexBands[b][2 * k];
                    i = complexBands[b][2 * k + 1];
                    double c = Math.cos((double)(-harmonic) * angles[k]);
                    s = Math.sin((double)(-harmonic) * angles[k]);
                    complexBands[b][2 * k] = r * c - i * s;
                    complexBands[b][2 * k + 1] = r * s + i * c;
                }
            }
            complexBands = generalization.combineBandsForwardComplex((double[][])complexBands);
            for (b = 0; b < rieszBands.length; ++b) {
                for (int k = 0; k < rieszBands[b].length; ++k) {
                    rieszBands[b][k] = complexBands[b][2 * k];
                }
            }
        } else {
            rieszBands = generalization.combineBandsBackwardComplex(rieszBands);
            for (int b = 0; b < rieszBands.length; ++b) {
                double s;
                double c;
                double i;
                double r;
                int k;
                int harmonic = this.harmonics[b];
                if (forward) {
                    for (k = 0; k < angles.length; ++k) {
                        r = rieszBands[b][2 * k];
                        i = rieszBands[b][2 * k + 1];
                        c = Math.cos((double)harmonic * angles[k]);
                        s = Math.sin((double)harmonic * angles[k]);
                        rieszBands[b][2 * k] = r * c - i * s;
                        rieszBands[b][2 * k + 1] = r * s + i * c;
                    }
                    continue;
                }
                for (k = 0; k < angles.length; ++k) {
                    r = rieszBands[b][2 * k];
                    i = rieszBands[b][2 * k + 1];
                    c = Math.cos((double)(-harmonic) * angles[k]);
                    s = Math.sin((double)(-harmonic) * angles[k]);
                    rieszBands[b][2 * k] = r * c - i * s;
                    rieszBands[b][2 * k + 1] = r * s + i * c;
                }
            }
            double[][] combinedBands = generalization.combineBandsForwardComplex(rieszBands);
            for (int b = 0; b < rieszBands.length; ++b) {
                rieszBands[b] = combinedBands[b];
            }
        }
    }
}

