/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.gui.main.GlobalSequenceListener;
import icy.gui.viewer.Viewer;
import icy.main.Icy;
import icy.math.MathUtil;
import icy.math.UnitUtil;
import icy.painter.Overlay;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginDaemon;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.adufour.vars.gui.model.IntegerRangeModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarColor;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.lang.VarInteger;
import plugins.kernel.canvas.VtkCanvas;
import plugins.tprovoost.scale.ScaleBarLocation;
import plugins.tprovoost.scale.ScaleBarOverlay;

public class KymographScaleBar
extends Plugin
implements PluginDaemon,
GlobalSequenceListener {
    private static XMLPreferences preferences = null;

    public void init() {
        if (preferences == null) {
            preferences = this.getPreferencesRoot();
        }
        Icy.getMainInterface().addGlobalSequenceListener((GlobalSequenceListener)this);
    }

    public void run() {
    }

    public void stop() {
        for (Sequence s : this.getSequences()) {
            KymographScaleBar.removeScaleBarFrom(s);
        }
        Icy.getMainInterface().removeGlobalSequenceListener((GlobalSequenceListener)this);
    }

    public void sequenceOpened(Sequence sequence) {
    }

    public void sequenceClosed(Sequence sequence) {
        KymographScaleBar.removeScaleBarFrom(sequence);
    }

    public static KymographScaleBarOverlay addScaleBarTo(Sequence sequence) {
        if (sequence == null) {
            throw new IcyHandledException("Cannot add the kymograph scale bar: no sequence specified");
        }
        if (sequence.hasOverlay(KymographScaleBarOverlay.class)) {
            return (KymographScaleBarOverlay)((Object)sequence.getOverlays(KymographScaleBarOverlay.class).get(0));
        }
        for (Overlay o : sequence.getOverlays(ScaleBarOverlay.class)) {
            sequence.removeOverlay(o);
        }
        KymographScaleBarOverlay overlay = new KymographScaleBarOverlay();
        sequence.addOverlay((Overlay)overlay);
        String name = sequence.getName().toLowerCase();
        if (name.startsWith("rendering") || name.startsWith("screen shot")) {
            for (Viewer viewer : sequence.getViewers()) {
                viewer.getCanvas().getLayer((Overlay)overlay).setVisible(false);
            }
        }
        return overlay;
    }

    public static void removeScaleBarFrom(Sequence sequence) {
        if (sequence == null) {
            throw new IcyHandledException("Cannot remove the kymograph scale bar: no sequence specified");
        }
        for (Overlay o : sequence.getOverlays(KymographScaleBarOverlay.class)) {
            sequence.removeOverlay(o);
        }
    }

    public static class KymographScaleBarOverlay
    extends Overlay {
        private static final double[] scaleRoundedFactors = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0};
        private final VarColor color = new VarColor("Color", new Color(KymographScaleBar.access$000().getInt("color", new Color(255, 255, 255, 255).getRGB()))){

            public void setValue(Color newValue) {
                if (((Color)this.getValue()).equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putInt("color", newValue.getRGB());
                this.painterChanged();
            }
        };
        private final VarEnum<ScaleBarLocation> location = new VarEnum<ScaleBarLocation>("Location", ScaleBarLocation.valueOf((String)KymographScaleBar.access$000().get("location", ScaleBarLocation.IMAGE_BOTTOM_LEFT.name()))){

            public void setValue(ScaleBarLocation newValue) {
                if (((ScaleBarLocation)this.getValue()).equals((Object)newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.put("location", newValue.name());
                this.painterChanged();
            }
        };
        private final VarBoolean showText = new VarBoolean("Display size", KymographScaleBar.access$000().getBoolean("showText", true)){

            public void setValue(Boolean newValue) {
                if (((Boolean)this.getValue()).equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putBoolean("showText", newValue.booleanValue());
                this.painterChanged();
            }
        };
        private final VarInteger spaceSize = new VarInteger("Spatial size", KymographScaleBar.access$000().getInt("size", 10)){

            public void setValue(Integer newValue) {
                if (this.getValue().equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putInt("size", newValue.intValue());
                this.painterChanged();
            }
        };
        private final VarInteger timeSize = new VarInteger("Time size", KymographScaleBar.access$000().getInt("timeSize", 10)){

            public void setValue(Integer newValue) {
                if (this.getValue().equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putInt("timeSize", newValue.intValue());
                this.painterChanged();
            }
        };
        private final VarInteger thickness = new VarInteger("Thickness", KymographScaleBar.access$000().getInt("thickness", 5)){

            public void setValue(Integer newValue) {
                if (this.getValue().equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putInt("thickness", newValue.intValue());
                this.painterChanged();
            }
        };
        private final VarEnum<UnitUtil.UnitPrefix> spaceUnit = new VarEnum<UnitUtil.UnitPrefix>("Unit", UnitUtil.UnitPrefix.valueOf((String)KymographScaleBar.access$000().get("unit", UnitUtil.UnitPrefix.MICRO.name()))){

            public void setValue(UnitUtil.UnitPrefix newValue) {
                if (((UnitUtil.UnitPrefix)this.getValue()).equals((Object)newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.put("unit", newValue.name());
                this.painterChanged();
            }
        };
        private final VarEnum<UnitUtil.UnitPrefix> timeUnit = new VarEnum<UnitUtil.UnitPrefix>("Time unit", UnitUtil.UnitPrefix.valueOf((String)KymographScaleBar.access$000().get("timeUnit", UnitUtil.UnitPrefix.NONE.name()))){

            public void setValue(UnitUtil.UnitPrefix newValue) {
                if (((UnitUtil.UnitPrefix)this.getValue()).equals((Object)newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.put("unit", newValue.name());
                this.painterChanged();
            }
        };
        private final VarBoolean autoSize = new VarBoolean("Auto-adjust size", KymographScaleBar.access$000().getBoolean("autoSize", false)){

            public void setValue(Boolean newValue) {
                if (((Boolean)this.getValue()).equals(newValue)) {
                    return;
                }
                super.setValue((Object)newValue);
                preferences.putBoolean("autoSize", newValue.booleanValue());
                this.painterChanged();
            }
        };
        private JPanel optionPanel;
        private final Path2D.Double line = new Path2D.Double();
        boolean init = false;

        public KymographScaleBarOverlay() {
            super("Kymograph scale-bar", Overlay.OverlayPriority.TOPMOST);
            Integer currentSpaceSize = this.spaceSize.getValue();
            this.spaceSize.setDefaultEditorModel((VarEditorModel)new IntegerRangeModel(Integer.valueOf(10), Integer.valueOf(1), Integer.valueOf(999), Integer.valueOf(1)));
            this.spaceSize.setValue((Object)currentSpaceSize);
            Integer currentTimeSize = this.timeSize.getValue();
            this.timeSize.setDefaultEditorModel((VarEditorModel)new IntegerRangeModel(Integer.valueOf(10), Integer.valueOf(1), Integer.valueOf(999), Integer.valueOf(1)));
            this.timeSize.setValue((Object)currentTimeSize);
            Integer currentThickness = this.thickness.getValue();
            this.thickness.setDefaultEditorModel((VarEditorModel)new IntegerRangeModel(Integer.valueOf(5), Integer.valueOf(1), Integer.valueOf(20), Integer.valueOf(1)));
            this.thickness.setValue((Object)currentThickness);
            ThreadUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    this.initOptionPanel();
                }
            });
        }

        private void initOptionPanel() {
            this.optionPanel = new JPanel(new GridBagLayout());
            for (Var variable : new Var[]{this.location, this.color, this.autoSize, this.spaceSize, this.timeSize, this.thickness, this.showText}) {
                SwingVarEditor unitEditor;
                SwingVarEditor editor;
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.insets = new Insets(2, 10, 2, 5);
                gbc.fill = 1;
                this.optionPanel.add((Component)new JLabel(variable.getName()), gbc);
                if (variable == this.spaceSize) {
                    gbc.weightx = 0.5;
                    editor = (SwingVarEditor)variable.createVarEditor(true);
                    this.optionPanel.add((Component)editor.getEditorComponent(), gbc);
                    gbc.gridwidth = 0;
                    unitEditor = (SwingVarEditor)this.spaceUnit.createVarEditor(true);
                    this.optionPanel.add((Component)unitEditor.getEditorComponent(), gbc);
                    continue;
                }
                if (variable == this.timeSize) {
                    gbc.weightx = 0.5;
                    editor = (SwingVarEditor)variable.createVarEditor(true);
                    this.optionPanel.add((Component)editor.getEditorComponent(), gbc);
                    gbc.gridwidth = 0;
                    unitEditor = (SwingVarEditor)this.timeUnit.createVarEditor(true);
                    this.optionPanel.add((Component)unitEditor.getEditorComponent(), gbc);
                    continue;
                }
                gbc.weightx = 1.0;
                gbc.gridwidth = 0;
                editor = (SwingVarEditor)variable.createVarEditor(true);
                this.optionPanel.add((Component)editor.getEditorComponent(), gbc);
            }
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            double yt;
            double xt;
            double ys;
            double xs;
            double yc;
            double xc;
            if (canvas instanceof VtkCanvas || g == null || !(canvas instanceof IcyCanvas2D)) {
                return;
            }
            IcyCanvas2D c2 = (IcyCanvas2D)canvas;
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.setColor((Color)this.color.getValue());
            if (((Boolean)this.autoSize.getValue()).booleanValue()) {
                int sizeW = sequence.getSizeX() / 7;
                if (((ScaleBarLocation)this.location.getValue()).isRelativeToImage()) {
                    sizeW = (int)Math.min((double)sizeW, (double)sequence.getSizeX() * canvas.getScaleX() * 0.9);
                }
                double valueReal = (double)sizeW * sequence.getPixelSizeX() / canvas.getScaleX();
                UnitUtil.UnitPrefix bestUnit = UnitUtil.getBestUnit((double)(valueReal * 0.1), (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.MICRO, (int)1);
                double valueRealBestUnit = UnitUtil.getValueInUnit((double)valueReal, (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.MICRO, (UnitUtil.UnitPrefix)bestUnit);
                double closestScale = MathUtil.closest((double)valueRealBestUnit, (double[])scaleRoundedFactors);
                this.spaceSize.setValue((Object)((int)closestScale));
                this.spaceUnit.setValue((Object)bestUnit);
                int sizeH = sequence.getSizeY() / 7;
                if (((ScaleBarLocation)this.location.getValue()).isRelativeToImage()) {
                    sizeH = (int)Math.min((double)sizeH, (double)sequence.getSizeY() * canvas.getScaleY() * 0.9);
                }
                double timeValueReal = (double)sizeH * sequence.getTimeInterval() / canvas.getScaleY();
                UnitUtil.UnitPrefix timeBestUnit = UnitUtil.getBestUnit((double)(timeValueReal * 0.1), (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.NONE, (int)1);
                double timeValueRealBestUnit = UnitUtil.getValueInUnit((double)timeValueReal, (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.NONE, (UnitUtil.UnitPrefix)timeBestUnit);
                double timeClosestScale = MathUtil.closest((double)timeValueRealBestUnit, (double[])scaleRoundedFactors);
                this.timeSize.setValue((Object)((int)timeClosestScale));
                this.timeUnit.setValue((Object)timeBestUnit);
            }
            String spaceText = "" + this.spaceSize.getValue() + this.spaceUnit.getValue() + "m";
            String timeText = "" + this.timeSize.getValue() + this.timeUnit.getValue() + "s";
            double spaceLength = UnitUtil.getValueInUnit((double)this.spaceSize.getValue().intValue(), (UnitUtil.UnitPrefix)((UnitUtil.UnitPrefix)this.spaceUnit.getValue()), (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.MICRO) / sequence.getPixelSizeX();
            double timeLength = UnitUtil.getValueInUnit((double)this.timeSize.getValue().intValue(), (UnitUtil.UnitPrefix)((UnitUtil.UnitPrefix)this.timeUnit.getValue()), (UnitUtil.UnitPrefix)UnitUtil.UnitPrefix.NONE) / sequence.getTimeInterval();
            float finalThickness = this.thickness.getValue().floatValue();
            switch ((ScaleBarLocation)this.location.getValue()) {
                default: {
                    g2.transform(c2.getInverseTransform());
                    xc = (double)canvas.getCanvasSizeX() * 0.05;
                    yc = (double)canvas.getCanvasSizeY() * 0.95;
                    xs = xc + spaceLength * c2.getScaleX();
                    ys = yc;
                    xt = xc;
                    yt = yc - timeLength * c2.getScaleY();
                    break;
                }
                case IMAGE_BOTTOM_LEFT: {
                    xc = (double)sequence.getSizeX() * 0.05;
                    yc = (double)sequence.getSizeY() * 0.95;
                    xs = xc + spaceLength;
                    ys = yc;
                    xt = xc;
                    yt = yc - timeLength;
                    finalThickness = (float)c2.canvasToImageLogDeltaX((int)finalThickness);
                    break;
                }
                case VIEWER_BOTTOM_RIGHT: {
                    g2.transform(c2.getInverseTransform());
                    xc = (double)canvas.getCanvasSizeX() * 0.95;
                    yc = (double)canvas.getCanvasSizeY() * 0.95;
                    xs = xc - spaceLength * c2.getScaleX();
                    ys = yc;
                    xt = xc;
                    yt = yc - timeLength * c2.getScaleY();
                    break;
                }
                case IMAGE_BOTTOM_RIGHT: {
                    xc = (double)sequence.getSizeX() * 0.95;
                    yc = (double)sequence.getSizeY() * 0.95;
                    xs = xc - spaceLength;
                    ys = yc;
                    xt = xc;
                    yt = yc - timeLength;
                    finalThickness = (float)c2.canvasToImageLogDeltaX((int)finalThickness);
                    break;
                }
                case VIEWER_TOP_LEFT: {
                    g2.transform(c2.getInverseTransform());
                    xc = (double)canvas.getCanvasSizeX() * 0.05;
                    yc = (double)canvas.getCanvasSizeY() * 0.05;
                    xs = xc + spaceLength * c2.getScaleX();
                    ys = yc;
                    xt = xc;
                    yt = yc + timeLength * c2.getScaleY();
                    break;
                }
                case IMAGE_TOP_LEFT: {
                    xc = (double)sequence.getSizeX() * 0.05;
                    yc = (double)sequence.getSizeY() * 0.05;
                    xs = xc + spaceLength;
                    ys = yc;
                    xt = xc;
                    yt = yc + timeLength;
                    finalThickness = (float)c2.canvasToImageLogDeltaX((int)finalThickness);
                    break;
                }
                case VIEWER_TOP_RIGHT: {
                    g2.transform(c2.getInverseTransform());
                    xc = (double)canvas.getCanvasSizeX() * 0.95;
                    yc = (double)canvas.getCanvasSizeY() * 0.05;
                    xs = xc - spaceLength * c2.getScaleX();
                    ys = yc;
                    xt = xc;
                    yt = yc + timeLength * c2.getScaleY();
                    break;
                }
                case IMAGE_TOP_RIGHT: {
                    xc = (double)sequence.getSizeX() * 0.95;
                    xs = xc - spaceLength;
                    ys = yc = (double)sequence.getSizeY() * 0.05;
                    xt = xc;
                    yt = yc + timeLength;
                    finalThickness = (float)c2.canvasToImageLogDeltaX((int)finalThickness);
                }
            }
            this.line.reset();
            this.line.moveTo(xs, ys);
            this.line.lineTo(xc, yc);
            this.line.lineTo(xt, yt);
            g2.setStroke(new BasicStroke(finalThickness, 0, 0));
            g2.draw(this.line);
            if (((Boolean)this.showText.getValue()).booleanValue()) {
                g2.setFont(g2.getFont().deriveFont(1, finalThickness * 3.0f));
                int spaceTextwidth = g2.getFontMetrics().stringWidth(spaceText);
                int timeTextwidth = g2.getFontMetrics().stringWidth(timeText);
                int textHeight = g2.getFontMetrics().getHeight();
                double xst = xs - xc > 0.0 ? xs + 1.0 : xs - 1.0 - (double)spaceTextwidth;
                double yst = yc + (double)(textHeight / 2) + (double)finalThickness / 2.0;
                double xtt = xc - (double)(timeTextwidth / 2);
                double ytt = yt - yc > 0.0 ? yt + 1.0 + (double)textHeight : yt - 1.0;
                g2.drawString(spaceText, (float)xst, (float)yst);
                g2.drawString(timeText, (float)xtt, (float)ytt);
            }
            g2.dispose();
        }

        public JPanel getOptionsPanel() {
            return this.optionPanel;
        }

        public boolean getAutoSize() {
            return (Boolean)this.autoSize.getValue();
        }

        public Color getColor() {
            return (Color)this.color.getValue();
        }

        public ScaleBarLocation getLocation() {
            return (ScaleBarLocation)this.location.getValue();
        }

        public double getSize() {
            return this.spaceSize.getValue().intValue();
        }

        public boolean getTextDisplay() {
            return (Boolean)this.showText.getValue();
        }

        public void setAutoSize(boolean autoSize) {
            this.autoSize.setValue((Object)autoSize);
        }

        public void setColor(Color color) {
            this.color.setValue((Object)color);
        }

        public void setLocation(ScaleBarLocation location) {
            this.location.setValue((Object)location);
        }

        public void setTextDisplay(boolean displayText) {
            this.showText.setValue((Object)displayText);
        }

        public void setSize(int size) {
            this.spaceSize.setValue((Object)size);
        }

        public void setUnit(UnitUtil.UnitPrefix unit) {
            this.spaceUnit.setValue((Object)unit);
        }
    }
}

