/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker;

import icy.roi.ROI;
import icy.sequence.Sequence;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import plugins.kernel.roi.roi2d.ROI2DPolyLine;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.tinevez.kymographtracker.spline.CubicSmoothingSpline;

public class Util {
    static float shiftDrawX = 0.5f;
    static float shiftDrawY = 0.5f;

    static ROI convertPathToROI(Sequence sequence, ArrayList<double[][]> pathList) {
        return Util.convertPathToSmoothedROI(sequence, pathList);
    }

    static ROI convertPathToSmoothedROI(Sequence sequence, ArrayList<double[][]> pathList) {
        double prevLastPosX = -1.0;
        double prevLastPosY = -1.0;
        double length = 0.0;
        ROI2DPolyLine polylineROI = null;
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y1 = new ArrayList<Double>();
        ArrayList<Double> y2 = new ArrayList<Double>();
        ArrayList<Double> w = new ArrayList<Double>();
        if (!pathList.isEmpty()) {
            for (double[][] path : pathList) {
                for (int i = 0; i < path.length; ++i) {
                    if (prevLastPosX == path[i][0] && prevLastPosY == path[i][1]) continue;
                    if (prevLastPosX != -1.0 && prevLastPosY != -1.0) {
                        length += Math.sqrt((path[i][0] - prevLastPosX) * (path[i][0] - prevLastPosX) + (path[i][1] - prevLastPosY) * (path[i][1] - prevLastPosY));
                    }
                    x.add(length);
                    y1.add(path[i][0]);
                    y2.add(path[i][1]);
                    prevLastPosX = path[i][0];
                    prevLastPosY = path[i][1];
                    w.add(1.0);
                }
                prevLastPosX = path[path.length - 1][0];
                prevLastPosY = path[path.length - 1][1];
            }
            double[] xTab = new double[x.size()];
            double[] y1Tab = new double[x.size()];
            double[] y2Tab = new double[x.size()];
            double[] wTab = new double[x.size()];
            for (int i = 0; i < xTab.length; ++i) {
                xTab[i] = (Double)x.get(i);
                y1Tab[i] = (Double)y1.get(i);
                y2Tab[i] = (Double)y2.get(i);
                wTab[i] = (Double)w.get(i);
            }
            double rho = 0.5;
            CubicSmoothingSpline smoothingSpline1 = new CubicSmoothingSpline(xTab, y1Tab, wTab, rho);
            CubicSmoothingSpline smoothingSpline2 = new CubicSmoothingSpline(xTab, y2Tab, wTab, rho);
            for (double l = 0.0; l < length; l += 1.0) {
                double xEval = smoothingSpline1.evaluate(l);
                double yEval = smoothingSpline2.evaluate(l);
                if (l == 0.0) {
                    polylineROI = new ROI2DPolyLine((Point2D)new Point2D.Double(xEval + (double)shiftDrawX, yEval + (double)shiftDrawY));
                    continue;
                }
                polylineROI.addPoint((Point2D)new Point2D.Double(xEval + (double)shiftDrawX, yEval + (double)shiftDrawY), true);
            }
        }
        polylineROI.setSelected(false);
        return polylineROI;
    }

    public static CubicSmoothingSpline getXsplineFromROI(ROI2DShape roi) {
        ArrayList pointList = roi.getPoints();
        double prevLastPosX = -1.0;
        double prevLastPosY = -1.0;
        double length = 0.0;
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y = new ArrayList<Double>();
        ArrayList<Double> w = new ArrayList<Double>();
        for (Point2D p : pointList) {
            double xx = p.getX();
            double yy = p.getY();
            if (prevLastPosX == xx && prevLastPosY == yy) continue;
            if (prevLastPosX != -1.0 && prevLastPosY != -1.0) {
                length += Math.sqrt((xx - prevLastPosX) * (xx - prevLastPosX) + (yy - prevLastPosY) * (yy - prevLastPosY));
            }
            x.add(length);
            y.add(xx);
            prevLastPosX = xx;
            prevLastPosY = yy;
            w.add(1.0);
        }
        double[] xTab = new double[x.size()];
        double[] yTab = new double[x.size()];
        double[] wTab = new double[x.size()];
        for (int i = 0; i < xTab.length; ++i) {
            xTab[i] = (Double)x.get(i);
            yTab[i] = (Double)y.get(i);
            wTab[i] = (Double)w.get(i);
        }
        double rho = 0.5;
        CubicSmoothingSpline smoothingSpline = new CubicSmoothingSpline(xTab, yTab, wTab, rho);
        return smoothingSpline;
    }

    public static CubicSmoothingSpline getYsplineFromROI(ROI2DShape roi) {
        ArrayList pointList = roi.getPoints();
        double prevLastPosX = -1.0;
        double prevLastPosY = -1.0;
        double length = 0.0;
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y = new ArrayList<Double>();
        ArrayList<Double> w = new ArrayList<Double>();
        for (Point2D p : pointList) {
            double xx = p.getX();
            double yy = p.getY();
            if (prevLastPosX == xx && prevLastPosY == yy) continue;
            if (prevLastPosX != -1.0 && prevLastPosY != -1.0) {
                length += Math.sqrt((xx - prevLastPosX) * (xx - prevLastPosX) + (yy - prevLastPosY) * (yy - prevLastPosY));
            }
            x.add(length);
            y.add(yy);
            prevLastPosX = xx;
            prevLastPosY = yy;
            w.add(1.0);
        }
        double[] xTab = new double[x.size()];
        double[] yTab = new double[x.size()];
        double[] wTab = new double[x.size()];
        for (int i = 0; i < xTab.length; ++i) {
            xTab[i] = (Double)x.get(i);
            yTab[i] = (Double)y.get(i);
            wTab[i] = (Double)w.get(i);
        }
        double rho = 0.5;
        CubicSmoothingSpline smoothingSpline = new CubicSmoothingSpline(xTab, yTab, wTab, rho);
        return smoothingSpline;
    }

    public static double getSplineLength(ROI2DShape roi) {
        ArrayList pointList = roi.getPoints();
        double prevLastPosX = -1.0;
        double prevLastPosY = -1.0;
        double length = 0.0;
        for (Point2D p : pointList) {
            double xx = p.getX();
            double yy = p.getY();
            if (prevLastPosX == xx && prevLastPosY == yy) continue;
            if (prevLastPosX != -1.0 && prevLastPosY != -1.0) {
                length += Math.sqrt((xx - prevLastPosX) * (xx - prevLastPosX) + (yy - prevLastPosY) * (yy - prevLastPosY));
            }
            prevLastPosX = xx;
            prevLastPosY = yy;
        }
        return length;
    }
}

