/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker.spline;

import java.util.ArrayList;

public class CubicSpline {
    private double s = 1.0E-16;
    private double[][] input;
    private double[] a;
    private double[] b;
    private double[] c;
    private double[] d;

    public CubicSpline(double[][] input, double smoothingFactor) {
        this.s = smoothingFactor;
    }

    private void smooth() {
        int i;
        double h;
        int N = this.input.length;
        boolean n1 = true;
        int n2 = N;
        double[] x = new double[N + 1];
        double[] y = new double[N + 1];
        double dy = 1.0;
        for (int i2 = 1; i2 < N + 1; ++i2) {
            x[i2] = this.input[i2][0];
            y[i2] = this.input[i2][1];
        }
        this.a = new double[N += 2];
        this.b = new double[N];
        this.c = new double[N];
        this.d = new double[N];
        double[] r = new double[N];
        double[] r1 = new double[N];
        double[] r2 = new double[N];
        double[] t = new double[N];
        double[] t1 = new double[N];
        double[] u = new double[N];
        double[] v = new double[N];
        int m1 = 0;
        int m2 = n2 + 1;
        double p = 0.0;
        u[m2] = 0.0;
        u[n2] = 0.0;
        u[1] = 0.0;
        u[m1] = 0.0;
        r2[m2] = 0.0;
        r2[n2] = 0.0;
        r1[n2] = 0.0;
        r[1] = 0.0;
        r[m1] = 0.0;
        m1 = 2;
        m2 = n2 - 1;
        double g = h = (double)(m1 - 1);
        double f = (y[m1] - y[1]) / h;
        for (i = m1; i <= m2; ++i) {
            g = h;
            h = 1.0;
            double e = f;
            f = y[i + 1] - y[i];
            this.a[i] = f - e;
            t[i] = 2.0 * (g + h) / 3.0;
            t1[i] = h / 3.0;
            r2[i] = 1.0 / g;
            r[i] = 1.0;
            r1[i] = -1.0 / g - 1.0;
        }
        for (i = m1; i <= m2; ++i) {
            this.b[i] = r[i] * r[i] + r1[i] * r1[i] + r2[i] * r2[i];
            this.c[i] = r[i] * r1[i + 1] + r1[i] * r2[i + 1];
            this.d[i] = r[i] * r2[i + 2];
        }
        double f2 = -this.s;
        while (true) {
            for (i = m1; i <= m2; ++i) {
                r1[i - 1] = f * r[i - 1];
                r2[i - 2] = g * r[i - 2];
                r[i] = 1.0 / (p * this.b[i] + t[i] - f * r1[i - 1] - g * r2[i - 2]);
                u[i] = this.a[i] - r1[i - 1] * u[i - 1] - r2[i - 2] * u[i - 2];
                f = p * this.c[i] + t1[i] - h * r1[i - 1];
                g = h;
                h = this.d[i] * p;
            }
            for (i = m2; i >= m1; --i) {
                u[i] = r[i] * u[i] - r1[i] * u[i + 1] - r2[i] * u[i + 2];
            }
            h = 0.0;
            double e = 0.0;
            for (i = 1; i <= m2; ++i) {
                g = h;
                h = u[i + 1] - u[i];
                v[i] = (h - g) * 1.0 * 1.0;
                e += v[i] * (h - g);
            }
            g = v[n2] = -h * 1.0 * 1.0;
            e -= g * h;
            g = f2;
            f2 = e * p * p;
            if (f2 >= this.s || f2 <= g) break;
            f = 0.0;
            h = (v[m1] - v[1]) / (double)(m1 - 1);
            for (i = m1; i <= m2; ++i) {
                g = h;
                h = v[i + 1] - v[i];
                g = h - g - r1[i - 1] * r[i - 1] - r2[i - 2] * r[i - 2];
                f += g * r[i] * g;
                r[i] = g;
            }
            h = e - p * f;
            if (h <= 0.0) break;
            p += (this.s - f2) / ((Math.sqrt(this.s / e) + p) / h);
        }
        for (i = 1; i <= n2; ++i) {
            this.a[i] = y[i] - p * v[i];
            this.c[i] = u[i];
        }
        for (i = 1; i <= m2; ++i) {
            h = 1.0;
            this.d[i] = (this.c[i + 1] - this.c[i]) / (3.0 * h);
            this.b[i] = (this.a[i + 1] - this.a[i]) / h - (h * this.d[i] + this.c[i]) * h;
        }
    }

    public void index() {
        this.smooth();
        int n = this.input.length;
        ArrayList<Double> output = new ArrayList<Double>(n);
        for (int i = 0; i < n; ++i) {
            double y = this.d[i] + this.c[i] + this.b[i] + this.a[i];
            output.add(new Double(y));
        }
        double y2 = ((Number)output.get(2)).doubleValue();
        double y1 = ((Number)output.get(1)).doubleValue();
        double y0 = y1 - (y2 - y1);
        output.set(0, new Double(y0));
    }
}

