/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.pathtracing;

import icy.gui.component.sequence.SequenceChooser;
import icy.gui.frame.TitledFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.painter.Painter;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.tinevez.pathtracing.InteractiveDjikstraTracing;
import plugins.tinevez.pathtracing.PathEvent;
import plugins.tinevez.pathtracing.PathListener;

public class PathTracing
extends PluginActionable {
    private TitledFrame mainFrame;
    private SequenceChooser sequenceChooser;
    private IntensityGraphPanel intensityGraphPanel;
    private TracingOptionPanel tracingOptPanel;
    int minLineSize = 100;
    double defaultAlpha = 1.0E-4;

    public void run() {
        JPanel mainPanel = new JPanel();
        this.mainFrame = GuiUtil.generateTitleFrame((String)"Path tracing", (JPanel)mainPanel, (Dimension)new Dimension(300, 70), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        JPanel sequencePanel = new JPanel();
        sequencePanel.setLayout(new BoxLayout(sequencePanel, 2));
        this.sequenceChooser = new SequenceChooser();
        sequencePanel.add((Component)this.sequenceChooser);
        sequencePanel.setBorder(new TitledBorder("Sequence to process"));
        this.sequenceChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PathTracing.this.sequenceChanged(PathTracing.this.sequenceChooser.getSelectedSequence());
            }
        });
        mainPanel.add(sequencePanel);
        this.tracingOptPanel = new TracingOptionPanel();
        mainPanel.add(this.tracingOptPanel);
        this.intensityGraphPanel = new IntensityGraphPanel();
        this.intensityGraphPanel.drawFinalPath = true;
        this.intensityGraphPanel.drawTemporaryPath = true;
        mainPanel.add(this.intensityGraphPanel);
        this.mainFrame.pack();
        this.mainFrame.addToMainDesktopPane();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.requestFocus();
    }

    public void sequenceChanged(Sequence sequence) {
        if (sequence != null) {
            InteractiveDjikstraTracing tracer = null;
            for (Painter p : sequence.getPainters()) {
                if (!(p instanceof InteractiveDjikstraTracing)) continue;
                tracer = (InteractiveDjikstraTracing)p;
                this.intensityGraphPanel.listenToTracer(tracer);
                break;
            }
            if (tracer == null) {
                try {
                    tracer = new InteractiveDjikstraTracing(sequence, this.tracingOptPanel.getAlpha());
                    sequence.addPainter((Painter)tracer);
                    this.intensityGraphPanel.listenToTracer(tracer);
                }
                catch (Exception e) {
                    new AnnounceFrame("The initialiation of the tracer has failed. Please refer to the log");
                    e.printStackTrace();
                }
            }
        }
    }

    public void changeTracersAlpha(double newAlpha) {
        block0: for (Sequence seq : this.getSequences()) {
            for (Painter p : seq.getPainters()) {
                if (!(p instanceof InteractiveDjikstraTracing)) continue;
                seq.removePainter(p);
                InteractiveDjikstraTracing tracer = new InteractiveDjikstraTracing(seq, newAlpha);
                seq.addPainter((Painter)tracer);
                if (this.intensityGraphPanel.tracer == p) {
                    this.intensityGraphPanel.listenToTracer(tracer);
                    tracer.enable();
                    continue block0;
                }
                tracer.disable();
                continue block0;
            }
        }
    }

    public class TracingOptionPanel
    extends JPanel
    implements CaretListener,
    ActionListener {
        private static final long serialVersionUID = 1942232576879610509L;
        JTextField alphaTextField;
        JLabel errorLabel;
        double alpha;
        JButton applyButton;

        public TracingOptionPanel() {
            this.setLayout(new BoxLayout(this, 2));
            this.add(new JLabel("Trade-off between pixel intensity and path length criteria"));
            this.alphaTextField = new JTextField(Double.toString(PathTracing.this.defaultAlpha));
            this.add(this.alphaTextField);
            this.alphaTextField.addCaretListener(this);
            this.errorLabel = new JLabel("");
            this.add(this.errorLabel);
            this.applyButton = new JButton("apply");
            this.applyButton.addActionListener(this);
            this.add(this.applyButton);
        }

        public double getAlpha() {
            double threshold;
            try {
                threshold = Double.parseDouble(this.alphaTextField.getText());
                if (this.errorLabel.getText().length() > 0) {
                    this.errorLabel.setText("");
                }
            }
            catch (NumberFormatException nfe) {
                threshold = PathTracing.this.defaultAlpha;
                this.errorLabel.setText("value not recognized");
            }
            if (threshold < 0.0) {
                this.errorLabel.setText("value should be positive");
                threshold = PathTracing.this.defaultAlpha;
            }
            return threshold;
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.getAlpha();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            PathTracing.this.changeTracersAlpha(this.getAlpha());
        }
    }

    class IntensityGraphPanel
    extends JPanel
    implements PathListener {
        private static final long serialVersionUID = 1421822401789996232L;
        XYDataset datest = null;
        ChartPanel chartPanel = null;
        InteractiveDjikstraTracing tracer = null;
        JCheckBox drawTemporaryPathBox;
        JCheckBox disableDrawingBox;
        public boolean drawTemporaryPath = true;
        public boolean drawFinalPath = true;
        JLabel lengthLabel = new JLabel();
        JLabel meanIntensityLabel = new JLabel();
        JLabel varianceIntensityLabel = new JLabel();

        public IntensityGraphPanel() {
            this.resetChart();
            this.setLayout(new BoxLayout(this, 3));
            this.add((Component)this.chartPanel);
            JPanel infoPanel = new JPanel(new FlowLayout(3));
            infoPanel.add(this.lengthLabel);
            infoPanel.add(this.meanIntensityLabel);
            infoPanel.add(this.varianceIntensityLabel);
            this.add(infoPanel);
            JPanel boxPanel = new JPanel(new FlowLayout(3));
            this.disableDrawingBox = new JCheckBox("Disable intensity drawing");
            this.disableDrawingBox.setSelected(false);
            this.disableDrawingBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IntensityGraphPanel.this.drawTemporaryPath = !IntensityGraphPanel.this.disableDrawingBox.isSelected() && IntensityGraphPanel.this.drawTemporaryPathBox.isSelected();
                    IntensityGraphPanel.this.drawFinalPath = !IntensityGraphPanel.this.disableDrawingBox.isSelected();
                    IntensityGraphPanel.this.refreshPath(IntensityGraphPanel.this.tracer);
                }
            });
            this.drawTemporaryPathBox = new JCheckBox("Draw temprory path inensity");
            this.drawTemporaryPathBox.setSelected(true);
            this.drawTemporaryPathBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IntensityGraphPanel.this.drawTemporaryPath = !IntensityGraphPanel.this.disableDrawingBox.isSelected() && IntensityGraphPanel.this.drawTemporaryPathBox.isSelected();
                    IntensityGraphPanel.this.refreshPath(IntensityGraphPanel.this.tracer);
                }
            });
            boxPanel.add(this.disableDrawingBox);
            boxPanel.add(this.drawTemporaryPathBox);
            this.add(boxPanel);
        }

        private void displayIntensityPath(double[][] path) {
            if (this.tracer != null) {
                int i;
                XYSeries series = new XYSeries((Comparable)((Object)"Path"));
                double sum = 0.0;
                double sum2 = 0.0;
                this.lengthLabel.setText("Length = " + path.length);
                for (i = 0; i < path.length; ++i) {
                    Number v = this.tracer.getIntensityAt(path[i][0], path[i][1]);
                    series.add((double)i, v);
                    sum += v.doubleValue();
                    sum2 += v.doubleValue() * v.doubleValue();
                }
                if (path.length > 0) {
                    this.meanIntensityLabel.setText("Mean intensity = " + sum / (double)path.length);
                    this.varianceIntensityLabel.setText("Intensity variance = " + (sum2 / (double)path.length - Math.pow(sum / (double)path.length, 2.0)));
                }
                for (i = series.getItemCount() + 1; i < PathTracing.this.minLineSize; ++i) {
                    series.add((double)i, 0.0);
                }
                XYSeriesCollection seriescollection = new XYSeriesCollection();
                seriescollection.addSeries(series);
                JFreeChart jfreechart = ChartFactory.createXYLineChart((String)"Intensity along the path", (String)"Position on the path", (String)"Intensity value", (XYDataset)seriescollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                if (this.chartPanel == null) {
                    this.chartPanel = new ChartPanel(jfreechart);
                } else {
                    this.chartPanel.setChart(jfreechart);
                }
            } else {
                this.resetChart();
            }
        }

        public void listenToTracer(InteractiveDjikstraTracing tracer) {
            if (this.tracer != null) {
                this.tracer.removePathLister(this);
                this.tracer.disable();
            }
            this.tracer = tracer;
            if (tracer != null) {
                tracer.addPathLister(this);
                tracer.enable();
                this.refreshPath(tracer);
            }
        }

        public void resetChart() {
            this.datest = null;
            XYSeries series = new XYSeries((Comparable)((Object)"Path"));
            XYSeriesCollection seriescollection = new XYSeriesCollection();
            for (int i = 1; i < PathTracing.this.minLineSize; ++i) {
                series.add((double)i, 0.0);
            }
            seriescollection.addSeries(series);
            JFreeChart jfreechart = ChartFactory.createXYLineChart((String)"Intensity along the path", (String)"Position on the path", (String)"Intensity value", (XYDataset)seriescollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
            if (this.chartPanel == null) {
                this.chartPanel = new ChartPanel(jfreechart);
            } else {
                this.chartPanel.setChart(jfreechart);
            }
            this.lengthLabel.setText("");
            this.meanIntensityLabel.setText("");
            this.varianceIntensityLabel.setText("");
        }

        @Override
        public void refreshPath(PathEvent event, Object source, double[][] path) {
            if (event == PathEvent.TEMPORARY_PATH && this.drawTemporaryPath) {
                this.displayIntensityPath(path);
            } else if (event == PathEvent.FINAL_PATH && this.drawFinalPath) {
                this.displayIntensityPath(path);
            } else if (event == PathEvent.RESET_PATH) {
                this.resetChart();
            }
        }

        private void refreshPath(InteractiveDjikstraTracing tracer) {
            if (tracer != null) {
                double[][] path = tracer.getOptimalPathCopy();
                if (path != null) {
                    this.displayIntensityPath(path);
                } else {
                    this.resetChart();
                }
            } else {
                this.resetChart();
            }
        }
    }
}

