/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import plugins.nchenouard.isotropicwavelets.IsotropicWaveletTransform;
import plugins.nchenouard.isotropicwavelets.IsotropicWaveletType;
import plugins.nchenouard.isotropicwavelets.WaveletAnalysisResults;
import plugins.nchenouard.isotropicwavelets.WaveletFilterSet;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszConfig;
import plugins.tinevez.rieszwavelets.RieszGeneralization;
import plugins.tinevez.rieszwavelets.RieszWaveletCoefficients;

public class RieszWaveletConfig {
    int width;
    int height;
    boolean isRealImage;
    WaveletFilterSet waveletsConfig;
    ArrayList<RieszConfig> rieszConfigList;

    public RieszWaveletConfig(int width, int height, boolean isRealImage, int numScales, IsotropicWaveletType waveletType, boolean prefilter, boolean prepareRieszFilters, int order, HarmonicTypes harmonicTypes) {
        this(width, height, isRealImage, numScales, waveletType, prefilter, prepareRieszFilters, order, harmonicTypes, true);
    }

    public RieszWaveletConfig(int width, int height, boolean isRealImage, int numScales, IsotropicWaveletType waveletType, boolean prefilter, boolean prepareRieszFilters, int order, HarmonicTypes harmonicTypes, boolean isotropicPadding) {
        this.width = width;
        this.height = height;
        this.isRealImage = isRealImage;
        if (!isRealImage) {
            throw new IllegalArgumentException("Complex images are not yet supported in this version of the wavelet library");
        }
        this.waveletsConfig = new WaveletFilterSet(waveletType, numScales, prefilter, width, height, isotropicPadding);
        this.rieszConfigList = new ArrayList();
        for (int i = 0; i < numScales; ++i) {
            if (prepareRieszFilters) {
                this.rieszConfigList.add(new RieszConfig(order, harmonicTypes, this.waveletsConfig.getScaleWidth(i), this.waveletsConfig.getScaleHeight(i)));
                continue;
            }
            this.rieszConfigList.add(new RieszConfig(order, harmonicTypes));
        }
    }

    public void displayRieszFilters(int scale) {
        Sequence imaginarySequence;
        Sequence realSequence;
        RieszConfig config = this.rieszConfigList.get(scale);
        if (config.filters != null) {
            realSequence = new Sequence();
            realSequence.setName("Real part");
            imaginarySequence = new Sequence();
            imaginarySequence.setName("Imaginary part");
            for (int c = 0; c < config.numChannels; ++c) {
                double[] realPart = new double[config.width * config.height];
                double[] imaginaryPart = new double[config.width * config.height];
                for (int i = 0; i < realPart.length; ++i) {
                    realPart[i] = config.filters[c][2 * i];
                    imaginaryPart[i] = config.filters[c][2 * i + 1];
                }
                realSequence.addImage(c, (BufferedImage)new IcyBufferedImage(this.waveletsConfig.getScaleWidth(scale), this.waveletsConfig.getScaleHeight(scale), (Object)realPart));
                imaginarySequence.addImage(c, (BufferedImage)new IcyBufferedImage(this.waveletsConfig.getScaleWidth(scale), this.waveletsConfig.getScaleHeight(scale), (Object)imaginaryPart));
            }
        } else {
            throw new IllegalArgumentException("Cannot show Riesz filters if they have not been prepared");
        }
        Icy.getMainInterface().addSequence(realSequence);
        Icy.getMainInterface().addSequence(imaginarySequence);
    }

    public RieszWaveletCoefficients multiscaleRieszAnalysis(double[] image, int width, int height, ArrayList<RieszGeneralization> generalizationList) {
        WaveletAnalysisResults waveletProjection = IsotropicWaveletTransform.isotropicBandlimitedAnalysis((double[])image, (int)width, (int)height, (WaveletFilterSet)this.waveletsConfig);
        ArrayList<double[][]> coefficients = new ArrayList<double[][]>(waveletProjection.getNumScales());
        for (int i = 0; i < waveletProjection.getNumScales(); ++i) {
            double[] band = waveletProjection.getWaveletBand(i);
            RieszConfig rieszConfig = this.rieszConfigList.get(i);
            RieszGeneralization generalization = generalizationList.get(i);
            double[][] rieszWaveletBand = rieszConfig.analysis(band, generalization);
            coefficients.add(rieszWaveletBand);
        }
        return new RieszWaveletCoefficients(this, generalizationList, coefficients, waveletProjection.getHPResidual(), waveletProjection.getLPResidual(), waveletProjection.getPadX(), waveletProjection.getPadY());
    }

    public RieszWaveletCoefficients multiscaleRieszAnalysisInFourier(double[] image, int width, int height, ArrayList<RieszGeneralization> generalizationList) {
        WaveletAnalysisResults waveletProjection = IsotropicWaveletTransform.isotropicBandlimitedAnalysis((double[])image, (int)width, (int)height, (WaveletFilterSet)this.waveletsConfig, (boolean)true);
        ArrayList<double[][]> coefficients = new ArrayList<double[][]>(waveletProjection.getNumScales());
        for (int i = 0; i < waveletProjection.getNumScales(); ++i) {
            double[] band = waveletProjection.getWaveletBand(i);
            RieszConfig rieszConfig = this.rieszConfigList.get(i);
            RieszGeneralization generalization = generalizationList.get(i);
            double[][] rieszWaveletBand = rieszConfig.analysis(band, generalization, true, false);
            coefficients.add(rieszWaveletBand);
        }
        return new RieszWaveletCoefficients(this, generalizationList, coefficients, waveletProjection.getHPResidual(), waveletProjection.getLPResidual(), waveletProjection.getPadX(), waveletProjection.getPadY());
    }

    public double[] multiscaleRieszSynthesisInFourier(RieszWaveletCoefficients coefficients, int width, int height) {
        double[][] waveletBands = new double[coefficients.getNumScales()][];
        double[] lpResidual = coefficients.getLPResidual();
        double[] hpResidual = coefficients.getHPResidual();
        for (int i = 0; i < this.getNumScales(); ++i) {
            double[][] rieszBands = coefficients.getRieszBandsAtScale(i);
            RieszConfig rieszConfig = this.rieszConfigList.get(i);
            RieszGeneralization generalization = coefficients.generalizationList.get(i);
            waveletBands[i] = rieszConfig.synthesis(rieszBands, generalization, false, true);
        }
        WaveletAnalysisResults waveletCoefficients = new WaveletAnalysisResults((double[][])waveletBands, lpResidual, hpResidual, coefficients.rieszWaveletConfig.waveletsConfig, true);
        double[] reconstruction = IsotropicWaveletTransform.isotropicBandlimitedSynthesis((WaveletAnalysisResults)waveletCoefficients);
        if (waveletCoefficients.getWaveletFilters().getHeight() > height || waveletCoefficients.getWaveletFilters().getWidth() > width) {
            reconstruction = IsotropicWaveletTransform.unpadImage((double[])reconstruction, (int)width, (int)height, (int)waveletCoefficients.getWaveletFilters().getWidth(), (int)waveletCoefficients.getWaveletFilters().getHeight(), (int)coefficients.getPadX(), (int)coefficients.getPadY());
        }
        return reconstruction;
    }

    public void steerCoefficients(RieszWaveletCoefficients coefficients, ArrayList<double[]> angleList, boolean forward) {
        for (int i = 0; i < this.getNumScales(); ++i) {
            double[][] rieszBands = coefficients.getRieszBandsAtScale(i);
            RieszConfig rieszConfig = this.rieszConfigList.get(i);
            RieszGeneralization generalization = coefficients.generalizationList.get(i);
            rieszConfig.steerCoefficients(rieszBands, generalization, angleList.get(i), forward);
        }
    }

    public int getNumScales() {
        return this.waveletsConfig.getNumScales();
    }

    public ArrayList<RieszConfig> getRieszConfigurations() {
        return new ArrayList<RieszConfig>(this.rieszConfigList);
    }

    public WaveletFilterSet getWaveletFilterSet() {
        return this.waveletsConfig;
    }
}

