/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.kymographtracker;

import icy.gui.frame.IcyFrame;
import icy.plugin.abstract_.PluginActionable;
import icy.sequence.Sequence;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import plugins.tinevez.kymographtracker.ActionPanel;
import plugins.tinevez.kymographtracker.KymographExtractorPanel;
import plugins.tinevez.kymographtracker.KymographTrackerPanel;
import plugins.tinevez.kymographtracker.ResultExportPanel;
import plugins.tinevez.kymographtracker.ResultImportPanel;
import plugins.tinevez.kymographtracker.SequenceSelectionPanel;
import plugins.tinevez.kymographtracker.WorkFlowPanel;

public class KymographTracker2
extends PluginActionable {
    Sequence selectedSequence = null;
    JPanel mainPanel;
    IcyFrame mainFrame;
    JPanel centerPanel;
    ArrayList<ActionPanel> actionPanels;

    private void generateGUI() {
        this.mainPanel = new JPanel();
        this.mainFrame = new IcyFrame("Kymograph Tracker v2.1.3", true, true, false, true);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this.actionPanels = new ArrayList();
        SequenceSelectionPanel sequencePanel = new SequenceSelectionPanel(this);
        root.add(sequencePanel.node);
        this.actionPanels.add(sequencePanel);
        sequencePanel.startWorkFlowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionPanel p : KymographTracker2.this.actionPanels) {
                    if (!(p instanceof WorkFlowPanel)) continue;
                    CardLayout cl = (CardLayout)KymographTracker2.this.centerPanel.getLayout();
                    cl.show(KymographTracker2.this.centerPanel, p.description);
                }
            }
        });
        WorkFlowPanel workFlowPanel = new WorkFlowPanel();
        DefaultMutableTreeNode workFlowNode = workFlowPanel.node;
        root.add(workFlowNode);
        workFlowPanel.startWorkFlowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (ActionPanel p : KymographTracker2.this.actionPanels) {
                    if (!(p instanceof KymographExtractorPanel)) continue;
                    CardLayout cl = (CardLayout)KymographTracker2.this.centerPanel.getLayout();
                    cl.show(KymographTracker2.this.centerPanel, p.description);
                }
            }
        });
        this.actionPanels.add(workFlowPanel);
        KymographExtractorPanel extractorPanel = new KymographExtractorPanel(false);
        workFlowNode.add(extractorPanel.node);
        this.actionPanels.add(extractorPanel);
        extractorPanel.startTrackingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ActionPanel p : KymographTracker2.this.actionPanels) {
                    if (!(p instanceof KymographTrackerPanel)) continue;
                    CardLayout cl = (CardLayout)KymographTracker2.this.centerPanel.getLayout();
                    cl.show(KymographTracker2.this.centerPanel, p.description);
                }
            }
        });
        KymographTrackerPanel trackerPanel = new KymographTrackerPanel();
        workFlowNode.add(trackerPanel.node);
        this.actionPanels.add(trackerPanel);
        ResultExportPanel exportPanel = new ResultExportPanel();
        workFlowNode.add(exportPanel.node);
        this.actionPanels.add(exportPanel);
        ResultImportPanel importPanel = new ResultImportPanel();
        root.add(importPanel.node);
        this.actionPanels.add(importPanel);
        final JTree tree = new JTree(root);
        tree.setRootVisible(false);
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
        tree.getSelectionModel().setSelectionMode(1);
        tree.setOpaque(true);
        JScrollPane treeScrollPane = new JScrollPane(tree);
        this.mainPanel.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)treeScrollPane, "Center");
        this.mainPanel.add((Component)leftPanel, "West");
        this.centerPanel = new JPanel(new CardLayout());
        for (ActionPanel p : this.actionPanels) {
            this.centerPanel.add((Component)p, p.description);
        }
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                KymographTracker2.this.refreshCenterPanel(node);
            }
        });
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.refreshCenterPanel(this.actionPanels.get((int)0).node);
        this.mainFrame.setContentPane((Container)this.mainPanel);
        this.mainFrame.setPreferredSize(new Dimension(600, 500));
        this.mainFrame.pack();
        this.addIcyFrame(this.mainFrame);
        this.mainFrame.setVisible(true);
        this.changeSelectedSequence(sequencePanel.sequenceChooser.getSelectedSequence());
    }

    private void refreshCenterPanel(DefaultMutableTreeNode node) {
        CardLayout cl = (CardLayout)this.centerPanel.getLayout();
        for (ActionPanel p : this.actionPanels) {
            if (node != p.node) continue;
            cl.show(this.centerPanel, p.description);
        }
    }

    protected void changeSelectedSequence(Sequence sequence) {
        this.selectedSequence = sequence;
        for (ActionPanel p : this.actionPanels) {
            p.changeSelectedSequence(sequence);
        }
    }

    public void run() {
        this.generateGUI();
    }
}

