/*
 * Decompiled with CFR 0.152.
 */
package plugins.tinevez.rieszwavelets;

import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.preferences.ApplicationPreferences;
import icy.preferences.GeneralPreferences;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import plugins.nchenouard.isotropicwavelets.IsotropicWaveletType;
import plugins.tinevez.rieszwavelets.HarmonicTypes;
import plugins.tinevez.rieszwavelets.RieszConfig;
import plugins.tinevez.rieszwavelets.RieszGeneralization;
import plugins.tinevez.rieszwavelets.RieszWaveletCoefficients;
import plugins.tinevez.rieszwavelets.RieszWaveletConfig;
import plugins.tinevez.rieszwavelets.StandardRieszFrames;

public class KymographSeparator {
    public static Sequence[] separateKymograph(Sequence kymographSeq) {
        Sequence[] out;
        int i;
        int i2;
        int height = kymographSeq.getSizeY();
        int width = kymographSeq.getSizeX();
        boolean isRealImage = true;
        int numScales = 4;
        boolean prefilter = false;
        IsotropicWaveletType waveletType = IsotropicWaveletType.Simoncelli;
        int order = 6;
        HarmonicTypes harmonicType = HarmonicTypes.even;
        boolean prepareRieszFilters = true;
        RieszWaveletConfig config = new RieszWaveletConfig(width, height, true, 4, waveletType, false, true, 6, harmonicType, false);
        ArrayList<RieszConfig> rieszConfigList = config.getRieszConfigurations();
        ArrayList<RieszGeneralization> generalizationList = new ArrayList<RieszGeneralization>();
        for (int i3 = 0; i3 < 4; ++i3) {
            RieszGeneralization rieszGeneralization = new RieszGeneralization(StandardRieszFrames.Simoncelli, rieszConfigList.get(i3));
            generalizationList.add(rieszGeneralization);
        }
        double[] image = kymographSeq.getDataXYAsDouble(0, 0, 0);
        RieszWaveletCoefficients anteroCoefficients = config.multiscaleRieszAnalysisInFourier(image, width, height, generalizationList);
        ArrayList<double[][]> retroBands = new ArrayList<double[][]>(anteroCoefficients.getNumScales());
        for (int i4 = 0; i4 < anteroCoefficients.getNumScales(); ++i4) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i4);
            double[][] retroCoeffs = new double[anteroCoeffs.length][];
            for (int j = 0; j < anteroCoeffs.length; ++j) {
                retroCoeffs[j] = (double[])anteroCoeffs[j].clone();
            }
            retroBands.add(retroCoeffs);
        }
        double[] retroHPResidual = null;
        if (anteroCoefficients.getHPResidual() != null) {
            retroHPResidual = (double[])anteroCoefficients.getHPResidual().clone();
        }
        double[] retroLPResidual = (double[])anteroCoefficients.getLPResidual().clone();
        RieszWaveletCoefficients retroCoefficients = new RieszWaveletCoefficients(anteroCoefficients.getConfig(), generalizationList, retroBands, retroHPResidual, retroLPResidual, anteroCoefficients.getPadX(), anteroCoefficients.getPadY());
        for (int i5 = 0; i5 < retroCoefficients.getNumScales(); ++i5) {
            double[][] retroCoeffs = retroCoefficients.getRieszBandsAtScale(i5);
            for (int k = 0; k < retroCoeffs[0].length; ++k) {
                retroCoeffs[0][k] = 0.0;
            }
            for (int j = 0; j < retroCoeffs.length / 2; ++j) {
                for (int k = 0; k < retroCoeffs[j].length; ++k) {
                    retroCoeffs[j][k] = 0.0;
                }
            }
        }
        for (int k = 0; k < retroLPResidual.length; ++k) {
            retroLPResidual[k] = 0.0;
        }
        Sequence retroSeq = new Sequence();
        double[] reconstructedImage = config.multiscaleRieszSynthesisInFourier(retroCoefficients, width, height);
        double minRetro = Double.POSITIVE_INFINITY;
        for (double d : reconstructedImage) {
            if (!(d < minRetro)) continue;
            minRetro = d;
        }
        for (i2 = 0; i2 < reconstructedImage.length; ++i2) {
            double d = reconstructedImage[i2];
            reconstructedImage[i2] = d - minRetro + 1.1754943508222875E-38;
        }
        retroSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage));
        for (i2 = 0; i2 < anteroCoefficients.getNumScales(); ++i2) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i2);
            for (int k = 0; k < anteroCoeffs[0].length; ++k) {
                anteroCoeffs[0][k] = 0.0;
            }
            for (int j = anteroCoeffs.length / 2 + 1; j < anteroCoeffs.length; ++j) {
                for (int k = 0; k < anteroCoeffs[j].length; ++k) {
                    anteroCoeffs[j][k] = 0.0;
                }
            }
        }
        double[] anteroLPresidual = anteroCoefficients.getLPResidual();
        for (int k = 0; k < anteroLPresidual.length; ++k) {
            anteroLPresidual[k] = 0.0;
        }
        Sequence anteroSeq = new Sequence();
        double[] reconstructedImage2 = config.multiscaleRieszSynthesisInFourier(anteroCoefficients, width, height);
        double minAntero = Double.POSITIVE_INFINITY;
        for (double d : reconstructedImage2) {
            if (!(d < minAntero)) continue;
            minAntero = d;
        }
        for (i = 0; i < reconstructedImage2.length; ++i) {
            double d = reconstructedImage2[i];
            reconstructedImage2[i] = d - minAntero + 1.1754943508222875E-38;
        }
        anteroSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage2));
        for (i = 0; i < anteroCoefficients.getNumScales(); ++i) {
            double[][] anteroCoeffs = anteroCoefficients.getRieszBandsAtScale(i);
            double[][] retroCoeffs = retroCoefficients.getRieszBandsAtScale(i);
            for (int j = anteroCoeffs.length / 2; j < anteroCoeffs.length; ++j) {
                for (int k = 0; k < anteroCoeffs[j].length; ++k) {
                    anteroCoeffs[j][k] = retroCoeffs[j][k];
                }
            }
        }
        Sequence filteredSeq = new Sequence();
        double[] reconstructedImage3 = config.multiscaleRieszSynthesisInFourier(anteroCoefficients, width, height);
        filteredSeq.addImage(0, (BufferedImage)new IcyBufferedImage(width, height, (Object)reconstructedImage3));
        for (Sequence sequence : out = new Sequence[]{filteredSeq, anteroSeq, retroSeq}) {
            sequence.setPixelSizeX(kymographSeq.getPixelSizeX());
            sequence.setPixelSizeY(kymographSeq.getPixelSizeY());
            sequence.setTimeInterval(kymographSeq.getTimeInterval());
        }
        return out;
    }

    public static void main(String[] args) throws UnsupportedFormatException, IOException {
        ApplicationPreferences.load();
        GeneralPreferences.load();
        GeneralPreferences.setAutomaticUpdate((boolean)false);
        Icy.main((String[])new String[]{"--nosplash", "--disableJCL"});
        File file = new File("samples/Path_1_kymograph.tif");
        IcyBufferedImage colorImage = Loader.loadImage((String)file.getAbsolutePath());
        IcyBufferedImage image = colorImage.getImage(0);
        final Sequence seq = new Sequence("source", image);
        final Sequence[] sequences = KymographSeparator.separateKymograph(seq);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Viewer(seq);
                for (Sequence sequence : sequences) {
                    new Viewer(sequence);
                }
            }
        });
    }
}

