/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.detector;

import icy.gui.dialog.MessageDialog;
import icy.image.IcyBufferedImage;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3i;
import plugins.adufour.connectedcomponents.ConnectedComponent;
import plugins.adufour.connectedcomponents.ConnectedComponents;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.Point3D;
import plugins.fab.spotDetector.detector.UDWTScale;
import plugins.fab.spotDetector.detector.wavelets.UDWT.B3SplineUDWT;
import plugins.fab.spotDetector.detector.wavelets.UDWT.WaveletConfigException;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class UDWTWaveletCore {
    ArrayList<UDWTScale> UDWTScaleArrayList = null;
    Sequence binarySequence;

    int getNumberOfMaxEnabledScale() {
        int maxScale = 0;
        for (UDWTScale scale : this.UDWTScaleArrayList) {
            if (!scale.isEnabled() || scale.scaleNumber <= maxScale) continue;
            maxScale = scale.scaleNumber;
        }
        return maxScale;
    }

    private int getNumberOfScale() {
        return this.UDWTScaleArrayList.size();
    }

    private double getScaleThreshold(int scale) {
        return this.UDWTScaleArrayList.get(scale).getThreshold();
    }

    private boolean isScaleEnabled(int scale) {
        return this.UDWTScaleArrayList.get(scale).isEnabled();
    }

    private void addConnectedComponentDetection(Sequence binarySequence, ArrayList<DetectionSpot> detectionList, int t, Sequence originalSequence) {
        Map result = ConnectedComponents.extractConnectedComponents((Sequence)binarySequence, (double)0.0, (ConnectedComponents.ExtractionType)ConnectedComponents.ExtractionType.BACKGROUND, (int)0, (int)Integer.MAX_VALUE, null);
        detectionList.addAll(this.convert2detectionList(originalSequence, result, t));
    }

    public Sequence getBinarySequence() {
        return this.binarySequence;
    }

    public ArrayList<DetectionSpot> computeDetection(boolean computeBinaryDetection, ArrayList<UDWTScale> UDWTScaleArrayList, Sequence sequenceIn, boolean detectNegative, boolean useROIforWATcomputation) {
        return this.computeDetection(computeBinaryDetection, UDWTScaleArrayList, sequenceIn, detectNegative, useROIforWATcomputation, false);
    }

    public ArrayList<DetectionSpot> computeDetection(boolean computeBinaryDetection, ArrayList<UDWTScale> UDWTScaleArrayList, Sequence sequenceIn, boolean detectNegative, boolean useROIforWATcomputation, boolean force2DWaveletsFor3D) {
        int t;
        this.UDWTScaleArrayList = UDWTScaleArrayList;
        ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
        int numScales = this.getNumberOfMaxEnabledScale();
        Sequence inputSequence = sequenceIn;
        if (inputSequence == null) {
            return detectionList;
        }
        if (inputSequence.getAllImage().size() == 0) {
            return detectionList;
        }
        this.binarySequence = new Sequence();
        this.binarySequence.setName("Binary Sequence");
        ArrayList<ROI> rois = new ArrayList<ROI>();
        Rectangle bounds = sequenceIn.getBounds2D();
        if (useROIforWATcomputation) {
            rois.addAll(sequenceIn.getROIs());
            if (rois.isEmpty()) {
                rois.add((ROI)new ROI2DRectangle((Rectangle2D)bounds));
            }
        }
        if (inputSequence.getSizeZ() == 1) {
            B3SplineUDWT waveletTransform = new B3SplineUDWT();
            if (!waveletTransform.isNumberOfScaleOkForImage2D(inputSequence.getSizeX(), inputSequence.getSizeY(), this.getNumberOfMaxEnabledScale())) {
                System.err.println("Scale configuration error");
                return detectionList;
            }
            for (t = 0; t < sequenceIn.getSizeT(); ++t) {
                float[][] scales;
                IcyBufferedImage image = inputSequence.getImage(t, 0);
                if (image == null) continue;
                boolean[] mask = this.buildBinaryMask(bounds, rois, t, 0);
                float[] dataIn = Array1DUtil.arrayToFloatArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                B3SplineUDWT waveletTransform2 = new B3SplineUDWT();
                try {
                    scales = waveletTransform2.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(), numScales);
                }
                catch (WaveletConfigException e1) {
                    e1.printStackTrace();
                    return detectionList;
                }
                float[][] coefficients = waveletTransform2.b3WaveletCoefficients2D(scales, dataIn, numScales, image.getWidth() * image.getHeight());
                Sequence resultSequence = new Sequence();
                resultSequence.setName("WaveletCoefficients");
                for (int i = 0; i < coefficients.length - 1; ++i) {
                    if (detectNegative) {
                        for (int ii = 0; ii < coefficients[i].length; ++ii) {
                            coefficients[i][ii] = -coefficients[i][ii];
                        }
                    }
                    this.filter_wat(coefficients[i], i, inputSequence.getWidth(), inputSequence.getHeight(), mask);
                }
                float[] c = coefficients[coefficients.length - 1];
                for (int i = 0; i < c.length; ++i) {
                    c[i] = 0.0f;
                }
                resultSequence.dataChanged();
                IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, 0);
                float[] binaryDetectionResult = new float[image.getWidth() * image.getHeight()];
                waveletTransform2.b3SpotConstruction2D(coefficients, binaryDetectionResult, numScales, image.getWidth() * image.getHeight(), UDWTScaleArrayList);
                for (int i = 0; i < binaryDetectionResult.length; ++i) {
                    binaryDetectionResult[i] = binaryDetectionResult[i] != 0.0f ? 255.0f : 0.0f;
                }
                ArrayUtil.arrayToArray((Object)binaryDetectionResult, (Object)imageOut.getDataXY(0), (boolean)image.isSignedDataType());
                Sequence binarySequenceForConnectedComponentExtraction = new Sequence();
                binarySequenceForConnectedComponentExtraction.setImage(0, 0, (BufferedImage)imageOut);
                this.addConnectedComponentDetection(binarySequenceForConnectedComponentExtraction, detectionList, t, inputSequence);
                if (!computeBinaryDetection) continue;
                this.binarySequence.setImage(t, 0, (BufferedImage)imageOut);
            }
        }
        if (inputSequence.getSizeZ() > 1 && force2DWaveletsFor3D) {
            System.out.println("Entering force 2D wavelet for 3D");
            B3SplineUDWT waveletTransform = new B3SplineUDWT();
            if (!waveletTransform.isNumberOfScaleOkForImage2D(inputSequence.getSizeX(), inputSequence.getSizeY(), this.getNumberOfMaxEnabledScale())) {
                System.err.println("Scale configuration error (your image is too small for this scale)");
                return detectionList;
            }
            for (t = 0; t < sequenceIn.getSizeT(); ++t) {
                Sequence binary3DOutput = new Sequence();
                for (int z = 0; z < sequenceIn.getSizeZ(); ++z) {
                    float[][] scales;
                    boolean[] mask = this.buildBinaryMask(bounds, rois, t, z);
                    IcyBufferedImage image = inputSequence.getImage(t, z);
                    float[] dataIn = Array1DUtil.arrayToFloatArray((Object)image.getDataXY(0), (boolean)image.isSignedDataType());
                    B3SplineUDWT waveletTransform3 = new B3SplineUDWT();
                    try {
                        scales = waveletTransform3.b3WaveletScales2D(dataIn, image.getWidth(), image.getHeight(), numScales);
                    }
                    catch (WaveletConfigException e1) {
                        e1.printStackTrace();
                        return detectionList;
                    }
                    float[][] coefficients = waveletTransform3.b3WaveletCoefficients2D(scales, dataIn, numScales, image.getWidth() * image.getHeight());
                    Sequence resultSequence = new Sequence();
                    resultSequence.setName("WaveletCoefficients");
                    for (int i = 0; i < coefficients.length - 1; ++i) {
                        if (detectNegative) {
                            for (int ii = 0; ii < coefficients[i].length; ++ii) {
                                coefficients[i][ii] = -coefficients[i][ii];
                            }
                        }
                        this.filter_wat(coefficients[i], i, inputSequence.getWidth(), inputSequence.getHeight(), mask);
                    }
                    float[] c = coefficients[coefficients.length - 1];
                    for (int i = 0; i < c.length; ++i) {
                        c[i] = 0.0f;
                    }
                    resultSequence.dataChanged();
                    IcyBufferedImage imageOut = new IcyBufferedImage(image.getWidth(), image.getHeight(), 1, 0);
                    float[] binaryDetectionResult = new float[image.getWidth() * image.getHeight()];
                    waveletTransform3.b3SpotConstruction2D(coefficients, binaryDetectionResult, numScales, image.getWidth() * image.getHeight(), UDWTScaleArrayList);
                    for (int i = 0; i < binaryDetectionResult.length; ++i) {
                        binaryDetectionResult[i] = binaryDetectionResult[i] != 0.0f ? 255.0f : 0.0f;
                    }
                    ArrayUtil.arrayToArray((Object)binaryDetectionResult, (Object)imageOut.getDataXY(0), (boolean)image.isSignedDataType());
                    binary3DOutput.setImage(0, z, (BufferedImage)imageOut);
                    if (!computeBinaryDetection) continue;
                    this.binarySequence.setImage(t, z, (BufferedImage)imageOut);
                }
                this.addConnectedComponentDetection(binary3DOutput, detectionList, t, inputSequence);
            }
        }
        if (inputSequence.getSizeZ() > 1 && !force2DWaveletsFor3D) {
            B3SplineUDWT waveletTransform = new B3SplineUDWT();
            if (!waveletTransform.isNumberOfScaleOkForImage3D(inputSequence.getSizeX(), inputSequence.getSizeY(), inputSequence.getSizeZ(), this.getNumberOfMaxEnabledScale())) {
                int scale2 = waveletTransform.getMinSize(2);
                int scale3 = waveletTransform.getMinSize(3);
                int scale4 = waveletTransform.getMinSize(4);
                MessageDialog.showDialog((String)("<html><center>There is a problem with the scale configuration (but don't worry, read this):<br><br>To run in 3D, the wavelet algorithm needs a number of slices depending on the scale(s) you enabled:<br><br>Scale 2 : " + scale2 + " slices<br>Scale 3 : " + scale3 + " slices<br>Scale 4 : " + scale4 + " slices<br><br>To use those parameters you need more Z in your stack.<br>Still, you can bypass this problem by selecting<br>the option <b>Force use of 2D Wavelets for 3D</b> in the detector panel<br>In this case, each 2D slices will be computed separately and results will be merged to create the resulting stack,<br>(and you don't need to add more Z slices),<br>The sequence file name is: " + inputSequence.getFilename() + "</center></html>"), (int)2);
                return detectionList;
            }
            for (int t2 = 0; t2 < sequenceIn.getSizeT(); ++t2) {
                int z;
                float[][][] scales;
                float[][] dataIn = new float[inputSequence.getSizeZ()][];
                for (int z2 = 0; z2 < inputSequence.getSizeZ(); ++z2) {
                    dataIn[z2] = Array1DUtil.arrayToFloatArray((Object)inputSequence.getDataXY(t2, z2, 0), (boolean)inputSequence.isSignedDataType());
                }
                B3SplineUDWT waveletTransform4 = new B3SplineUDWT();
                try {
                    scales = waveletTransform4.b3WaveletScales3D(dataIn, inputSequence.getSizeX(), inputSequence.getSizeY(), inputSequence.getSizeZ(), numScales);
                }
                catch (WaveletConfigException e1) {
                    e1.printStackTrace();
                    return detectionList;
                }
                float[][][] coefficients = waveletTransform4.b3WaveletCoefficients3D(scales, dataIn, numScales, inputSequence.getSizeX() * inputSequence.getSizeY(), inputSequence.getSizeZ());
                boolean[][] masks = new boolean[inputSequence.getSizeZ()][];
                for (int z3 = 0; z3 < masks.length; ++z3) {
                    masks[z3] = this.buildBinaryMask(bounds, rois, t2, z3);
                }
                for (int scale = 0; scale < coefficients.length - 1; ++scale) {
                    for (int z4 = 0; z4 < coefficients[scale].length; ++z4) {
                        if (detectNegative) {
                            for (int ii = 0; ii < coefficients[scale][z4].length; ++ii) {
                                coefficients[scale][z4][ii] = -coefficients[scale][z4][ii];
                            }
                        }
                        this.filter_wat(coefficients[scale][z4], scale, inputSequence.getWidth(), inputSequence.getHeight(), masks[z4]);
                    }
                }
                float[][] c = coefficients[coefficients.length - 1];
                for (z = 0; z < c.length; ++z) {
                    for (int i = 0; i < c[z].length; ++i) {
                        c[z][i] = 0.0f;
                    }
                }
                float[][] reconstruction = new float[inputSequence.getSizeZ()][inputSequence.getSizeX() * inputSequence.getSizeY()];
                waveletTransform4.b3SpotConstruction3D(coefficients, reconstruction, numScales, inputSequence.getSizeX() * inputSequence.getSizeY(), inputSequence.getSizeZ(), UDWTScaleArrayList);
                for (z = 0; z < reconstruction.length; ++z) {
                    for (int i = 0; i < reconstruction[z].length; ++i) {
                        reconstruction[z][i] = reconstruction[z][i] != 0.0f ? 255.0f : 0.0f;
                    }
                }
                VolumetricImage vOut = new VolumetricImage();
                for (int z5 = 0; z5 < inputSequence.getSizeZ(); ++z5) {
                    IcyBufferedImage imageOut = new IcyBufferedImage(inputSequence.getSizeX(), inputSequence.getSizeY(), 1, 0);
                    ArrayUtil.arrayToArray((Object)reconstruction[z5], (Object)imageOut.getDataXY(0), (boolean)true);
                    vOut.setImage(z5, imageOut);
                }
                Sequence binarySequenceForConnectedComponentExtraction = new Sequence();
                binarySequenceForConnectedComponentExtraction.addVolumetricImage(0, vOut);
                this.addConnectedComponentDetection(binarySequenceForConnectedComponentExtraction, detectionList, t2, inputSequence);
                if (!computeBinaryDetection) continue;
                this.binarySequence.addVolumetricImage(t2, vOut);
            }
        }
        this.binarySequence.dataChanged();
        if (computeBinaryDetection) {
            // empty if block
        }
        return detectionList;
    }

    private boolean[] buildBinaryMask(Rectangle bounds, List<ROI> rois, int t, int z) {
        if (rois.isEmpty()) {
            return null;
        }
        BooleanMask2D result = new BooleanMask2D(bounds, new boolean[bounds.width * bounds.height]);
        for (ROI roi : rois) {
            result.add(roi.getBooleanMask2D(z, t, -1, true));
        }
        return result.mask;
    }

    private void filter_wat(float[] data, int depth, int width, int height, boolean[] mask) {
        if (!this.isScaleEnabled(depth)) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0.0f;
            }
            return;
        }
        double[] lambdac = new double[this.getNumberOfScale() + 2];
        for (int i = 0; i < this.getNumberOfScale() + 2; ++i) {
            lambdac[i] = Math.sqrt(2.0 * Math.log(width * height / (1 << 2 * i)));
        }
        ImageMathInfo imageCaract = this.avesigma(data, mask);
        double[] dcoeff = new double[this.getNumberOfMaxEnabledScale()];
        for (int i = 0; i < this.getNumberOfMaxEnabledScale(); ++i) {
            dcoeff[i] = this.getScaleThreshold(i) / 100.0;
        }
        double coeffThr = lambdac[depth + 1] * imageCaract.mad / dcoeff[depth];
        for (int i = 0; i < data.length; ++i) {
            if ((double)data[i] >= coeffThr) continue;
            data[i] = 0.0f;
        }
    }

    private ImageMathInfo avesigma(float[] image, boolean[] mask) {
        ImageMathInfo ic = new ImageMathInfo();
        ic.mad = this.getMeanAverageDistance(image, mask);
        return ic;
    }

    private float getMeanAverageDistance(float[] data, boolean[] mask) {
        float mean = this.getMean(data, mask);
        float a = 0.0f;
        if (mask == null) {
            for (int i = 0; i < data.length; ++i) {
                float s = data[i] - mean;
                a += Math.abs(s);
            }
            if (data.length > 0) {
                return a / (float)data.length;
            }
        } else {
            float nbValue = 0.0f;
            for (int i = 0; i < data.length; ++i) {
                if (!mask[i]) continue;
                float s = data[i] - mean;
                a += Math.abs(s);
                nbValue += 1.0f;
            }
            if (nbValue > 0.0f) {
                return a / nbValue;
            }
        }
        return 0.0f;
    }

    private float getVar(float[] data) {
        if (data.length <= 1) {
            return 0.0f;
        }
        float sum = 0.0f;
        float sum2 = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            float val = data[i];
            sum2 += val * val;
            sum += val;
        }
        return (sum2 - sum * sum / (float)data.length) / (float)(data.length - 1);
    }

    private float getMean(float[] data, boolean[] mask) {
        float mean = 0.0f;
        float sum = 0.0f;
        if (mask == null) {
            for (int i = 0; i < data.length; ++i) {
                sum += data[i];
            }
            if (data.length > 0) {
                mean = sum / (float)data.length;
            }
        } else {
            float nbValue = 0.0f;
            for (int i = 0; i < data.length; ++i) {
                if (!mask[i]) continue;
                sum += data[i];
                nbValue += 1.0f;
            }
            if (nbValue > 0.0f) {
                mean = sum / nbValue;
            }
        }
        return mean;
    }

    private ArrayList<DetectionSpot> convert2detectionList(Sequence originalSequence, Map<Integer, List<ConnectedComponent>> result, int t) {
        ArrayList<DetectionSpot> detectionList = new ArrayList<DetectionSpot>();
        for (int i : result.keySet()) {
            List<ConnectedComponent> list = result.get(i);
            for (ConnectedComponent cc : list) {
                DetectionSpot detection = new DetectionSpot();
                for (Point3i point : cc.getPoints()) {
                    detection.points.add(new Point3D(point.x, point.y, point.z));
                }
                detection.setT(t);
                detection.computeMassCenter();
                this.computeMinMeanMaxIntensity(detection, originalSequence);
                detectionList.add(detection);
            }
        }
        return detectionList;
    }

    private void computeMinMeanMaxIntensity(DetectionSpot detection, Sequence originalSequence) {
        double minIntensity = Double.MAX_VALUE;
        double maxIntensity = Double.MIN_VALUE;
        double sumIntensity = 0.0;
        for (Point3D point : detection.points) {
            IcyBufferedImage image = originalSequence.getImage(detection.getT(), (int)point.z);
            double value = image.getData((int)point.x, (int)point.y, 0);
            if (value < minIntensity) {
                minIntensity = value;
            }
            if (value > maxIntensity) {
                maxIntensity = value;
            }
            sumIntensity += value;
        }
        detection.maxIntensity = maxIntensity;
        detection.minIntensity = minIntensity;
        double averageIntensity = 0.0;
        if (detection.points.size() > 0) {
            averageIntensity = sumIntensity / (double)detection.points.size();
        }
        detection.meanIntensity = averageIntensity;
    }

    private class ImageMathInfo {
        double mad;

        private ImageMathInfo() {
        }
    }
}

