/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.filtering;

import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.roi.ROI;
import icy.util.XLSUtil;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.filtering.FilteringDetectionAbstract;

public class SizeFiltering
extends FilteringDetectionAbstract {
    JTextField minValueTextField = new JTextField("0");
    JTextField maxValueTextField = new JTextField("3000");

    public SizeFiltering() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        ComponentUtil.setFixedHeight((Component)this.minValueTextField, (int)22);
        ComponentUtil.setFixedHeight((Component)this.maxValueTextField, (int)22);
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Range of accepted objects (in pixels)")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Min size: "), this.minValueTextField}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Max size: "), this.maxValueTextField}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(50)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        for (ROI roi : gdt.roi2detection.keySet()) {
            ArrayList<DetectionSpot> detection = gdt.roi2detection.get(roi);
            ArrayList<DetectionSpot> detectionCopy = new ArrayList<DetectionSpot>(detection);
            int highValue = Integer.parseInt(this.maxValueTextField.getText());
            int lowValue = Integer.parseInt(this.minValueTextField.getText());
            for (DetectionSpot detectionSpot : detectionCopy) {
                if (detectionSpot.points.size() <= highValue && detectionSpot.points.size() >= lowValue) continue;
                detection.remove(detectionSpot);
            }
        }
        ArrayList<DetectionSpot> detection = gdt.detectionResult;
        ArrayList<DetectionSpot> detectionCopy = new ArrayList<DetectionSpot>(detection);
        int highValue = Integer.parseInt(this.maxValueTextField.getText());
        int lowValue = Integer.parseInt(this.minValueTextField.getText());
        for (DetectionSpot detectionSpot : detectionCopy) {
            if (detectionSpot.points.size() <= highValue && detectionSpot.points.size() >= lowValue) continue;
            detection.remove(detectionSpot);
        }
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
        int row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Filtering: Simple Filtering");
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)(++row), (String)"Detection Size range:");
        XLSUtil.setCellString((WritableSheet)page, (int)1, (int)row, (String)"Min:");
        XLSUtil.setCellNumber((WritableSheet)page, (int)2, (int)row, (double)Integer.parseInt(this.minValueTextField.getText()));
        XLSUtil.setCellString((WritableSheet)page, (int)3, (int)row, (String)"Max:");
        XLSUtil.setCellNumber((WritableSheet)page, (int)4, (int)row, (double)Integer.parseInt(this.maxValueTextField.getText()));
    }
}

