/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.packrect;

import com.jogamp.opengl.util.packrect.BackingStoreManager;
import com.jogamp.opengl.util.packrect.Level;
import com.jogamp.opengl.util.packrect.Rect;
import com.jogamp.opengl.util.packrect.RectVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LevelSet {
    private List<Level> levels = new ArrayList<Level>();
    private int nextAddY;
    private int w;
    private int h;

    public LevelSet(int n, int n2) {
        this.w = n;
        this.h = n2;
    }

    public int w() {
        return this.w;
    }

    public int h() {
        return this.h;
    }

    public boolean add(Rect rect) {
        Level level;
        int n;
        if (rect.w() > this.w) {
            return false;
        }
        for (n = this.levels.size() - 1; n >= 0; --n) {
            level = this.levels.get(n);
            if (!level.add(rect)) continue;
            return true;
        }
        for (n = this.levels.size() - 1; n >= 0; --n) {
            level = this.levels.get(n);
            if (!level.couldAllocateIfCompacted(rect)) continue;
            return false;
        }
        if (this.nextAddY + rect.h() > this.h) {
            return false;
        }
        Level level2 = new Level(this.w, rect.h(), this.nextAddY, this);
        this.levels.add(level2);
        this.nextAddY += rect.h();
        boolean bl = level2.add(rect);
        if (!bl) {
            throw new RuntimeException("Unexpected failure in addition to new Level");
        }
        return true;
    }

    public boolean remove(Rect rect) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            Level level = this.levels.get(i);
            if (!level.remove(rect)) continue;
            return true;
        }
        return false;
    }

    public boolean compactAndAdd(Rect rect, Object object, BackingStoreManager backingStoreManager) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            Level level = this.levels.get(i);
            if (!level.couldAllocateIfCompacted(rect)) continue;
            level.compact(object, backingStoreManager);
            boolean bl = level.add(rect);
            if (!bl) {
                throw new RuntimeException("Unexpected failure to add after compaction");
            }
            return true;
        }
        return false;
    }

    public boolean canExpand(Level level, int n) {
        if (this.levels.isEmpty()) {
            return false;
        }
        return this.levels.get(this.levels.size() - 1) == level && this.h - this.nextAddY >= n - level.h();
    }

    public void expand(Level level, int n, int n2) {
        this.nextAddY += n2 - n;
    }

    public int getUsedHeight() {
        return this.nextAddY;
    }

    public void setHeight(int n) throws IllegalArgumentException {
        if (n < this.getUsedHeight()) {
            throw new IllegalArgumentException("May not reduce height below currently used height");
        }
        this.h = n;
    }

    public float verticalFragmentationRatio() {
        int n = 0;
        int n2 = this.getUsedHeight();
        if (n2 == 0) {
            return 0.0f;
        }
        Iterator<Level> iterator = this.iterator();
        while (iterator.hasNext()) {
            Level level = iterator.next();
            if (!level.isEmpty()) continue;
            n += level.h();
        }
        return (float)n / (float)n2;
    }

    public Iterator<Level> iterator() {
        return this.levels.iterator();
    }

    public void visit(RectVisitor rectVisitor) {
        for (Level level : this.levels) {
            level.visit(rectVisitor);
        }
    }

    public void updateRectangleReferences() {
        for (Level level : this.levels) {
            level.updateRectangleReferences();
        }
    }

    public void clear() {
        this.levels.clear();
        this.nextAddY = 0;
    }
}

