/*
 * Decompiled with CFR 0.152.
 */
package plugins.spop.medianfilter;

import icy.image.IcyBufferedImage;
import icy.math.ArrayMath;
import icy.sequence.Sequence;
import icy.system.IcyHandledException;
import icy.type.collection.array.Array1DUtil;
import icy.util.OMEUtil;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import ome.xml.meta.MetadataRetrieve;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarInteger;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.adufour.vars.lang.Var;

public class MedianFilter
extends EzPlug
implements Block,
EzStoppable {
    EzVarSequence input = new EzVarSequence("Input");
    EzVarText type_2D = new EzVarText("Type", new String[]{"2D", "3D"}, 0, Boolean.valueOf(false));
    EzVarInteger size = new EzVarInteger("Half Size", 2, 1, 30, 1);
    EzVarSequence output = new EzVarSequence("Output");

    public void initialize() {
        super.addEzComponent((EzComponent)this.input);
        super.addEzComponent((EzComponent)this.type_2D);
        super.addEzComponent((EzComponent)this.size);
        super.setTimeDisplay(true);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add(this.input.name, (Var)this.input.getVariable());
        inputMap.add(this.type_2D.name, this.type_2D.getVariable());
        inputMap.add(this.size.name, this.size.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add(this.output.name, (Var)this.output.getVariable());
    }

    public void execute() {
        Sequence sequence = (Sequence)this.input.getValue(true);
        int dim_window = (Integer)this.size.getValue();
        try {
            if (((String)this.type_2D.getValue()).equalsIgnoreCase("2D")) {
                this.Median_filter_2D(sequence, dim_window);
            } else {
                this.Median_filter_3D(sequence, dim_window);
            }
        }
        catch (Exception e) {
            throw new IcyHandledException((Throwable)e);
        }
    }

    public void Median_filter_2D(Sequence sequence, int lx) throws InterruptedException {
        int no_elem = (2 * lx + 1) * (2 * lx + 1);
        double[] tab_elem = new double[no_elem];
        Sequence seq_out = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequence.getOMEXMLMetadata()));
        int dim_x = sequence.getSizeX();
        int dim_y = sequence.getSizeY();
        int dim_z = sequence.getSizeZ();
        int dim_t = sequence.getSizeT();
        int dim_c = sequence.getSizeC();
        seq_out.beginUpdate();
        for (int time_slice = 0; time_slice < dim_t; ++time_slice) {
            for (int z = 0; z < dim_z; ++z) {
                IcyBufferedImage icy_img = new IcyBufferedImage(dim_x, dim_y, sequence.getColorModel());
                for (int c = 0; c < dim_c; ++c) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Object sequenceDataXY = sequence.getDataXY(time_slice, z, c);
                    double[] tab = Array1DUtil.arrayToDoubleArray((Object)sequenceDataXY, (boolean)false);
                    double[] tab_out = Arrays.copyOf(tab, tab.length);
                    for (int x = lx; x < dim_x - lx; ++x) {
                        for (int y = lx; y < dim_y - lx; ++y) {
                            int i = 0;
                            int temp = y * dim_x + x;
                            for (int xl = -lx; xl <= lx; ++xl) {
                                for (int yl = -lx; yl <= lx; ++yl) {
                                    tab_elem[i] = tab[temp + yl * dim_x + xl];
                                    ++i;
                                }
                            }
                            tab_out[temp] = ArrayMath.median((double[])tab_elem, (boolean)false);
                        }
                    }
                    Array1DUtil.doubleArrayToSafeArray((double[])tab_out, (Object)icy_img.getDataXY(c), (boolean)icy_img.isSignedDataType());
                }
                seq_out.setImage(time_slice, z, (BufferedImage)icy_img);
            }
        }
        seq_out.endUpdate();
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            seq_out.setChannelName(c, sequence.getChannelName(c));
            seq_out.setDefaultColormap(c, sequence.getDefaultColorMap(c), true);
            seq_out.setColormap(c, sequence.getColorMap(c));
        }
        seq_out.setName(seq_out.getName() + "_Median2D(" + lx + ")");
        if (this.getUI() != null) {
            this.addSequence(seq_out);
        }
        this.output.setValue(seq_out);
    }

    public void Median_filter_3D(Sequence sequence, int lx) throws InterruptedException {
        int no_elem = (2 * lx + 1) * (2 * lx + 1) * (2 * lx + 1);
        double[] tab_elem = new double[no_elem];
        double[] tab_elem_2D = new double[(2 * lx + 1) * (2 * lx + 1)];
        Sequence seq_out = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequence.getOMEXMLMetadata()));
        int dim_x = sequence.getSizeX();
        int dim_y = sequence.getSizeY();
        int dim_z = sequence.getSizeZ();
        int dim_t = sequence.getSizeT();
        int dim_c = sequence.getSizeC();
        double[][] tab = new double[dim_z][];
        double[][] tab_out = new double[dim_z][dim_x * dim_y];
        seq_out.beginUpdate();
        for (int time_slice = 0; time_slice < dim_t; ++time_slice) {
            int z;
            IcyBufferedImage[] icy_img = new IcyBufferedImage[dim_z];
            for (z = 0; z < dim_z; ++z) {
                icy_img[z] = new IcyBufferedImage(dim_x, dim_y, sequence.getColorModel());
            }
            for (int c = 0; c < dim_c; ++c) {
                int z2;
                for (z2 = 0; z2 < dim_z; ++z2) {
                    tab[z2] = Array1DUtil.arrayToDoubleArray((Object)sequence.getDataXY(time_slice, z2, c), (boolean)false);
                    tab_out[z2] = Arrays.copyOf(tab[z2], tab[z2].length);
                }
                for (z2 = 0; z2 < dim_z; ++z2) {
                    int temp;
                    int i;
                    int y;
                    int x;
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    if (z2 < lx || z2 >= dim_z - lx) {
                        for (x = lx; x < dim_x - lx; ++x) {
                            for (y = lx; y < dim_y - lx; ++y) {
                                i = 0;
                                temp = y * dim_x + x;
                                for (int xl = -lx; xl <= lx; ++xl) {
                                    for (int yl = -lx; yl <= lx; ++yl) {
                                        tab_elem_2D[i] = tab[z2][temp + yl * dim_x + xl];
                                        ++i;
                                    }
                                }
                                tab_out[z2][temp] = ArrayMath.median((double[])tab_elem_2D, (boolean)false);
                            }
                        }
                        continue;
                    }
                    for (x = lx; x < dim_x - lx; ++x) {
                        for (y = lx; y < dim_y - lx; ++y) {
                            i = 0;
                            temp = y * dim_x + x;
                            for (int zl = -lx; zl <= lx; ++zl) {
                                for (int xl = -lx; xl <= lx; ++xl) {
                                    for (int yl = -lx; yl <= lx; ++yl) {
                                        tab_elem[i] = tab[z2 + zl][temp + yl * dim_x + xl];
                                        ++i;
                                    }
                                }
                            }
                            tab_out[z2][temp] = ArrayMath.median((double[])tab_elem, (boolean)false);
                        }
                    }
                }
                for (z2 = 0; z2 < dim_z; ++z2) {
                    Array1DUtil.doubleArrayToSafeArray((double[])tab_out[z2], (Object)icy_img[z2].getDataXY(c), (boolean)icy_img[z2].isSignedDataType());
                }
                System.gc();
            }
            for (z = 0; z < dim_z; ++z) {
                seq_out.setImage(time_slice, z, (BufferedImage)icy_img[z]);
            }
        }
        seq_out.endUpdate();
        for (int c = 0; c < sequence.getSizeC(); ++c) {
            seq_out.setChannelName(c, sequence.getChannelName(c));
            seq_out.setDefaultColormap(c, sequence.getDefaultColorMap(c), true);
            seq_out.setColormap(c, sequence.getColorMap(c));
        }
        seq_out.setName(sequence.getName() + "_Median3D(" + lx + ")");
        if (this.getUI() != null) {
            this.addSequence(seq_out);
        }
        this.output.setValue(seq_out);
    }

    public void clean() {
    }
}

