/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.lang.reflect.Field;

class HDF5CompoundMemberByteifyerBooleanFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    HDF5CompoundMemberByteifyerBooleanFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        if (memberInfoOrNull != null) {
            HDF5DataClass dataClass = memberInfoOrNull.getType().getDataClass();
            return clazz == Boolean.TYPE && (dataClass == HDF5DataClass.BOOLEAN || dataClass == HDF5DataClass.INTEGER);
        }
        return clazz == Boolean.TYPE;
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType enumTypeOrNull, Class<?> memberClazz, int index, int offset, int memOffset, HDF5ValueObjectByteifyer.IFileAccessProvider fileInfoProvider) {
        String memberName = member.getMemberName();
        int memberTypeId = member.getStorageDataTypeId();
        int booleanDataTypeId = memberTypeId < 0 ? fileInfoProvider.getBooleanDataTypeId() : memberTypeId;
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, offset, memOffset, booleanDataTypeId, member.tryGetTypeVariant());
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, memOffset, booleanDataTypeId, member.tryGetTypeVariant());
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, memOffset, booleanDataTypeId, member.tryGetTypeVariant());
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, memOffset, booleanDataTypeId, member.tryGetTypeVariant());
            }
        }
        throw new Error("Unknown access type");
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, String memberName, int offset, int memOffset, final int booleanDataTypeId, HDF5DataTypeVariant typeVariant) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5MemberByteifyer(field, memberName, 1, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 1;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return booleanDataTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                return HDFNativeData.byteToByte((byte)(field.getBoolean(obj) ? 1 : 0));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                boolean value = byteArr[arrayOffset + this.offsetInMemory] != 0;
                field.setBoolean(obj, value);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, int memOffset, final int booleanDataTypeId, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 1, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 1;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return booleanDataTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                return HDFNativeData.byteToByte((byte)((Boolean)HDF5CompoundByteifyerFactory.getMap(obj, memberName) != false ? 1 : 0));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                boolean value = byteArr[arrayOffset + this.offsetInMemory] != 0;
                HDF5CompoundByteifyerFactory.putMap(obj, memberName, value);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(String memberName, final int index, int offset, int memOffset, final int booleanDataTypeId, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 1, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 1;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return booleanDataTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                return HDFNativeData.byteToByte((byte)((Boolean)HDF5CompoundByteifyerFactory.getList(obj, index) != false ? 1 : 0));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                boolean value = byteArr[arrayOffset + this.offsetInMemory] != 0;
                HDF5CompoundByteifyerFactory.setList(obj, index, value);
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(String memberName, final int index, int offset, int memOffset, final int booleanDataTypeId, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 1, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 1;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return booleanDataTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                return HDFNativeData.byteToByte((byte)((Boolean)HDF5CompoundByteifyerFactory.getArray(obj, index) != false ? 1 : 0));
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                boolean value = byteArr[arrayOffset + this.offsetInMemory] != 0;
                HDF5CompoundByteifyerFactory.setArray(obj, index, value);
            }
        };
    }
}

