/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.TargaRLECodec;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class TargaReader
extends FormatReader {
    private byte[][] colorMap;
    private long offset;
    private boolean compressed;
    private int orientation;
    private int bits;

    public TargaReader() {
        super("Truevision Targa", "tga");
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.isRGB() ? null : this.colorMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.offset);
        int planeSize = FormatTools.getPlaneSize(this);
        TargaRLECodec codec = new TargaRLECodec();
        CodecOptions options = new CodecOptions();
        options.maxBytes = planeSize;
        options.bitsPerSample = this.bits;
        RandomAccessInputStream s2 = this.in;
        if (this.compressed) {
            byte[] b = codec.decompress(this.in, options);
            s2 = new RandomAccessInputStream(b);
            s2.order(this.isLittleEndian());
        }
        int bpp = this.bits;
        while (bpp % 8 != 0) {
            ++bpp;
        }
        bpp /= 8;
        int rowSkip = this.orientation < 2 ? this.getSizeY() - h2 - y : y;
        int colSkip = this.orientation % 2 == 1 ? this.getSizeX() - w - x : x;
        try {
            s2.skipBytes(rowSkip * this.getSizeX() * bpp);
            for (int row = 0; row < h2; ++row) {
                if (s2.getFilePointer() >= s2.length()) {
                    break;
                }
                s2.skipBytes(colSkip * bpp);
                for (int col = 0; col < w && s2.getFilePointer() < s2.length(); ++col) {
                    int rowIndex = this.orientation < 2 ? h2 - row - 1 : row;
                    int colIndex = this.orientation % 2 == 1 ? w - col - 1 : col;
                    int index = this.getSizeC() * (rowIndex * w + colIndex);
                    if (bpp == 2) {
                        short v = s2.readShort();
                        buf[index] = (byte)((v & 0x7C00) >> 10);
                        buf[index + 1] = (byte)((v & 0x3E0) >> 5);
                        buf[index + 2] = (byte)(v & 0x1F);
                        continue;
                    }
                    if (bpp == 4) {
                        buf[index + 2] = s2.readByte();
                        buf[index + 1] = s2.readByte();
                        buf[index] = s2.readByte();
                        s2.skipBytes(1);
                        continue;
                    }
                    for (int c = this.getSizeC() - 1; c >= 0; --c) {
                        buf[index + c] = s2.readByte();
                    }
                }
                s2.skipBytes(bpp * (this.getSizeX() - w - colSkip));
            }
        }
        finally {
            if (this.compressed) {
                s2.close();
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.colorMap = null;
            this.offset = 0L;
            this.compressed = false;
            this.orientation = 0;
            this.bits = 0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.littleEndian = true;
        this.in.order(this.isLittleEndian());
        int nIdentificationChars = this.in.readUnsignedByte();
        boolean hasColorMap = this.in.readByte() == 1;
        byte imageType = this.in.readByte();
        this.compressed = imageType == 9 || imageType == 10 || imageType == 11;
        int colorMapOrigin = this.in.readUnsignedShort();
        int colorMapLength = this.in.readUnsignedShort();
        int bitsPerEntry = this.in.readUnsignedByte();
        this.in.skipBytes(4);
        m3.sizeX = this.in.readUnsignedShort();
        m3.sizeY = this.in.readUnsignedShort();
        m3.bitsPerPixel = this.bits = this.in.readUnsignedByte();
        int imageDescriptor = this.in.readUnsignedByte();
        this.orientation = (imageDescriptor & 0x30) >> 4;
        String identification = this.in.readString(nIdentificationChars);
        if (colorMapLength > 0) {
            this.colorMap = new byte[3][colorMapLength];
            int bpc = bitsPerEntry == 32 ? 8 : bitsPerEntry / 3;
            byte[] v = new byte[bitsPerEntry / 8];
            for (int i = 0; i < colorMapLength; ++i) {
                this.in.read(v);
                if (v.length == 4 || v.length == 3) {
                    this.colorMap[0][i] = v[2];
                    this.colorMap[1][i] = v[1];
                    this.colorMap[2][i] = v[0];
                    continue;
                }
                if (v.length != 2) continue;
                short pixel = DataTools.bytesToShort(v, this.isLittleEndian());
                this.colorMap[0][i] = (byte)((pixel & 0x7C00) >> 10);
                this.colorMap[1][i] = (byte)((pixel & 0x3E0) >> 5);
                this.colorMap[2][i] = (byte)(pixel & 0x1F);
            }
        }
        this.offset = this.in.getFilePointer();
        this.addGlobalMeta("Color map present", hasColorMap);
        this.addGlobalMeta("Image type", (int)imageType);
        this.addGlobalMeta("Color map origin", colorMapOrigin);
        this.addGlobalMeta("Color map length", colorMapLength);
        this.addGlobalMeta("Bits per color map entry", bitsPerEntry);
        this.addGlobalMeta("Image width", this.getSizeX());
        this.addGlobalMeta("Image height", this.getSizeY());
        this.addGlobalMeta("Bits per pixel", this.getBitsPerPixel());
        this.addGlobalMeta("Identification", identification);
        this.addGlobalMeta("Image orientation", this.orientation);
        this.addGlobalMeta("Pixel offset", this.offset);
        m3.sizeZ = 1;
        m3.sizeT = 1;
        m3.rgb = imageType == 2 || imageType == 10;
        m3.sizeC = this.isRGB() ? 3 : 1;
        m3.dimensionOrder = "XYCZT";
        m3.falseColor = false;
        m3.pixelType = 1;
        m3.bitsPerPixel = this.getBitsPerPixel() == 32 ? 8 : this.getBitsPerPixel() / this.getSizeC();
        m3.imageCount = 1;
        m3.interleaved = true;
        m3.indexed = this.colorMap != null && !this.isRGB();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(identification, 0);
        }
    }
}

