/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.plugin;

import icy.file.FileUtil;
import icy.gui.component.ImageComponent;
import icy.gui.frame.IcyFrame;
import icy.gui.util.ComponentUtil;
import icy.gui.util.GuiUtil;
import icy.network.NetworkUtil;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.ThreadUtil;
import icy.util.EventUtil;
import icy.util.Random;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class PluginDetailPanel
extends IcyFrame
implements HyperlinkListener {
    final PluginDescriptor plugin;
    private final ExecuteActionButton executeButton;
    private final CloseActionButton closeButton;
    final JPanel imagePanel;
    final ImageComponent pluginImage;
    final JLabel pluginPathLabel;
    final JLabel pluginAuthorLabel;
    final JLabel pluginWebsiteLabel;
    final JLabel pluginEmailLabel;
    final JTextPane pluginDescriptionText;
    final JTextPane pluginChangeLogText;

    public PluginDetailPanel(PluginDescriptor plugin) {
        super(plugin.getName() + " " + plugin.getVersion(), false, true);
        this.plugin = plugin;
        this.executeButton = new ExecuteActionButton();
        this.closeButton = new CloseActionButton();
        this.setPreferredSize(new Dimension(640, 520));
        this.pluginDescriptionText = new JTextPane();
        this.pluginDescriptionText.setContentType("text/html");
        this.pluginDescriptionText.setEditable(false);
        this.pluginDescriptionText.setOpaque(false);
        this.pluginDescriptionText.addHyperlinkListener(this);
        ComponentUtil.setFixedHeight(this.pluginDescriptionText, 256);
        JScrollPane scDescription = new JScrollPane(this.pluginDescriptionText);
        scDescription.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this.pluginImage = new ImageComponent(plugin.isImageLoaded() ? plugin.getImage() : PluginDescriptor.DEFAULT_IMAGE);
        this.imagePanel = new JPanel(new BorderLayout());
        this.imagePanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.imagePanel.add((Component)this.pluginImage, "Center");
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)this.imagePanel, "West");
        topPanel.add((Component)scDescription, "Center");
        this.pluginPathLabel = new JLabel();
        this.pluginPathLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (EventUtil.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    String path = PluginDetailPanel.this.pluginPathLabel.getText();
                    try {
                        if (!StringUtil.isEmpty(path) && !path.equals("---")) {
                            SystemUtil.openFolder(FileUtil.getDirectory(path));
                        }
                    }
                    catch (IOException e1) {
                        IcyExceptionHandler.showErrorMessage(e1, false, false);
                    }
                    e.consume();
                }
            }
        });
        this.pluginAuthorLabel = new JLabel();
        this.pluginWebsiteLabel = new JLabel();
        this.pluginWebsiteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isConsumed()) {
                    return;
                }
                if (EventUtil.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    String url = PluginDetailPanel.this.pluginWebsiteLabel.getText();
                    if (!StringUtil.isEmpty(url) && !url.equals("---")) {
                        NetworkUtil.openBrowser(url);
                    }
                    e.consume();
                }
            }
        });
        this.pluginEmailLabel = new JLabel();
        JPanel infosPanel = new JPanel();
        infosPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        infosPanel.setLayout(new BoxLayout(infosPanel, 3));
        infosPanel.add(GuiUtil.createTabBoldLabel("Path", 1));
        infosPanel.add(GuiUtil.createTabLabel(this.pluginPathLabel, 32));
        infosPanel.add(Box.createVerticalStrut(4));
        infosPanel.add(GuiUtil.createTabBoldLabel("Author", 1));
        infosPanel.add(GuiUtil.createTabLabel(this.pluginAuthorLabel, 32));
        infosPanel.add(Box.createVerticalStrut(4));
        infosPanel.add(GuiUtil.createTabBoldLabel("Web site", 1));
        infosPanel.add(GuiUtil.createTabLabel(this.pluginWebsiteLabel, 32));
        infosPanel.add(Box.createVerticalStrut(4));
        infosPanel.add(GuiUtil.createTabBoldLabel("Email", 1));
        infosPanel.add(GuiUtil.createTabLabel(this.pluginEmailLabel, 32));
        infosPanel.add(Box.createVerticalStrut(4));
        infosPanel.add(Box.createVerticalGlue());
        JScrollPane scInfosPanel = new JScrollPane(infosPanel);
        scInfosPanel.setPreferredSize(new Dimension(280, 128));
        scInfosPanel.setMaximumSize(new Dimension(280, 2048));
        scInfosPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.pluginChangeLogText = new JTextPane();
        this.pluginChangeLogText.setContentType("text/html");
        this.pluginChangeLogText.setEditable(false);
        this.pluginChangeLogText.setOpaque(false);
        this.pluginChangeLogText.addHyperlinkListener(this);
        JScrollPane scChangeLog = new JScrollPane(this.pluginChangeLogText);
        scChangeLog.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        JPanel changeLogPanel = new JPanel(new BorderLayout());
        changeLogPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 4, 4));
        changeLogPanel.add((Component)GuiUtil.createTabBoldLabel("ChangeLog", 1), "North");
        changeLogPanel.add((Component)GuiUtil.createLineBoxPanel(Box.createHorizontalStrut(32), scChangeLog), "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)new JSeparator(0), "North");
        centerPanel.add((Component)scInfosPanel, "West");
        centerPanel.add((Component)changeLogPanel, "Center");
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        buttonsPanel.add(this.executeButton);
        buttonsPanel.add(Box.createHorizontalGlue());
        buttonsPanel.add(Box.createHorizontalStrut(4));
        buttonsPanel.add(this.closeButton);
        JPanel bottomPanel = new JPanel(new BorderLayout());
        bottomPanel.add((Component)new JSeparator(0), "North");
        bottomPanel.add((Component)buttonsPanel, "Center");
        this.setLayout(new BorderLayout());
        this.add(topPanel, "North");
        this.add(centerPanel, "Center");
        this.add(bottomPanel, "South");
        this.updateGui();
        this.addToDesktopPane();
        this.setLocation(10 * Random.nextInt(20) + 40, 10 * Random.nextInt(10) + 40);
        this.setVisible(true);
        this.requestFocus();
        if (!plugin.isAllLoaded()) {
            ThreadUtil.bgRun(new Runnable(){

                @Override
                public void run() {
                    PluginDetailPanel.this.plugin.loadAll();
                    ThreadUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginDetailPanel.this.updateGui();
                        }
                    });
                }
            });
        }
    }

    void updateGui() {
        PluginDescriptor localPlugin;
        Font sysFont = this.pluginAuthorLabel.getFont();
        Image img = this.plugin.getImage();
        String description = this.plugin.getDescription();
        String changesLog = this.plugin.getChangeLog();
        String author = this.plugin.getAuthor();
        String email = this.plugin.getEmail();
        String web = this.plugin.getWeb();
        String jarPath = this.plugin.getPluginJarPath();
        if (StringUtil.isEmpty(jarPath) && (localPlugin = PluginLoader.getPlugin(this.plugin.getClassName())) != null) {
            jarPath = localPlugin.getPluginJarPath();
        }
        if (img == null) {
            this.pluginImage.setImage(PluginDescriptor.DEFAULT_IMAGE);
        } else {
            this.pluginImage.setImage(img);
        }
        if (StringUtil.isEmpty(description)) {
            this.pluginDescriptionText.setText("No description");
        } else {
            if (StringUtil.containHtmlCR(description)) {
                this.pluginDescriptionText.setText(StringUtil.removeCR(description));
            } else {
                this.pluginDescriptionText.setText(StringUtil.toHtmlCR(description));
            }
            this.pluginDescriptionText.setCaretPosition(0);
        }
        ComponentUtil.setJTextPaneFont(this.pluginDescriptionText, sysFont, Color.black);
        if (StringUtil.isEmpty(changesLog)) {
            this.pluginChangeLogText.setText("---");
        } else {
            this.pluginChangeLogText.setText(StringUtil.toHtmlCR(changesLog));
            this.pluginChangeLogText.setCaretPosition(0);
        }
        ComponentUtil.setJTextPaneFont(this.pluginChangeLogText, new Font("courier", 0, 11), Color.black);
        if (StringUtil.isEmpty(jarPath)) {
            this.pluginPathLabel.setText("---");
            this.pluginPathLabel.setToolTipText("");
        } else {
            this.pluginPathLabel.setText(jarPath);
            this.pluginPathLabel.setToolTipText(jarPath + "  (double click to see file location)");
        }
        if (StringUtil.isEmpty(author)) {
            this.pluginAuthorLabel.setText("---");
            this.pluginAuthorLabel.setToolTipText("");
        } else {
            this.pluginAuthorLabel.setText(author);
            this.pluginAuthorLabel.setToolTipText(author);
        }
        if (StringUtil.isEmpty(email)) {
            this.pluginEmailLabel.setText("---");
            this.pluginEmailLabel.setToolTipText("");
        } else {
            this.pluginEmailLabel.setText(email);
            this.pluginEmailLabel.setToolTipText(email);
        }
        if (StringUtil.isEmpty(web)) {
            this.pluginWebsiteLabel.setText("---");
            this.pluginWebsiteLabel.setToolTipText("");
        } else {
            this.pluginWebsiteLabel.setText(web);
            this.pluginWebsiteLabel.setToolTipText(web + "  (double click to open in browser)");
        }
        this.pack();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            NetworkUtil.openBrowser(e.getURL());
        }
    }

    private class CloseActionButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 4912851751410749786L;

        public CloseActionButton() {
            super("Close");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginDetailPanel.this.close();
        }
    }

    private class ExecuteActionButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 3096619820228575930L;

        public ExecuteActionButton() {
            super("Execute");
            this.setVisible(PluginDetailPanel.this.plugin.isActionable());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PluginLauncher.start(PluginDetailPanel.this.plugin);
        }
    }
}

