/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.component.RangeComponent;
import icy.gui.component.sequence.SequencePreviewPanel;
import icy.sequence.DimensionId;
import icy.sequence.SequenceModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EventListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SequenceDimensionAdjustPanel
extends JPanel {
    private static final long serialVersionUID = 5670426025630944193L;
    protected DimensionId dim;
    protected SequencePreviewPanel sequencePreviewPanel;
    protected RangeComponent range;
    private JPanel extractionRulePanel;
    protected JSpinner extractSpinner;
    protected JSpinner loopSpinner;
    double oldLow;
    double oldHigh;

    public SequenceDimensionAdjustPanel(DimensionId dim) {
        if (dim != DimensionId.Z && dim != DimensionId.T) {
            throw new IllegalArgumentException("Only Z or T dimension allowed");
        }
        this.dim = dim;
        this.initialize();
        if (dim == DimensionId.Z) {
            this.sequencePreviewPanel.getMainPanel().setBorder(new TitledBorder(null, "Select Z interval", 4, 2, null, null));
            this.range = new RangeComponent(1);
            this.range.setToolTipText("Select Z interval");
        } else {
            this.sequencePreviewPanel.getMainPanel().setBorder(new TitledBorder(null, "Select T interval", 4, 2, null, null));
            this.range = new RangeComponent(0);
            this.range.setToolTipText("Select T interval");
        }
        this.range.setMinMaxStep(0.0, 0.0, 1.0);
        this.range.setVisible(false);
        this.range.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double low = SequenceDimensionAdjustPanel.this.range.getLow();
                double high = SequenceDimensionAdjustPanel.this.range.getHigh();
                if (SequenceDimensionAdjustPanel.this.oldLow != low) {
                    if (SequenceDimensionAdjustPanel.this.dim == DimensionId.Z) {
                        SequenceDimensionAdjustPanel.this.sequencePreviewPanel.setPositionZ((int)low);
                    } else {
                        SequenceDimensionAdjustPanel.this.sequencePreviewPanel.setPositionT((int)low);
                    }
                } else if (SequenceDimensionAdjustPanel.this.oldHigh != high) {
                    if (SequenceDimensionAdjustPanel.this.dim == DimensionId.Z) {
                        SequenceDimensionAdjustPanel.this.sequencePreviewPanel.setPositionZ((int)high);
                    } else {
                        SequenceDimensionAdjustPanel.this.sequencePreviewPanel.setPositionT((int)high);
                    }
                }
                SequenceDimensionAdjustPanel.this.oldLow = low;
                SequenceDimensionAdjustPanel.this.oldHigh = high;
                SequenceDimensionAdjustPanel.this.fireRangeChangedEvent();
            }
        });
        if (dim == DimensionId.Z) {
            JPanel panel = this.sequencePreviewPanel.getZPanel();
            panel.removeAll();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.range, "Center");
        } else {
            JPanel panel = this.sequencePreviewPanel.getTPanel();
            panel.removeAll();
            panel.setLayout(new BorderLayout());
            panel.add((Component)this.range, "Center");
        }
        this.extractSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SpinnerNumberModel model = (SpinnerNumberModel)SequenceDimensionAdjustPanel.this.loopSpinner.getModel();
                int currentValue = (Integer)model.getValue();
                int min = SequenceDimensionAdjustPanel.this.getExtractValue();
                SequenceDimensionAdjustPanel.this.loopSpinner.setModel(new SpinnerNumberModel(Math.max(min, currentValue), min, (int)SequenceDimensionAdjustPanel.this.range.getMax(), 1));
                SequenceDimensionAdjustPanel.this.fireRangeChangedEvent();
            }
        });
        this.loopSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SequenceDimensionAdjustPanel.this.fireRangeChangedEvent();
            }
        });
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.sequencePreviewPanel = new SequencePreviewPanel();
        this.add((Component)this.sequencePreviewPanel, "Center");
        this.extractionRulePanel = new JPanel();
        this.extractionRulePanel.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), "Extraction rule", 4, 2, null, new Color(0, 0, 0)));
        this.add((Component)this.extractionRulePanel, "South");
        GridBagLayout gbl_extractionRulePanel = new GridBagLayout();
        gbl_extractionRulePanel.columnWidths = new int[]{0, 0, 0, 0, 0, 0};
        gbl_extractionRulePanel.rowHeights = new int[]{20, 0};
        gbl_extractionRulePanel.columnWeights = new double[]{0.0, 1.0, 0.0, 1.0, 2.0, Double.MIN_VALUE};
        gbl_extractionRulePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.extractionRulePanel.setLayout(gbl_extractionRulePanel);
        JLabel lblKeep = new JLabel("Keep");
        GridBagConstraints gbc_lblKeep = new GridBagConstraints();
        gbc_lblKeep.anchor = 13;
        gbc_lblKeep.insets = new Insets(0, 0, 0, 5);
        gbc_lblKeep.gridx = 0;
        gbc_lblKeep.gridy = 0;
        this.extractionRulePanel.add((Component)lblKeep, gbc_lblKeep);
        this.extractSpinner = new JSpinner();
        this.extractSpinner.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.extractSpinner.setToolTipText("Number of frames to keep every N frames. 'Keep 1 every 2' means keep every other frame.");
        GridBagConstraints gbc_extractSpinner = new GridBagConstraints();
        gbc_extractSpinner.fill = 2;
        gbc_extractSpinner.anchor = 11;
        gbc_extractSpinner.insets = new Insets(0, 0, 0, 5);
        gbc_extractSpinner.gridx = 1;
        gbc_extractSpinner.gridy = 0;
        this.extractionRulePanel.add((Component)this.extractSpinner, gbc_extractSpinner);
        JLabel lblEvery = new JLabel("every");
        GridBagConstraints gbc_lblEvery = new GridBagConstraints();
        gbc_lblEvery.anchor = 13;
        gbc_lblEvery.insets = new Insets(0, 0, 0, 5);
        gbc_lblEvery.gridx = 2;
        gbc_lblEvery.gridy = 0;
        this.extractionRulePanel.add((Component)lblEvery, gbc_lblEvery);
        this.loopSpinner = new JSpinner();
        this.loopSpinner.setModel(new SpinnerNumberModel(new Integer(1), new Integer(1), null, new Integer(1)));
        this.loopSpinner.setToolTipText("Size for the extraction rule loop.");
        GridBagConstraints gbc_loopSpinner = new GridBagConstraints();
        gbc_loopSpinner.fill = 2;
        gbc_loopSpinner.insets = new Insets(0, 0, 0, 5);
        gbc_loopSpinner.anchor = 11;
        gbc_loopSpinner.gridx = 3;
        gbc_loopSpinner.gridy = 0;
        this.extractionRulePanel.add((Component)this.loopSpinner, gbc_loopSpinner);
    }

    public DimensionId getDimensionId() {
        return this.dim;
    }

    public boolean isPreviewVisible() {
        return this.sequencePreviewPanel.isVisible();
    }

    public void setPreviewVisible(boolean value) {
        this.sequencePreviewPanel.setVisible(value);
    }

    private void setMax(int value) {
        this.range.setMinMaxStep(0.0, value, 1.0);
        this.range.setLowHigh(0.0, value);
        this.range.setVisible(value > 0);
        this.extractSpinner.setModel(new SpinnerNumberModel(1, 1, Math.max(value, 1), 1));
        this.loopSpinner.setModel(new SpinnerNumberModel(1, 1, Math.max(value, 1), 1));
    }

    public SequenceModel getModel() {
        return this.sequencePreviewPanel.getModel();
    }

    public void setModel(SequenceModel model) {
        if (this.getModel() != model) {
            this.sequencePreviewPanel.setModel(model);
            this.dimensionChangedInternal();
        }
    }

    public void dimensionChanged() {
        this.dimensionChangedInternal();
        this.sequencePreviewPanel.dimensionChanged();
    }

    private void dimensionChangedInternal() {
        SequenceModel model = this.getModel();
        if (model != null) {
            if (this.dim == DimensionId.Z) {
                this.setMax(Math.max(0, model.getSizeZ() - 1));
            } else {
                this.setMax(Math.max(0, model.getSizeT() - 1));
            }
        } else {
            this.setMax(0);
        }
    }

    public void imageChanged() {
        this.sequencePreviewPanel.imageChanged();
    }

    public int getRangeLow() {
        return (int)this.range.getLow();
    }

    public int getRangeHigh() {
        return (int)this.range.getHigh();
    }

    public boolean isIndexSelected(int index) {
        if (index < this.getRangeLow()) {
            return false;
        }
        if (index > this.getRangeHigh()) {
            return false;
        }
        return (index - this.getRangeLow()) % this.getLoopValue() < this.getExtractValue();
    }

    public int getExtractValue() {
        return (Integer)this.extractSpinner.getValue();
    }

    public int getLoopValue() {
        return (Integer)this.loopSpinner.getValue();
    }

    protected void fireRangeChangedEvent() {
        for (RangeChangeListener listener : (RangeChangeListener[])this.getListeners(RangeChangeListener.class)) {
            listener.rangeChanged();
        }
    }

    public void addRangeChangeListener(RangeChangeListener listener) {
        this.listenerList.add(RangeChangeListener.class, listener);
    }

    public void removeRangeChangeListener(RangeChangeListener listener) {
        this.listenerList.remove(RangeChangeListener.class, listener);
    }

    public static interface RangeChangeListener
    extends EventListener {
        public void rangeChanged();
    }
}

