/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormodel;

import icy.common.CollapsibleEvent;
import icy.common.UpdateEventHandler;
import icy.common.listener.ChangeListener;
import icy.image.colormap.IcyColorMap;
import icy.image.colormodel.ByteColorModel;
import icy.image.colormodel.DoubleColorModel;
import icy.image.colormodel.FloatColorModel;
import icy.image.colormodel.IcyColorModelEvent;
import icy.image.colormodel.IcyColorModelListener;
import icy.image.colormodel.IntColorModel;
import icy.image.colormodel.LongColorModel;
import icy.image.colormodel.ShortColorModel;
import icy.image.colormodel.UByteColorModel;
import icy.image.colormodel.UIntColorModel;
import icy.image.colormodel.ULongColorModel;
import icy.image.colormodel.UShortColorModel;
import icy.image.colorspace.IcyColorSpace;
import icy.image.colorspace.IcyColorSpaceEvent;
import icy.image.colorspace.IcyColorSpaceListener;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.math.ScalerEvent;
import icy.math.ScalerListener;
import icy.type.DataType;
import icy.type.TypeUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayUtil;
import icy.util.ReflectionUtil;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class IcyColorModel
extends ColorModel
implements ScalerListener,
IcyColorSpaceListener,
ChangeListener {
    protected final Scaler[] normalScalers;
    protected final Scaler[] colormapScalers;
    protected final DataType dataType;
    protected final int numComponents;
    private final List<IcyColorModelListener> listeners;
    private final UpdateEventHandler updater;

    IcyColorModel(int numComponents, DataType dataType, int[] bits) {
        super(dataType.getBitSize(), bits, new IcyColorSpace(numComponents), true, false, 3, dataType.toDataBufferType());
        if (numComponents == 0) {
            throw new IllegalArgumentException("Number of components should be > 0");
        }
        this.numComponents = numComponents;
        this.listeners = new ArrayList<IcyColorModelListener>();
        this.updater = new UpdateEventHandler(this, false);
        this.dataType = dataType;
        double[] defaultBounds = dataType.getDefaultBounds();
        double min = defaultBounds[0];
        double max = defaultBounds[1];
        boolean isFloat = dataType.isFloat();
        this.normalScalers = new Scaler[numComponents];
        this.colormapScalers = new Scaler[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            this.normalScalers[i] = new Scaler(min, max, 0.0, 1.0, !isFloat);
            this.colormapScalers[i] = new Scaler(min, max, 0.0, 255.0, !isFloat);
            this.colormapScalers[i].addListener(this);
        }
        this.getIcyColorSpace().addListener(this);
    }

    @Deprecated
    IcyColorModel(int numComponents, int dataType, boolean signed, int[] bits) {
        this(numComponents, DataType.getDataType(dataType, signed), bits);
    }

    public static IcyColorModel createInstance(int numComponents, DataType dataType) {
        int bits = dataType.getBitSize();
        int numComponentFixed = numComponents + 1;
        int[] componentBits = new int[numComponentFixed];
        for (int i = 0; i < numComponentFixed; ++i) {
            componentBits[i] = bits;
        }
        switch (dataType) {
            case UBYTE: {
                return new UByteColorModel(numComponents, componentBits);
            }
            case BYTE: {
                return new ByteColorModel(numComponents, componentBits);
            }
            case USHORT: {
                return new UShortColorModel(numComponents, componentBits);
            }
            case SHORT: {
                return new ShortColorModel(numComponents, componentBits);
            }
            case UINT: {
                return new UIntColorModel(numComponents, componentBits);
            }
            case INT: {
                return new IntColorModel(numComponents, componentBits);
            }
            case ULONG: {
                return new ULongColorModel(numComponents, componentBits);
            }
            case LONG: {
                return new LongColorModel(numComponents, componentBits);
            }
            case FLOAT: {
                return new FloatColorModel(numComponents, componentBits);
            }
            case DOUBLE: {
                return new DoubleColorModel(numComponents, componentBits);
            }
        }
        throw new IllegalArgumentException("Unsupported data type !");
    }

    @Deprecated
    public static IcyColorModel createInstance(int numComponents, int dataType, boolean signed) {
        return IcyColorModel.createInstance(numComponents, DataType.getDataType(dataType, signed));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IcyColorModel createInstance(IcyColorModel colorModel, boolean copyColormap, boolean copyBounds) {
        IcyColorModel result = IcyColorModel.createInstance(colorModel.getNumComponents(), colorModel.getDataType_());
        result.beginUpdate();
        try {
            if (copyColormap) {
                result.setColorMaps(colorModel);
            }
            if (copyBounds) {
                result.setBounds(colorModel);
            }
        }
        finally {
            result.endUpdate();
        }
        return result;
    }

    public static IcyColorModel createInstance() {
        return IcyColorModel.createInstance(4, DataType.UBYTE);
    }

    public static BandedSampleModel createCompatibleSampleModel(int transferType, int w, int h, int numComponent) {
        return new BandedSampleModel(transferType, w, h, numComponent);
    }

    public static WritableRaster createWritableRaster(Object data, int w, int h) {
        if (ArrayUtil.getDim(data) != 2) {
            throw new IllegalArgumentException("IcyColorModel.createWritableRaster(..) error: 'data' argument should be a 2D array !");
        }
        DataType dataType = ArrayUtil.getDataType(data);
        int sizeC = ArrayUtil.getLength(data);
        BandedSampleModel sm = IcyColorModel.createCompatibleSampleModel(dataType.toDataBufferType(), w, h, sizeC);
        switch (dataType) {
            case UBYTE: 
            case BYTE: {
                return Raster.createWritableRaster(sm, new DataBufferByte((byte[][])data, w * h), null);
            }
            case SHORT: {
                return Raster.createWritableRaster(sm, new DataBufferShort((short[][])data, w * h), null);
            }
            case USHORT: {
                return Raster.createWritableRaster(sm, new DataBufferUShort((short[][])data, w * h), null);
            }
            case UINT: 
            case INT: {
                return Raster.createWritableRaster(sm, new DataBufferInt((int[][])data, w * h), null);
            }
            case FLOAT: {
                return Raster.createWritableRaster(sm, new DataBufferFloat((float[][])data, w * h), null);
            }
            case DOUBLE: {
                return Raster.createWritableRaster(sm, new DataBufferDouble((double[][])data, w * h), null);
            }
        }
        throw new IllegalArgumentException("IcyColorModel.createWritableRaster(..) error: unsupported data type : " + (Object)((Object)dataType));
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return IcyColorModel.createCompatibleSampleModel(this.transferType, w, h, this.getNumComponents());
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        SampleModel sm = this.createCompatibleSampleModel(w, h);
        return Raster.createWritableRaster(sm, sm.createDataBuffer(), null);
    }

    public WritableRaster createWritableRaster(Object[] data, int w, int h) {
        SampleModel sm = this.createCompatibleSampleModel(w, h);
        switch (this.dataType) {
            case UBYTE: 
            case BYTE: {
                return Raster.createWritableRaster(sm, new DataBufferByte((byte[][])data, w * h), null);
            }
            case SHORT: {
                return Raster.createWritableRaster(sm, new DataBufferShort((short[][])data, w * h), null);
            }
            case USHORT: {
                return Raster.createWritableRaster(sm, new DataBufferUShort((short[][])data, w * h), null);
            }
            case UINT: 
            case INT: {
                return Raster.createWritableRaster(sm, new DataBufferInt((int[][])data, w * h), null);
            }
            case FLOAT: {
                return Raster.createWritableRaster(sm, new DataBufferFloat((float[][])data, w * h), null);
            }
            case DOUBLE: {
                return Raster.createWritableRaster(sm, new DataBufferDouble((double[][])data, w * h), null);
            }
        }
        throw new IllegalArgumentException("IcyColorModel.createWritableRaster(..) error : unsupported data type : " + (Object)((Object)this.dataType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(IcyColorModel source) {
        this.beginUpdate();
        try {
            for (int i = 0; i < this.numComponents; ++i) {
                Scaler srcNormalScaler = source.getNormalScalers()[i];
                Scaler dstNormalScaler = this.normalScalers[i];
                Scaler srcColorMapScaler = source.getColormapScalers()[i];
                Scaler dstColorMapScaler = this.colormapScalers[i];
                dstNormalScaler.beginUpdate();
                try {
                    dstNormalScaler.setAbsLeftRightIn(srcNormalScaler.getAbsLeftIn(), srcNormalScaler.getAbsRightIn());
                    dstNormalScaler.setLeftRightIn(srcNormalScaler.getLeftIn(), srcNormalScaler.getRightIn());
                    dstNormalScaler.setLeftRightOut(srcNormalScaler.getLeftOut(), srcNormalScaler.getRightOut());
                }
                finally {
                    dstNormalScaler.endUpdate();
                }
                dstColorMapScaler.beginUpdate();
                try {
                    dstColorMapScaler.setAbsLeftRightIn(srcColorMapScaler.getAbsLeftIn(), srcColorMapScaler.getAbsRightIn());
                    dstColorMapScaler.setLeftRightIn(srcColorMapScaler.getLeftIn(), srcColorMapScaler.getRightIn());
                    dstColorMapScaler.setLeftRightOut(srcColorMapScaler.getLeftOut(), srcColorMapScaler.getRightOut());
                    continue;
                }
                finally {
                    dstColorMapScaler.endUpdate();
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    @Deprecated
    public void copyBounds(IcyColorModel source) {
        this.setBounds(source);
    }

    public IcyColorMap getColorMap(int component) {
        return this.getIcyColorSpace().getColorMap(component);
    }

    @Deprecated
    public IcyColorMap getColormap(int component) {
        return this.getColorMap(component);
    }

    public void setColorMaps(ColorModel source) {
        this.getIcyColorSpace().setColorMaps(source);
    }

    @Deprecated
    public void setColormaps(ColorModel source) {
        this.setColorMaps(source);
    }

    @Deprecated
    public void copyColormap(ColorModel source) {
        this.setColorMaps(source);
    }

    public void setColorMap(int component, IcyColorMap map, boolean setAlpha) {
        this.getIcyColorSpace().setColorMap(component, map, setAlpha);
    }

    @Deprecated
    public void setColormap(int component, IcyColorMap map) {
        this.setColorMap(component, map, true);
    }

    @Override
    public int getAlpha(int pixel) {
        throw new IllegalArgumentException("Argument type not supported for this color model");
    }

    @Override
    public int getBlue(int pixel) {
        throw new IllegalArgumentException("Argument type not supported for this color model");
    }

    @Override
    public int getGreen(int pixel) {
        throw new IllegalArgumentException("Argument type not supported for this color model");
    }

    @Override
    public int getRed(int pixel) {
        throw new IllegalArgumentException("Argument type not supported for this color model");
    }

    @Override
    public abstract int getRGB(Object var1);

    public abstract int getRGB(Object var1, LUT var2);

    @Override
    public int getBlue(Object pixel) {
        return this.getRGB(pixel) & 0xFF;
    }

    @Override
    public int getGreen(Object pixel) {
        return this.getRGB(pixel) >> 8 & 0xFF;
    }

    @Override
    public int getRed(Object pixel) {
        return this.getRGB(pixel) >> 16 & 0xFF;
    }

    @Override
    public int getAlpha(Object pixel) {
        return this.getRGB(pixel) >> 24 & 0xFF;
    }

    @Override
    public int[] getComponents(int pixel, int[] components, int offset) {
        throw new IllegalArgumentException("Not supported in this ColorModel");
    }

    @Override
    public abstract int[] getComponents(Object var1, int[] var2, int var3);

    @Override
    public abstract float[] getNormalizedComponents(Object var1, float[] var2, int var3);

    @Override
    public float[] getNormalizedComponents(int[] components, int offset, float[] normComponents, int normOffset) {
        if (components.length - offset < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        float[] result = Array1DUtil.allocIfNull(normComponents, this.numComponents + normOffset);
        for (int i = 0; i < this.numComponents; ++i) {
            result[normOffset + i] = (float)this.normalScalers[i].scale(components[offset + i]);
        }
        return result;
    }

    @Override
    public int[] getUnnormalizedComponents(float[] normComponents, int normOffset, int[] components, int offset) {
        if (normComponents.length - normOffset < this.numComponents) {
            throw new IllegalArgumentException("Incorrect number of components.  Expecting " + this.numComponents);
        }
        int[] result = Array1DUtil.allocIfNull(components, this.numComponents + offset);
        for (int i = 0; i < this.numComponents; ++i) {
            result[offset + i] = (int)this.normalScalers[i].unscale(normComponents[normOffset + i]);
        }
        return result;
    }

    @Override
    public int getDataElement(int[] components, int offset) {
        throw new IllegalArgumentException("Not supported in this ColorModel");
    }

    @Override
    public int getDataElement(float[] normComponents, int normOffset) {
        throw new IllegalArgumentException("Not supported in this ColorModel");
    }

    @Override
    public abstract Object getDataElements(int[] var1, int var2, Object var3);

    @Override
    public Object getDataElements(int rgb, Object pixel) {
        return this.getDataElements(this.getIcyColorSpace().fromRGB(rgb), 0, pixel);
    }

    @Override
    public abstract Object getDataElements(float[] var1, int var2, Object var3);

    @Override
    public ColorModel coerceData(WritableRaster raster, boolean isAlphaPremultiplied) {
        return this;
    }

    protected double colormapScale(int component, double value) {
        return this.colormapScalers[component].scale(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IcyColorModel) {
            return this.isCompatible((IcyColorModel)obj);
        }
        return false;
    }

    public boolean isCompatible(IcyColorModel cm) {
        return this.getNumComponents() == cm.getNumComponents() && this.getDataType_() == cm.getDataType_();
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sm = raster.getSampleModel();
        int[] bits = this.getComponentSize();
        if (sm instanceof ComponentSampleModel) {
            if (sm.getNumBands() != this.numComponents) {
                return false;
            }
            for (int i = 0; i < bits.length; ++i) {
                if (sm.getSampleSize(i) >= bits[i]) continue;
                return false;
            }
            return raster.getTransferType() == this.transferType;
        }
        return false;
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sm) {
        if (this.numComponents != sm.getNumBands()) {
            return false;
        }
        return sm.getTransferType() == this.transferType;
    }

    public IcyColorSpace getIcyColorSpace() {
        return (IcyColorSpace)this.getColorSpace();
    }

    public void setColorSpace(IcyColorSpace colorSpace) {
        IcyColorSpace cs = this.getIcyColorSpace();
        if (cs != colorSpace) {
            try {
                Field csField = ReflectionUtil.getField(ColorModel.class, "colorSpace", true);
                csField.set(this, colorSpace);
                cs.removeListener(this);
                colorSpace.addListener(this);
            }
            catch (Exception e) {
                System.err.println("Warning: Couldn't change colorspace of IcyColorModel...");
            }
        }
    }

    public Scaler[] getNormalScalers() {
        return this.normalScalers;
    }

    public Scaler[] getColormapScalers() {
        return this.colormapScalers;
    }

    @Override
    public int getNumComponents() {
        return this.numComponents;
    }

    @Deprecated
    public int getDataType() {
        return TypeUtil.dataBufferTypeToDataType(this.transferType);
    }

    public DataType getDataType_() {
        return this.dataType;
    }

    public double[] getDefaultComponentBounds() {
        return this.dataType.getDefaultBounds();
    }

    public double getComponentAbsMinValue(int component) {
        return this.normalScalers[component].getAbsLeftIn();
    }

    public double getComponentAbsMaxValue(int component) {
        return this.normalScalers[component].getAbsRightIn();
    }

    public double[] getComponentAbsBounds(int component) {
        double[] result = new double[]{this.getComponentAbsMinValue(component), this.getComponentAbsMaxValue(component)};
        return result;
    }

    public double getComponentUserMinValue(int component) {
        return this.normalScalers[component].getLeftIn();
    }

    public double getComponentUserMaxValue(int component) {
        return this.normalScalers[component].getRightIn();
    }

    public double[] getComponentUserBounds(int component) {
        double[] result = new double[]{this.getComponentUserMinValue(component), this.getComponentUserMaxValue(component)};
        return result;
    }

    public void setComponentAbsMinValue(int component, double min) {
        this.normalScalers[component].setAbsLeftIn(min);
        this.colormapScalers[component].setAbsLeftIn(min);
    }

    public void setComponentAbsMaxValue(int component, double max) {
        this.normalScalers[component].setAbsRightIn(max);
        this.colormapScalers[component].setAbsRightIn(max);
    }

    public void setComponentAbsBounds(int component, double[] bounds) {
        this.setComponentAbsBounds(component, bounds[0], bounds[1]);
    }

    public void setComponentAbsBounds(int component, double min, double max) {
        this.normalScalers[component].setAbsLeftRightIn(min, max);
        this.colormapScalers[component].setAbsLeftRightIn(min, max);
    }

    public void setComponentUserMinValue(int component, double min) {
        this.normalScalers[component].setLeftIn(min);
        this.colormapScalers[component].setLeftIn(min);
    }

    public void setComponentUserMaxValue(int component, double max) {
        this.normalScalers[component].setRightIn(max);
        this.colormapScalers[component].setRightIn(max);
    }

    public void setComponentUserBounds(int component, double[] bounds) {
        this.setComponentUserBounds(component, bounds[0], bounds[1]);
    }

    public void setComponentUserBounds(int component, double min, double max) {
        this.normalScalers[component].setLeftRightIn(min, max);
        this.colormapScalers[component].setLeftRightIn(min, max);
    }

    public void setComponentsAbsBounds(double[][] bounds) {
        int numComponents = this.getNumComponents();
        if (bounds.length != numComponents) {
            throw new IllegalArgumentException("bounds.length != ColorModel.numComponents");
        }
        for (int component = 0; component < numComponents; ++component) {
            this.setComponentAbsBounds(component, bounds[component]);
        }
    }

    public void setComponentsUserBounds(double[][] bounds) {
        int numComponents = this.getNumComponents();
        if (bounds.length != numComponents) {
            throw new IllegalArgumentException("bounds.length != ColorModel.numComponents");
        }
        for (int component = 0; component < numComponents; ++component) {
            this.setComponentUserBounds(component, bounds[component]);
        }
    }

    public boolean isFloatDataType() {
        return this.dataType.isFloat();
    }

    public boolean isSignedDataType() {
        return this.dataType.isSigned();
    }

    public boolean hasLinearColormaps() {
        for (int c = 0; c < this.numComponents; ++c) {
            if (this.getColorMap(c).isLinear()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return new String("ColorModel: dataType = " + (Object)((Object)this.dataType) + " numComponents = " + this.numComponents + " color space = " + this.getColorSpace());
    }

    public void addListener(IcyColorModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IcyColorModelListener listener) {
        this.listeners.remove(listener);
    }

    public void fireEvent(IcyColorModelEvent e) {
        for (IcyColorModelListener listener : new ArrayList<IcyColorModelListener>(this.listeners)) {
            listener.colorModelChanged(e);
        }
    }

    @Override
    public void onChanged(CollapsibleEvent compare) {
        IcyColorModelEvent event = (IcyColorModelEvent)compare;
        this.fireEvent(event);
    }

    @Override
    public void scalerChanged(ScalerEvent e) {
        int ind = Scaler.indexOf(this.colormapScalers, e.getScaler());
        if (ind != -1) {
            this.updater.changed(new IcyColorModelEvent(this, IcyColorModelEvent.IcyColorModelEventType.SCALER_CHANGED, ind));
        }
    }

    @Override
    public void colorSpaceChanged(IcyColorSpaceEvent e) {
        this.updater.changed(new IcyColorModelEvent(this, IcyColorModelEvent.IcyColorModelEventType.COLORMAP_CHANGED, e.getComponent()));
    }

    public void beginUpdate() {
        this.updater.beginUpdate();
    }

    public void endUpdate() {
        this.updater.endUpdate();
    }

    public boolean isUpdating() {
        return this.updater.isUpdating();
    }
}

