/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginROIDescriptor;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ROIDescriptor {
    protected final String id;
    protected final String name;
    protected final Class<?> type;

    public static Map<ROIDescriptor, PluginROIDescriptor> getDescriptors() {
        HashMap<ROIDescriptor, PluginROIDescriptor> result = new HashMap<ROIDescriptor, PluginROIDescriptor>();
        ArrayList<PluginDescriptor> pluginDescriptors = PluginLoader.getPlugins(PluginROIDescriptor.class);
        for (PluginDescriptor pluginDescriptor : pluginDescriptors) {
            try {
                PluginROIDescriptor plugin = (PluginROIDescriptor)((Object)PluginLauncher.create(pluginDescriptor));
                List<ROIDescriptor> descriptors = plugin.getDescriptors();
                if (descriptors == null) continue;
                for (ROIDescriptor roiDescriptor : descriptors) {
                    result.put(roiDescriptor, plugin);
                }
            }
            catch (Throwable e) {
                IcyExceptionHandler.showErrorMessage(e, false, true);
                IcyExceptionHandler.report(pluginDescriptor, IcyExceptionHandler.getErrorMessage(e, true));
            }
        }
        return result;
    }

    public static ROIDescriptor getDescriptor(Collection<ROIDescriptor> descriptors, String id) {
        for (ROIDescriptor roiDescriptor : descriptors) {
            if (!StringUtil.equals(roiDescriptor.getId(), id)) continue;
            return roiDescriptor;
        }
        return null;
    }

    public static ROIDescriptor getDescriptor(String id) {
        return ROIDescriptor.getDescriptor(ROIDescriptor.getDescriptors().keySet(), id);
    }

    public static Object computeDescriptor(Collection<ROIDescriptor> roiDescriptors, String descriptorId, ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        ROIDescriptor roiDescriptor = ROIDescriptor.getDescriptor(roiDescriptors, descriptorId);
        if (roiDescriptor != null) {
            return roiDescriptor.compute(roi, sequence);
        }
        return null;
    }

    public static Object computeDescriptor(String descriptorId, ROI roi, Sequence sequence) throws UnsupportedOperationException, InterruptedException {
        return ROIDescriptor.computeDescriptor(ROIDescriptor.getDescriptors().keySet(), descriptorId, roi, sequence);
    }

    protected ROIDescriptor(String id, String name, Class<?> type) {
        this.id = id;
        this.name = name;
        this.type = type;
    }

    protected ROIDescriptor(String name, Class<?> type) {
        this(name, name, type);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getDescription();

    public String getUnit(Sequence sequence) {
        return null;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean separateChannel() {
        return false;
    }

    public boolean needRecompute(SequenceEvent change) {
        return false;
    }

    public boolean needRecompute(ROIEvent change) {
        return change.getType() == ROIEvent.ROIEventType.ROI_CHANGED;
    }

    public abstract Object compute(ROI var1, Sequence var2) throws UnsupportedOperationException, InterruptedException;

    public boolean equals(Object obj) {
        if (obj instanceof ROIDescriptor) {
            return StringUtil.equals(((ROIDescriptor)obj).getId(), this.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

