/*
 * Decompiled with CFR 0.152.
 */
package icy.system;

import icy.system.IcyExceptionHandler;
import icy.util.StringUtil;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public class ClassPatcher {
    private static final String ARG_RESULT = "result";
    private final ClassPool pool = ClassPool.getDefault();
    private final String patchPackage;
    private final String patchSuffix;

    public ClassPatcher(ClassLoader classLoader, String patchPackage, String patchSuffix) {
        this.pool.appendClassPath((ClassPath)new ClassClassPath(this.getClass()));
        if (classLoader != null) {
            this.pool.appendClassPath((ClassPath)new LoaderClassPath(classLoader));
        }
        this.patchPackage = patchPackage;
        this.patchSuffix = patchSuffix;
    }

    public ClassPatcher(String patchPackage, String patchSuffix) {
        this(null, patchPackage, patchSuffix);
    }

    public void insertAfterMethod(String fullClass, String methodSig) {
        this.insertAfterMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void insertAfterMethod(String fullClass, String methodSig, String newCode) {
        try {
            this.getMethod(fullClass, methodSig).insertAfter(newCode);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot modify method: " + methodSig, e);
        }
    }

    public void insertBeforeMethod(String fullClass, String methodSig) {
        this.insertBeforeMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void insertBeforeMethod(String fullClass, String methodSig, String newCode) {
        try {
            this.getMethod(fullClass, methodSig).insertBefore(newCode);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot modify method: " + methodSig, e);
        }
    }

    public void insertMethod(String fullClass, String methodSig) {
        this.insertMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void insertMethod(String fullClass, String methodSig, String newCode) {
        CtClass classRef = this.getClass(fullClass);
        String methodBody = methodSig + " { " + newCode + " } ";
        try {
            CtMethod methodRef = CtNewMethod.make((String)methodBody, (CtClass)classRef);
            classRef.addMethod(methodRef);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot add method: " + methodSig, e);
        }
    }

    public void replaceMethod(String fullClass, String methodSig) {
        this.replaceMethod(fullClass, methodSig, this.newCode(fullClass, methodSig));
    }

    public void replaceMethod(String fullClass, String methodSig, String newCode) {
        try {
            this.getMethod(fullClass, methodSig).setBody(newCode);
        }
        catch (CannotCompileException e) {
            throw new IllegalArgumentException("Cannot modify method: " + methodSig, e);
        }
    }

    public Class<?> loadClass(String fullClass) {
        CtClass classRef = this.getClass(fullClass);
        try {
            return classRef.toClass();
        }
        catch (CannotCompileException e) {
            IcyExceptionHandler.showErrorMessage(e, false);
            System.err.println("Cannot load class: " + fullClass);
            return null;
        }
    }

    public Class<?> loadClass(String fullClass, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        CtClass classRef = this.getClass(fullClass);
        try {
            return classRef.toClass(classLoader, protectionDomain);
        }
        catch (CannotCompileException e) {
            IcyExceptionHandler.showErrorMessage(e, false);
            System.err.println("Cannot load class: " + fullClass);
            return null;
        }
    }

    private CtClass getClass(String fullClass) {
        try {
            return this.pool.get(fullClass);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such class: " + fullClass, e);
        }
    }

    private CtMethod getMethod(String fullClass, String methodSig) {
        CtClass cc = this.getClass(fullClass);
        String name = this.getMethodName(methodSig);
        String[] argTypes = this.getMethodArgTypes(methodSig, false);
        CtClass[] params = new CtClass[argTypes.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getClass(argTypes[i]);
        }
        try {
            return cc.getDeclaredMethod(name, params);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("No such method: " + methodSig, e);
        }
    }

    private String newCode(String fullClass, String methodSig) {
        int dotIndex = fullClass.lastIndexOf(".");
        String className = fullClass.substring(dotIndex + 1);
        String methodName = this.getMethodName(methodSig);
        boolean isStatic = this.isStatic(methodSig);
        boolean isVoid = this.isVoid(methodSig);
        StringBuilder newCode = new StringBuilder((isVoid ? "" : "return ") + this.patchPackage + "." + className + this.patchSuffix + "." + methodName + "(");
        boolean firstArg = true;
        if (!isStatic) {
            newCode.append("this");
            firstArg = false;
        }
        int i = 1;
        for (String argName : this.getMethodArgNames(methodSig, true)) {
            if (firstArg) {
                firstArg = false;
            } else {
                newCode.append(", ");
            }
            if (StringUtil.equals(argName, ARG_RESULT)) {
                newCode.append("$_");
                continue;
            }
            newCode.append("$" + i);
            ++i;
        }
        newCode.append(");");
        return newCode.toString();
    }

    private String getMethodName(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        int spaceIndex = methodSig.lastIndexOf(" ", parenIndex);
        return methodSig.substring(spaceIndex + 1, parenIndex);
    }

    private String[] getMethodArgs(String methodSig, boolean wantResult) {
        String[] args;
        ArrayList<String> result = new ArrayList<String>();
        int parenIndex = methodSig.indexOf("(");
        String methodArgs = methodSig.substring(parenIndex + 1, methodSig.length() - 1);
        for (String arg : args = methodArgs.equals("") ? new String[]{} : methodArgs.split(",")) {
            String a = arg.trim();
            if (StringUtil.equals(a.split(" ")[1], ARG_RESULT) && !wantResult) continue;
            result.add(a);
        }
        return result.toArray(new String[result.size()]);
    }

    private String[] getMethodArgTypes(String methodSig, boolean wantResult) {
        String[] args = this.getMethodArgs(methodSig, wantResult);
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].split(" ")[0];
        }
        return args;
    }

    private String[] getMethodArgNames(String methodSig, boolean wantResult) {
        String[] args = this.getMethodArgs(methodSig, wantResult);
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].split(" ")[1];
        }
        return args;
    }

    private boolean isStatic(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        String methodPrefix = methodSig.substring(0, parenIndex);
        for (String token : methodPrefix.split(" ")) {
            if (!token.equals("static")) continue;
            return true;
        }
        return false;
    }

    private boolean isVoid(String methodSig) {
        int parenIndex = methodSig.indexOf("(");
        String methodPrefix = methodSig.substring(0, parenIndex);
        return methodPrefix.startsWith("void ") || methodPrefix.indexOf(" void ") > 0;
    }
}

