/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection.array;

import icy.type.DataType;
import icy.type.TypeUtil;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.Array2DUtil;
import icy.type.collection.array.Array3DUtil;
import icy.type.collection.array.ArrayDataType;
import icy.type.collection.array.ArrayType;
import java.lang.reflect.Array;

public class ArrayUtil {
    @Deprecated
    public static ArrayDataType getArrayDataType(Object array) {
        int dim = 0;
        Class<?> arrayClass = array.getClass();
        while (arrayClass.isArray()) {
            ++dim;
            arrayClass = arrayClass.getComponentType();
        }
        return new ArrayDataType(DataType.getDataType(arrayClass), dim);
    }

    public static ArrayType getArrayType(Object array) {
        int dim = 0;
        Class<?> arrayClass = array.getClass();
        while (arrayClass.isArray()) {
            ++dim;
            arrayClass = arrayClass.getComponentType();
        }
        return new ArrayType(DataType.getDataType(arrayClass), dim);
    }

    public static int getDim(Object array) {
        int result = 0;
        Class<?> arrayClass = array.getClass();
        while (arrayClass.isArray()) {
            ++result;
            arrayClass = arrayClass.getComponentType();
        }
        return result;
    }

    public static DataType getDataType(Object array) {
        Class<?> arrayClass = array.getClass();
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
        }
        return DataType.getDataType(arrayClass);
    }

    public static DataType getDataType(Object array, boolean signed) {
        DataType result = ArrayUtil.getDataType(array);
        if (signed) {
            return result;
        }
        switch (result) {
            case BYTE: {
                return DataType.UBYTE;
            }
            case SHORT: {
                return DataType.USHORT;
            }
            case INT: {
                return DataType.UINT;
            }
            case LONG: {
                return DataType.ULONG;
            }
        }
        return result;
    }

    public static int getLength(Object array) {
        if (array != null) {
            return Array.getLength(array);
        }
        return 0;
    }

    @Deprecated
    public static int getLenght(Object array) {
        return ArrayUtil.getLength(array);
    }

    public static int getTotalLength(Object array) {
        int result = 1;
        Object subArray = array;
        Class<?> arrayClass = array.getClass();
        while (arrayClass.isArray()) {
            arrayClass = arrayClass.getComponentType();
            if ((result *= Array.getLength(subArray)) <= 0) continue;
            subArray = Array.get(array, 0);
        }
        return result;
    }

    @Deprecated
    public static int getTotalLenght(Object array) {
        return ArrayUtil.getTotalLength(array);
    }

    @Deprecated
    public static Object createArray1D(int dataType, int len) {
        return Array1DUtil.createArray(dataType, len);
    }

    @Deprecated
    public static Object createArray2D(int dataType, int len) {
        return Array2DUtil.createArray(dataType, len);
    }

    @Deprecated
    public static Object createArray3D(int dataType, int len) {
        return Array3DUtil.createArray(dataType, len);
    }

    public static Object createArray(DataType dataType, int dim, int len) {
        int[] dims = new int[dim];
        dims[0] = len;
        return Array.newInstance(dataType.toPrimitiveClass(), dims);
    }

    public static Object createArray(ArrayType arrayType, int len) {
        return ArrayUtil.createArray(arrayType.getDataType(), arrayType.getDim(), len);
    }

    public static Object allocIfNull(Object array, ArrayType arrayType, int len) {
        if (array == null) {
            return ArrayUtil.createArray(arrayType, len);
        }
        return array;
    }

    public static Object[] encapsulate(Object array) {
        ArrayType type = ArrayUtil.getArrayType(array);
        type.setDim(type.getDim() + 1);
        Object[] result = (Object[])ArrayUtil.createArray(type, 1);
        result[0] = array;
        return result;
    }

    @Deprecated
    public static double getValue(Object array, int offset, boolean signed) {
        return ArrayUtil.getValue(array, offset, TypeUtil.getDataType(array), signed);
    }

    @Deprecated
    public static double getValue(Object array, int offset, int dataType, boolean signed) {
        return Array1DUtil.getValue(array, offset, dataType, signed);
    }

    @Deprecated
    public static float getValueAsFloat(Object array, int offset, boolean signed) {
        return ArrayUtil.getValueAsFloat(array, offset, TypeUtil.getDataType(array), signed);
    }

    @Deprecated
    public static float getValueAsFloat(Object array, int offset, int dataType, boolean signed) {
        return Array1DUtil.getValueAsFloat(array, offset, dataType, signed);
    }

    @Deprecated
    public static int getValueAsInt(Object array, int offset, boolean signed) {
        return ArrayUtil.getValueAsInt(array, offset, TypeUtil.getDataType(array), signed);
    }

    @Deprecated
    public static int getValueAsInt(Object array, int offset, int dataType, boolean signed) {
        return Array1DUtil.getValueAsInt(array, offset, dataType, signed);
    }

    @Deprecated
    public static void setValue(Object array, int offset, double value) {
        ArrayUtil.setValue(array, offset, TypeUtil.getDataType(array), value);
    }

    @Deprecated
    public static void setValue(Object array, int offset, int dataType, double value) {
        Array1DUtil.setValue(array, offset, dataType, value);
    }

    public static boolean arrayTypeCompare(Object array1, Object array2) {
        return ArrayUtil.getArrayType(array1).equals(ArrayUtil.getArrayType(array2));
    }

    public static boolean arrayCompare(Object array1, Object array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        ArrayType type = ArrayUtil.getArrayType(array1);
        if (!type.equals(ArrayUtil.getArrayType(array2))) {
            return false;
        }
        int dim = type.getDim();
        if (dim > 2) {
            int len = Array.getLength(array1);
            if (len != Array.getLength(array2)) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (ArrayUtil.arrayCompare(Array.get(array1, i), Array.get(array2, i))) continue;
                return false;
            }
            return true;
        }
        switch (type.getDataType().getJavaType()) {
            case BYTE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.arrayByteCompare((byte[])array1, (byte[])array2);
                    }
                    case 2: {
                        return Array2DUtil.arrayByteCompare((byte[][])array1, (byte[][])array2);
                    }
                }
                break;
            }
            case SHORT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.arrayShortCompare((short[])array1, (short[])array2);
                    }
                    case 2: {
                        return Array2DUtil.arrayShortCompare((short[][])array1, (short[][])array2);
                    }
                }
                break;
            }
            case INT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.arrayIntCompare((int[])array1, (int[])array2);
                    }
                    case 2: {
                        return Array2DUtil.arrayIntCompare((int[][])array1, (int[][])array2);
                    }
                }
                break;
            }
            case LONG: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.arrayLongCompare((long[])array1, (long[])array2);
                    }
                    case 2: {
                        return Array2DUtil.arrayLongCompare((long[][])array1, (long[][])array2);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.arrayFloatCompare((float[])array1, (float[])array2);
                    }
                    case 2: {
                        return Array2DUtil.arrayFloatCompare((float[][])array1, (float[][])array2);
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.arrayDoubleCompare((double[])array1, (double[])array2);
                    }
                    case 2: {
                        return Array2DUtil.arrayDoubleCompare((double[][])array1, (double[][])array2);
                    }
                }
            }
        }
        return false;
    }

    @Deprecated
    public static void fill(Object array, int from, int to, double value) {
        Array1DUtil.fill(array, from, to, value);
    }

    @Deprecated
    public static void innerCopy(Object array, int from, int to, int cnt) {
        Array1DUtil.innerCopy(array, from, to, cnt);
    }

    public static Object toArray1D(Object in, Object out, int offset) {
        ArrayType type = ArrayUtil.getArrayType(in);
        DataType dataType = type.getDataType();
        int dim = type.getDim();
        if (dim > 3) {
            Object result = Array1DUtil.allocIfNull(out, dataType, offset + ArrayUtil.getTotalLength(in));
            if (in != null) {
                int len = Array.getLength(in);
                int off = offset;
                for (int i = 0; i < len; ++i) {
                    Object s_in = Array.get(in, i);
                    if (s_in == null) continue;
                    ArrayUtil.toArray1D(s_in, result, off);
                    off += Array.getLength(s_in);
                }
            }
        }
        switch (dataType.getJavaType()) {
            case BYTE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.toByteArray1D((byte[])in, (byte[])out, offset);
                    }
                    case 2: {
                        return Array2DUtil.toByteArray1D((byte[][])in, (byte[])out, offset);
                    }
                    case 3: {
                        return Array3DUtil.toByteArray1D((byte[][][])in, (byte[])out, offset);
                    }
                }
                break;
            }
            case SHORT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.toShortArray1D((short[])in, (short[])out, offset);
                    }
                    case 2: {
                        return Array2DUtil.toShortArray1D((short[][])in, (short[])out, offset);
                    }
                    case 3: {
                        return Array3DUtil.toShortArray1D((short[][][])in, (short[])out, offset);
                    }
                }
                break;
            }
            case INT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.toIntArray1D((int[])in, (int[])out, offset);
                    }
                    case 2: {
                        return Array2DUtil.toIntArray1D((int[][])in, (int[])out, offset);
                    }
                    case 3: {
                        return Array3DUtil.toIntArray1D((int[][][])in, (int[])out, offset);
                    }
                }
                break;
            }
            case LONG: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.toLongArray1D((long[])in, (long[])out, offset);
                    }
                    case 2: {
                        return Array2DUtil.toLongArray1D((long[][])in, (long[])out, offset);
                    }
                    case 3: {
                        return Array3DUtil.toLongArray1D((long[][][])in, (long[])out, offset);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.toFloatArray1D((float[])in, (float[])out, offset);
                    }
                    case 2: {
                        return Array2DUtil.toFloatArray1D((float[][])in, (float[])out, offset);
                    }
                    case 3: {
                        return Array3DUtil.toFloatArray1D((float[][][])in, (float[])out, offset);
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.toDoubleArray1D((double[])in, (double[])out, offset);
                    }
                    case 2: {
                        return Array2DUtil.toDoubleArray1D((double[][])in, (double[])out, offset);
                    }
                    case 3: {
                        return Array3DUtil.toDoubleArray1D((double[][][])in, (double[])out, offset);
                    }
                }
            }
        }
        return out;
    }

    static int getCopyLength(Object in, int inOffset, Object out, int outOffset, int length) {
        if (length == -1) {
            return ArrayUtil.getCopyLength(in, inOffset, out, outOffset);
        }
        return length;
    }

    public static int getCopyLength(Object in, int inOffset, Object out, int outOffset) {
        int len = ArrayUtil.getCopyLength(in, inOffset);
        if (out == null) {
            return len;
        }
        return Math.min(len, ArrayUtil.getCopyLength(out, outOffset));
    }

    public static int getCopyLength(Object array, int offset) {
        return ArrayUtil.getLength(array) - offset;
    }

    public static Object arrayToArray(Object in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        ArrayType type = ArrayUtil.getArrayType(in);
        int dim = type.getDim();
        if (dim > 2) {
            int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
            Object result = ArrayUtil.allocIfNull(out, type, outOffset + len);
            for (int i = 0; i < len; ++i) {
                Array.set(result, i + outOffset, ArrayUtil.arrayToArray(Array.get(in, i + inOffset), 0, Array.get(result, i + outOffset), 0, -1, signed));
            }
            return result;
        }
        switch (type.getDataType().getJavaType()) {
            case BYTE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.byteArrayToArray((byte[])in, inOffset, out, outOffset, length, signed);
                    }
                    case 2: {
                        return Array2DUtil.byteArrayToArray((byte[][])in, inOffset, out, outOffset, length, signed);
                    }
                }
                break;
            }
            case SHORT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.shortArrayToArray((short[])in, inOffset, out, outOffset, length, signed);
                    }
                    case 2: {
                        return Array2DUtil.shortArrayToArray((short[][])in, inOffset, out, outOffset, length, signed);
                    }
                }
                break;
            }
            case INT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.intArrayToArray((int[])in, inOffset, out, outOffset, length, signed);
                    }
                    case 2: {
                        return Array2DUtil.intArrayToArray((int[][])in, inOffset, out, outOffset, length, signed);
                    }
                }
                break;
            }
            case LONG: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.longArrayToArray((long[])in, inOffset, out, outOffset, length, signed);
                    }
                    case 2: {
                        return Array2DUtil.longArrayToArray((long[][])in, inOffset, out, outOffset, length, signed);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.floatArrayToArray((float[])in, inOffset, out, outOffset, length);
                    }
                    case 2: {
                        return Array2DUtil.floatArrayToArray((float[][])in, inOffset, out, outOffset, length);
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.doubleArrayToArray((double[])in, inOffset, out, outOffset, length);
                    }
                    case 2: {
                        return Array2DUtil.doubleArrayToArray((double[][])in, inOffset, out, outOffset, length);
                    }
                }
            }
        }
        return out;
    }

    public static Object arrayToArray(Object in, Object out, boolean signed) {
        return ArrayUtil.arrayToArray(in, 0, out, 0, -1, signed);
    }

    @Deprecated
    public static Object doubleArrayToArray1D(double[] in, int inOffset, Object out, int outOffset, int length) {
        return Array1DUtil.doubleArrayToArray(in, inOffset, out, outOffset, length);
    }

    @Deprecated
    public static Object doubleArrayToArray1D(double[] in, Object out) {
        return Array1DUtil.doubleArrayToArray(in, out);
    }

    @Deprecated
    public static Object floatArrayToArray1D(float[] in, int inOffset, Object out, int outOffset, int length) {
        return Array1DUtil.floatArrayToArray(in, inOffset, out, outOffset, length);
    }

    @Deprecated
    public static Object floatArrayToArray1D(float[] in, Object out) {
        return Array1DUtil.floatArrayToArray(in, out);
    }

    @Deprecated
    public static Object intArrayToArray1D(int[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.intArrayToArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object intArrayToArray1D(int[] in, Object out, boolean signed) {
        return Array1DUtil.intArrayToArray(in, out, signed);
    }

    @Deprecated
    public static Object shortArrayToArray1D(short[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.shortArrayToArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object shortArrayToArray1D(short[] in, Object out, boolean signed) {
        return Array1DUtil.shortArrayToArray(in, out, signed);
    }

    @Deprecated
    public static Object byteArrayToArray1D(byte[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.byteArrayToArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object doubleArrayToArray2D(double[][] in, int inOffset, Object out, int outOffset, int length) {
        return Array2DUtil.doubleArrayToArray(in, inOffset, out, outOffset, length);
    }

    @Deprecated
    public static Object doubleArrayToArray2D(double[][] in, Object out) {
        return Array2DUtil.doubleArrayToArray(in, out);
    }

    @Deprecated
    public static Object floatArrayToArray2D(float[][] in, int inOffset, Object out, int outOffset, int length) {
        return Array2DUtil.floatArrayToArray(in, inOffset, out, outOffset, length);
    }

    @Deprecated
    public static Object floatArrayToArray2D(float[][] in, Object out) {
        return Array2DUtil.floatArrayToArray(in, out);
    }

    @Deprecated
    public static Object intArrayToArray2D(int[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.intArrayToArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object intArrayToArray2D(int[][] in, Object out, boolean signed) {
        return Array2DUtil.intArrayToArray(in, out, signed);
    }

    @Deprecated
    public static Object shortArrayToArray2D(short[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.shortArrayToArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object shortArrayToArray2D(short[][] in, Object out, boolean signed) {
        return Array2DUtil.shortArrayToArray(in, out, signed);
    }

    @Deprecated
    public static Object byteArrayToArray2D(byte[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.byteArrayToArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object byteArrayToArray2D(byte[][] in, Object out, boolean signed) {
        return Array2DUtil.byteArrayToArray(in, out, signed);
    }

    @Deprecated
    public static double[] arrayToDoubleArray1D(Object in, int inOffset, double[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToDoubleArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static double[] arrayToDoubleArray1D(Object in, double[] out, boolean signed) {
        return Array1DUtil.arrayToDoubleArray(in, out, signed);
    }

    @Deprecated
    public static double[] arrayToDoubleArray1D(Object in, boolean signed) {
        return Array1DUtil.arrayToDoubleArray(in, signed);
    }

    @Deprecated
    public static double[][] arrayToDoubleArray2D(Object in, int inOffset, double[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToDoubleArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static double[][] arrayToDoubleArray2D(Object in, double[][] out, boolean signed) {
        return Array2DUtil.arrayToDoubleArray(in, out, signed);
    }

    @Deprecated
    public static double[][] arrayToDoubleArray2D(Object in, boolean signed) {
        return Array2DUtil.arrayToDoubleArray(in, signed);
    }

    @Deprecated
    public static float[] arrayToFloatArray1D(Object in, int inOffset, float[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToFloatArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static float[] arrayToFloatArray1D(Object in, float[] out, boolean signed) {
        return Array1DUtil.arrayToFloatArray(in, out, signed);
    }

    @Deprecated
    public static float[] arrayToFloatArray1D(Object in, boolean signed) {
        return Array1DUtil.arrayToFloatArray(in, signed);
    }

    @Deprecated
    public static float[][] arrayToFloatArray2D(Object in, int inOffset, float[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToFloatArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static float[][] arrayToFloatArray2D(Object in, float[][] out, boolean signed) {
        return Array2DUtil.arrayToFloatArray(in, out, signed);
    }

    @Deprecated
    public static float[][] arrayToFloatArray2D(Object in, boolean signed) {
        return Array2DUtil.arrayToFloatArray(in, signed);
    }

    @Deprecated
    public static int[] arrayToIntArray1D(Object in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToIntArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static int[] arrayToIntArray1D(Object in, int[] out, boolean signed) {
        return Array1DUtil.arrayToIntArray(in, out, signed);
    }

    @Deprecated
    public static int[] arrayToIntArray1D(Object in, boolean signed) {
        return Array1DUtil.arrayToIntArray(in, signed);
    }

    @Deprecated
    public static int[][] arrayToIntArray2D(Object in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToIntArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static int[][] arrayToIntArray2D(Object in, int[][] out, boolean signed) {
        return Array2DUtil.arrayToIntArray(in, out, signed);
    }

    @Deprecated
    public static int[][] arrayToIntArray2D(Object in, boolean signed) {
        return Array2DUtil.arrayToIntArray(in, signed);
    }

    @Deprecated
    public static short[] arrayToShortArray1D(Object in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToShortArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static short[] arrayToShortArray1D(Object in, short[] out, boolean signed) {
        return Array1DUtil.arrayToShortArray(in, out, signed);
    }

    @Deprecated
    public static short[] arrayToShortArray1D(Object in, boolean signed) {
        return Array1DUtil.arrayToShortArray(in, signed);
    }

    @Deprecated
    public static short[][] arrayToShortArray2D(Object in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToShortArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static short[][] arrayToShortArray2D(Object in, short[][] out, boolean signed) {
        return Array2DUtil.arrayToShortArray(in, out, signed);
    }

    @Deprecated
    public static short[][] arrayToShortArray2D(Object in, boolean signed) {
        return Array2DUtil.arrayToShortArray(in, signed);
    }

    @Deprecated
    public static byte[] arrayToByteArray1D(Object in, int inOffset, byte[] out, int outOffset, int length) {
        return Array1DUtil.arrayToByteArray(in, inOffset, out, outOffset, length);
    }

    @Deprecated
    public static byte[] arrayToByteArray1D(Object in, byte[] out) {
        return Array1DUtil.arrayToByteArray(in, out);
    }

    @Deprecated
    public static byte[] arrayToByteArray1D(Object in) {
        return Array1DUtil.arrayToByteArray(in);
    }

    @Deprecated
    public static byte[][] arrayToByteArray2D(Object in, int inOffset, byte[][] out, int outOffset, int length) {
        return Array2DUtil.arrayToByteArray(in, inOffset, out, outOffset, length);
    }

    @Deprecated
    public static byte[][] arrayToByteArray2D(Object in, byte[][] out) {
        return Array2DUtil.arrayToByteArray(in, out);
    }

    @Deprecated
    public static byte[][] arrayToByteArray2D(Object in) {
        return Array2DUtil.arrayToByteArray(in);
    }

    public static Object arrayToDoubleArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToDoubleArray(array, signed);
            }
            case 2: {
                return Array2DUtil.arrayToDoubleArray(array, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.DOUBLE, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToDoubleArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToFloatArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToFloatArray(array, signed);
            }
            case 2: {
                return Array2DUtil.arrayToFloatArray(array, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.FLOAT, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToFloatArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToLongArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToIntArray(array, signed);
            }
            case 2: {
                return Array2DUtil.arrayToIntArray(array, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.LONG, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToLongArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToIntArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToIntArray(array, signed);
            }
            case 2: {
                return Array2DUtil.arrayToIntArray(array, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.INT, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToIntArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToShortArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToShortArray(array, signed);
            }
            case 2: {
                return Array2DUtil.arrayToShortArray(array, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.SHORT, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToShortArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToByteArray(Object array) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToByteArray(array);
            }
            case 2: {
                return Array2DUtil.arrayToByteArray(array);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.BYTE, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToByteArray(Array.get(array, i)));
        }
        return result;
    }

    public static Object arrayToSafeArray(Object in, int inOffset, Object out, int outOffset, int length, boolean srcSigned, boolean dstSigned) {
        ArrayType type = ArrayUtil.getArrayType(in);
        int dim = type.getDim();
        if (dim > 2) {
            int len = ArrayUtil.getCopyLength(in, inOffset, out, outOffset, length);
            Object result = ArrayUtil.allocIfNull(out, type, outOffset + len);
            for (int i = 0; i < len; ++i) {
                Array.set(result, i + outOffset, ArrayUtil.arrayToSafeArray(Array.get(in, i + inOffset), 0, Array.get(result, i + outOffset), 0, -1, srcSigned, dstSigned));
            }
            return result;
        }
        switch (type.getDataType().getJavaType()) {
            case BYTE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.byteArrayToSafeArray((byte[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                    case 2: {
                        return Array2DUtil.byteArrayToSafeArray((byte[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                }
                break;
            }
            case SHORT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.shortArrayToSafeArray((short[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                    case 2: {
                        return Array2DUtil.shortArrayToSafeArray((short[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                }
                break;
            }
            case INT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.intArrayToSafeArray((int[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                    case 2: {
                        return Array2DUtil.intArrayToSafeArray((int[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                }
                break;
            }
            case LONG: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.longArrayToSafeArray((long[])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                    case 2: {
                        return Array2DUtil.longArrayToSafeArray((long[][])in, inOffset, out, outOffset, length, srcSigned, dstSigned);
                    }
                }
                break;
            }
            case FLOAT: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.floatArrayToSafeArray((float[])in, inOffset, out, outOffset, length, dstSigned);
                    }
                    case 2: {
                        return Array2DUtil.floatArrayToSafeArray((float[][])in, inOffset, out, outOffset, length, dstSigned);
                    }
                }
                break;
            }
            case DOUBLE: {
                switch (dim) {
                    case 1: {
                        return Array1DUtil.doubleArrayToSafeArray((double[])in, inOffset, out, outOffset, length, dstSigned);
                    }
                    case 2: {
                        return Array2DUtil.doubleArrayToSafeArray((double[][])in, inOffset, out, outOffset, length, dstSigned);
                    }
                }
            }
        }
        return out;
    }

    @Deprecated
    public static Object arrayToSafeArray(Object in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return ArrayUtil.arrayToSafeArray(in, inOffset, out, outOffset, length, signed, signed);
    }

    public static Object arrayToSafeArray(Object in, Object out, boolean srcSigned, boolean dstSigned) {
        return ArrayUtil.arrayToSafeArray(in, 0, out, 0, -1, srcSigned, dstSigned);
    }

    @Deprecated
    public static Object arrayToSafeArray(Object in, Object out, boolean signed) {
        return ArrayUtil.arrayToSafeArray(in, 0, out, 0, -1, signed, signed);
    }

    @Deprecated
    public static Object doubleArrayToSafeArray1D(double[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.doubleArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object doubleArrayToSafeArray1D(double[] in, Object out, boolean signed) {
        return Array1DUtil.doubleArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static Object doubleArrayToSafeArray2D(double[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.doubleArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object doubleArrayToSafeArray2D(double[][] in, Object out, boolean signed) {
        return Array2DUtil.doubleArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static Object floatArrayToSafeArray1D(float[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.floatArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object floatArrayToSafeArray1D(float[] in, Object out, boolean signed) {
        return Array1DUtil.floatArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static Object floatArrayToSafeArray2D(float[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.floatArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object floatArrayToSafeArray2D(float[][] in, Object out, boolean signed) {
        return Array2DUtil.floatArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static Object intArrayToSafeArray1D(int[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.intArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object intArrayToSafeArray1D(int[] in, Object out, boolean signed) {
        return Array1DUtil.intArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static Object intArrayToSafeArray2D(int[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.intArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object intArrayToSafeArray2D(int[][] in, Object out, boolean signed) {
        return Array2DUtil.intArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static Object shortArrayToSafeArray1D(short[] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array1DUtil.shortArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object shortArrayToSafeArray1D(short[] in, Object out, boolean signed) {
        return Array1DUtil.shortArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static Object shortArrayToSafeArray2D(short[][] in, int inOffset, Object out, int outOffset, int length, boolean signed) {
        return Array2DUtil.shortArrayToSafeArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static Object shortArrayToSafeArray2D(short[][] in, Object out, boolean signed) {
        return Array2DUtil.shortArrayToSafeArray(in, out, signed);
    }

    @Deprecated
    public static int[] arrayToSafeIntArray1D(Object in, int inOffset, int[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToSafeIntArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static int[] arrayToSafeIntArray1D(Object in, int[] out, boolean signed) {
        return Array1DUtil.arrayToSafeIntArray(in, out, signed);
    }

    @Deprecated
    public static int[][] arrayToSafeIntArray2D(Object in, int inOffset, int[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToSafeIntArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static int[][] arrayToSafeIntArray2D(Object in, int[][] out, boolean signed) {
        return Array2DUtil.arrayToSafeIntArray(in, out, signed);
    }

    @Deprecated
    public static short[] arrayToSafeShortArray1D(Object in, int inOffset, short[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToSafeShortArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static short[] arrayToSafeShortArray1D(Object in, short[] out, boolean signed) {
        return Array1DUtil.arrayToSafeShortArray(in, out, signed);
    }

    @Deprecated
    public static short[][] arrayToSafeShortArray2D(Object in, int inOffset, short[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToSafeShortArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static short[][] arrayToSafeShortArray2D(Object in, short[][] out, boolean signed) {
        return Array2DUtil.arrayToSafeShortArray(in, out, signed);
    }

    @Deprecated
    public static byte[] arrayToSafeByteArray1D(Object in, int inOffset, byte[] out, int outOffset, int length, boolean signed) {
        return Array1DUtil.arrayToSafeByteArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static byte[] arrayToSafeByteArray1D(Object in, byte[] out, boolean signed) {
        return Array1DUtil.arrayToSafeByteArray(in, out, signed);
    }

    @Deprecated
    public static byte[][] arrayToSafeByteArray2D(Object in, int inOffset, byte[][] out, int outOffset, int length, boolean signed) {
        return Array2DUtil.arrayToSafeByteArray(in, inOffset, out, outOffset, length, signed);
    }

    @Deprecated
    public static byte[][] arrayToSafeByteArray2D(Object in, byte[][] out, boolean signed) {
        return Array2DUtil.arrayToSafeByteArray(in, out, signed);
    }

    public static Object arrayToSafeLongArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToSafeLongArray(array, null, signed);
            }
            case 2: {
                return Array2DUtil.arrayToSafeLongArray(array, null, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.LONG, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToSafeLongArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToSafeIntArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToSafeIntArray(array, null, signed);
            }
            case 2: {
                return Array2DUtil.arrayToSafeIntArray(array, null, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.INT, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToSafeIntArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToSafeShortArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToSafeShortArray(array, null, signed);
            }
            case 2: {
                return Array2DUtil.arrayToSafeShortArray(array, null, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.SHORT, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToSafeIntArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static Object arrayToSafeByteArray(Object array, boolean signed) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToSafeByteArray(array, null, signed);
            }
            case 2: {
                return Array2DUtil.arrayToSafeByteArray(array, null, signed);
            }
        }
        int len = Array.getLength(array);
        Object result = ArrayUtil.createArray(DataType.BYTE, dim, len);
        for (int i = 0; i < len; ++i) {
            Array.set(result, i, ArrayUtil.arrayToSafeIntArray(Array.get(array, i), signed));
        }
        return result;
    }

    public static String arrayToString(Object array) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToString(array);
            }
        }
        return null;
    }

    public static String array1DToString(Object array, boolean signed, boolean hexa, String separator, int size) {
        if (array == null) {
            return null;
        }
        int dim = ArrayUtil.getDim(array);
        switch (dim) {
            case 1: {
                return Array1DUtil.arrayToString(array, signed, hexa, separator, size);
            }
        }
        return null;
    }

    public static Object stringToArray1D(String value, DataType dataType) {
        return Array1DUtil.stringToArray(value, dataType);
    }

    @Deprecated
    public static Object stringToArray1D(String value, int dataType) {
        return ArrayUtil.stringToArray1D(value, DataType.getDataType(dataType));
    }

    public static Object stringToArray1D(String value, DataType dataType, boolean hexa, String separator) {
        return Array1DUtil.stringToArray(value, dataType, hexa, separator);
    }

    @Deprecated
    public static Object stringToArray1D(String value, int dataType, boolean hexa, String separator) {
        return ArrayUtil.stringToArray1D(value, DataType.getDataType(dataType), hexa, separator);
    }

    public static int[] createLinearIntArray(int size, int initialValue, int step) {
        int[] array = new int[size];
        int value = initialValue;
        for (int i = 0; i < size; ++i) {
            array[i] = value;
            value += step;
        }
        return array;
    }

    public static double[] createLinearDoubleArray(int size, double initialValue, double step) {
        double[] array = new double[size];
        double value = initialValue;
        for (int i = 0; i < size; ++i) {
            array[i] = value;
            value += step;
        }
        return array;
    }

    @Deprecated
    public static byte[] toByteArray1D(boolean[] array) {
        return Array1DUtil.toByteArray(array, null, 0);
    }

    @Deprecated
    public static byte[] toByteArray1D(boolean[] in, byte[] out, int offset) {
        return Array1DUtil.toByteArray(in, out, offset);
    }

    @Deprecated
    public static boolean[] toBooleanArray1D(byte[] array) {
        return Array1DUtil.toBooleanArray(array);
    }

    @Deprecated
    public static boolean[] toBooleanArray1D(byte[] in, boolean[] out, int offset) {
        return Array1DUtil.toBooleanArray(in, out, offset);
    }
}

