/*
 * Decompiled with CFR 0.152.
 */
package icy.type.value;

import icy.file.xml.XMLPersistent;
import icy.util.XMLUtil;
import java.util.ArrayList;
import org.w3c.dom.Node;

public abstract class AbstractValue<T>
implements Comparable<T>,
XMLPersistent {
    protected static final String ID_VALUE = "value";
    protected T value;
    private final ArrayList<ValueChangeListener<T>> listeners;

    public AbstractValue(T value) {
        this.value = value;
        this.listeners = new ArrayList();
    }

    public AbstractValue() {
        this.value = this.getDefaultValue();
        this.listeners = new ArrayList();
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        if (!this.value.equals(value)) {
            this.value = value;
            this.changed();
        }
    }

    public abstract boolean loadFromString(String var1);

    public abstract T getDefaultValue();

    public void loadFromString(String s, T def) {
        if (!this.loadFromString(s)) {
            this.value = def;
        }
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setElementValue(node, ID_VALUE, this.value.toString());
        return true;
    }

    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        return this.loadFromString(XMLUtil.getElementValue(node, ID_VALUE, ""));
    }

    private void changed() {
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ValueChangeListener<T> listener) {
        ArrayList<ValueChangeListener<T>> arrayList = this.listeners;
        synchronized (arrayList) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ValueChangeListener<T> listener) {
        ArrayList<ValueChangeListener<T>> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent() {
        ArrayList<ValueChangeListener<T>> listenersCopy;
        ArrayList<ValueChangeListener<T>> arrayList = this.listeners;
        synchronized (arrayList) {
            listenersCopy = new ArrayList<ValueChangeListener<T>>(this.listeners);
        }
        for (ValueChangeListener valueChangeListener : listenersCopy) {
            valueChangeListener.valueChanged(this);
        }
    }

    public static interface ValueChangeListener<T> {
        public void valueChanged(AbstractValue<T> var1);
    }
}

