/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base;

import mitiv.base.Shape;
import mitiv.base.Shaped;
import mitiv.base.Traits;
import mitiv.base.Typed;

public class ArrayDescriptor
implements Shaped,
Typed {
    final int type;
    final int number;
    final Shape shape;

    public ArrayDescriptor(int type, int ... dims) {
        this(type, new Shape(dims));
    }

    public ArrayDescriptor(int type, Shape shape) {
        this.type = type;
        this.shape = shape;
        if (this.shape.number() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Total number of elements is too large");
        }
        this.number = (int)this.shape.number();
    }

    public static int computeNumber(int[] shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Illegal NULL shape");
        }
        int number = 1;
        for (int r = 0; r < shape.length; ++r) {
            if (shape[r] <= 0) {
                throw new IllegalArgumentException("Bad dimension length");
            }
            number *= shape[r];
        }
        return number;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public final int getRank() {
        return this.shape.rank();
    }

    @Override
    public final int getNumber() {
        return this.number;
    }

    @Override
    public final int getDimension(int k) {
        return this.shape.dimension(k);
    }

    @Override
    public final Shape getShape() {
        return this.shape;
    }

    public final boolean equals(ArrayDescriptor other) {
        return other == this || other.type == this.type && other.shape.equals(this.shape);
    }

    public String toString() {
        return Traits.nameOf(this.type) + this.shape.toString();
    }
}

