/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.lang.reflect.Array;
import java.util.Locale;
import mitiv.array.ArrayFactory;
import mitiv.array.ShapedArray;
import mitiv.base.ArrayDescriptor;
import mitiv.base.Traits;
import mitiv.exception.IllegalTypeException;
import mitiv.linalg.shaped.ShapedVector;

public class ArrayReflection {
    public static Class<?> deepComponentType(Object o) {
        Class<?> c = o.getClass();
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    public static int getDepth(Object o) {
        int depth = 0;
        Class<?> c = o.getClass();
        while (c.isArray()) {
            c = c.getComponentType();
            ++depth;
        }
        return depth;
    }

    public static long countElements(Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> sub = obj.getClass().getComponentType();
        if (sub == null) {
            return 1L;
        }
        int len = Array.getLength(obj);
        if (sub.isArray()) {
            long count = 0L;
            for (int i = 0; i < len; ++i) {
                count += ArrayReflection.countElements(Array.get(obj, i));
            }
            return count;
        }
        return len;
    }

    public static int recursiveCopy(Object dst, int off, Object src) {
        if (src != null) {
            Class<?> sub = src.getClass().getComponentType();
            if (sub == null) {
                Array.set(dst, off++, src);
            } else {
                int len = Array.getLength(src);
                if (sub.isArray()) {
                    for (int i = 0; i < len; ++i) {
                        off = ArrayReflection.recursiveCopy(dst, off, Array.get(src, i));
                    }
                } else {
                    System.arraycopy(src, 0, dst, off, len);
                    off += len;
                }
            }
        }
        return off;
    }

    public static Object flatten(Object obj) {
        return ArrayReflection.flatten(obj, false);
    }

    public static Object flatten(Object obj, boolean forceCopy) {
        Class<?> c;
        if (!forceCopy && (c = obj.getClass()).isArray() && !c.getComponentType().isArray()) {
            return obj;
        }
        Object arr = null;
        long count = ArrayReflection.countElements(obj);
        int length = (int)count;
        if ((long)length != count) {
            throw new IndexOutOfBoundsException("Too many components to store in a flat array");
        }
        arr = Array.newInstance(ArrayReflection.deepComponentType(obj), length);
        ArrayReflection.recursiveCopy(arr, 0, obj);
        return arr;
    }

    public static Object flatten(boolean value) {
        return new boolean[]{value};
    }

    public static Object flatten(char value) {
        return new char[]{value};
    }

    public static Object flatten(byte value) {
        return new byte[]{value};
    }

    public static Object flatten(short value) {
        return new short[]{value};
    }

    public static Object flatten(int value) {
        return new int[]{value};
    }

    public static Object flatten(long value) {
        return new long[]{value};
    }

    public static Object flatten(float value) {
        return new float[]{value};
    }

    public static Object flatten(double value) {
        return new double[]{value};
    }

    public static Object flatten(boolean value, boolean forceCopy) {
        return new boolean[]{value};
    }

    public static Object flatten(char value, boolean forceCopy) {
        return new char[]{value};
    }

    public static Object flatten(byte value, boolean forceCopy) {
        return new byte[]{value};
    }

    public static Object flatten(short value, boolean forceCopy) {
        return new short[]{value};
    }

    public static Object flatten(int value, boolean forceCopy) {
        return new int[]{value};
    }

    public static Object flatten(long value, boolean forceCopy) {
        return new long[]{value};
    }

    public static Object flatten(float value, boolean forceCopy) {
        return new float[]{value};
    }

    public static Object flatten(double value, boolean forceCopy) {
        return new double[]{value};
    }

    private static void checkLengths(Object arr, int[] dims, int k) {
        if (k >= 1) {
            int n = dims[k];
            int p = dims[k - 1];
            for (int i = 0; i < n; ++i) {
                Object sub = Array.get(arr, i);
                if (sub == null) {
                    ArrayReflection.emptyDimension();
                }
                if (Array.getLength(sub) != p) {
                    ArrayReflection.nonRectangular();
                }
                if (k < 2) continue;
                ArrayReflection.checkLengths(sub, dims, k - 1);
            }
        }
    }

    public static ArrayDescriptor makeArrayDescriptor(Object obj) {
        int type;
        Class<?> c = obj.getClass();
        int rank = 0;
        int[] dims = null;
        while (c.isArray()) {
            c = c.getComponentType();
            ++rank;
        }
        if (rank == 0) {
            dims = null;
        } else {
            dims = new int[rank];
            int k = rank;
            Object arr = obj;
            while (true) {
                dims[--k] = Array.getLength(arr);
                if (k <= 0) break;
                if ((arr = Array.get(arr, 0)) != null) continue;
                ArrayReflection.emptyDimension();
            }
            ArrayReflection.checkLengths(obj, dims, rank - 1);
        }
        if (c.equals(Byte.TYPE)) {
            type = 0;
        } else if (c.equals(Short.TYPE)) {
            type = 1;
        } else if (c.equals(Integer.TYPE)) {
            type = 2;
        } else if (c.equals(Long.TYPE)) {
            type = 3;
        } else if (c.equals(Float.TYPE)) {
            type = 4;
        } else if (c.equals(Double.TYPE)) {
            type = 5;
        } else {
            throw new IllegalTypeException("Only numerical primitive types are supported");
        }
        return new ArrayDescriptor(type, dims);
    }

    public ShapedArray makeShapedArray(ShapedArray arr) {
        return arr;
    }

    public ShapedArray makeShapedArray(ShapedVector vec) {
        return vec.asShapedArray();
    }

    public ShapedArray makeShapedArray(Object obj) {
        ArrayDescriptor descr = ArrayReflection.makeArrayDescriptor(obj);
        Object data = ArrayReflection.flatten(obj);
        switch (descr.getType()) {
            case 0: {
                return ArrayFactory.wrap((byte[])data, descr.getShape());
            }
            case 1: {
                return ArrayFactory.wrap((short[])data, descr.getShape());
            }
            case 2: {
                return ArrayFactory.wrap((int[])data, descr.getShape());
            }
            case 3: {
                return ArrayFactory.wrap((long[])data, descr.getShape());
            }
            case 4: {
                return ArrayFactory.wrap((float[])data, descr.getShape());
            }
            case 5: {
                return ArrayFactory.wrap((double[])data, descr.getShape());
            }
        }
        throw new IllegalTypeException("Only numerical primitive types are supported");
    }

    private static void emptyDimension() {
        throw new IllegalArgumentException("Arrays with empty dimension(s) are not supported");
    }

    private static void nonRectangular() {
        throw new IllegalArgumentException("Only rectangular arrays are supported");
    }

    public static void main(String[] args) {
        int i3;
        Locale.setDefault(Locale.US);
        int n1 = 7;
        int n2 = 8;
        int n3 = 9;
        int[][][] arr = new int[n3][n2][];
        for (i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                arr[i3][i2] = new int[n1];
            }
        }
        int i = 0;
        for (i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    arr[i3][i2][i1] = i++;
                }
            }
        }
        String name = arr.getClass().getName();
        System.out.println("isArray: " + (arr.getClass().isArray() ? "true" : "false"));
        System.out.format("rank: %d\n", Array.getLength(arr));
        System.out.println(ArrayReflection.deepComponentType(arr));
        System.out.println(name);
        System.out.println(name.length());
        ArrayDescriptor tmp = ArrayReflection.makeArrayDescriptor(arr);
        System.out.format("type = %s, rank = %d, dims = {", Traits.nameOf(tmp.getType()), tmp.getRank());
        for (int k = 0; k < tmp.getRank(); ++k) {
            System.out.format(k == 0 ? "%d" : ",%d", tmp.getDimension(k));
        }
        System.out.format("}\n", new Object[0]);
        int[] a = (int[])ArrayReflection.flatten(arr);
        int nerrs = 0;
        int i2 = 0;
        for (int i32 = 0; i32 < n3; ++i32) {
            for (int i22 = 0; i22 < n2; ++i22) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (arr[i32][i22][i1] == a[i2++]) continue;
                    ++nerrs;
                }
            }
        }
        System.out.format("# of errors: %d\n", nerrs);
        float[] x = (float[])Array.newInstance(Float.TYPE, 1);
        x[0] = 3.9f;
        System.out.format("x[0]: %g\n", Float.valueOf(x[0]));
        x = (float[])ArrayReflection.flatten(new float[]{5.0f});
        System.out.format("x[0]: %g\n", Float.valueOf(x[0]));
        long value = 11L;
        Object o = ArrayReflection.flatten(value);
        System.out.format("# of components: %d\n", Array.getLength(o));
        System.out.format("is array: %b\n", o.getClass().isArray());
        System.out.format("type of components: %s\n", o.getClass().getComponentType().toString());
        long[] b = (long[])ArrayReflection.flatten(value);
        System.out.format("# of components: %d\n", b.length);
        System.out.format("b[0]: %d\n", b[0]);
        short[] c = new short[]{1, 2, 3, 4};
        short[] d = (short[])ArrayReflection.flatten(c);
        short[] e = (short[])ArrayReflection.flatten(c, true);
        d[2] = 100;
        e[2] = 200;
        System.out.format("c[...] = {%d,%d,%d,%d}\n", c[0], c[1], c[2], c[3]);
        System.out.format("d[...] = {%d,%d,%d,%d}\n", d[0], d[1], d[2], d[3]);
        System.out.format("e[...] = {%d,%d,%d,%d}\n", e[0], e[1], e[2], e[3]);
    }
}

