/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

public class Poly {
    static final double THIRD = 0.3333333333333333;
    static final double HALF = 0.5;
    static final double TWO_PI_OVER_THREE = 2.0943951023931953;

    public static int solveQuadratic(double[] x, double a, double b, double c) {
        if (a != 0.0) {
            double p = a + a;
            double q = c + c;
            double r = b * b - p * q;
            if (r > 0.0) {
                double x1;
                r = b >= 0.0 ? -Math.sqrt(r) - b : Math.sqrt(r) - b;
                double x0 = q / r;
                if (x0 < (x1 = r / p)) {
                    x[0] = x0;
                    x[1] = x1;
                } else {
                    x[0] = x1;
                    x[1] = x0;
                }
                return 2;
            }
            if (r == 0.0) {
                x[0] = x[1] = -b / p;
                return 1;
            }
        } else if (b != 0.0) {
            x[0] = x[1] = -c / b;
            return 1;
        }
        return 0;
    }

    public static int solveCubic(double[] x, double a, double b, double c) {
        double t2 = a * a;
        double t = 0.3333333333333333 * a;
        double r = (t2 - 0.5 * b) * t + 0.5 * c;
        double r2 = r * r;
        double q = t2 - 0.3333333333333333 * b;
        double q3 = q * q * q;
        if (r2 < q3) {
            double xt;
            double phi = 0.3333333333333333 * Math.acos(r / Math.sqrt(q3));
            double rho = -2.0 * Math.sqrt(q);
            double x0 = rho * Math.cos(phi) - t;
            double x1 = rho * Math.cos(phi - 2.0943951023931953) - t;
            double x2 = rho * Math.cos(phi + 2.0943951023931953) - t;
            if (x0 > x1) {
                xt = x0;
                x0 = x1;
                x1 = xt;
            }
            if (x0 > x2) {
                xt = x0;
                x0 = x2;
                x2 = xt;
            }
            if (x1 > x2) {
                xt = x1;
                x1 = x2;
                x2 = xt;
            }
            x[0] = x0;
            x[1] = x1;
            x[2] = x2;
            return 3;
        }
        double s = Math.sqrt(r2 - q3);
        double p = r >= 0.0 ? -Math.cbrt(r + s) : Math.cbrt(s - r);
        x[0] = p == 0.0 ? -t : p + q / p - t;
        return 1;
    }
}

