/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui;

import icy.system.thread.ThreadUtil;
import java.awt.Dimension;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarListener;

public abstract class VarEditor<V>
implements VarListener<V> {
    protected final Var<V> variable;
    private final Object editorComponent;
    private boolean nameVisible = true;
    private boolean componentFocusable = true;
    private boolean componentResizeable = false;

    public VarEditor(Var<V> variable) {
        this.variable = variable;
        this.editorComponent = this.createEditorComponent();
    }

    protected abstract Object createEditorComponent();

    public Object getEditorComponent() {
        return this.editorComponent;
    }

    public abstract Dimension getPreferredSize();

    public double getComponentHorizontalResizeFactor() {
        return 1.0;
    }

    public double getComponentVerticalResizeFactor() {
        return 0.0;
    }

    public abstract void setComponentToolTipText(String var1);

    public Var<V> getVariable() {
        return this.variable;
    }

    public boolean isComponentEnabled() {
        return true;
    }

    public boolean isComponentOpaque() {
        return true;
    }

    public boolean isComponentFocusable() {
        return this.componentFocusable;
    }

    public boolean isComponentResizeable() {
        return this.componentResizeable;
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    protected abstract void activateListeners();

    protected abstract void deactivateListeners();

    public void setComponentFocusable(boolean componentFocusable) {
        this.componentFocusable = componentFocusable;
    }

    public void setComponentResizeable(boolean componentResizeable) {
        this.componentResizeable = componentResizeable;
    }

    public void setEnabled(boolean enabled) {
        this.variable.removeListener(this);
        this.deactivateListeners();
        if (this.editorComponent != null) {
            this.setEditorEnabled(enabled && this.variable.isEnabled());
        }
        if (enabled && this.editorComponent != null) {
            this.variable.addListener(this);
            this.activateListeners();
            this.updateInterfaceValue();
        }
    }

    protected abstract void setEditorEnabled(boolean var1);

    public void setNameVisible(boolean nameVisible) {
        this.nameVisible = nameVisible;
    }

    protected abstract void updateInterfaceValue();

    public void dispose() {
        this.setEnabled(false);
    }

    @Override
    public void valueChanged(Var<V> source, V oldValue, V newValue) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VarEditor.this.updateInterfaceValue();
            }
        });
    }

    @Override
    public void referenceChanged(Var<V> source, Var<? extends V> oldReference, Var<? extends V> newReference) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                VarEditor.this.updateInterfaceValue();
            }
        });
    }
}

