/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.lang;

import icy.file.xml.XMLPersistent;
import icy.system.IcyHandledException;
import icy.util.XMLUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.model.ValueSelectionModel;
import plugins.adufour.vars.gui.model.VarEditorModel;
import plugins.adufour.vars.gui.swing.ComboBox;
import plugins.adufour.vars.gui.swing.Label;
import plugins.adufour.vars.lang.VarMutable;
import plugins.adufour.vars.lang.VarObject;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.vars.util.VarListener;
import plugins.adufour.vars.util.VarReferencingPolicy;

public class Var<T>
implements XMLPersistent,
VarListener<T> {
    public static final String XML_KEY_ID = "ID";
    static final String XML_KEY_VALUE = "value";
    public static final String NO_VALUE = "No value";
    private final String name;
    private boolean optional = false;
    private boolean enabled = true;
    protected Class<T> type;
    private final T defaultValue;
    private T value;
    private VarReferencingPolicy referencingPolicy = VarReferencingPolicy.BOTH;
    private Var<? extends T> reference;
    private final List<Var<? super T>> referrers = new ArrayList<Var<? super T>>();
    protected VarEditorModel<T> defaultEditorModel;
    protected final List<VarListener<T>> listeners = new ArrayList<VarListener<T>>();

    public Var(String name, T defaultValue) throws NullPointerException {
        this(name, defaultValue, null);
    }

    public Var(String name, T defaultValue, VarListener<T> defaultListener) throws NullPointerException {
        this(name, defaultValue.getClass(), defaultValue, defaultListener);
    }

    public Var(String name, Class<T> type) {
        this(name, type, null, null);
    }

    @Deprecated
    public Var(String name, Class<T> type, T defaultValue) {
        this(name, type, defaultValue, null);
    }

    public Var(String name, Class<T> type, T defaultValue, VarListener<T> defaultListener) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
        if (defaultListener != null) {
            this.addListener(defaultListener);
        }
    }

    public Var(String name, VarEditorModel<T> editorModel) {
        this(name, editorModel.getDefaultValue().getClass(), editorModel.getDefaultValue(), null);
        this.defaultEditorModel = editorModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(VarListener<T> listener) {
        List<VarListener<T>> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    private void addReferrer(Var<? super T> referrer) {
        this.referrers.add(referrer);
    }

    public VarEditor<T> createVarEditor() {
        if (this.getDefaultEditorModel() instanceof ValueSelectionModel) {
            return new ComboBox(this);
        }
        if (this.getDefaultEditorModel() == null) {
            return new Label(this);
        }
        throw new UnsupportedOperationException("A " + this.getClass().getSimpleName() + " cannot be edited with a " + this.getDefaultEditorModel().getClass().getSimpleName());
    }

    public VarEditor<T> createVarEditor(boolean enable) {
        VarEditor<T> editor = this.createVarEditor();
        if (enable) {
            editor.setEnabled(true);
        }
        return editor;
    }

    public VarEditor<T> createVarViewer() {
        Label label = new Label(this);
        label.getEditorComponent().setHorizontalAlignment(0);
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireVariableChanged(Var<? extends T> oldRef, Var<? extends T> newRef) {
        ArrayList<VarListener<T>> listenersCopy;
        List<VarListener<T>> list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<VarListener<T>>(this.listeners);
        }
        for (VarListener varListener : listenersCopy) {
            varListener.referenceChanged(this, oldRef, newRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireVariableChanged(T oldValue, T newValue) {
        ArrayList<VarListener<T>> listenersCopy;
        List<VarListener<T>> list = this.listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<VarListener<T>>(this.listeners);
        }
        for (VarListener varListener : listenersCopy) {
            varListener.valueChanged(this, oldValue, newValue);
        }
    }

    public VarEditorModel<T> getDefaultEditorModel() {
        return this.defaultEditorModel;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Var<? extends T> getReference() {
        return this.reference;
    }

    public Iterator<Var<? super T>> getReferrers() {
        return this.referrers.iterator();
    }

    public Iterable<Var<? super T>> getIterableReferrers() {
        return new Iterable<Var<? super T>>(){

            @Override
            public Iterator<Var<? super T>> iterator() {
                return Var.this.getReferrers();
            }
        };
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isReferenced() {
        return this.referrers.size() > 0;
    }

    public Class<T> getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.getType() == null ? "No type" : this.getType().getSimpleName();
    }

    public T getValue() {
        return this.getValue(false);
    }

    public T getValue(boolean forbidNull) throws VarException {
        T returnValue;
        T t = returnValue = this.reference == null ? this.value : this.reference.getValue();
        if (returnValue == null && forbidNull) {
            throw new VarException(this, "No value specified");
        }
        return returnValue;
    }

    public String getValueAsString(boolean followReference) {
        return this.reference != null && followReference ? this.reference.getValueAsString(followReference) : this.getValueAsString();
    }

    public String getValueAsString() {
        T myValue = this.getValue();
        if (myValue == null) {
            return "";
        }
        if (myValue.getClass().isArray()) {
            int length = Array.getLength(myValue);
            if (length == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            Object arrayValue = Array.get(myValue, 0);
            sb.append(arrayValue == null ? "null" : arrayValue.toString());
            for (int i = 1; i < length; ++i) {
                arrayValue = Array.get(myValue, i);
                sb.append(" " + (arrayValue == null ? "null" : arrayValue.toString()));
            }
            return sb.toString();
        }
        return myValue.toString();
    }

    public boolean isAssignableFrom(Var<?> source) {
        if (source.getType() == null) {
            return false;
        }
        return this.getType().isAssignableFrom(source.getType());
    }

    public boolean loadFromXML(Node node) {
        String xmlValue = null;
        try {
            xmlValue = XMLUtil.getAttributeValue((Element)((Element)node), (String)XML_KEY_VALUE, (String)"");
            if (xmlValue.isEmpty()) {
                return true;
            }
            T newValue = this.parse(xmlValue);
            this.setValue(newValue);
            return true;
        }
        catch (UnsupportedOperationException e) {
            if (xmlValue != null) {
                String message = "Warning: unable to read value \"" + xmlValue + "\" into variable \"" + this.name + "\" of type ";
                message = message + (this instanceof VarMutable ? "VarMutable (" + ((VarMutable)this).getTypeAsString() + ")" : this.getClass().getSimpleName());
                System.err.println(message);
            }
            this.setValue(null);
            return true;
        }
        catch (NullPointerException npE) {
            return false;
        }
    }

    public T parse(String text) {
        throw new UnsupportedOperationException("Parsing operation not supported for type " + this.getClass().getSimpleName());
    }

    public String prettyPrint(String separator) {
        T myValue = this.getValue();
        if (myValue == null) {
            return NO_VALUE;
        }
        if (!myValue.getClass().isArray()) {
            return myValue.toString();
        }
        int length = Array.getLength(myValue);
        if (length == 0) {
            return "Empty list";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Array.get(myValue, 0).toString());
        for (int i = 1; i < length; ++i) {
            sb.append(separator + Array.get(myValue, i).toString());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(VarListener<T> listener) {
        List<VarListener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners() {
        List<VarListener<T>> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReferrer(Var<? super T> referrer) throws ConcurrentModificationException {
        List<Var<? super T>> list = this.referrers;
        synchronized (list) {
            this.referrers.remove(referrer);
        }
    }

    public boolean saveToXML(Node node) throws UnsupportedOperationException {
        XMLUtil.setAttributeValue((Element)((Element)node), (String)XML_KEY_VALUE, (String)(this.value == null ? "" : this.getValueAsString()));
        return true;
    }

    public void setDefaultEditorModel(VarEditorModel<T> model) {
        this.defaultEditorModel = model;
        if (model != null) {
            this.setValue(model.getDefaultValue());
        }
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setReference(Var<T> variable) throws ClassCastException {
        boolean change;
        if (this.referencingPolicy == VarReferencingPolicy.OUT || this.referencingPolicy == VarReferencingPolicy.NONE) {
            throw new IcyHandledException("Error: variable '" + this.name + "' is not allowed to reference another one");
        }
        if (variable != null && !this.isAssignableFrom(variable) && !(variable instanceof VarObject)) {
            throw new ClassCastException(this + " cannot point to " + variable);
        }
        boolean bl = change = this.reference != variable;
        if (change) {
            Var<T> oldRef = this.reference;
            if (oldRef != null) {
                oldRef.removeListener(this);
                super.removeReferrer(this);
            }
            this.reference = variable;
            if (variable != null) {
                variable.addListener(this);
                super.addReferrer(this);
            }
            this.fireVariableChanged((T)oldRef, (T)this.reference);
        }
    }

    public void setReferencingPolicy(VarReferencingPolicy policy) {
        this.referencingPolicy = policy;
    }

    public VarReferencingPolicy getReferencingPolicy() {
        return this.referencingPolicy;
    }

    public void setValueAsString(String newValue) {
        this.setValue(this.parse(newValue));
    }

    public void setValue(T newValue) throws IllegalArgumentException {
        if (this.value == null && newValue == null) {
            return;
        }
        if (this.value != null && this.value.equals(newValue)) {
            return;
        }
        boolean changed = true;
        if (this.reference != null) {
            T referenceValue = this.reference.getValue();
            if (referenceValue == null) {
                if (newValue == null) {
                    changed = false;
                }
            } else if (this.areValuesEqual(referenceValue, newValue)) {
                changed = false;
            }
            if (changed) {
                System.err.println("Warning: cannot assign a value to \"" + this.name + "\": it is pointing to another variable");
            } else {
                this.value = newValue;
            }
            return;
        }
        T oldValue = this.value;
        this.value = newValue;
        this.fireVariableChanged(oldValue, newValue);
    }

    protected boolean areValuesEqual(T a, Object b) {
        return a.equals(b);
    }

    public String toString() {
        String s = "[" + this.getName() + ", type=" + this.getClass().getSimpleName();
        s = s + (this.reference == null ? ", value=" + this.getValueAsString() + "]" : "] points to " + this.reference.toString());
        return s;
    }

    @Override
    public void valueChanged(Var<T> source, T oldValue, T newValue) {
        this.fireVariableChanged(oldValue, newValue);
    }

    @Override
    public void referenceChanged(Var<T> source, Var<? extends T> oldReference, Var<? extends T> newReference) {
    }
}

