/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.VirtualStack;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.io.FileInfo;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.util.DicomTools;
import ij.util.StringSorter;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.io.File;
import java.util.Properties;

public class FolderOpener
implements PlugIn {
    private static String[] excludedTypes = new String[]{".txt", ".lut", ".roi", ".pty", ".hdr", ".java", ".ijm", ".py", ".js", ".bsh", ".xml"};
    private static boolean staticSortFileNames = true;
    private static boolean staticOpenAsVirtualStack;
    private boolean convertToRGB;
    private boolean sortFileNames = true;
    private boolean sortByMetaData = true;
    private boolean openAsVirtualStack;
    private double scale = 100.0;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private String legacyRegex;
    private FileInfo fi;
    private String info1;
    private ImagePlus image;
    private boolean saveImage;
    private long t0;

    public static ImagePlus open(String path) {
        return FolderOpener.open(path, null);
    }

    public static ImagePlus open(String path, String options) {
        if (options == null) {
            options = "";
        }
        FolderOpener fo = new FolderOpener();
        fo.saveImage = true;
        if (options != null) {
            boolean bl = fo.openAsVirtualStack = options.contains("virtual") || options.contains("use");
            if (options.contains("noMetaSort")) {
                fo.sortByMetaData = false;
            }
        }
        fo.filter = Macro.getValue(options, "file", "");
        fo.run(path);
        return fo.image;
    }

    public ImagePlus openFolder(String path) {
        this.saveImage = true;
        this.run(path);
        return this.image;
    }

    @Override
    public void run(String arg) {
        Overlay overlay;
        boolean allSameCalibration;
        Calibration cal;
        double max;
        double min;
        ImageStack stack;
        String title;
        String[] list;
        String directory;
        block97: {
            int index;
            boolean isMacro = Macro.getOptions() != null;
            directory = null;
            if (arg != null && !arg.equals("")) {
                directory = arg;
            } else {
                if (!isMacro) {
                    this.sortFileNames = staticSortFileNames;
                    this.openAsVirtualStack = staticOpenAsVirtualStack;
                }
                arg = null;
                String title2 = "Open Image Sequence...";
                String macroOptions = Macro.getOptions();
                if (macroOptions != null) {
                    File f;
                    directory = Macro.getValue(macroOptions, title2, null);
                    if (directory != null && !(f = new File(directory = OpenDialog.lookupPathVariable(directory))).isDirectory() && (f.exists() || directory.lastIndexOf(".") > directory.length() - 5)) {
                        directory = f.getParent();
                    }
                    this.legacyRegex = Macro.getValue(macroOptions, "or", "");
                    if (this.legacyRegex.equals("")) {
                        this.legacyRegex = null;
                    }
                }
                if (directory == null) {
                    if (Prefs.useFileChooser && !IJ.isMacOSX()) {
                        OpenDialog od = new OpenDialog(title2, arg);
                        directory = od.getDirectory();
                        String name = od.getFileName();
                        if (name == null) {
                            return;
                        }
                    } else {
                        directory = IJ.getDirectory(title2);
                    }
                }
            }
            if (directory == null) {
                return;
            }
            if (!directory.endsWith("/") && !directory.endsWith(File.separator)) {
                directory = directory + "/";
            }
            if ((list = new File(directory).list()) == null) {
                IJ.error("File>Import>Image Sequence", "Directory not found: " + directory);
                return;
            }
            title = directory;
            if (title.endsWith(File.separator) || title.endsWith("/")) {
                title = title.substring(0, title.length() - 1);
            }
            if ((index = title.lastIndexOf(File.separatorChar)) != -1) {
                title = title.substring(index + 1);
            } else {
                index = title.lastIndexOf("/");
                if (index != -1) {
                    title = title.substring(index + 1);
                }
            }
            if (title.endsWith(":")) {
                title = title.substring(0, title.length() - 1);
            }
            IJ.register(FolderOpener.class);
            list = this.trimFileList(list);
            if (list == null) {
                return;
            }
            if (IJ.debugMode) {
                IJ.log("FolderOpener: " + directory + " (" + list.length + " files)");
            }
            int width = 0;
            int height = 0;
            int stackSize = 1;
            int bitDepth = 0;
            stack = null;
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            cal = null;
            allSameCalibration = true;
            IJ.resetEscape();
            overlay = null;
            this.n = list.length;
            this.start = 1;
            this.increment = 1;
            boolean dicomImages = false;
            try {
                for (int i = 0; i < list.length; ++i) {
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages(true);
                    ImagePlus imp = opener.openImage(directory, list[i]);
                    IJ.redirectErrorMessages(false);
                    if (imp == null) continue;
                    width = imp.getWidth();
                    height = imp.getHeight();
                    bitDepth = imp.getBitDepth();
                    String info = (String)imp.getProperty("Info");
                    if (info != null && info.contains("7FE0,0010")) {
                        dicomImages = true;
                    }
                    if (arg != null || this.showDialog(imp, list)) break;
                    return;
                }
                if (width == 0) {
                    IJ.error("Sequence Reader", "This folder does not appear to contain\nany TIFF, JPEG, BMP, DICOM, GIF, FITS or PGM files.\n \n   \"" + directory + "\"");
                    return;
                }
                String pluginName = "Sequence Reader";
                if (this.legacyRegex != null) {
                    pluginName = pluginName + "(legacy)";
                }
                if ((list = FolderOpener.getFilteredList(list, this.filter, pluginName)) == null) {
                    return;
                }
                IJ.showStatus("");
                this.t0 = System.currentTimeMillis();
                if (this.sortFileNames || dicomImages || IJ.isMacOSX()) {
                    list = StringSorter.sortNumerically(list);
                }
                if (this.n < 1) {
                    this.n = list.length;
                }
                if (this.start < 1 || this.start > list.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > list.length) {
                    this.n = list.length - this.start + 1;
                }
                int count = 0;
                int counter = 0;
                ImagePlus imp = null;
                boolean firstMessage = true;
                boolean fileInfoStack = false;
                for (int i = this.start - 1; i < list.length; ++i) {
                    if (counter++ % this.increment != 0) continue;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    IJ.redirectErrorMessages(true);
                    if ("RoiSet.zip".equals(list[i])) {
                        IJ.open(directory + list[i]);
                        imp = null;
                    } else if (!this.openAsVirtualStack || stack == null) {
                        imp = opener.openImage(directory, list[i]);
                        stackSize = imp != null ? imp.getStackSize() : 1;
                    }
                    IJ.redirectErrorMessages(false);
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        bitDepth = imp.getBitDepth();
                        this.fi = imp.getOriginalFileInfo();
                        ImageProcessor ip = imp.getProcessor();
                        min = ip.getMin();
                        max = ip.getMax();
                        cal = imp.getCalibration();
                        if (this.convertToRGB) {
                            bitDepth = 24;
                        }
                        ColorModel cm = imp.getProcessor().getColorModel();
                        if (this.openAsVirtualStack) {
                            if (stackSize > 1) {
                                stack = new FileInfoVirtualStack();
                                fileInfoStack = true;
                            } else {
                                stack = new VirtualStack(width, height, cm, directory);
                            }
                            ((VirtualStack)stack).setBitDepth(bitDepth);
                        } else {
                            stack = this.scale < 100.0 ? new ImageStack((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0), cm) : new ImageStack(width, height, cm);
                        }
                        this.info1 = (String)imp.getProperty("Info");
                    }
                    if (imp == null) continue;
                    if (imp.getWidth() != width || imp.getHeight() != height) {
                        IJ.log(list[i] + ": wrong size; " + width + "x" + height + " expected, " + imp.getWidth() + "x" + imp.getHeight() + " found");
                        continue;
                    }
                    String label = imp.getTitle();
                    if (stackSize == 1) {
                        String info = (String)imp.getProperty("Info");
                        if (info != null) {
                            if (FolderOpener.useInfo(info)) {
                                label = label + "\n" + info;
                            }
                        } else {
                            String sliceLabel = imp.getStack().getSliceLabel(1);
                            if (FolderOpener.useInfo(sliceLabel)) {
                                label = sliceLabel;
                            }
                        }
                    }
                    if (Math.abs(imp.getCalibration().pixelWidth - cal.pixelWidth) > 1.0E-10) {
                        allSameCalibration = false;
                    }
                    ImageStack inputStack = imp.getStack();
                    Overlay overlay2 = imp.getOverlay();
                    if (overlay2 != null && !this.openAsVirtualStack) {
                        if (overlay == null) {
                            overlay = new Overlay();
                        }
                        for (int j = 0; j < overlay2.size(); ++j) {
                            Roi roi = overlay2.get(j);
                            int position = roi.getPosition();
                            if (position == 0) {
                                roi.setPosition(count + 1);
                            }
                            overlay.add(roi);
                        }
                    }
                    if (this.openAsVirtualStack) {
                        if (fileInfoStack) {
                            this.openAsFileInfoStack((FileInfoVirtualStack)stack, directory + list[i]);
                        } else {
                            ((VirtualStack)stack).addSlice(list[i]);
                        }
                    } else {
                        for (int slice = 1; slice <= stackSize; ++slice) {
                            int bitDepth2 = imp.getBitDepth();
                            String label2 = label;
                            ImageProcessor ip = null;
                            if (stackSize > 1) {
                                String sliceLabel = inputStack.getSliceLabel(slice);
                                if (sliceLabel != null && sliceLabel.length() <= 15) {
                                    label2 = label2 + ":" + sliceLabel;
                                } else if (label2 != null && !label2.equals("")) {
                                    label2 = label2 + ":" + slice;
                                }
                            }
                            ip = inputStack.getProcessor(slice);
                            if (this.convertToRGB) {
                                ip = ip.convertToRGB();
                                bitDepth2 = 24;
                            }
                            if (bitDepth2 != bitDepth) {
                                if (bitDepth == 8 && bitDepth2 == 24) {
                                    ip = ip.convertToByte(true);
                                    bitDepth2 = 8;
                                } else if (bitDepth == 32) {
                                    ip = ip.convertToFloat();
                                    bitDepth2 = 32;
                                } else if (bitDepth == 24) {
                                    ip = ip.convertToRGB();
                                    bitDepth2 = 24;
                                }
                            }
                            if (bitDepth2 != bitDepth) {
                                if (dicomImages && bitDepth == 16 && bitDepth2 == 32 && this.scale == 100.0) {
                                    ip = ip.convertToFloat();
                                    bitDepth = 32;
                                    ImageStack stack2 = new ImageStack(width, height, stack.getColorModel());
                                    for (int n = 1; n <= stack.getSize(); ++n) {
                                        ImageProcessor ip2 = stack.getProcessor(n);
                                        ip2 = ip2.convertToFloat();
                                        ip2.subtract(32768.0);
                                        String sliceLabel = stack.getSliceLabel(n);
                                        stack2.addSlice(sliceLabel, ip2.convertToFloat());
                                    }
                                    stack = stack2;
                                } else {
                                    IJ.log(list[i] + ": wrong bit depth; " + bitDepth + " expected, " + bitDepth2 + " found");
                                    break;
                                }
                            }
                            if (this.scale < 100.0) {
                                ip = ip.resize((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0));
                            }
                            if (ip.getMin() < min) {
                                min = ip.getMin();
                            }
                            if (ip.getMax() > max) {
                                max = ip.getMax();
                            }
                            stack.addSlice(label2, ip);
                        }
                    }
                    IJ.showStatus(++count + "/" + this.n);
                    IJ.showProgress(count, this.n);
                    if (count < this.n) {
                        if (!IJ.escapePressed()) continue;
                        IJ.beep();
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory("FolderOpener");
                if (stack == null) break block97;
                stack.trim();
            }
        }
        if (stack != null && stack.getSize() > 0) {
            Properties props;
            ImagePlus imp2 = new ImagePlus(title, stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            if (this.fi == null) {
                this.fi = new FileInfo();
            }
            this.fi.fileFormat = 0;
            this.fi.fileName = "";
            this.fi.directory = directory;
            imp2.setFileInfo(this.fi);
            imp2.setOverlay(overlay);
            if (stack instanceof VirtualStack && (props = ((VirtualStack)stack).getProperties()) != null) {
                imp2.setProperty("FHT", props.get("FHT"));
            }
            if (allSameCalibration) {
                if (this.scale != 100.0 && cal.scaled()) {
                    cal.pixelWidth /= this.scale / 100.0;
                    cal.pixelHeight /= this.scale / 100.0;
                }
                if (cal.pixelWidth != 1.0 && cal.pixelDepth == 1.0) {
                    cal.pixelDepth = cal.pixelWidth;
                }
                imp2.setCalibration(cal);
            }
            if (this.info1 != null && this.info1.lastIndexOf("7FE0,0010") > 0) {
                if (this.sortByMetaData) {
                    stack = DicomTools.sort(stack);
                }
                imp2.setStack(stack);
                double voxelDepth = DicomTools.getVoxelDepth(stack);
                if (voxelDepth > 0.0) {
                    if (IJ.debugMode) {
                        IJ.log("DICOM voxel depth set to " + voxelDepth + " (" + cal.pixelDepth + ")");
                    }
                    cal.pixelDepth = voxelDepth;
                    imp2.setCalibration(cal);
                }
                if (imp2.getType() == 1 || imp2.getType() == 2) {
                    imp2.getProcessor().setMinAndMax(min, max);
                    imp2.updateAndDraw();
                }
            }
            if (imp2.getStackSize() == 1) {
                imp2.setProperty("Label", list[0]);
                if (this.info1 != null) {
                    imp2.setProperty("Info", this.info1);
                }
            }
            if (arg == null && !this.saveImage) {
                String time = (double)(System.currentTimeMillis() - this.t0) / 1000.0 + " seconds";
                imp2.show(time);
                if (stack.isVirtual() && (overlay = stack.getProcessor(1).getOverlay()) != null) {
                    imp2.setOverlay(overlay);
                }
            }
            if (this.saveImage) {
                this.image = imp2;
            }
        }
        IJ.showProgress(1.0);
        if (Recorder.record) {
            String options;
            String string = options = this.openAsVirtualStack ? "virtual" : "";
            if (this.filter != null && this.filter.length() > 0) {
                if (this.filter.contains(" ")) {
                    this.filter = "[" + this.filter + "]";
                }
                options = options + " file=" + this.filter;
            }
            if (!this.sortByMetaData) {
                options = options + " noMetaSort";
            }
            Recorder.recordCall("imp = FolderOpener.open(\"" + directory + "\", \"" + options + "\");");
        }
    }

    public static boolean useInfo(String info) {
        return info != null && !info.startsWith("Software") && !info.startsWith("ImageDescription");
    }

    private void openAsFileInfoStack(FileInfoVirtualStack stack, String path) {
        FileInfo[] info = Opener.getTiffFileInfo(path);
        if (info == null || info.length == 0) {
            return;
        }
        int n = info[0].nImages;
        if (info.length == 1 && n > 1) {
            long size = this.fi.width * this.fi.height * this.fi.getBytesPerPixel();
            for (int i = 0; i < n; ++i) {
                FileInfo fi = (FileInfo)info[0].clone();
                fi.nImages = 1;
                fi.longOffset = fi.getOffset() + (long)i * (size + fi.getGap());
                stack.addImage(fi);
            }
        } else {
            FileInfo fi = info[0];
            if (fi.fileType == 12) {
                int slice = 1;
                while (slice <= 3) {
                    FileInfo fi2 = (FileInfo)fi.clone();
                    fi2.sliceNumber = slice++;
                    stack.addImage(fi2);
                }
            } else {
                stack.addImage(fi);
            }
        }
    }

    boolean showDialog(ImagePlus imp, String[] list) {
        int fileCount = list.length;
        FolderOpenerDialog gd = new FolderOpenerDialog("Sequence Options", imp, list);
        gd.addNumericField("Number of images:", fileCount, 0);
        gd.addNumericField("Starting image:", 1.0, 0);
        gd.addNumericField("Increment:", 1.0, 0);
        gd.addNumericField("Scale images:", this.scale, 0, 4, "%");
        gd.addStringField("File name contains:", "", 10);
        gd.setInsets(0, 45, 0);
        gd.addMessage("(enclose regex in parens)", null, Color.darkGray);
        gd.addCheckbox("Convert_to_RGB", this.convertToRGB);
        gd.addCheckbox("Sort names numerically", this.sortFileNames);
        gd.addCheckbox("Use virtual stack", this.openAsVirtualStack);
        gd.addMessage("10000 x 10000 x 1000 (100.3MB)");
        gd.addHelp("http://imagej.nih.gov/ij/docs/menus/file.html#seq1");
        gd.setSmartRecording(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.n = (int)gd.getNextNumber();
        this.start = (int)gd.getNextNumber();
        this.increment = (int)gd.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.scale = gd.getNextNumber();
        if (this.scale < 5.0) {
            this.scale = 5.0;
        }
        if (this.scale > 100.0) {
            this.scale = 100.0;
        }
        this.filter = gd.getNextString();
        if (this.legacyRegex != null) {
            this.filter = "(" + this.legacyRegex + ")";
        }
        this.convertToRGB = gd.getNextBoolean();
        this.sortFileNames = gd.getNextBoolean();
        if (!this.sortFileNames) {
            this.sortByMetaData = false;
        }
        this.openAsVirtualStack = gd.getNextBoolean();
        if (this.openAsVirtualStack) {
            this.scale = 100.0;
        }
        if (!IJ.macroRunning()) {
            staticSortFileNames = this.sortFileNames;
            staticOpenAsVirtualStack = this.openAsVirtualStack;
        }
        return true;
    }

    public static String[] getFilteredList(String[] list, String filter, String title) {
        int i;
        boolean isRegex = false;
        if (filter != null && (filter.equals("") || filter.equals("*"))) {
            filter = null;
        }
        if (list == null || filter == null) {
            return list;
        }
        if (title == null) {
            String[] list2 = new String[list.length];
            for (i = 0; i < list.length; ++i) {
                list2[i] = list[i];
            }
            list = list2;
        }
        if (filter.length() >= 2 && filter.startsWith("(") && filter.endsWith(")")) {
            filter = filter.substring(1, filter.length() - 1);
            isRegex = true;
        }
        int filteredImages = 0;
        for (i = 0; i < list.length; ++i) {
            if (isRegex && FolderOpener.containsRegex(list[i], filter, title != null && title.contains("(legacy)"))) {
                ++filteredImages;
                continue;
            }
            if (list[i].contains(filter)) {
                ++filteredImages;
                continue;
            }
            list[i] = null;
        }
        if (filteredImages == 0) {
            if (title != null) {
                if (isRegex) {
                    IJ.error(title, "None of the file names contain the regular expression '" + filter + "'.");
                } else {
                    IJ.error(title, "None of the " + list.length + " files contain '" + filter + "' in the name.");
                }
            }
            return null;
        }
        String[] list2 = new String[filteredImages];
        int j = 0;
        for (int i2 = 0; i2 < list.length; ++i2) {
            if (list[i2] == null) continue;
            list2[j++] = list[i2];
        }
        list = list2;
        return list;
    }

    private static boolean containsRegex(String name, String regex, boolean legacy) {
        boolean contains = false;
        try {
            contains = legacy ? name.matches(regex) : name.replaceAll(regex, "").length() != name.length();
            IJ.showStatus("");
        }
        catch (Exception e) {
            String msg = e.getMessage();
            int index = msg.indexOf("\n");
            if (index > 0) {
                msg = msg.substring(0, index);
            }
            IJ.showStatus("Regex error: " + msg);
            contains = true;
        }
        return contains;
    }

    public String[] trimFileList(String[] rawlist) {
        int count = 0;
        for (int i = 0; i < rawlist.length; ++i) {
            String name = rawlist[i];
            if (name.startsWith(".") || name.equals("Thumbs.db") || FolderOpener.excludedFileType(name)) {
                rawlist[i] = null;
                continue;
            }
            ++count;
        }
        if (count == 0) {
            return null;
        }
        String[] list = rawlist;
        if (count < rawlist.length) {
            list = new String[count];
            int index = 0;
            for (int i = 0; i < rawlist.length; ++i) {
                if (rawlist[i] == null) continue;
                list[index++] = rawlist[i];
            }
        }
        return list;
    }

    public static boolean excludedFileType(String name) {
        if (name == null) {
            return true;
        }
        for (int i = 0; i < excludedTypes.length; ++i) {
            if (!name.endsWith(excludedTypes[i])) continue;
            return true;
        }
        return false;
    }

    public void openAsVirtualStack(boolean b) {
        this.openAsVirtualStack = b;
    }

    public void sortFileNames(boolean b) {
        this.sortFileNames = b;
    }

    public void sortByMetaData(boolean b) {
        this.sortByMetaData = b;
    }

    public String[] sortFileList(String[] list) {
        return StringSorter.sortNumerically(list);
    }

    class FolderOpenerDialog
    extends GenericDialog {
        ImagePlus imp;
        int fileCount;
        boolean eightBits;
        boolean rgb;
        String[] list;

        public FolderOpenerDialog(String title, ImagePlus imp, String[] list) {
            super(title);
            this.imp = imp;
            this.list = list;
            this.fileCount = list.length;
        }

        @Override
        protected void setup() {
            this.eightBits = ((Checkbox)this.checkbox.elementAt(0)).getState();
            this.rgb = ((Checkbox)this.checkbox.elementAt(1)).getState();
            this.setStackInfo();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        @Override
        public void textValueChanged(TextEvent e) {
            this.setStackInfo();
        }

        void setStackInfo() {
            if (this.imp == null) {
                return;
            }
            int width = this.imp.getWidth();
            int height = this.imp.getHeight();
            int depth = this.imp.getStackSize();
            int bytesPerPixel = 1;
            int n = this.getNumber(this.numberField.elementAt(0));
            int start = this.getNumber(this.numberField.elementAt(1));
            int inc = this.getNumber(this.numberField.elementAt(2));
            double scale = this.getNumber(this.numberField.elementAt(3));
            if (scale < 5.0) {
                scale = 5.0;
            }
            if (scale > 100.0) {
                scale = 100.0;
            }
            if (n < 1) {
                n = this.fileCount;
            }
            if (start < 1 || start > this.fileCount) {
                start = 1;
            }
            if (start + n - 1 > this.fileCount) {
                n = this.fileCount - start + 1;
            }
            if (inc < 1) {
                inc = 1;
            }
            TextField tf = (TextField)this.stringField.elementAt(0);
            String filter = tf.getText();
            int n3 = Integer.MAX_VALUE;
            String[] filteredList = FolderOpener.getFilteredList(this.list, filter, null);
            n3 = filteredList != null ? filteredList.length : 0;
            if (n3 < n) {
                n = n3;
            }
            switch (this.imp.getType()) {
                case 1: {
                    bytesPerPixel = 2;
                    break;
                }
                case 2: 
                case 4: {
                    bytesPerPixel = 4;
                }
            }
            if (this.eightBits) {
                bytesPerPixel = 1;
            }
            if (this.rgb) {
                bytesPerPixel = 4;
            }
            width = (int)((double)width * scale / 100.0);
            height = (int)((double)height * scale / 100.0);
            int n2 = (this.fileCount - start + 1) * depth / inc;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > n) {
                n2 = n;
            }
            double size = (double)width * (double)height * (double)n2 * (double)bytesPerPixel / 1048576.0;
            ((Label)this.theLabel).setText(width + " x " + height + " x " + n2 + " (" + IJ.d2s(size, 1) + "MB)");
        }

        public int getNumber(Object field) {
            Double d;
            TextField tf = (TextField)field;
            String theText = tf.getText();
            try {
                d = new Double(theText);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return (int)d.doubleValue();
            }
            return 0;
        }
    }
}

