/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.Resizer;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Scaler
implements PlugIn,
TextListener,
FocusListener {
    private ImagePlus imp;
    private static String xstr = "0.5";
    private static String ystr = "0.5";
    private String zstr = "1.0";
    private static int newWidth;
    private static int newHeight;
    private int newDepth;
    private boolean doZScaling;
    private static boolean averageWhenDownsizing;
    private static boolean newWindow;
    private static int interpolationMethod;
    private String[] methods = ImageProcessor.getInterpolationMethods();
    private static boolean fillWithBackground;
    private static boolean processStack;
    private double xscale;
    private double yscale;
    private double zscale;
    private String title = "Untitled";
    private Vector fields;
    private double bgValue;
    private boolean constainAspectRatio = true;
    private TextField xField;
    private TextField yField;
    private TextField zField;
    private TextField widthField;
    private TextField heightField;
    private TextField depthField;
    private Rectangle r;
    private Object fieldWithFocus;
    private int oldDepth;

    @Override
    public void run(String arg) {
        this.imp = IJ.getImage();
        Roi roi = this.imp.getRoi();
        ImageProcessor ip = this.imp.getProcessor();
        if (roi != null && !roi.isArea()) {
            ip.resetRoi();
        }
        if (!this.showDialog(ip)) {
            return;
        }
        boolean bl = this.doZScaling = this.newDepth > 0 && this.newDepth != this.oldDepth;
        if (this.doZScaling) {
            newWindow = true;
            processStack = true;
        }
        if (ip.getWidth() > 1 && ip.getHeight() > 1 || newWindow) {
            ip.setInterpolationMethod(interpolationMethod);
        } else {
            ip.setInterpolationMethod(0);
        }
        ip.setBackgroundValue(this.bgValue);
        this.imp.startTiming();
        try {
            if (newWindow && this.imp.getStackSize() > 1 && processStack) {
                this.createNewStack(this.imp, ip);
            } else {
                Overlay overlay = this.imp.getOverlay();
                if (this.imp.getHideOverlay()) {
                    overlay = null;
                }
                if (overlay != null && overlay.size() != 1) {
                    overlay = null;
                }
                if (overlay != null) {
                    overlay = overlay.duplicate();
                }
                this.scale(ip, overlay);
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Scale");
        }
        IJ.showProgress(1.0);
    }

    void createNewStack(ImagePlus imp, ImageProcessor ip) {
        Calibration cal;
        int nSlices = imp.getStackSize();
        int w = imp.getWidth();
        int h = imp.getHeight();
        ImagePlus imp2 = imp.createImagePlus();
        Rectangle r = ip.getRoi();
        boolean crop = r.width != imp.getWidth() || r.height != imp.getHeight();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(newWidth, newHeight);
        boolean virtualStack = stack1.isVirtual();
        double min = imp.getDisplayRangeMin();
        double max = imp.getDisplayRangeMax();
        int method = interpolationMethod;
        if (w == 1 || h == 1) {
            method = 0;
        }
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showStatus("Scale: " + i + "/" + nSlices);
            ImageProcessor ip1 = stack1.getProcessor(i);
            String label = stack1.getSliceLabel(i);
            if (crop) {
                ip1.setRoi(r);
                ip1 = ip1.crop();
            }
            ip1.setInterpolationMethod(method);
            ImageProcessor ip2 = ip1.resize(newWidth, newHeight, averageWhenDownsizing);
            if (ip2 != null) {
                stack2.addSlice(label, ip2);
            }
            IJ.showProgress(i, nSlices);
        }
        imp2.setStack(this.title, stack2);
        if (virtualStack) {
            imp2.setDisplayRange(min, max);
        }
        if ((cal = imp2.getCalibration()).scaled()) {
            cal.pixelWidth *= 1.0 / this.xscale;
            cal.pixelHeight *= 1.0 / this.yscale;
        }
        Overlay overlay = imp.getOverlay();
        if (imp.getHideOverlay()) {
            overlay = null;
        }
        if (overlay != null) {
            overlay = overlay.duplicate();
            Overlay overlay2 = new Overlay();
            for (int i = 0; i < overlay.size(); ++i) {
                Roi roi = overlay.get(i);
                Rectangle bounds = roi.getBounds();
                if (!(roi instanceof ImageRoi) || bounds.x != 0 || bounds.y != 0) continue;
                ImageRoi iroi = (ImageRoi)roi;
                ImageProcessor processor = iroi.getProcessor();
                processor.setInterpolationMethod(method);
                processor = processor.resize(newWidth, newHeight, averageWhenDownsizing);
                iroi.setProcessor(processor);
                overlay2.add(iroi);
            }
            if (overlay2.size() > 0) {
                imp2.setOverlay(overlay2);
            }
        }
        IJ.showProgress(1.0);
        int[] dim = imp.getDimensions();
        imp2.setDimensions(dim[2], dim[3], dim[4]);
        if (imp.isComposite()) {
            imp2 = new CompositeImage(imp2, ((CompositeImage)imp).getMode());
            ((CompositeImage)imp2).copyLuts(imp);
        }
        if (imp.isHyperStack()) {
            imp2.setOpenAsHyperStack(true);
        }
        if (this.doZScaling) {
            Resizer resizer = new Resizer();
            resizer.setAverageWhenDownsizing(averageWhenDownsizing);
            imp2 = resizer.zScale(imp2, this.newDepth, interpolationMethod);
        }
        if (imp2 != null) {
            imp2.show();
            imp2.changes = true;
        }
    }

    private void scale(ImageProcessor ip, Overlay overlay) {
        if (newWindow) {
            Rectangle r = ip.getRoi();
            ImagePlus imp2 = this.imp.createImagePlus();
            imp2.setProcessor(this.title, ip.resize(newWidth, newHeight, averageWhenDownsizing));
            Calibration cal = imp2.getCalibration();
            if (cal.scaled()) {
                cal.pixelWidth *= 1.0 / this.xscale;
                cal.pixelHeight *= 1.0 / this.yscale;
            }
            if (overlay != null) {
                Roi roi = overlay.get(0);
                Rectangle bounds = roi.getBounds();
                if (roi instanceof ImageRoi && bounds.x == 0 && bounds.y == 0) {
                    ImageRoi iroi = (ImageRoi)roi;
                    ImageProcessor processor = iroi.getProcessor();
                    processor.setInterpolationMethod(interpolationMethod);
                    processor = processor.resize(newWidth, newHeight, averageWhenDownsizing);
                    iroi.setProcessor(processor);
                    imp2.setOverlay(new Overlay(iroi));
                }
            }
            imp2.show();
            this.imp.trimProcessor();
            imp2.trimProcessor();
            imp2.changes = true;
        } else {
            if (processStack && this.imp.getStackSize() > 1) {
                Undo.reset();
                StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
                sp.scale(this.xscale, this.yscale, this.bgValue);
            } else {
                ip.snapshot();
                Undo.setup(1, this.imp);
                ip.setSnapshotCopyMode(true);
                ip.scale(this.xscale, this.yscale);
                ip.setSnapshotCopyMode(false);
            }
            this.imp.deleteRoi();
            this.imp.updateAndDraw();
            this.imp.changes = true;
        }
    }

    boolean showDialog(ImageProcessor ip) {
        boolean hyperstack;
        boolean isMacro;
        String options = Macro.getOptions();
        boolean bl = isMacro = options != null;
        if (isMacro) {
            if (options.contains(" interpolate")) {
                options = options.replaceAll(" interpolate", " interpolation=Bilinear");
            } else if (!options.contains(" interpolation=")) {
                options = options + " interpolation=None";
            }
            if (options.contains("width=") && options.contains(" height=")) {
                xstr = "-";
                ystr = "-";
                this.zstr = options.contains(" depth=") ? "-" : "1.0";
            }
            Macro.setOptions(options);
        }
        int bitDepth = this.imp.getBitDepth();
        int stackSize = this.imp.getStackSize();
        boolean isStack = stackSize > 1;
        this.oldDepth = stackSize;
        if (isStack && !isMacro) {
            xstr = "1.0";
            ystr = "1.0";
            this.zstr = "1.0";
        }
        this.r = ip.getRoi();
        int width = newWidth;
        if (width == 0) {
            width = this.r.width;
        }
        int height = (int)Math.round((double)width * (double)this.r.height / (double)this.r.width);
        this.xscale = Tools.parseDouble(xstr, 0.0);
        this.yscale = Tools.parseDouble(ystr, 0.0);
        this.zscale = 1.0;
        if (this.xscale != 0.0 && this.yscale != 0.0) {
            width = (int)Math.round((double)this.r.width * this.xscale);
            height = (int)Math.round((double)this.r.height * this.yscale);
        } else {
            xstr = "-";
            ystr = "-";
        }
        GenericDialog gd = new GenericDialog("Scale");
        gd.addStringField("X Scale:", xstr);
        gd.addStringField("Y Scale:", ystr);
        if (isStack) {
            gd.addStringField("Z Scale:", this.zstr);
        }
        gd.setInsets(5, 0, 5);
        gd.addStringField("Width (pixels):", "" + width);
        gd.addStringField("Height (pixels):", "" + height);
        if (isStack) {
            String label = "Depth (images):";
            if (this.imp.isHyperStack()) {
                int slices = this.imp.getNSlices();
                int frames = this.imp.getNFrames();
                if (slices == 1 && frames > 1) {
                    label = "Depth (frames):";
                    this.oldDepth = frames;
                } else {
                    label = "Depth (slices):";
                    this.oldDepth = slices;
                }
            }
            gd.addStringField(label, "" + this.oldDepth);
        }
        this.fields = gd.getStringFields();
        if (this.fields != null) {
            for (int i = 0; i < this.fields.size(); ++i) {
                ((TextField)this.fields.elementAt(i)).addTextListener(this);
                ((TextField)this.fields.elementAt(i)).addFocusListener(this);
            }
            this.xField = (TextField)this.fields.elementAt(0);
            this.yField = (TextField)this.fields.elementAt(1);
            if (isStack) {
                this.zField = (TextField)this.fields.elementAt(2);
                this.widthField = (TextField)this.fields.elementAt(3);
                this.heightField = (TextField)this.fields.elementAt(4);
                this.depthField = (TextField)this.fields.elementAt(5);
            } else {
                this.widthField = (TextField)this.fields.elementAt(2);
                this.heightField = (TextField)this.fields.elementAt(3);
            }
        }
        this.fieldWithFocus = this.xField;
        gd.addChoice("Interpolation:", this.methods, this.methods[interpolationMethod]);
        if (bitDepth == 8 || bitDepth == 24) {
            gd.addCheckbox("Fill with background color", fillWithBackground);
        }
        gd.addCheckbox("Average when downsizing", averageWhenDownsizing);
        boolean bl2 = hyperstack = this.imp.isHyperStack() || this.imp.isComposite();
        if (isStack && !hyperstack) {
            gd.addCheckbox("Process entire stack", processStack);
        }
        gd.addCheckbox("Create new window", newWindow);
        this.title = WindowManager.getUniqueName(this.imp.getTitle());
        gd.setInsets(10, 0, 0);
        gd.addStringField("Title:", this.title, 12);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        xstr = gd.getNextString();
        ystr = gd.getNextString();
        this.xscale = Tools.parseDouble(xstr, 0.0);
        this.yscale = Tools.parseDouble(ystr, 0.0);
        if (isStack) {
            this.zstr = gd.getNextString();
            this.zscale = Tools.parseDouble(this.zstr, 0.0);
        }
        String wstr = gd.getNextString();
        newWidth = (int)Math.round(Tools.parseDouble(wstr, 0.0));
        newHeight = (int)Math.round(Tools.parseDouble(gd.getNextString(), 0.0));
        if (newHeight != 0 && (wstr.equals("-") || wstr.equals("0"))) {
            newWidth = (int)Math.round((double)newHeight * (double)this.r.width / (double)this.r.height);
        } else if (newWidth != 0 && newHeight == 0) {
            newHeight = (int)Math.round((double)newWidth * (double)this.r.height / (double)this.r.width);
        } else if (newHeight != 0 && newWidth == 0) {
            newWidth = (int)Math.round((double)newHeight * (double)this.r.width / (double)this.r.height);
        }
        if (newWidth == 0 || newHeight == 0) {
            IJ.error("Scaler", "Width or height is 0");
            return false;
        }
        if (this.xscale > 0.0 && this.yscale > 0.0) {
            newWidth = (int)Math.round((double)this.r.width * this.xscale);
            newHeight = (int)Math.round((double)this.r.height * this.yscale);
        }
        if (isStack) {
            this.newDepth = (int)Math.round(Tools.parseDouble(gd.getNextString(), 0.0));
            if (this.newDepth == stackSize && this.zscale != 1.0 && this.zscale > 0.0) {
                this.newDepth = (int)Math.round((double)stackSize * this.zscale);
            }
        }
        interpolationMethod = gd.getNextChoiceIndex();
        if (bitDepth == 8 || bitDepth == 24) {
            fillWithBackground = gd.getNextBoolean();
        }
        averageWhenDownsizing = gd.getNextBoolean();
        if (isStack && !hyperstack) {
            processStack = gd.getNextBoolean();
        }
        if (hyperstack) {
            processStack = true;
        }
        newWindow = gd.getNextBoolean();
        if (this.xscale == 0.0) {
            this.xscale = (double)newWidth / (double)this.r.width;
            this.yscale = (double)newHeight / (double)this.r.height;
        }
        gd.setSmartRecording(true);
        this.title = gd.getNextString();
        if (fillWithBackground) {
            Color bgc = Toolbar.getBackgroundColor();
            if (bitDepth == 8) {
                this.bgValue = ip.getBestIndex(bgc);
            } else if (bitDepth == 24) {
                this.bgValue = bgc.getRGB();
            }
        } else {
            this.bgValue = 0.0;
        }
        return true;
    }

    @Override
    public void textValueChanged(TextEvent e) {
        int newDepth;
        if (this.xField == null || this.yField == null) {
            return;
        }
        Object source = e.getSource();
        double newXScale = this.xscale;
        double newYScale = this.yscale;
        double newZScale = this.zscale;
        if (source == this.xField && this.fieldWithFocus == this.xField) {
            String newXText = this.xField.getText();
            newXScale = Tools.parseDouble(newXText, 0.0);
            if (newXScale == 0.0) {
                return;
            }
            if (newXScale != this.xscale) {
                int newWidth = (int)Math.round(newXScale * (double)this.r.width);
                this.widthField.setText("" + newWidth);
                if (this.constainAspectRatio) {
                    this.yField.setText(newXText);
                    int newHeight = (int)Math.round(newXScale * (double)this.r.height);
                    this.heightField.setText("" + newHeight);
                }
            }
        } else if (source == this.yField && this.fieldWithFocus == this.yField) {
            String newYText = this.yField.getText();
            newYScale = Tools.parseDouble(newYText, 0.0);
            if (newYScale == 0.0) {
                return;
            }
            if (newYScale != this.yscale) {
                int newHeight = (int)Math.round(newYScale * (double)this.r.height);
                this.heightField.setText("" + newHeight);
            }
        } else if (source == this.zField && this.fieldWithFocus == this.zField) {
            String newZText = this.zField.getText();
            newZScale = Tools.parseDouble(newZText, 0.0);
            if (newZScale == 0.0) {
                return;
            }
            if (newZScale != this.zscale) {
                int nSlices = this.imp.getStackSize();
                if (this.imp.isHyperStack()) {
                    int slices = this.imp.getNSlices();
                    int frames = this.imp.getNFrames();
                    nSlices = slices == 1 && frames > 1 ? frames : slices;
                }
                int newDepth2 = (int)Math.round(newZScale * (double)nSlices);
                this.depthField.setText("" + newDepth2);
            }
        } else if (source == this.widthField && this.fieldWithFocus == this.widthField) {
            int newWidth = (int)Math.round(Tools.parseDouble(this.widthField.getText(), 0.0));
            if (newWidth != 0) {
                int newHeight = (int)Math.round((double)newWidth * (double)this.r.height / (double)this.r.width);
                this.heightField.setText("" + newHeight);
                this.xField.setText("-");
                this.yField.setText("-");
                newXScale = 0.0;
                newYScale = 0.0;
            }
        } else if (source == this.depthField && this.fieldWithFocus == this.depthField && (newDepth = (int)Math.round(Tools.parseDouble(this.depthField.getText(), 0.0))) != 0) {
            this.zField.setText("-");
            newZScale = 0.0;
        }
        this.xscale = newXScale;
        this.yscale = newYScale;
        this.zscale = newZScale;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.fieldWithFocus = e.getSource();
        if (this.fieldWithFocus == this.widthField) {
            this.constainAspectRatio = true;
        } else if (this.fieldWithFocus == this.yField) {
            this.constainAspectRatio = false;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    static {
        averageWhenDownsizing = true;
        newWindow = true;
        interpolationMethod = 1;
        processStack = true;
    }
}

