/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui;

import com.ochafik.io.JTextAreaOutputStream;
import icy.file.FileUtil;
import icy.file.Saver;
import icy.gui.component.button.IcyButton;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.w3c.dom.Document;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.BlockListener;
import plugins.adufour.blocks.util.BlocksException;
import plugins.adufour.blocks.util.BlocksFinder;
import plugins.adufour.blocks.util.BlocksML;
import plugins.adufour.blocks.util.BlocksReloadedException;
import plugins.adufour.blocks.util.WorkFlowListener;
import plugins.adufour.protocols.Protocols;
import plugins.adufour.protocols.gui.MainFrame;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.util.VarListener;

public class ProtocolPanel
extends JPanel
implements WorkFlowListener,
PropertyChangeListener {
    private final WorkFlowContainer workFlowContainer;
    private final JScrollPane mainScrollPane;
    private final JSplitPane splitPane;
    private final JPanel logPanel;
    private final JTextAreaOutputStream logStream;
    private final VarString statusMessage = new VarString("status", "status");
    private final VarListener<String> statusListener;
    private WorkFlow workFlow;
    private boolean xmlDirty = false;
    private File xmlFile;

    public ProtocolPanel(MainFrame frame) {
        this(null, new WorkFlow(true), frame);
    }

    private ProtocolPanel(File file, WorkFlow workFlow, MainFrame frame) {
        JTextArea logArea = new JTextArea();
        logArea.setOpaque(false);
        this.logStream = new JTextAreaOutputStream(logArea);
        this.logPanel = new JPanel(new BorderLayout());
        this.logPanel.setOpaque(false);
        this.logPanel.add((Component)new JLabel("Execution log", 0), "North");
        JScrollPane logScrollPane = new JScrollPane(logArea, 20, 30);
        this.logPanel.add((Component)logScrollPane, "Center");
        this.xmlFile = file;
        this.setWorkFlow(workFlow);
        this.workFlowContainer = new WorkFlowContainer(workFlow, true);
        this.workFlowContainer.addPropertyChangeListener("WORKFLOW_REPLACED", this);
        this.mainScrollPane = new JScrollPane(this.workFlowContainer);
        this.setLayout(new BorderLayout());
        this.splitPane = new JSplitPane(1, true, this.mainScrollPane, this.logPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(400);
        this.splitPane.getRightComponent().setMinimumSize(new Dimension());
        this.splitPane.setResizeWeight(1.0);
        this.add((Component)this.splitPane, "Center");
        final JLabel workFlowStatusLabel = new JLabel(" ", 4);
        this.add((Component)workFlowStatusLabel, "South");
        this.statusListener = new VarListener<String>(){

            public void valueChanged(Var<String> source, String oldValue, final String newValue) {
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        workFlowStatusLabel.setText(newValue);
                    }
                });
            }

            public void referenceChanged(Var<String> source, Var<? extends String> oldReference, Var<? extends String> newReference) {
            }
        };
        BlocksML.getInstance().addStatusListener(this.statusListener);
        this.statusMessage.addListener(this.statusListener);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProtocolPanel.this.splitPane.setDividerLocation(1.0);
            }
        }, (boolean)true);
    }

    @Override
    public void blockAdded(WorkFlow source, BlockDescriptor addedBlock) {
        this.setDirty(true);
    }

    @Override
    public void blockCollapsed(WorkFlow source, BlockDescriptor block, boolean collapsed) {
        this.setDirty(true);
    }

    @Override
    public void blockDimensionChanged(WorkFlow source, BlockDescriptor block, int newWidth, int newHeight) {
        this.setDirty(true);
    }

    @Override
    public void blockLocationChanged(WorkFlow source, BlockDescriptor block, int newX, int newY) {
        this.setDirty(true);
    }

    @Override
    public void blockStatusChanged(WorkFlow source, BlockDescriptor block, BlockDescriptor.BlockStatus status) {
    }

    @Override
    public void blockVariableAdded(WorkFlow source, BlockDescriptor block, Var<?> variable) {
        this.setDirty(true);
    }

    @Override
    public <T> void blockVariableChanged(WorkFlow source, BlockDescriptor block, Var<T> variable, T newValue) {
        if (block.inputVars.contains(variable) && variable.getReference() == null) {
            this.setDirty(true);
        }
    }

    @Override
    public void blockRemoved(WorkFlow source, BlockDescriptor removedBlock) {
        this.setDirty(true);
    }

    @Override
    public void linkAdded(WorkFlow source, Link<?> addedLink) {
        this.setDirty(true);
    }

    @Override
    public void linkRemoved(WorkFlow source, Link<?> removedLink) {
        this.setDirty(true);
    }

    public File getFile() {
        return this.xmlFile;
    }

    public WorkFlow getWorkFlow() {
        return this.workFlow;
    }

    public boolean isDirty() {
        return this.xmlDirty;
    }

    public boolean isEmpty() {
        return this.workFlow.size() == 0;
    }

    public void setFile(File file) {
        this.xmlFile = file;
    }

    void setDirty(boolean dirty) {
        this.firePropertyChange("WORKFLOW_MODIFIED", this.xmlDirty, dirty);
        this.xmlDirty = dirty;
    }

    public boolean saveToDisk() throws BlocksException {
        boolean success;
        if (this.xmlFile == null) {
            int option;
            JFileChooser jfc = new JFileChooser(Protocols.getDefaultProtocolFolder());
            jfc.setFileFilter(BlocksML.XML_FILE_FILTER);
            jfc.setDialogTitle("Save an Icy protocol...");
            if (jfc.showSaveDialog(this) != 0) {
                return false;
            }
            File file = jfc.getSelectedFile();
            if (file == null) {
                return false;
            }
            Protocols.setDefaultProtocolFolder(file.getParent());
            String name = file.getPath();
            if (!name.toLowerCase().endsWith(".xml") && !name.toLowerCase().endsWith(".protocol")) {
                file = new File(file.getAbsolutePath() + ".protocol");
            }
            if (file.exists() && (option = JOptionPane.showConfirmDialog(this, file.getPath() + " already exists. Overwrite ?", "Confirmation", 2)) != 0) {
                return false;
            }
            this.xmlFile = file;
        }
        if (success = this.saveToDisk(this.xmlFile)) {
            this.setDirty(false);
        }
        return success;
    }

    public boolean saveToDisk(File f) throws BlocksException {
        if (f == null) {
            return false;
        }
        try {
            BlocksML.getInstance().saveWorkFlow(this.workFlow, f);
        }
        catch (IOException e) {
            throw new IcyHandledException(e.getMessage());
        }
        File snapshotFile = new File(FileUtil.setExtension((String)f.getPath(), (String)"_screenshot.png"));
        try {
            Saver.saveImage((IcyBufferedImage)this.snapshot(), (File)snapshotFile, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to save the snapshot. Reason: " + e.getLocalizedMessage());
        }
        return true;
    }

    public IcyBufferedImage snapshot() {
        BufferedImage image = new BufferedImage(this.workFlowContainer.getWidth(), this.workFlowContainer.getHeight(), 2);
        Graphics2D g2d = image.createGraphics();
        this.workFlowContainer.paint(g2d);
        Rectangle bounds = this.workFlowContainer.getContentsBoundingBox();
        IcyBufferedImage icyImage = IcyBufferedImage.createFrom((BufferedImage)image);
        return IcyBufferedImageUtil.getSubImage((IcyBufferedImage)icyImage, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height);
    }

    @Override
    public void statusChanged(WorkFlow source, String message) {
        this.statusMessage.setValue((Object)message);
    }

    @Override
    public void workFlowReordered(WorkFlow source) {
        this.setDirty(true);
    }

    public WorkFlowContainer getWorkFlowContainer() {
        return this.workFlowContainer;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "WORKFLOW_REPLACED") {
            this.setWorkFlow((WorkFlow)evt.getNewValue());
        }
    }

    private void setWorkFlow(WorkFlow workFlow) {
        if (this.workFlow != null) {
            this.workFlow.removeListener(this);
            this.setDirty(true);
        }
        this.workFlow = workFlow;
        this.workFlow.addListener(this);
        this.workFlow.setLogStream(new PrintStream((OutputStream)this.logStream));
    }

    public void dispose() {
        BlocksML.getInstance().removeStatusListener(this.statusListener);
        this.statusMessage.removeListeners();
        this.workFlow.removeListener(this);
        this.workFlowContainer.removePropertyChangeListener(this);
        this.workFlowContainer.dispose();
        this.mainScrollPane.removeAll();
        this.removeAll();
    }

    public void showBlocksPopupMenu(Component invoker) {
        JPopupMenu blocksPopupMenu = new JPopupMenu();
        new BlocksFinder().createJMenu(blocksPopupMenu, this.workFlowContainer, new Point());
        blocksPopupMenu.show(invoker, 0, invoker.getHeight());
    }

    public void showBlocksEmbedMenu(Component invoker) {
        WorkFlowContainer wfc;
        JPopupMenu embedPopupMenu = new JPopupMenu();
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Container c = (Container)focusOwner;
        if (!(c instanceof JLayeredPane)) {
            this.workFlowContainer.requestFocus();
            wfc = this.workFlowContainer;
        } else {
            wfc = (WorkFlowContainer)c;
        }
        BlocksFinder.createEmbedJMenu(embedPopupMenu, wfc);
        embedPopupMenu.show(invoker, 0, invoker.getHeight());
    }

    public void updateRunButton(IcyButton buttonRun) {
        switch (this.workFlow.getBlockDescriptor().getStatus()) {
            case RUNNING: {
                buttonRun.setIcon((Icon)new IcyIcon(ResourceUtil.getAlphaIconAsImage((String)"playback_stop.png")));
                break;
            }
            default: {
                buttonRun.setIcon((Icon)new IcyIcon(ResourceUtil.getAlphaIconAsImage((String)"playback_play.png")));
            }
        }
    }

    public void loadWorkFlow(Document xml, final boolean isDirty) throws BlocksException, BlocksReloadedException {
        BlocksML.getInstance().loadWorkFlow(xml, this.workFlow);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ProtocolPanel.this.repaint();
                ProtocolPanel.this.setDirty(isDirty);
            }
        }, (boolean)true);
    }

    public void addBlockListener(BlockListener blockListener) {
        this.workFlow.getBlockDescriptor().addBlockListener(blockListener);
    }

    public void removeBlockListener(BlockListener blockListener) {
        this.workFlow.getBlockDescriptor().removeBlockListener(blockListener);
    }
}

