/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.block;

import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.Link;
import plugins.adufour.blocks.lang.Loop;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.blocks.util.VarVisibilityListener;
import plugins.adufour.protocols.gui.block.BlockPanel;
import plugins.adufour.protocols.gui.block.WorkFlowContainer;
import plugins.adufour.protocols.gui.link.DragDropZone;
import plugins.adufour.protocols.gui.link.Line;
import plugins.adufour.protocols.gui.link.RoundedSquareLine;
import plugins.adufour.vars.lang.Var;

public class WorkFlowPanel
extends BlockPanel
implements VarVisibilityListener {
    private final WorkFlow innerWorkFlow;
    protected final JScrollPane scrollPane;
    protected final WorkFlowContainer innerFlowPane;
    private final HashMap<Var<?>, Line> exposingLinks = new HashMap();
    private final MouseAdapter mouseAdapter;
    protected Box varBox;
    protected final JMenuItem menuRemoveEnclosure = new JMenuItem("Remove block but keep contents");

    public WorkFlowPanel(WorkFlowContainer wfPane, final BlockDescriptor blockDesc) {
        super(wfPane, blockDesc);
        this.innerWorkFlow = (WorkFlow)blockDesc.getBlock();
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int xShift = WorkFlowPanel.this.innerFlowPane.getLocationOnScreen().x - WorkFlowPanel.this.getLocationOnScreen().x;
                int yShift = WorkFlowPanel.this.innerFlowPane.getLocationOnScreen().y - WorkFlowPanel.this.getLocationOnScreen().y;
                Point realPoint = new Point(e.getX() + xShift, e.getY() + yShift);
                for (Var var : WorkFlowPanel.this.exposingLinks.keySet()) {
                    if (!((Line)WorkFlowPanel.this.exposingLinks.get(var)).isOverCloseButton(realPoint)) continue;
                    VarList vars = blockDesc.inputVars;
                    if (!vars.contains(var)) {
                        vars = blockDesc.outputVars;
                    }
                    vars.setVisible(var, !vars.isVisible(var));
                    break;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int xShift = WorkFlowPanel.this.innerFlowPane.getLocationOnScreen().x - WorkFlowPanel.this.getLocationOnScreen().x;
                int yShift = WorkFlowPanel.this.innerFlowPane.getLocationOnScreen().y - WorkFlowPanel.this.getLocationOnScreen().y;
                Point realPoint = new Point(e.getX() + xShift, e.getY() + yShift);
                for (Line l : WorkFlowPanel.this.exposingLinks.values()) {
                    l.setCustomColor(l.contains(realPoint.x, realPoint.y));
                }
            }
        };
        blockDesc.inputVars.addVisibilityListener(this);
        blockDesc.outputVars.addVisibilityListener(this);
        this.innerFlowPane = new WorkFlowContainer(this.innerWorkFlow, wfPane.isEditable());
        this.innerFlowPane.setParentPanel(this);
        this.innerFlowPane.addMouseListener(this.mouseAdapter);
        this.innerFlowPane.addMouseMotionListener(this.mouseAdapter);
        this.scrollPane = new JScrollPane(this.innerFlowPane);
        this.scrollPane.setOpaque(false);
        this.scrollPane.setPreferredSize(new Dimension());
        this.varBox = Box.createVerticalBox();
        this.varBox.setOpaque(false);
        this.varBox.setVisible(false);
        this.add((Component)this.varBox, "South");
        Dimension size = this.innerWorkFlow.getBlockDescriptor().getDimension();
        if (size.width != 0) {
            this.setPreferredSize(size);
        } else {
            this.setPreferredSize(new Dimension(400, 400));
        }
        this.setResizeable(!blockDesc.isCollapsed());
        this.menuRemoveEnclosure.addActionListener(this);
        this.menuRemoveEnclosure.setIcon((Icon)ICON_REMOVE);
        this.menuRemoveEnclosure.setToolTipText("<html><h4>Remove this block but keep its contents</h4></html>");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuRemoveEnclosure) {
            this.innerFlowPane.selectAllBlocks();
            this.workFlowPane.getWorkFlow().removeBlock(this.blockDesc, true);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void drawMenu() {
        super.drawMenu();
        this.menu.add(this.menuRemoveEnclosure);
    }

    @Override
    protected void drawContent() {
        int maxRow = this.drawExposedLinks(0);
        this.drawInnerWorkFlowContainer(maxRow + 1);
    }

    protected int drawExposedLinks(int row) {
        int rowIn = row;
        for (Var<?> input : this.innerWorkFlow.getBlockDescriptor().inputVars) {
            if (!this.blockDesc.inputVars.isVisible(input) || this.blockDesc.isLoop() && ((Loop)this.blockDesc.getBlock()).isLoopVariable(input)) continue;
            if (!this.varDropZones.containsKey(input)) {
                this.varDropZones.put(input, this.createVarDropZone(input, true, DragDropZone.LINK_RIGHT));
            }
            GridBagConstraints gbc_dropZone = new GridBagConstraints();
            gbc_dropZone.anchor = 17;
            gbc_dropZone.fill = 0;
            gbc_dropZone.insets = new Insets(2, 0, 0, 0);
            gbc_dropZone.gridx = 0;
            gbc_dropZone.gridy = rowIn++;
            gbc_dropZone.weighty = 0.0;
            DragDropZone dropZone = (DragDropZone)this.varDropZones.get(input);
            this.jPanelContent.add((Component)dropZone, gbc_dropZone);
        }
        int rowOut = row;
        for (Var<?> output : this.innerWorkFlow.getBlockDescriptor().outputVars) {
            if (!this.blockDesc.outputVars.isVisible(output) || this.blockDesc.isLoop() && ((Loop)this.blockDesc.getBlock()).isLoopVariable(output)) continue;
            if (!this.varDragZones.containsKey(output)) {
                this.varDragZones.put(output, this.createVarDragZone(output, true));
            }
            GridBagConstraints gbc_dragZone = new GridBagConstraints();
            gbc_dragZone.anchor = 13;
            gbc_dragZone.fill = 0;
            gbc_dragZone.insets = new Insets(2, 0, 0, 0);
            gbc_dragZone.gridx = 0;
            gbc_dragZone.gridy = rowOut++;
            DragDropZone dragZone = (DragDropZone)this.varDragZones.get(output);
            this.jPanelContent.add((Component)dragZone, gbc_dragZone);
        }
        return Math.max(rowIn, rowOut);
    }

    protected void drawInnerWorkFlowContainer(int row) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 15, 5, 13);
        gbc.anchor = 10;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = row;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.jPanelContent.add((Component)this.scrollPane, gbc);
    }

    @Override
    void dispose() {
        this.blockDesc.inputVars.addVisibilityListener(this);
        this.blockDesc.outputVars.addVisibilityListener(this);
        this.menuRemoveEnclosure.removeActionListener(this);
        this.innerFlowPane.removeMouseListener(this.mouseAdapter);
        this.innerFlowPane.removeMouseMotionListener(this.mouseAdapter);
        this.innerFlowPane.dispose();
        super.dispose();
    }

    @Override
    public void paintChildren(Graphics g) {
        Graphics gg = g.create();
        super.paintChildren(g);
        Rectangle clip = this.scrollPane.getBounds();
        gg.clipRect(clip.x, clip.y, clip.width, clip.height);
        if (!this.blockDesc.isCollapsed()) {
            for (Line line : this.exposingLinks.values()) {
                line.update();
                line.paint((Graphics2D)gg);
            }
        }
        gg.dispose();
    }

    @Override
    public void visibilityChanged(Var<?> variable, boolean isVisible) {
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                WorkFlowPanel.this.refreshNow();
            }
        });
        this.updateExposedLink(variable, isVisible);
    }

    public void updateExposedLink(final Var<?> variable, boolean visible) {
        if (visible) {
            if (this.innerWorkFlow.getInputOwner(variable) != null) {
                final BlockDescriptor innerBlock = this.innerWorkFlow.getInputOwner(variable);
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        final BlockPanel ownerPanel = WorkFlowPanel.this.innerFlowPane.getBlockPanel(innerBlock);
                        if (ownerPanel == null) {
                            return;
                        }
                        WorkFlowPanel.this.exposingLinks.put(variable, new RoundedSquareLine(WorkFlowPanel.this, ownerPanel, variable){

                            @Override
                            protected DragDropZone getP1Zone() {
                                return (DragDropZone)WorkFlowPanel.this.varDropZones.get(variable);
                            }

                            @Override
                            protected DragDropZone getP2Zone() {
                                return ownerPanel.varDropZones.get(variable);
                            }

                            @Override
                            public void updateP1() {
                                if (WorkFlowPanel.this.blockDesc.isCollapsed()) {
                                    return;
                                }
                                DragDropZone dz = this.getP1Zone();
                                if (dz != null) {
                                    int y = dz.getLocationOnScreen().y;
                                    int offsetY = WorkFlowPanel.this.getLocationOnScreen().y;
                                    this.x1 = dz.getWidth();
                                    this.y1 = y - offsetY + dz.getHeight() / 2;
                                }
                            }

                            @Override
                            public void updateP2() {
                                if (ownerPanel.blockDesc.isCollapsed()) {
                                    Point loc = ownerPanel.getLocationOnScreen();
                                    this.x2 = loc.x - WorkFlowPanel.this.getLocationOnScreen().x + 4;
                                    this.y2 = loc.y - WorkFlowPanel.this.getLocationOnScreen().y + ownerPanel.getHeight() / 2;
                                } else {
                                    DragDropZone dz = ownerPanel.varDropZones.get(variable);
                                    Point loc = dz.getLocationOnScreen();
                                    this.x2 = loc.x - WorkFlowPanel.this.getLocationOnScreen().x;
                                    this.y2 = loc.y - WorkFlowPanel.this.getLocationOnScreen().y + dz.getHeight() / 2;
                                }
                            }
                        });
                    }
                }, (boolean)true);
            } else {
                final BlockDescriptor innerBlock = this.innerWorkFlow.getOutputOwner(variable);
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        final BlockPanel ownerPanel = WorkFlowPanel.this.innerFlowPane.getBlockPanel(innerBlock);
                        if (ownerPanel == null) {
                            return;
                        }
                        WorkFlowPanel.this.exposingLinks.put(variable, new RoundedSquareLine(ownerPanel, WorkFlowPanel.this, variable){

                            @Override
                            protected DragDropZone getP1Zone() {
                                return ownerPanel.varDragZones.get(variable);
                            }

                            @Override
                            protected DragDropZone getP2Zone() {
                                return (DragDropZone)WorkFlowPanel.this.varDragZones.get(variable);
                            }

                            @Override
                            public void updateP1() {
                                if (ownerPanel.blockDesc.isCollapsed()) {
                                    Point loc = ownerPanel.getLocationOnScreen();
                                    this.x1 = loc.x - WorkFlowPanel.this.getLocationOnScreen().x + ownerPanel.getWidth() - 4;
                                    this.y1 = loc.y - WorkFlowPanel.this.getLocationOnScreen().y + ownerPanel.getHeight() / 2;
                                } else {
                                    DragDropZone dz = ownerPanel.varDragZones.get(variable);
                                    Point loc = dz.getLocationOnScreen();
                                    this.x1 = loc.x - WorkFlowPanel.this.getLocationOnScreen().x + dz.getWidth();
                                    this.y1 = loc.y - WorkFlowPanel.this.getLocationOnScreen().y + dz.getHeight() / 2;
                                }
                            }

                            @Override
                            public void updateP2() {
                                if (WorkFlowPanel.this.blockDesc.isCollapsed()) {
                                    return;
                                }
                                DragDropZone dz = (DragDropZone)WorkFlowPanel.this.varDragZones.get(variable);
                                int y = dz.getLocationOnScreen().y;
                                int innerY = WorkFlowPanel.this.getLocationOnScreen().y;
                                this.x2 = dz.getLocation().x;
                                this.y2 = y - innerY + dz.getHeight() / 2;
                            }
                        });
                    }
                }, (boolean)true);
            }
        } else if (this.exposingLinks.containsKey(variable)) {
            variable.setReference(null);
            this.exposingLinks.remove(variable).dispose();
            BlockDescriptor block = this.innerWorkFlow.getInputOwner(variable);
            WorkFlow parentWorkFlow = this.blockDesc.getContainer();
            if (block != null) {
                this.varDropZones.remove(variable);
                this.blockDesc.getContainer().getBlockDescriptor().removeInput(variable);
                if (parentWorkFlow.isLinked(variable)) {
                    parentWorkFlow.removeLink(variable);
                }
            } else {
                block = this.innerWorkFlow.getOutputOwner(variable);
                if (block != null) {
                    this.varDragZones.remove(variable);
                    this.blockDesc.getContainer().getBlockDescriptor().removeOutput(variable);
                    ArrayList linksToDelete = new ArrayList();
                    for (Link<Object> link : parentWorkFlow.getLinksIterator()) {
                        if (link.srcVar != variable) continue;
                        linksToDelete.add(link);
                    }
                    for (Link<Object> link : linksToDelete) {
                        parentWorkFlow.removeLink(link.dstVar);
                    }
                }
            }
        }
        this.repaint();
        this.getParent().repaint();
    }

    @Override
    public void drawPanel() {
        super.drawPanel();
        this.varBox.setVisible(this.blockDesc.isCollapsed());
        if (this.blockDesc.isCollapsed()) {
            GridBagConstraints gbc_dropZone = new GridBagConstraints();
            gbc_dropZone.anchor = 17;
            gbc_dropZone.fill = 0;
            gbc_dropZone.insets = new Insets(2, 0, 0, 0);
            gbc_dropZone.gridx = 0;
            GridBagConstraints gbc_varName = new GridBagConstraints();
            gbc_varName.anchor = 10;
            gbc_varName.fill = 2;
            gbc_varName.insets = new Insets(2, 5, 0, 0);
            gbc_varName.gridx = 1;
            gbc_varName.weightx = 1.0;
            GridBagConstraints gbc_dragZone = new GridBagConstraints();
            gbc_dragZone.anchor = 13;
            gbc_dragZone.fill = 0;
            gbc_dragZone.insets = new Insets(2, 5, 0, 0);
            gbc_dragZone.gridx = 2;
            LinkedHashMap inputs = new LinkedHashMap();
            LinkedHashMap outputs = new LinkedHashMap();
            this.varBox.removeAll();
            int nbExposingBlocks = 0;
            for (BlockDescriptor bd : this.innerWorkFlow) {
                ArrayList in = new ArrayList();
                ArrayList out = new ArrayList();
                for (Var<?> v : bd.inputVars) {
                    if (!this.exposingLinks.keySet().contains(v)) continue;
                    in.add(v);
                    if (inputs.containsKey(bd)) continue;
                    inputs.put(bd, in);
                    outputs.put(bd, out);
                    ++nbExposingBlocks;
                }
                for (Var<?> v : bd.outputVars) {
                    if (!this.exposingLinks.keySet().contains(v)) continue;
                    out.add(v);
                    if (inputs.containsKey(bd)) continue;
                    inputs.put(bd, in);
                    outputs.put(bd, out);
                    ++nbExposingBlocks;
                }
            }
            this.varBox.setPreferredSize(new Dimension(0, this.exposingLinks.size() * 20 + nbExposingBlocks * 25));
            for (BlockDescriptor bd : inputs.keySet()) {
                JPanel varPanel;
                this.varBox.add(new JSeparator(0));
                JPanel blockP = new JPanel(new BorderLayout());
                blockP.setOpaque(false);
                JLabel blockName = new JLabel("\t" + bd.getDefinedName(), 0);
                blockName.setFont(blockName.getFont().deriveFont(3, 12.0f));
                blockP.add((Component)blockName, "North");
                Box blockBox = Box.createVerticalBox();
                blockBox.setOpaque(false);
                blockP.add((Component)blockBox, "Center");
                for (Var v : (ArrayList)inputs.get(bd)) {
                    varPanel = new JPanel(new GridBagLayout());
                    varPanel.setOpaque(false);
                    varPanel.add((Component)this.varDropZones.get(v), gbc_dropZone);
                    varPanel.add((Component)new JLabel("\t" + v.getName()), gbc_varName);
                    blockBox.add(varPanel);
                }
                for (Var v : (ArrayList)outputs.get(bd)) {
                    varPanel = new JPanel(new GridBagLayout());
                    varPanel.setOpaque(false);
                    varPanel.add((Component)new JLabel("\t\t\t"), gbc_dropZone);
                    varPanel.add((Component)new JLabel("\t" + v.getName()), gbc_varName);
                    varPanel.add((Component)this.varDragZones.get(v), gbc_dragZone);
                    blockBox.add(varPanel);
                }
                this.varBox.add(blockP);
            }
            this.setSize(this.getPreferredSize());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (!this.blockDesc.isCollapsed()) {
            return d;
        }
        return new Dimension(200, d.height + this.varBox.getPreferredSize().height);
    }
}

